package com.bcxin.ars.service.util;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * ehcache缓存工具类
 * @author wjb
 * @date 2018年8月16日17:31:17
 * @desc 缓存的相关操作
 */
@Service
public class EhcacheUtil<T> {

    @Autowired
    private CacheManager cacheManager;
    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param value 缓存值（内容）
     */
    @SuppressWarnings("unchecked")
    public void add(String cacheName, T value) {
        Cache cache = cacheManager.getCache(cacheName);
        List<T> list = cache.get(cacheName, ArrayList.class);
        if (null!=list&&list.isEmpty()) {
            list = new ArrayList<>();
        }
        list.add(value);
        cache.put(cacheName, list);
    }

    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @desc  根据名称获取缓存内容
     */
    @SuppressWarnings("unchecked")
    public List<T> get(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if(null == cache){
            return null;
        }
        List<T> list = cache.get(cacheName, ArrayList.class);
        if (null!=list&&list.isEmpty()) {
            return null;
        }
        return list;
    }


    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param value 缓存值（内容）
     * @desc  判断缓存中是否存在该内容
     * @return boolean  true存在 false 不存在
     */
    @SuppressWarnings("unchecked")
    public boolean contains(String cacheName, T value) {
        Cache cache = cacheManager.getCache(cacheName);
        List<T> list = cache.get(cacheName, ArrayList.class);
        if (null!=list&&list.isEmpty()) {
            return false;
        }
        return list.contains(value);
    }



    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param value 缓存值（内容）
     * @desc  如果存在，删除缓存中指定内容
     */
    @SuppressWarnings("unchecked")
    public void remove(String cacheName, T value) {
        Cache cache = cacheManager.getCache(cacheName);
        List<T> list = cache.get(cacheName, ArrayList.class);
        if (null!=list&&list.isEmpty()) {
            return;
        }
        list.remove(value);
        cache.put(cacheName, list);

    }

    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param value 缓存属性（名称）
     * @param value 缓存值（内容）
     * @desc map类型的缓存
     */
    @SuppressWarnings("unchecked")
    public void put(String cacheName, String key, T value) {
        Cache cache = cacheManager.getCache(cacheName);
        Map<String, T> map = cache.get(cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            map = new HashMap<>();
        }
        map.put(key, value);
        cache.put(cacheName, map);

    }
    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param key 缓存属性
     * @desc  根据缓存属性获取缓存内容
     */
    @SuppressWarnings("unchecked")
    public String get(String cacheName, String key) {
        Cache cache = cacheManager.getCache(cacheName);
        Map<String, String> map = cache.get(cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return null;
        }
        return map.get(key);
    }

    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @desc  根据缓存名称获取缓存内容
     */
    @SuppressWarnings("unchecked")
    public List<T> getValues(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        Map<String, T> map = cache.get(cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return null;
        }
        List<T> values = new ArrayList<>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }
    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param key 缓存属性
     * @return boolean  true 代表存在  false 代码不存在
     * @desc  根据缓存属性判断缓存内容是否存在
     */
    @SuppressWarnings("unchecked")
    public boolean containsKey(String cacheName, String key) {
        Cache cache = cacheManager.getCache(cacheName);
        Map<String, T> map = cache.get(cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return false;
        }
        return map.containsKey(key);

    }

    /**
     * @author wjb
     * @date 2018年8月16日17:31:17
     * @param cacheName 缓存名称
     * @param key 缓存属性
     * @desc  根据缓存属性删除缓存内容
     */
    @SuppressWarnings("unchecked")
    public void removeKey(String cacheName, String key) {
        Cache cache = cacheManager.getCache(cacheName);
        Map<String, T> map = cache.get(cacheName, HashMap.class);
        if (null == map || map.isEmpty()) {
            return;
        }
        map.remove(key);
        cache.put(cacheName, map);
    }


}
