package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 调百课堂接口工具类
 * @author linqinglin
 * @date 2019/04/23 0023 15:14
 */
@Component
public class BKTInterfaceUtil {

    private static Logger logger = LoggerFactory.getLogger(BKTInterfaceUtil.class);

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;


    /**
     * 调saas接口
     * @param url 接口地址
     * @param paramObj 传参
     */
    public AjaxResult callInterface(String url , Object paramObj){
        //对象转map
        Map<String,Object> paramMap = BeanUtil.beanToMap(paramObj);
        return callInterface(url,paramMap);
    }

    /**
     * 调saas接口
     * @param url 接口地址
     * @param paramMap 传参
     */
    public AjaxResult callInterface(String url , Map<String,Object> paramMap){
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();
        //获取SaaS对接地址

        url = configUtils.bkt_data_host + url;

        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //获取结果
            String resultStr = HttpUtil.post(url, paramMap);
            interfaceLog.setResult(resultStr);

            SAASResultDto resultDto = JSONObject.parseObject(resultStr, SAASResultDto.class);
            if(resultDto != null && StringUtil.isNotEmpty(resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("百保盾与百课堂同步成功");
                } else {
                    result = false;
                    //错误信息
                    msg =  resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("百保盾与百课堂同步失败");
                }
            }else{
                result = false;
                msg =  "没有返回结果";
                logger.info("百保盾与百课堂同步失败,没有返回结果");
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result);
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "百保盾与百课堂同步失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }


    public static void main(String[] args) {
      String url ="http://outbjbbd.test.baibaodun.cn/ars-rest/comTask/contract/save.json";
      String contracts = "[{\"comContractId\":638318060121358336,\"comTaskId\":636983286630973440,\"createBy\":634333489453334528,\"createTime\":1572229567521,\"isDelete\":\"0\",\"updateTime\":1572229567524}]";
      //对象转map
      Map<String,Object> paramMap = new HashedMap();
      paramMap.put("sid","0E44373E153D7C59341D77809D11C17E07FD91598F759F3E79BFA3D9BDB2CCCF7DD089A41E48CD4CADB1F18A76187437EC609C2215764BBA1AF3EF5CE85BAAC2");
      paramMap.put("comTaskId",636983286630973440L);
      paramMap.put("contracts",contracts);
      //获取结果
      String resultStr = HttpUtil.post(url, paramMap);
      System.out.println(resultStr);
    }
}
