package com.bcxin.ars.service.thirdParty;

import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.dto.thirdParty.PersonCheckDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PersonCheckServiceImpl implements PersonCheckService {


    //背景筛查
    private static BackGroupCensorService backGroupCensorService;


    @Override
    public PersonCheckDto check(PersonCheckDto personCheckDto) {
        if(StringUtil.isEmpty(personCheckDto.getIdNumber()) || StringUtil.isEmpty(personCheckDto.getName())){
            throw new ArsException("姓名或身体证号不能为空");
        }


        PersonCheckDto result=  new PersonCheckDto();
        StringBuffer msg =  new StringBuffer();
        boolean checkResult = true;
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
        BackgroundApprovalDto dto = new BackgroundApprovalDto();
        //身份证号
        dto.setIdNumber(personCheckDto.getIdNumber());
        //姓名
        dto.setRealName(personCheckDto.getName());
        //第三方核查人员
        dto.setBusinesstype(Constants.THIRDPARTY_PERSON_CHECK);
        //背景筛查
        List<BackgroundApproval> backgroundApprovals = backGroupCensorService.censor(dto);
        //循环背景筛查记录，检查是否有不通过
        if(backgroundApprovals!=null && backgroundApprovals.size()>0) {
            for (BackgroundApproval backgroundApproval : backgroundApprovals) {
                if (ApprovalState.SHBTG.equals(backgroundApproval.getApprovalstate())) {
                    msg.append(backgroundApproval.getApprovalreason()).append(Constants.COMMA);
                    checkResult = false;
                }
            }
            if(msg.length()>0) {
                msg.deleteCharAt(msg.length() - 1);
            }
        }

        if(!checkResult){
            result.setType("1");
            result.setMsg(msg.toString());
        }else{
            result.setType("0");
        }
        //TODO 日志



        return result;
    }
}
