package com.bcxin.ars.service.task.impl;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dao.task.TaskFeedbackDao;
import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskFeedbackSearchDto;
import com.bcxin.ars.dto.task.*;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
@Transactional
@DataSyncAnnotation(getClazz = TaskFeedback.class)
public class TaskFeedbackServiceImpl implements TaskFeedbackService {

	@Autowired
	private TaskDao taskDao;

	@Autowired
	private TaskFeedbackDao taskFeedbackDao;

	@Autowired
	private SecurityCompanyDao companyDao;

	@Autowired
	private SecurityCompanyService companyService;

	@Autowired
	private SecurityPersonDao personDao;

	@Autowired
	private TaskPersonDao taskPersonDao;
	@Autowired
	private ArsUtil arsUtil;

	@Override
	public TaskFeedback findById(Long id) {
		return taskFeedbackDao.findById(id);
	}
	@Override
	public TaskFeedback findByIdRand() {
		return taskFeedbackDao.findByIdRand();
	}

	@Override
	public List<TaskFeedback> findByTaskId(Long taskId) {
		return taskFeedbackDao.findByTaskId(taskId);
	}

	@Override
	public TaskFeedback saveOrUpdate(TaskFeedback feedback) {
		User currentUser= arsUtil.getCurrentUser();
		if(feedback.getId() != null) {
			TaskFeedback dbFeedback = taskFeedbackDao.findById(feedback.getId());
			if(dbFeedback == null){
				throw new ArsException("数据异常");
			}else if(feedback.getTaskStatus().getId().equals(1l)){
				throw new ArsException("数据异常");
			}else if(feedback.getTaskStatus().getId().equals(2l)){//签到
				dbFeedback.setStartTime(new Date());
				if(dbFeedback.getTask().getTaskType().getId() != 4l){
					if(DateUtil.convertStringToDate(dbFeedback.getTaskDate() + " " + dbFeedback.getTaskStart()).getTime() < new Date().getTime()){
						dbFeedback.setSignStatus("2");
					}else{
						dbFeedback.setSignStatus("1");
					}
				}
			}else if(feedback.getTaskStatus().getId().equals(3l)){//反馈
				dbFeedback.setEndTime(new Date());
				dbFeedback.setComment(feedback.getComment());
				dbFeedback.setPhotos(feedback.getPhotos());

				if(dbFeedback.getTask().getTaskType().getId() != 4l){
					if(DateUtil.convertStringToDate(dbFeedback.getTaskDate() + " " + dbFeedback.getTaskEnd()).getTime() > new Date().getTime()){
						dbFeedback.setFeedbackStatus("2");
					}else{
						dbFeedback.setFeedbackStatus("1");
					}
				}

				//如果子任务全部结束的话，更新人员任务的接受状态
				/*if(taskFeedbackDao.findAllWLTaskfeed(dbFeedback)==0) {
					Task task = dbFeedback.getTask();
					List<Task> endlist = new ArrayList<Task>();
					endlist.add(task);
					taskPersonDao.updateState(endlist,dbFeedback.getPerson().getId());
				}*/
				//TODO 判断任务所有子任务全部是否结束
				/*if(taskFeedbackDao.findAllWLTaskfeed(dbFeedback)==0) {
					Task task = dbFeedback.getTask();
					List<Task> endlist = new ArrayList<Task>();
					endlist.add(task);
					taskPersonDao.updateState(endlist,dbFeedback.getPerson().getId());
				}*/
			}
//			if(StringUtil.isNotEmpty(feedback.getSignStatus())){
//				dbFeedback.setSignStatus(feedback.getSignStatus());
//			}
//			if(StringUtil.isNotEmpty(feedback.getFeedbackStatus())){
//				dbFeedback.setFeedbackStatus(feedback.getFeedbackStatus());
//			}
			dbFeedback.setTaskStatus(feedback.getTaskStatus());
			dbFeedback.setUpdateTime(new Date());
			dbFeedback.setUpdateBy(currentUser.getUsername());
			taskFeedbackDao.update(dbFeedback);
		}else {
			throw new ArsException("数据异常");
		}
		return feedback;
	}

	@Override
	public void saveOrUpdateForDS(TaskFeedback feedback) {

		//先从内网检查是否有记录
		TaskFeedback dbfeedback = findById(feedback.getId());
		if(feedback.getActive() == null){
			feedback.setActive(true);
		}

		if(dbfeedback == null){
			taskFeedbackDao.save(feedback);
		}else{
			if(feedback.getActive() != null && !feedback.getActive()){
				taskFeedbackDao.delete(feedback);
			}else{
				TaskFeedback dbFeedback = taskFeedbackDao.findById(feedback.getId());
				if(feedback.getUpdateTime().getTime() > dbFeedback.getUpdateTime().getTime()){
					taskFeedbackDao.update(feedback);
				}
			}
		}
	}
	@Override
	public List<ReportData> findAreaReport() {
		Long companyId = null;
		SecurityCompany sc = companyService.getCurrentUserCompany();
		if(sc == null) {
			return null;
		} else {
			companyId = sc.getId();
		}
		return taskFeedbackDao.findAreaReport(companyId);
	}

	@Override
	public Map<String, String[]> findCatalogReport() {
		Long companyId = null;
		SecurityCompany sc = companyService.getCurrentUserCompany();
		if(sc == null) {
			return null;
		} else {
			companyId = sc.getId();
		}
		List<ReportData> list = taskFeedbackDao.findCatalogReport(companyId);
		Map<String, String[]> data = new HashMap<String, String[]>();
		String[] name = new String[list.size()];
		String[] value = new String[list.size()];
		for(int i=0; i<list.size(); i++) {
			ReportData rd = list.get(i);
			name[i] = rd.getName();
			value[i] = rd.getValue()+"";
		}
		data.put("name", name);
		data.put("value", value);
		return data;
	}

	@Override
	public List<ReportData> findLevelReport() {
		Long companyId = null;
		SecurityCompany sc = companyService.getCurrentUserCompany();
		if(sc == null) {
			return null;
		} else {
			companyId = sc.getId();
		}
		return taskFeedbackDao.findLevelReport(companyId);
	}

	@Override
	public TaskFeedbackSearchDto search(TaskFeedbackSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		List<TaskFeedback> data = taskFeedbackDao.search(dto);
		Long count = taskFeedbackDao.searchCount(dto);
		dto.setData(data);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public List<TaskFeedback> findNotFeedback(Long personId) {
		List<TaskFeedback> list = taskFeedbackDao.findNotFeedback(personId);
		for(TaskFeedback tf : list) {
			for(TaskPerson tp : tf.getTask().getPersonList()) {
				List<TaskPersonSchedule> tpsList = new ArrayList<TaskPersonSchedule>();
				for(TaskPersonSchedule tps : tp.getScheduleList()) {
					String taskDate = tps.getTaskDate().trim();
					if(!tf.getTaskDate().trim().equals(taskDate)
							&& !DateUtil.getWeekOfDate(tf.getTaskDate()).equals(taskDate)) {
						tpsList.add(tps);
					}
				}
				tp.getScheduleList().removeAll(tpsList);
			}
		}
		return list;
	}

	@Override
	public List<TaskFeedback> findFeedbackList(Long personId, Long taskStatus, Integer minutes) {
		return taskFeedbackDao.findFeedbackList(personId,taskStatus,minutes);
	}

	/**
	 * 获取下一班次子任务
	 * @param taskid
	 * @return
	 */
	@Override
	public List<TaskFeedback> findFeedbackNext(Long taskid){
		return taskFeedbackDao.findFeedbackNext(taskid);
	}
	/**
	 * 获取指定任务下指定反馈列表(部分字段）
	 * @param taskid
	 * @return
	 */
	@Override
	public List<TaskFeedback> findFeedbackByTaskid(Long taskid,long personid) {
		return taskFeedbackDao.findFeedbackByTaskid(taskid, personid);
	}
	@Override
	public List<TaskFeedback> findUrgentFeedbackByTaskid(Long taskid,long personid) {
		return taskFeedbackDao.findUrgentFeedbackByTaskid(taskid, personid);
	}
	@Override
	public List<TaskFeedback> findAllFeedbackByTaskid(Long taskid,long personid) {
		return taskFeedbackDao.findAllFeedbackByTaskid(taskid,personid);
	}

	@Override
	public TaskFeedback findByTaskIdAndPerson(Long taskId,Long personId) {
		TaskFeedback taskFeedback =  new TaskFeedback();
		//任务信息
		Task task =  new Task();
		task.setId(taskId);
		//人员信息
		SecurityPerson person  = new SecurityPerson();
		person.setId(personId);
		taskFeedback.setTask(task);
		taskFeedback.setPerson(person);
		return taskFeedbackDao.findByTaskIdAndPerson(taskFeedback);

	}

	@Override
	public List<TaskFeedback> searchForDataSynchronization( DataSynchronizationSearchDto searchDto) {
		return taskFeedbackDao.searchForDataSynchronization(searchDto);
	}


	@Override
	public List<TaskFeedBackDto> findTaskFeedbasksByTask(TaskDetailSearchDto taskDetailDto, TaskDto taskDto) {
		List<TaskFeedBackDto> feedbacks = taskFeedbackDao.findFeedBasks(taskDetailDto);

		if(taskDto == null){
			taskDto = taskDao.findTaskDetail(taskDetailDto);
		}
		if(taskDto.getAcceptStatus().equals("0") || taskDto.getAcceptStatus().equals("2") || taskDto.getAcceptStatus().equals("4")){
			TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
			if( taskDto.getTaskType().getId() == 1l && taskDto.isRepeat()){
				Map<String, List<String>> weekMap = DateUtil.getWeekDatesByYearMouth(taskDetailDto.getTaskdate());
				if(weekMap != null){
					if(taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size()> 0){
						for( TaskPersonSchedule personSchedule : taskPerson.getScheduleList()){
							List<String> weekDays = weekMap.get(personSchedule.getTaskDate());
							if(weekDays != null && weekDays.size() > 0){
								List<SecurityCompanySchedule> companySchedules = personSchedule.getScheduleDetail();
								for (String weekDay : weekDays) {
									if(DateUtil.convertStringToDate(weekDay).getTime() >= DateUtil.convertStringToDate(taskDto.getCreateTime()).getTime()){
										List<FeedBackDetailDto> backdetails = new ArrayList<FeedBackDetailDto>();
										TaskFeedBackDto newFeedBackDto = new TaskFeedBackDto();
										newFeedBackDto.setTaskDate(weekDay);
										for (SecurityCompanySchedule securityCompanySchedule : companySchedules) {
											FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
											newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
											newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
											newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
											newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
											newFeedBackDetailDto.setTaskStatus(1l);
											backdetails.add(newFeedBackDetailDto);
										}
										newFeedBackDto.setDetails(backdetails);
										feedbacks.add(newFeedBackDto);
									}
								}
							}
						}
					}
				}
			}else{
				if(taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0){
					for(TaskPersonSchedule personSchedule : taskPerson.getScheduleList()){
						List<SecurityCompanySchedule> companySchedules = personSchedule.getScheduleDetail();
						List<FeedBackDetailDto> backdetails = new ArrayList<FeedBackDetailDto>();
						TaskFeedBackDto newFeedBackDto = new TaskFeedBackDto();
						newFeedBackDto.setTaskDate(personSchedule.getTaskDate());
						if(companySchedules!=null && companySchedules.size()>0){
							for (SecurityCompanySchedule securityCompanySchedule : companySchedules) {
								FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
								newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
								newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
								newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
								newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
								newFeedBackDetailDto.setTaskStatus(1l);
								backdetails.add(newFeedBackDetailDto);
							}
						}
						newFeedBackDto.setDetails(backdetails);
						feedbacks.add(newFeedBackDto);
					}
				}
			}
		}else{
			if(DateUtil.convertStringToDate(taskDetailDto.getTaskdate()+"-01").getTime()  >= DateUtil.convertStringToDate(DateUtil.getCurrentDate("yyyy-MM-01")).getTime()){
				TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
				if( taskDto.getTaskType().getId() == 1l && taskDto.isRepeat()){
					Map<String, List<String>> weekMap = DateUtil.getWeekDatesByYearMouth(taskDetailDto.getTaskdate());
					for( TaskPersonSchedule personSchedule : taskPerson.getScheduleList()){
						List<String> weekDays = weekMap.get(personSchedule.getTaskDate());
						if(weekDays != null && weekDays.size() > 0){
							List<SecurityCompanySchedule> companySchedules = personSchedule.getScheduleDetail();

							Boolean exist = false;
							Boolean detailExist = false;
							for (String weekDay : weekDays) {
								if(DateUtil.convertStringToDate(weekDay).getTime() >= DateUtil.convertStringToDate(taskDto.getCreateTime()).getTime()){
									for (SecurityCompanySchedule securityCompanySchedule : companySchedules) {
										exist = false;
										for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
											detailExist = false;
											if(weekDay.equals(taskFeedBackDto.getTaskDate())){
												exist = true;
												List<FeedBackDetailDto> backdetails = taskFeedBackDto.getDetails();
												for (FeedBackDetailDto feedBackDetailDto : backdetails) {
													if(feedBackDetailDto.getScheduleId() == securityCompanySchedule.getId()){
														detailExist = true;
													}
												}
												if(!detailExist){
													FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
													newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
													newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
													newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
													newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
													newFeedBackDetailDto.setTaskStatus(1l);
													backdetails.add(newFeedBackDetailDto);
												}
											}
										}
										if(!exist){
											TaskFeedBackDto newFeedBackDto = new TaskFeedBackDto();
											FeedBackDetailDto newFeedBackDetailDto = new FeedBackDetailDto();
											newFeedBackDetailDto.setTaskEnd(securityCompanySchedule.getEndTime());
											newFeedBackDetailDto.setTaskStart(securityCompanySchedule.getStartTime());
											newFeedBackDetailDto.setScheduleId(securityCompanySchedule.getId());
											newFeedBackDetailDto.setScheduleName(securityCompanySchedule.getName());
											newFeedBackDetailDto.setTaskStatus(1l);
											newFeedBackDto.setTaskDate(weekDay);
											List<FeedBackDetailDto> details = new ArrayList<FeedBackDetailDto>();
											details.add(newFeedBackDetailDto);
											newFeedBackDto.setDetails(details);
											feedbacks.add(newFeedBackDto);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		if(feedbacks != null && feedbacks.size() > 0){
			Date nowDate  = new Date();
			for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
				if(taskFeedBackDto.getDetails() != null && taskFeedBackDto.getDetails().size() > 0){
					//最早可签到班次
					Date minTaskClockDate =null;
					for(FeedBackDetailDto backDetailDto :taskFeedBackDto.getDetails()){
						String scheduleStatus = backDetailDto.getScheduleStatus();
						if(scheduleStatus!=null && scheduleStatus.equals("2")){
							if(StringUtil.isNotEmpty(backDetailDto.getTaskStart())){
								Date taskStartDate = DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+ backDetailDto.getTaskStart());
								if(minTaskClockDate == null){
									minTaskClockDate = taskStartDate;
								}else{
									if(taskStartDate.getTime() > minTaskClockDate.getTime()){
										backDetailDto.setScheduleStatus("1");
									}else{
										minTaskClockDate = taskStartDate;
									}
								}
							}
						}
						if(backDetailDto.getTaskStatus() == 1l){
							if(StringUtil.isNotEmpty(backDetailDto.getTaskStart())){
								Date taskStartDate = DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+ backDetailDto.getTaskStart());
								if(taskStartDate.getTime() > nowDate.getTime()){
									int minutes = DateUtil.dateDiffForMinutes(nowDate,taskStartDate);
									int days = minutes/(60*24);
									int hours = minutes%(60*24)/60;
									StringBuffer tipBuffer = new StringBuffer("还有");
									if(days > 0){
										tipBuffer.append(days+"天");
									}
									if(hours > 0){
										tipBuffer.append(hours+"小时");
									}
									if((minutes%60) > 0){
										tipBuffer.append((minutes%60)+"分钟");
									}
									tipBuffer.append("开始");
									backDetailDto.setTip(tipBuffer.toString());
								}else{
									backDetailDto.setTip("已过任务开始时间");
								}
							}
						}else if(backDetailDto.getTaskStatus() == 2l){
							if(StringUtil.isNotEmpty(backDetailDto.getTaskEnd())){
								Date taskEndDate = DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+ backDetailDto.getTaskEnd());
								if(taskEndDate.getTime() > nowDate.getTime()){
									int minutes = DateUtil.dateDiffForMinutes(nowDate, taskEndDate);
									int days = minutes/(60*24);
									int hours = minutes%(60*24)/60;
									StringBuffer tipBuffer = new StringBuffer("还有");
									if(days > 0){
										tipBuffer.append(days+"天");
									}
									if(hours > 0){
										tipBuffer.append(hours+"小时");
									}
									if((minutes%60) > 0){
										tipBuffer.append((minutes%60)+"分钟");
									}
									tipBuffer.append("下班");
									backDetailDto.setTip(tipBuffer.toString());
								}else{
									backDetailDto.setTip("已过任务结束时间");
								}
							}
						}else if(backDetailDto.getTaskStatus() == 3l){
							if(StringUtil.isNotEmpty(backDetailDto.getStartTime()) && StringUtil.isNotEmpty(backDetailDto.getEndTime())){
								Date startDate = DateUtil.convertStringToDate(backDetailDto.getStartTime());
								Date endDate = DateUtil.convertStringToDate(backDetailDto.getEndTime());
								int minutes = DateUtil.dateDiffForMinutes(startDate, endDate);
								int days = minutes/(60*24);
								int hours = minutes%(60*24)/60;
								StringBuffer tipBuffer = new StringBuffer("总时长:");
								if(days > 0){
									tipBuffer.append(days+"天");
								}
								if(hours > 0){
									tipBuffer.append(hours+"小时");
								}
								if((minutes%60) > 0){
									tipBuffer.append((minutes%60)+"分钟");
								}
								backDetailDto.setTip(tipBuffer.toString());
							}
						}
					}
				}
			}
//			feedbacks.get(index)
		}else {
			if( taskDto.getTaskType().getId() == 1l && taskDto.isRepeat() && (taskDto.getAcceptStatus().equals("0") || taskDto.getAcceptStatus().equals("2") || taskDto.getAcceptStatus().equals("4"))){
				taskDetailDto.getTaskdate();
				try {
					String nextDate = DateUtil.dateAdd(DateUtil.DATATYPE_MONTH, taskDetailDto.getTaskdate()+"-01", 1);
					taskDetailDto.setTaskdate(DateUtil.convertDateToString(DateUtil.convertStringToDate(nextDate), DateUtil.FORMAT9));
					return findTaskFeedbasksByTask(taskDetailDto, taskDto);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return feedbacks;
	}

	/**
	 * 查询大于当前时间的下一班次，精确到秒
	 * @param taskListDto
	 * @return
	 */
	@Override
	public TaskFeedBackDto findNextFeedBack_back(TaskListDto taskListDto){
		return  taskFeedbackDao.findNextFeedBack_back(taskListDto);
	}
	@Override
	public FeedBackDetailDto findFeedBackDetailById(Long id) {
		return taskFeedbackDao.findFeedBackDetailById(id);
	}
	@Override
	public List<FeedBackDetailDto> findBackDetailByPersonid(Long personId) {
		return taskFeedbackDao.findBackDetailByPersonid(personId);
	}
	@Override
	public TaskFeedback saveAppSign(TaskFeedback feedback) {
		User currentUser= arsUtil.getCurrentUser();
		if(feedback.getId() != null) {
			TaskFeedback dbFeedback = taskFeedbackDao.findById(feedback.getId());
			//设置子任务已经到下班状态但是未打卡下班：为"漏打卡"
			Long taskId = dbFeedback.getTask().getId();
			Long personId = dbFeedback.getPerson().getId();
			Long execFeedBackCount =null ;
			if(taskId!=null&&personId!=null){
				taskFeedbackDao.updateFeedbackStatus(taskId, personId);
				execFeedBackCount = taskFeedbackDao.searchExecFeedBackCount(taskId, personId);
			}
			//判断子任务是否有未执行完毕任务，如果有这不能进行下一场班次打卡上班
			if(execFeedBackCount!=null && execFeedBackCount>0){
				return null;
			}
			//设置子任务为打卡状态
			dbFeedback.setStartTime(new Date());
			if(dbFeedback.getTask().getTaskType().getId() != 4l){
				if(DateUtil.convertStringToDate(dbFeedback.getTaskDate() + " " + dbFeedback.getTaskStart()).getTime() < new Date().getTime()){
					dbFeedback.setSignStatus("2");
				}else{
					dbFeedback.setSignStatus("1");
				}
			}
			dbFeedback.setTaskStatus(feedback.getTaskStatus());
			dbFeedback.setUpdateTime(new Date());
			dbFeedback.setUpdateBy(currentUser.getUsername());
			taskFeedbackDao.update(dbFeedback);
		}else {
			throw new ArsException("数据异常");
		}
		return feedback;
	}
	@Override
	public Long findFeedBackFinishSumTime(Long taskId, Long personId) {
		return taskFeedbackDao.findFeedBackFinishSumTime(taskId, personId);
	}
	@Override
	public List<TaskFeedBackDto> findFeedBasksByScheduleStatus(TaskDetailSearchDto taskDetailDto) {
		return taskFeedbackDao.findFeedBasksByScheduleStatus(taskDetailDto);
	}
	@Override
	public List<TaskFeedBackDto> findTaskFeedbasksByTask_V109(TaskDetailSearchDto taskDetailDto) {
		List<TaskFeedBackDto> feedbacks = taskFeedbackDao.findFeedBasks(taskDetailDto);
		//根据保安人员ID获取当前最早可签到的子任务ID
		Long signFeedBaskID = taskFeedbackDao.findCanSignFeedBaskID(taskDetailDto);
		if(feedbacks != null && feedbacks.size() > 0){
			Date nowDate  = new Date();
			for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
				if(taskFeedBackDto.getDetails() != null && taskFeedBackDto.getDetails().size() > 0){
					for(FeedBackDetailDto backDetailDto :taskFeedBackDto.getDetails()){
						String scheduleStatus = backDetailDto.getScheduleStatus();
						if(StringUtils.isNotEmpty(scheduleStatus)){
							//子任务可签到，但是不是最早的可签到子任务，则设置成"未开始"
							if(signFeedBaskID != null && !signFeedBaskID.equals(backDetailDto.getFeedbackid())
									&& scheduleStatus.equals("2")){
								//最早可签到班次
								if(StringUtil.isNotEmpty(backDetailDto.getTaskStart())){
									backDetailDto.setScheduleStatus("1");
									scheduleStatus = "1";
								}
							}
							if(scheduleStatus.equals("1") || scheduleStatus.equals("2")){//1未开始,2可签到
								if(StringUtil.isNotEmpty(backDetailDto.getTaskStart())){
									Date taskStartDate = DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+ backDetailDto.getTaskStart());
									if(taskStartDate.getTime() > nowDate.getTime()){
										int minutes = DateUtil.dateDiffForMinutes(nowDate,taskStartDate);
										int days = minutes/(60*24);
										int hours = minutes%(60*24)/60;
										StringBuffer tipBuffer = new StringBuffer("还有");
										if(days > 0){
											tipBuffer.append(days+"天");
										}
										if(hours > 0){
											tipBuffer.append(hours+"小时");
										}
										if((minutes%60) > 0){
											tipBuffer.append((minutes%60)+"分钟");
										}
										tipBuffer.append("开始");
										backDetailDto.setTip(tipBuffer.toString());
									}else{
										backDetailDto.setTip("已过任务开始时间");
									}
								}
							}else if(scheduleStatus.equals("3")){//可下班
								if(StringUtil.isNotEmpty(backDetailDto.getTaskEnd())){
									Date taskEndDate = DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+ backDetailDto.getTaskEnd());
									if(taskEndDate.getTime() > nowDate.getTime()){
										int minutes = DateUtil.dateDiffForMinutes(nowDate, taskEndDate);
										int days = minutes/(60*24);
										int hours = minutes%(60*24)/60;
										StringBuffer tipBuffer = new StringBuffer("还有");
										if(days > 0){
											tipBuffer.append(days+"天");
										}
										if(hours > 0){
											tipBuffer.append(hours+"小时");
										}
										if((minutes%60) > 0){
											tipBuffer.append((minutes%60)+"分钟");
										}
										tipBuffer.append("下班");
										backDetailDto.setTip(tipBuffer.toString());
									}else{
										backDetailDto.setTip("已过任务结束时间");
									}
								}
							}else if(scheduleStatus.equals("4")){//已完成
								if(StringUtil.isNotEmpty(backDetailDto.getStartTime()) && StringUtil.isNotEmpty(backDetailDto.getEndTime())){
									Date startDate = DateUtil.convertStringToDate(backDetailDto.getStartTime());
									Date endDate = DateUtil.convertStringToDate(backDetailDto.getEndTime());
									int minutes = DateUtil.dateDiffForMinutes(startDate, endDate);
									int days = minutes/(60*24);
									int hours = minutes%(60*24)/60;
									StringBuffer tipBuffer = new StringBuffer("总时长:");
									if(days > 0){
										tipBuffer.append(days+"天");
									}
									if(hours > 0){
										tipBuffer.append(hours+"小时");
									}
									if((minutes%60) > 0){
										tipBuffer.append((minutes%60)+"分钟");
									}
									backDetailDto.setTip(tipBuffer.toString());
								}
							}
						}
					}
				}
			}
		}
		return feedbacks;
	}
	@Override
	public List<TaskFeedback> findFeedbackByTaskid_V109(Long taskId, long personid) {
		return taskFeedbackDao.findFeedbackByTaskid_V109(taskId, personid);
	}
}
