package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.PerTaskCardRecordDao;
import com.bcxin.ars.dao.task.PersonClockInDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.PersonClockInDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.model.task.PersonClockIn;
import com.bcxin.ars.service.task.PersonClockInService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = PersonClockIn.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
public class PersonClockInServiceImpl implements PersonClockInService {
    Logger logger = LoggerFactory.getLogger(PersonClockInServiceImpl.class);
    @Autowired
    private PerTaskCardRecordDao perTaskCardRecordDao;
    @Autowired
    private PersonClockInDao personClockInDao;
    @Autowired
    private ConfigUtils configUtils;
    @Override
    public int savePerClockIn(PerTaskCardRecord perTaskCardRecord) {
        //查询人员打卡记录详情
        PersonClockInDto personClockInDto = perTaskCardRecordDao.selectPerClockInDto(perTaskCardRecord.getTaskCardRecordId());
        if (personClockInDto == null){
            return 0;
        }
        //查询人员打卡记录表中是否有记录
        PersonClockIn personClockIn = personClockInDao.selectPerClockIn(personClockInDto);

        Date clockInDate = personClockInDto.getClockInDate();
        //上班时间和下班时间转换为带日期的时间
        Date startWorkTime = timeToTimeDate(clockInDate,personClockInDto.getStartWorkTime());
        Date endWorkTime = timeToTimeDate(clockInDate,personClockInDto.getEndWorkTime());
        //下班时间为第二天，并且上班打卡时间大于上班时间
        //如果表中没记录就新增一条记录
        if(personClockIn == null ){
            personClockIn = new PersonClockIn();
            personClockIn.setPersonId(personClockInDto.getPersonId());
            personClockIn.setWorkDate(personClockInDto.getClockInDate());
            personClockIn.setShiftRuleId(personClockInDto.getShiftRuleId());
            personClockIn.setClockInRound(personClockInDto.getClockInRound());
            personClockIn.setStartWorkTime(startWorkTime);
            personClockIn.setEndWorkTime(endWorkTime);
        }

        //打上班卡的时候，将上班时间设置为打卡时间
        if(personClockInDto.getClockInType().equals("1")){
            if(personClockInDto.getClockInTime().getTime()>endWorkTime.getTime()) {
                Calendar c = Calendar.getInstance();
                c.setTime(clockInDate);
                //日期+1天
                c.add(c.DATE, 1);
                endWorkTime = timeToTimeDate(c.getTime(), personClockInDto.getEndWorkTime());
            }
            personClockIn.setStartWorkTime(personClockInDto.getClockInTime());
            personClockIn.setEndWorkTime(endWorkTime);
        }
        //打下班卡的时候，将下班时间设置为打卡时间
        if(personClockInDto.getClockInType().equals("2")){
            personClockIn.setEndWorkTime(personClockInDto.getClockInTime());
        }
        personClockIn.setUpdateTime(new Date());
        return personClockInDao.save(personClockIn);
    }
    //时间转换为带日期的时间
    public Date timeToTimeDate(Date date, Time time){
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date)+" "+time.toString();
        Date timeDate = null;
        try{
            timeDate = formatter1.parse(dateString);
        }catch (Exception e){
           logger.error(e.getMessage(),e);
        }
        return timeDate;
    }


    /**
     * 外网同步到内网
     * @param list
     */
    @Override
    public void importBatch(List<PersonClockIn> list) {
        List<PerTaskCardRecord> dbList = personClockInDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (PersonClockIn perTaskCardRecord : list) {
                try {
                    if(!configUtils.isIntranet()){
                        perTaskCardRecord.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, perTaskCardRecord.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            personClockInDao.saveBatch(list);
        }
    }

    /**
     * 外网同步到内网查询
     * @param dto
     * @return
     */
    @Override
    public List<PersonClockIn> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return personClockInDao.searchForDataSynchronization(dto);
    }
}
