package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.PerTaskCardRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.PerTaskCardRecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.service.task.PerTaskCardRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * 任务打卡记录Service实现类
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:54
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = PerTaskCardRecord.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
public class PerTaskCardRecordServiceImpl implements PerTaskCardRecordService {

    Logger logger = LoggerFactory.getLogger(PerTaskCardRecordServiceImpl.class);

    @Autowired
    private PerTaskCardRecordDao perTaskCardRecordDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   
    @Override
    public int delete(PerTaskCardRecord perTaskCardRecord) {
        User currentUser = arsUtil.getCurrentUser();
        perTaskCardRecord.setUpdateTime(new Date());
        perTaskCardRecord.setUpdateBy(currentUser.getUsername());
        return perTaskCardRecordDao.delete(perTaskCardRecord);
    }

    @Override
    public int save(PerTaskCardRecord perTaskCardRecord) {
        User currentUser = arsUtil.getCurrentUser();
        PerTaskCardRecord dbPerTaskCardRecord = perTaskCardRecordDao.findById(perTaskCardRecord.getTaskCardRecordId());
        if (dbPerTaskCardRecord != null){
            BeanUtils.copyPropertiesIgnore(perTaskCardRecord,dbPerTaskCardRecord,true);
            BeanUtils.copyPropertiesIgnore(dbPerTaskCardRecord,perTaskCardRecord,false);

        }
        perTaskCardRecord.setUpdateBy(currentUser.getUsername());
        perTaskCardRecord.setUpdateTime(new Date());
        return perTaskCardRecordDao.save(perTaskCardRecord);
    }

    @Override
    public PerTaskCardRecord findById(Long id) {
        return perTaskCardRecordDao.findById(id);
    }

    @Override
    public void searchForPage(PerTaskCardRecordPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       perTaskCardRecordDao.searchForPage(dto,page);
    }

    /**
     * 外网同步到内网
     * @param list
     */
    @Override
    public void importBatch(List<PerTaskCardRecord> list) {
        List<PerTaskCardRecord> dbList = perTaskCardRecordDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (PerTaskCardRecord perTaskCardRecord : list) {
                try {
                    if(!configUtils.isIntranet()){
                       perTaskCardRecord.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, perTaskCardRecord.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            perTaskCardRecordDao.saveBatch(list);
        }
    }

    /**
     * 外网同步到内网查询
     * @param dto
     * @return
     */
    @Override
    public List<PerTaskCardRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return perTaskCardRecordDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PerTaskCardRecord> findDSOutList(String startDate) {
        return perTaskCardRecordDao.findDSOutList(startDate);
    }

    @Override
    public List<PerTaskCardRecord> findByBatchId(List<PerTaskCardRecord> list) {
        return perTaskCardRecordDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(PerTaskCardRecord perTaskCardRecord) {
        User currentUser = arsUtil.getCurrentUser();
        perTaskCardRecord.setUpdateTime(new Date());
        perTaskCardRecord.setUpdateBy(currentUser.getUsername());
        perTaskCardRecordDao.updateSelective(perTaskCardRecord);
    }
}
