package com.bcxin.ars.service.task.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.task.ComTempTaskDao;
import com.bcxin.ars.dao.task.ComTempTaskPerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ComTempTaskPageSearchDto;
import com.bcxin.ars.dto.task.ComTempTaskDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.report.ReportProblemPerson;
import com.bcxin.ars.model.supervision.PersonAward;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.bcxin.ars.service.task.ComTempTaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 临保任务Service业务层处理
 * 
 * @author lin
 * @date 2021-02-01
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComTempTask.class, getImportType = ImportType.BATCH, getMethodName = "importBatch")
public class ComTempTaskServiceImpl implements ComTempTaskService {
    
    Logger logger = LoggerFactory.getLogger(ComTempTaskServiceImpl.class);
    
    @Autowired
    private ComTempTaskDao comTempTaskDao;

    @Autowired
    private ComTempTaskPerDao comTempTaskPerDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(ComTempTask comTempTask) {
        User currentUser = arsUtil.getCurrentUser();
        comTempTask.setUpdateTime(new Date());
        comTempTask.setUpdateBy(currentUser.getUsername());
        return comTempTaskDao.delete(comTempTask);
    }

    @Override
    public int save(ComTempTask comTempTask) {
        User currentUser = arsUtil.getCurrentUser();
        if(comTempTask.getComTempTaskId() == null){
            comTempTask.setComTempTaskId(idWorker.nextId());
            comTempTask.setCreateTime(new Date());
            SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
            comTempTask.setComId(company.getId());
        }else{
            ComTempTask dbComTempTask = comTempTaskDao.findById(comTempTask.getComTempTaskId());
            BeanUtils.copyPropertiesIgnore(comTempTask,dbComTempTask,true);
            BeanUtils.copyPropertiesIgnore(dbComTempTask,comTempTask,false);
        }
        //默认未开始
        comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_3);
        if(comTempTask.getStartDate().getTime()<=System.currentTimeMillis() && comTempTask.getEndDate().getTime()>=System.currentTimeMillis() ){
            comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_1);
        }else if(comTempTask.getEndDate().getTime()<System.currentTimeMillis()){
            comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_2);
        }

        comTempTask.setActive(true);
        comTempTask.setUpdateBy(currentUser.getUsername());
        comTempTask.setUpdateTime(new Date());
        comTempTask.setUpdateflag(true);
        comTempTask.setUserId(currentUser.getId());
        return comTempTaskDao.save(comTempTask);
    }

    @Override
    public ComTempTask findById(Long id) {
        return comTempTaskDao.findById(id);
    }

    @Override
    public void searchForPage(ComTempTaskPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        User currentUser = arsUtil.getCurrentUser();
        if(currentUser.getPlatform() == Constants.PLATFORM_COMPANY){
            dto.setUserId(currentUser.getId());
        }
        comTempTaskDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<ComTempTask> list) {
        List<ComTempTask> dbList = comTempTaskDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComTempTask comTempTask : list) {
                comTempTask.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        comTempTask.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comTempTask.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comTempTaskDao.saveBatch(list);
        }
    }

    @Override
    public List<ComTempTask> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comTempTaskDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComTempTask> findDSOutList(String startDate) {
        return comTempTaskDao.findDSOutList(startDate);
    }

    @Override
    public List<ComTempTask> findByBatchId(List<ComTempTask> list) {
        return comTempTaskDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ComTempTask comTempTask) {
        User currentUser = arsUtil.getCurrentUser();
        comTempTask.setUpdateTime(new Date());
        comTempTask.setUpdateBy(currentUser.getUsername());
        comTempTaskDao.updateSelective(comTempTask);
    }

    @Override
    public void saveTaskPer(ComTempTaskDto comTempTask) {
        List<ComTempTaskPer> perList = comTempTaskPerDao.findByComTempTask(comTempTask);
        Map<Long, ComTempTaskPer> perMap =perList.stream().collect(Collectors.toMap(ComTempTaskPer::getPerId, Function.identity()));

        User currentUser = arsUtil.getCurrentUser();
        ComTempTaskPer taskPer = null;
        List<ComTempTaskPer> savePerList = new ArrayList<>();
        for (Long perId : comTempTask.getPerIds()) {
            if (perMap.get(perId) == null) {
                taskPer = new ComTempTaskPer();
                taskPer.setComTempTaskPerId(idWorker.nextId());
                taskPer.setComTempTaskId(comTempTask.getComTempTaskId());
                taskPer.setComId(comTempTask.getComId());
                taskPer.setPerId(perId);
                taskPer.setActive(true);
                taskPer.setUserId(currentUser.getId());
                taskPer.setCreateTime(new Date());
                taskPer.setUpdateTime(new Date());
                taskPer.setUpdateBy(currentUser.getUsername());
                savePerList.add(taskPer);
            }
        }
        if(savePerList.size() > 0){
            comTempTaskPerDao.saveBatch(savePerList);
        }
    }

    @Override
    public void removePer(ComTempTaskPer comTempTaskPer){
        comTempTaskPer.setUpdateBy(arsUtil.getCurrentUser().getUsername());
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPerDao.delete(comTempTaskPer);
    }
}
