package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dao.task.ComTaskDaoAop;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dao.task.ComTaskSchedulDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComTaskSearchDto;
import com.bcxin.ars.dto.task.ComTaskDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.model.task.ComTaskPer;
import com.bcxin.ars.service.task.ComTaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 驻勤点service实现
 * @author linqinglin
 * @date 2019/10/11 0011 11:10
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComTask.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
public class ComTaskServiceImpl implements ComTaskService {

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private ComTaskDao comTaskDao;

    @Autowired
    private ComTaskDaoAop comTaskDaoAop;

    @Autowired
    private ComTaskPerDao comTaskPerDao;

    @Autowired
    private ComTaskSchedulDao comTaskSchedulDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public void search(ComTaskSearchDto dto, AjaxPageResponse<ComTaskDto> page) {
        arsUtil.setPoliceSearch(dto);

        if(StringUtil.isNotEmpty(dto.getComAreaCode())){
            String areaCode =dto.getComAreaCode();
            if (areaCode.endsWith("0000")) {// 省
                dto.setComAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {// 市
                dto.setComAreaCode(areaCode.substring(0, 4) + "__");
            } else {// 区
                dto.setComAreaCode(areaCode);
            }
        }

        if(StringUtil.isNotEmpty(dto.getTaskAreaCode())){
            String areaCode =dto.getTaskAreaCode();
            if (areaCode.endsWith("0000")) {// 省
                dto.setTaskAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {// 市
                dto.setTaskAreaCode(areaCode.substring(0, 4) + "__");
            } else {// 区
                dto.setTaskAreaCode(areaCode);
            }
        }


        comTaskDao.searchV3(dto,page);
    }

    @Override
    public ComTaskDto findDetailById(Long id) {
        return comTaskDao.findDetailById(id);
    }

    @Override
    public ComTask findById(Long id) {
        return comTaskDao.findById(id);
    }

    @Override
    public void save(ComTask comTask) {
        ComTask dbComTask = comTaskDao.findById(comTask.getComTaskId());

        if(dbComTask != null && Constants.TASKSTATUS_DENY.equals(dbComTask.getTaskStatusNew())&& !dbComTask.getTaskStatusNew().equals(comTask.getTaskStatus())){
            //自动完成 的任务重新启用
            comTaskPerDao.deleteByTaskId(dbComTask.getComTaskId());
            comTaskSchedulDao.deleteByTaskId(comTask.getComTaskId());
        }

        //保存关联人员
        this.savePer(comTask,true);
        comTask.setUpdateTime(new Date());


        if(comTask.getBbdId() != null){
            comTask.setOrgId(comTask.getBbdId());
            Police police = policeDao.findById(comTask.getBbdId());
            if(police != null){
                comTask.setOrgName(police.getOrgname());
                comTask.setAreaCode(police.getAreacode());
            }
        }
        if(dbComTask != null){
            BeanUtils.copyPropertiesIgnore(comTask,dbComTask,true);
            BeanUtils.copyPropertiesIgnore(dbComTask,comTask,false);
        }

        comTaskDaoAop.save(comTask);

        new Thread(()->{
            comTaskDao.removeRelationTask(comTask);
            comTaskDao.relationTask(comTask);
            //更新驻勤状态
            comTaskDao.updateTaskStatusNew(comTask.getComTaskId());
        }).start();
    }

    /**
     * 保存关联人员
     * @param comTask
     * @param ignoreNull 是否跳过空值
     */
    private void savePer(ComTask comTask, Boolean ignoreNull){
        User currentUser = arsUtil.getCurrentUser();
        List<ComTaskPer> newPerList = comTask.getPerList();

        if(ignoreNull && (newPerList == null || newPerList.size()==0)){
            return;
        }

        if(newPerList == null) {
            newPerList = new ArrayList<>();
        }

        for (ComTaskPer comTaskPer : newPerList) {
            comTaskPer.setActive(true);
            comTaskPer.setUpdateBy(currentUser.getUsername());
            comTaskPer.setUpdateTime(new Date());
        }
        List<ComTaskPer> dbPersonList = comTaskPerDao.findByTaskId(comTask.getComTaskId());
        if (dbPersonList.size() > 0) {
            //删除不存在的
            List<ComTaskPer> removeList = new ArrayList<>();
            CollectionUtils.addAll(removeList, new Object[dbPersonList.size()]);
            Collections.copy(removeList, dbPersonList);
            removeList.removeAll(newPerList);
            if (removeList.size() > 0) {
                comTaskPerDao.deleteBatch(removeList);
                comTaskSchedulDao.deleteBatchByTaskIdPerIds(removeList);
            }
        }
        //删除数据库中已存在的
        newPerList.removeAll(dbPersonList);

        if (newPerList.size() > 0) {
            //保存新增的
            comTaskPerDao.saveBatch(newPerList);
        }
    }

    @Override
    public void importBatch(List<ComTask> list) {
        List<ComTask> dbList = comTaskDao.findByBatchId(list);
        list.removeAll(dbList);
        if(list != null && list.size() > 0) {
            comTaskDaoAop.saveBatch(list);
        }
    }

    @Override
    public List<ComTask> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comTaskDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComTask> findByContractId(String contractId) {
        return comTaskDao.findByContractId(contractId);
    }

    @Override
    public List<ComTask> findByPerId(Long perId) {
        return comTaskDao.findByPerId(perId);
    }
    /**
     * 定时器更新驻勤状态和合同状态
     */
    @Override
    public void updateStatusV2() {
        //定时器更新驻勤状态
        comTaskDao.updateTaskStatusNew(null);
        //定时器更新合同状态
        comTaskDao.updateContractStatus();

    }

    @Override
    public void addPersons(ComTask comTask,String perIdListStr) {
        User currentUser = arsUtil.getCurrentUser();
        List<ComTaskPer> perList = new ArrayList<>();
        ComTaskPer comTaskPer = null;
        for (String perId : perIdListStr.split(",")) {
            comTaskPer = new ComTaskPer();
            comTaskPer.setComTaskId(comTask.getComTaskId());
            comTaskPer.setPerId(Long.parseLong(perId));
            comTaskPer.setActive(true);
            comTaskPer.setCreateTime(new Date());
            comTaskPer.setUpdateBy(currentUser.getUsername());
            comTaskPer.setUpdateTime(new Date());
            perList.add(comTaskPer);
        }
        if(perList != null && perList.size() > 0) {
            comTask.setPerList(perList);
            comTaskPerDao.saveBatch(perList);
            new Thread(()->{
                comTaskDao.relationTask(comTask);
            }).start();
        }
    }

    @Override
    public void removePersons(ComTask comTask,String perIdListStr) {
        List<ComTaskPer> perList = new ArrayList<>();
        ComTaskPer comTaskPer = null;
        for (String perId : perIdListStr.split(",")) {
            comTaskPer = new ComTaskPer();
            comTaskPer.setComTaskId(comTask.getComTaskId());
            comTaskPer.setPerId(Long.parseLong(perId));
            perList.add(comTaskPer);
        }
        if(perList != null && perList.size() > 0) {
            comTask.setPerList(perList);
            comTaskPerDao.deleteBatch(perList);
            comTaskSchedulDao.deleteBatchByTaskIdPerIds(perList);
            new Thread(()->{
                comTaskDao.removeRelationTask(comTask);
            }).start();
        }
    }

    @Override
    public void delete(ComTask comTask) {
        comTask.setUpdateTime(new Date());
        comTask.setIsDelete("1");
        comTaskDaoAop.delete(comTask);

        comTaskPerDao.deleteByTaskId(comTask.getComTaskId());
        comTaskSchedulDao.deleteByTaskId(comTask.getComTaskId());

        new Thread(()->{
            comTaskDao.removeRelationTask(comTask);
        }).start();
    }

    @Override
    public void deleteBatch(Long[] taskIdList) {
        List<ComTask> taskList = new ArrayList<>();
        ComTask comTask = null;
        for (Long taskId : taskIdList) {
            comTask = new ComTask();
            comTask.setUpdateTime(new Date());
            comTask.setIsDelete("1");
            comTask.setComTaskId(taskId);
            taskList.add(comTask);
        }

        comTaskDaoAop.deleteBatch(taskList);

        comTaskPerDao.deleteByTaskIds(taskIdList);
        comTaskSchedulDao.deleteByTaskIds(taskIdList);

        new Thread(()->{
            comTaskDao.removeRelationTaskList(taskList);
        }).start();
    }

    @Override
    public List<ComTask> findByComId(String comId) {
        return comTaskDao.findByComId(comId);
    }

}
