package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComTaskSchedulDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.BbdTaskSchedul;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTaskSchedul;
import com.bcxin.ars.service.task.ComTaskSchedulService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 任务排班制明细Service实现类
 *
 * @author linqinglin
 * @Date 2020-03-24 16:43:05
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComTaskSchedul.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
public class ComTaskSchedulServiceImpl implements ComTaskSchedulService {

    Logger logger = LoggerFactory.getLogger(ComTaskSchedulServiceImpl.class);

    @Autowired
    private ComTaskSchedulDao comTaskSchedulDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   
    @Override
    public int delete(ComTaskSchedul comTaskSchedul) {
        User currentUser = arsUtil.getCurrentUser();
        comTaskSchedul.setUpdateTime(new Date());
        comTaskSchedul.setUpdateBy(currentUser.getUsername());
        return comTaskSchedulDao.delete(comTaskSchedul);
    }

    @Override
    public int save(ComTaskSchedul comTaskSchedul) {
        User currentUser = arsUtil.getCurrentUser();
        if(comTaskSchedul.getId() == null){
            comTaskSchedul.setCreateTime(new Date());
        }else{
            ComTaskSchedul dbComTaskSchedul = comTaskSchedulDao.findById(comTaskSchedul.getId());
            BeanUtils.copyPropertiesIgnore(comTaskSchedul,dbComTaskSchedul,true);
            BeanUtils.copyPropertiesIgnore(dbComTaskSchedul,comTaskSchedul,false);
        }

        comTaskSchedul.setActive(true);
        comTaskSchedul.setUpdateBy(currentUser.getUsername());
        comTaskSchedul.setUpdateTime(new Date());
        comTaskSchedul.setUpdateflag(true);
        comTaskSchedul.setAreaCode(currentUser.getPolice().getAreacode());
        return comTaskSchedulDao.save(comTaskSchedul);
    }

    @Override
    public ComTaskSchedul findById(Long id) {
        return comTaskSchedulDao.findById(id);
    }


    @Override
    public void importBatch(List<ComTaskSchedul> list) {
        List<ComTaskSchedul> dbList = comTaskSchedulDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComTaskSchedul comTaskSchedul : list) {
                comTaskSchedul.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       comTaskSchedul.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comTaskSchedul.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comTaskSchedulDao.saveBatch(list);
        }
    }

    @Override
    public List<ComTaskSchedul> findByBatchId(List<ComTaskSchedul> list) {
        return comTaskSchedulDao.findByBatchId(list);
    }

    @Override
    public void saveBatch(List<BbdTaskSchedul> taskScheduls,Long comTaskId,String startDate,String endDate ) {
        User currentUser = arsUtil.getCurrentUser();
        List<ComTaskSchedul> list = new ArrayList<>();
        List<String> perIds = new ArrayList<>();

        for (BbdTaskSchedul bbdTaskSchedul : taskScheduls) {
            perIds.add(bbdTaskSchedul.getPerId());
            list.addAll(bbdTaskSchedul.getTaskSchedulList());
        }

        comTaskSchedulDao.deleteByTaskIdPerIdsAndTime(comTaskId,perIds,startDate,endDate);
        if(list.size() > 0) {
            for (ComTaskSchedul schedul : list) {
                schedul.setActive(true);
                schedul.setUpdateTime(new Date());
                schedul.setUpdateBy(currentUser.getUsername());
            }
            comTaskSchedulDao.saveBatch(list);
        }
    }

    /**
     * 外网同步到内网查询
     * @param dto
     * @return
     */
    @Override
    public List<ComTaskSchedul> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comTaskSchedulDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComTaskSchedul> findDSOutList(String startDate) {
        return comTaskSchedulDao.findDSOutList(startDate);
    }

}
