package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.task.ComTaskPer;
import com.bcxin.ars.service.task.ComTaskPerService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
/**
 * 任务安排人员Service实现类
 *
 * @author linqinglin
 * @Date 2020-03-26 09:22:37
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComTaskPer.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
public class ComTaskPerServiceImpl implements ComTaskPerService {

    Logger logger = LoggerFactory.getLogger(ComTaskPerServiceImpl.class);

    @Autowired
    private ComTaskPerDao comTaskPerDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   

    @Override
    public void importBatch(List<ComTaskPer> list) {
        List<ComTaskPer> dbList = comTaskPerDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComTaskPer comTaskPer : list) {
                comTaskPer.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       comTaskPer.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comTaskPer.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comTaskPerDao.saveBatch(list);
        }
    }

    @Override
    public List<ComTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comTaskPerDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComTaskPer> findByBatchId(List<ComTaskPer> list) {
        return comTaskPerDao.findByBatchId(list);
    }

}
