package com.bcxin.ars.service.task.impl;

import com.bcxin.ars.dao.task.ComShiftDao;
import com.bcxin.ars.dao.task.ComShiftRuleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComShiftPageSearchDto;
import com.bcxin.ars.dto.task.ComShiftDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComShift;
import com.bcxin.ars.model.task.ComShiftRule;
import com.bcxin.ars.service.task.ComShiftService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 企业班次Service实现类
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:32
 */
@Service
@Transactional
public class ComShiftServiceImpl implements ComShiftService {

    Logger logger = LoggerFactory.getLogger(ComShiftServiceImpl.class);

    @Autowired
    private ComShiftDao comShiftDao;

    @Autowired
    private ComShiftRuleDao comShiftRuleDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   
    @Override
    public int delete(ComShift comShift) {
        User currentUser = arsUtil.getCurrentUser();
        comShift.setUpdateTime(new Date());
        comShift.setUpdateBy(currentUser.getUsername());
        return comShiftDao.delete(comShift);
    }

    @Override
    public int save(ComShiftDto comShift) {
        User currentUser = arsUtil.getCurrentUser();
        if(comShift.getComShiftRuleList() != null && comShift.getComShiftRuleList().size() > 0){
            for (ComShiftRule comShiftRule : comShift.getComShiftRuleList()) {
                comShiftRule.setUpdateBy(currentUser.getUsername());
                comShiftRule.setUpdateTime(new Date());
            }
            comShiftRuleDao.saveBatch(comShift.getComShiftRuleList());
        }
        if(comShift.getOldShiftId() != null){
            ComShift oldComShift = comShiftDao.findById(comShift.getOldShiftId());
            if(oldComShift != null){
                oldComShift.setEffectEndTime(new Date());
                comShiftDao.save(oldComShift);
            }
        }

        ComShift dbComShift = comShiftDao.findById(comShift.getShiftId());
        if(dbComShift == null){
            comShift.setCreateTime(new Date());
        }else{
            BeanUtils.copyPropertiesIgnore(comShift,dbComShift,true);
            BeanUtils.copyPropertiesIgnore(dbComShift,comShift,false);
        }

        comShift.setUpdateBy(currentUser.getUsername());
        comShift.setUpdateTime(new Date());
        return comShiftDao.save(comShift);
    }

    @Override
    public ComShift findById(Long id) {
        return comShiftDao.findById(id);
    }

    @Override
    public void searchForPage(ComShiftPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       comShiftDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<ComShift> list) {
        List<ComShift> dbList = comShiftDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComShift comShift : list) {
                comShift.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       comShift.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comShift.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comShiftDao.saveBatch(list);
        }
    }

    @Override
    public List<ComShift> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comShiftDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComShift> findDSOutList(String startDate) {
        return comShiftDao.findDSOutList(startDate);
    }

    @Override
    public List<ComShift> findByBatchId(List<ComShift> list) {
        return comShiftDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ComShift comShift) {
        User currentUser = arsUtil.getCurrentUser();
        comShift.setUpdateTime(new Date());
        comShift.setUpdateBy(currentUser.getUsername());
        comShiftDao.updateSelective(comShift);
    }
}
