package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.RegisterpersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Registerperson;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.Sha1Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
@Transactional
public class RegisterpersonServiceImpl implements RegisterpersonService{

    /***
     * 日志
     */
	private static Logger logger = LoggerFactory.getLogger(RegisterpersonServiceImpl.class);
	
	@Autowired
	private RegisterpersonDao registerpersonDao;
	
	@Autowired
	private UserService userService;
	
	@Autowired
	private ArsUtil arsUtil;

    @Override
    public AjaxResult singleUserRegister(User user) {
        AjaxResult result = new AjaxResult();
        try {
            ///判断手机是否重复
            User dbUser = userService.findByUsername(user.getPhone(), String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
            if(dbUser != null){
                result.setSuccessful(false);
                result.setMsg("手机号已被注册!");
                return result;
            }
            //用户类型
            user.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
            //通过单点手机号码和名称一样
            //user.setRealname(user.getRealname());
            user.setUpdateBy(user.getUsername());
            user.setPassword(Sha1Util.entryptPassword(user.getPassword()));
            userService.saveOrUpdate(user,String.valueOf(user.getPlatform()));
            Registerperson registerperson = new Registerperson();

            //注册信息
            registerperson.setCompanyname(user.getPhone());
            registerperson.setCompanytype("1");
            registerperson.setName(user.getRealname());
            registerperson.setPhone(user.getPhone());
            registerperson.setUserid(user.getId());

            saveOrUpdate(registerperson);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }
	@Override
	public AjaxResult SXNWregister(User user) {
		AjaxResult result = new AjaxResult();
		try {
		//	User dbUser = userService.findByUsernameStatus(user.getUsername(), true);
//			User dbUser = userService.findByUsername(user.getUsername(),String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
//			if(dbUser != null){
//				result.setSuccessful(false);
//				result.setMsg("用户已存在!");
//				return result;
//			}
			///判断手机是否重复
			User dbUser = userService.findByUsername(user.getPhone(), String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
			if(dbUser != null){
				result.setSuccessful(false);
				result.setMsg("手机号已被注册!");
				return result;
			}
			//解决类型
			user.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
			//通过单点手机号码和名称一样
			user.setRealname(user.getPhone());
			user.setUpdateBy(user.getUsername());
			user.setPassword(Sha1Util.entryptPassword(user.getPassword()));
			userService.saveOrUpdate(user,String.valueOf(user.getPlatform()));
			Registerperson registerperson = new Registerperson();

			//TODO
			registerperson.setCompanyname(user.getPhone());
			registerperson.setCompanytype("1");
			registerperson.setName(user.getRealname());
			registerperson.setPhone(user.getPhone());
			registerperson.setUserid(user.getId());

			saveOrUpdate(registerperson);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

	@Override
	public Registerperson findById(long id) {
		return registerpersonDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Registerperson registerperson) {
		User currentUser = arsUtil.getCurrentUser();
		if(registerperson.getId() == null){
			registerperson.setActive(true);
			registerperson.setCreateTime(new Date());
			registerperson.setUpdateTime(new Date());
			if(currentUser != null){
				registerperson.setUpdateBy(currentUser.getUsername());
			}
			
			//TODO
			registerperson.setName(registerperson.getPhone());
			registerperson.setCompanytype("1");
			registerperson.setCompanyname(registerperson.getPhone());
			registerpersonDao.save(registerperson);
		}else{
			Registerperson dbRegisterperson = registerpersonDao.findById(registerperson.getId());
			dbRegisterperson.setUpdateTime(new Date());
			if(currentUser != null){
				dbRegisterperson.setUpdateBy(currentUser.getUsername());
			}
			dbRegisterperson.setUpdateTime(new Date());
			
			dbRegisterperson.setCompanyname(registerperson.getCompanyname());
			dbRegisterperson.setCardnumber(registerperson.getCardnumber());
			dbRegisterperson.setCompanytype(registerperson.getCompanytype());
			dbRegisterperson.setEmail(registerperson.getEmail());
			dbRegisterperson.setName(registerperson.getName());
			dbRegisterperson.setPhone(registerperson.getPhone());
			dbRegisterperson.setValidatecode(registerperson.getValidatecode());
			
			registerpersonDao.update(dbRegisterperson);
		}
		
	}

	@Override
	public AjaxResult register(User user) {
		AjaxResult result = new AjaxResult();
		try {
			//User dbUser = userService.findByUsernameStatus(user.getUsername(), true);
			User dbUser = userService.findByUsername(user.getUsername(), String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
			if(dbUser != null){
				result.setSuccessful(false);
				result.setMsg("登陆用户名已存在!");
				return result;
			}

			///判断手机是否重复
			dbUser = userService.findByUsername(user.getPhone(), String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
			if(dbUser != null){
				result.setSuccessful(false);
				result.setMsg("手机号已被注册!");
				return result;
			}
			//角色为自然人
			user.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
			//用户名
			user.setUsername(user.getUsername());
			//手机号
			user.setPhone(user.getPhone());
			//更新者
			user.setUpdateBy(user.getUsername());
			user.setPassword(Sha1Util.entryptPassword(user.getPassword()));
			userService.saveOrUpdate(user,String.valueOf(user.getPlatform()));
			Registerperson registerperson = new Registerperson();
			
			//TODO 注册信息
			registerperson.setCompanyname(user.getPhone());
			registerperson.setCompanytype("1");
			registerperson.setName(user.getPhone());
			registerperson.setPhone(user.getPhone());
			registerperson.setUserid(user.getId());
			
			saveOrUpdate(registerperson);
			result.setSuccessful(true);

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}



}
