package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.subsidy.ExportConfigDaoAop;
import com.bcxin.ars.dao.sys.ExportConfigColumnDao;
import com.bcxin.ars.dto.sys.ExportColumnDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.service.sys.ExportColumnService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
@Transactional
public class ExportColumnServiceImpl implements ExportColumnService {

    @Autowired
    private ExportConfigColumnDao exportConfigColumnDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ExportConfigDaoAop exportConfigDaoAop;
    @Override
    public void search(ExportColumnDto exportConfigDto, AjaxPageResponse<ExportColumn> page) {
        exportConfigColumnDao.search(exportConfigDto,page);
    }

    @Override
    public ExportColumn findById(Long id) {
        return exportConfigColumnDao.findById(id);
    }

    @Override
    public void save(ExportColumn exportColumn) {
        User currentUser = arsUtil.getCurrentUser();
        if(exportColumn.getId() == null){
            exportColumn.setCreateTime(new Date());
        }
        exportColumn.setActive(true);
        exportColumn.setUpdateBy(currentUser.getUsername());
        exportColumn.setUpdateTime(new Date());
        exportConfigDaoAop.saveColumn(exportColumn);
    }
}
