package com.bcxin.ars.service.sxzw.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import com.bcxin.ars.dto.SxsSbAjaxResult;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SxsZwAjaxResult;
import com.bcxin.ars.dto.sxzw.SxzwSignDto;
import com.bcxin.ars.dto.sxzw.SxzwUserDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sxzw.SxZwWebService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.AESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.sms.MD5Util;

import cn.hutool.http.HttpUtil;

import javax.servlet.http.HttpServletRequest;

/**
 * 陕西省互联网+公安政务服务接口
 * 
 * @author zhangye
 * @version 1.0
 */
@Service
@Transactional
public class SxZwServiceImpl implements SxZwWebService {

	Logger logger = LoggerFactory.getLogger(SxZwServiceImpl.class);

	@Autowired
	private UserService userService;

	@Autowired
	private LoginLogService loginLogService;






	@Autowired
	private SponsorlicenseService sponsorlicenseService;







	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private UserDao userDao;

	@Autowired
	private RegisterpersonService registerpersonService;

	@Value("${login-timeout}")
	private int loginTimeout = 10;

	/**
	 * 加密KEY
	 */
	@Value("${sx-xa-appKey}")
	private String APPKEY;
	/**
	 * 接入系统ID
	 */
	@Value("${sx-xa-appId}")
	private String APPID;
	/**
	 * token验证URL
	 */
	@Value("${sx-xa-tokenValidate-url}")
	private String ZW_TOKENVALIDATE_URL;
	/**
	 * @Author: subh
	 * @Description:提供给公安政务查询接口
	 * @param appId
	 *            接入系统ID
	 * @param timeStamp
	 *            时间戳
	 * @param randomStr
	 *            随机字符串
	 * @param signStr
	 *            签名字符串
	 * @return
	 */
	@Override
	public SxsSbAjaxResult query(String appId, String timeStamp, String randomStr, String signStr) {
		String stringA = "appId=" + appId + "&randomStr=" + randomStr + "&timeStamp=" + timeStamp;
		String signStrTemp = stringA + "&appKey=82b4d6845f2f1f227fc6884ed87f2f00";
		signStr = MD5Util.string2MD5(signStrTemp).toLowerCase();
		SxsSbAjaxResult sxsZwAjaxResult = new SxsSbAjaxResult();
		try {
			if(!signStr.equals( MD5Util.string2MD5(signStrTemp).toLowerCase())){
				sxsZwAjaxResult.setMsg("数据签名不正确");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			}
			sxsZwAjaxResult= sponsorlicenseService.find();
			sxsZwAjaxResult.setMsg("操作成功");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			sxsZwAjaxResult.setMsg("访问政务网接口失败！");
			sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
			return sxsZwAjaxResult;
		}
		return sxsZwAjaxResult;
	}



	public SxsZwAjaxResult login(String token, String itemId, String url, String redirectUrl,HttpServletRequest request) {
		String appId = APPID;
		String randomStr = createRandomCharData(32);// 获取32位随机数
		Calendar cal = Calendar.getInstance();
		Long timeStamp = cal.getTimeInMillis(); // 获取时间戳
		String appKey = APPKEY;
		String signStr = ""; // 数据签名字符串
		String stringA = "appId=" + appId + "&randomStr=" + randomStr + "&timeStamp=" + timeStamp;
		String signStrTemp = stringA + "&appKey=" + appKey;
		signStr = MD5Util.string2MD5(signStrTemp).toLowerCase();
		SxsZwAjaxResult sxsZwAjaxResult = new SxsZwAjaxResult();
		try {
			// 调用西安市公安政务token验证接口
			String zw_tokenValidate_Url = ZW_TOKENVALIDATE_URL;
			Map<String, Object> paramMap = new HashMap<String, Object>();
			paramMap.put("appId", appId);
			paramMap.put("timeStamp", timeStamp.toString());
			paramMap.put("randomStr", randomStr);
			paramMap.put("signStr", signStr);
			paramMap.put("token", token);
			SxzwSignDto sxzwSignDto = new SxzwSignDto();
			sxzwSignDto.setAppId(appId);
			sxzwSignDto.setTimeStamp(timeStamp);
			sxzwSignDto.setRandomStr(randomStr);
			sxzwSignDto.setSignStr(signStr);
			String returnResult = HttpUtil.post(zw_tokenValidate_Url, paramMap, 10000);
			if (StringUtil.isEmpty(returnResult)) {
				// 验证失败
				sxsZwAjaxResult.setMsg("访问token验证接口失败");
				sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
				return sxsZwAjaxResult;
			} else {
				// 验证成功
				SxsZwAjaxResult checkResult = new SxsZwAjaxResult();
				checkResult = JSONObject.parseObject(returnResult, SxsZwAjaxResult.class);
				if (checkResult.getCode() == Constants.SXS_XAS_CODE_SUCCES) {
					// 解密
					String userData = AESUtil.decrypt(checkResult.getUserObj().toString(), appKey, 128);
					SxzwUserDto sxzwUserDto = JSONObject.parseObject(userData, SxzwUserDto.class);
					if (sxzwUserDto == null) {
						checkResult.setCode(Constants.SXS_XAS_CODE_ERROR);
						checkResult.setMsg("访问政务网接口返回数据失败！");
						checkResult.setUserObj(null);
						return checkResult;
					}
					if (StringUtils.isEmpty(sxzwUserDto.getUserName())) {
						checkResult.setCode(Constants.SXS_XAS_CODE_ERROR);
						checkResult.setMsg("政务网接口返回数据用户姓名为空！");
						checkResult.setUserObj(null);
						return checkResult;
					}
					if (StringUtils.isEmpty(sxzwUserDto.getMobile())) {
						checkResult.setCode(Constants.SXS_XAS_CODE_ERROR);
						checkResult.setMsg("政务网接口返回数据用户手机号码为空！");
						checkResult.setUserObj(null);
						return checkResult;
					}
					if (StringUtils.isEmpty(sxzwUserDto.getIdentityId())) {
						checkResult.setCode(Constants.SXS_XAS_CODE_ERROR);
						checkResult.setMsg("政务网接口返回数据用户身份证号码为空！");
						checkResult.setUserObj(null);
						return checkResult;
					}

					if (sxzwUserDto.getMobile().length() != 11) {
						checkResult.setCode(Constants.SXS_XAS_CODE_ERROR);
						checkResult.setMsg("政务网接口返回数据用户手机号码长度不正确！");
						checkResult.setUserObj(null);
						return checkResult;
					}

					User user = new User();
					user.setIdNumber(sxzwUserDto.getIdentityId());
					user.setPhone(sxzwUserDto.getMobile().toString());
					user.setPassword(sxzwUserDto.getMobile().toString().substring(
							sxzwUserDto.getMobile().toString().length() - 6,
							sxzwUserDto.getMobile().toString().length()));
					user.setRealname(sxzwUserDto.getUserName());
					user.setUsername(sxzwUserDto.getMobile().toString());
					List<User> data = userDao.searchByDto(user);
					// 如果不存在该用户 帮其注册
					if (data.size() == 0) {
						// 注册
						AjaxResult userAjaxResult = registerpersonService.SXNWregister(user);
						// 注册失败
						if (!userAjaxResult.isSuccessful()) {
							sxsZwAjaxResult.setMsg("注册账号失败！");
							sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
							return sxsZwAjaxResult;
						}
						// 如果自动注册则设置手机号码后六位
						user.setPassword(sxzwUserDto.getMobile().toString().substring(
								sxzwUserDto.getMobile().toString().length() - 6,
								sxzwUserDto.getMobile().toString().length()));
					} else {
						// 获取已经存在的用户信息
						user = data.get(0);
					}
					// 重定向地址非空则是正式登录
					if (!StringUtils.isEmpty(redirectUrl)) {
						// 登录
						AjaxResult loginAjaxResult = new AjaxResult();
						try {
							loginAjaxResult = webLogin(user.getUsername(), user.getPassword(),request);
						} catch (Exception e) {
							// 登录失败
							logger.error(e.getMessage(), e);
							sxsZwAjaxResult.setMsg("登录失败！");
							sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
							return sxsZwAjaxResult;
						}
						if (!loginAjaxResult.isSuccessful()) {
							sxsZwAjaxResult.setMsg("登录失败！");
							sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
							return sxsZwAjaxResult;
						}
					}
					// 验证成功，登录成功
					checkResult.setUrl(url);
					checkResult.setSignObj(sxzwSignDto);
					checkResult.setUserObj(null);
					return checkResult;
				} else {
					// 验证失败
					checkResult.setCode(Constants.SXS_XAS_CODE_ERROR);
					checkResult.setMsg("访问政务网接口失败！");
					checkResult.setUserObj(null);
					return checkResult;
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			sxsZwAjaxResult.setMsg("访问政务网接口失败！");
			sxsZwAjaxResult.setCode(Constants.SXS_XAS_CODE_ERROR);
			return sxsZwAjaxResult;
		}
	}
	/**
	 * @Author: zhangye
	 * @Description:用户登录
	 */
	private AjaxResult webLogin(String username, String password,HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			UsernamePasswordToken token = new UsernamePasswordToken(username, password, Constants.SXNWCode);
			Subject currentUser = SecurityUtils.getSubject();
			token.setRememberMe(false);
			try {
				currentUser.login(token);
			} catch (AuthenticationException e) {
				logger.error(e.getMessage(), e);
				result.setSuccessful(false);
				result.setMsg("用户名/密码错误");
			}
			// 判断是否登录成功！
			if (currentUser.isAuthenticated()) {
				Session session = currentUser.getSession();
				User user = userService.findByUsername(username,String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
				System.out.println("当前登录用户是：" + user.getUsername());
				// 更新一下登陆状态
				user.setLoginstate(1);
				// 登录次数+1
				if (user.getLoginNum() != null) {
					user.setLoginNum(user.getLoginNum() + 1);
				} else {
					user.setLoginNum(1);
				}
				// 登录时间为当前时间
				user.setLoginDate(new Date());
				userService.updateLoginState(user);
				// sessionID
				user.setSessionId(session.getId().toString());
				// 设置超时时间
				arsUtil.setCurrentUser(user, 1000 * 120 * loginTimeout);
				result.setData(user);
				result.setSuccessful(true);
				loginLogService.logIn(request);
			}
		} catch (UnknownAccountException e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg("用户名/密码错误");
		} catch (IncorrectCredentialsException e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg("用户名/密码错误");
		} catch (ExcessiveAttemptsException e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg("登录失败多次，账户锁定10分钟");
		} catch (AuthenticationException e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	private static String createRandomCharData(int length) {
		StringBuilder sb = new StringBuilder();
		Random rand = new Random();// 随机用以下三个随机生成器
		Random randdata = new Random();
		int data = 0;
		for (int i = 0; i < length; i++) {
			int index = rand.nextInt(3);
			// 目的是随机选择生成数字，大小写字母
			switch (index) {
			case 0:
				data = randdata.nextInt(10);// 仅仅会生成0~9
				sb.append(data);
				break;
			case 1:
				data = randdata.nextInt(26) + 65;// 保证只会产生65~90之间的整数
				sb.append((char) data);
				break;
			case 2:
				data = randdata.nextInt(26) + 97;// 保证只会产生97~122之间的整数
				sb.append((char) data);
				break;
			}
		}
		return sb.toString();
	}

}
