package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.CompanyAwardDao;
import com.bcxin.ars.dao.supervision.CompanyAwardDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.CompanyAwardPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.CompanyAward;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/07/16 0016 14:45
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = CompanyAward.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = CompanyAward.class,getImportType = ImportType.BATCH)
public class CompanyAwardServiceImpl extends BaseService implements CompanyAwardService {

    @Autowired
    private CompanyAwardDao companyAwardDao;
    @Autowired
    private CompanyAwardDaoAop companyAwardDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private IdWorker idWorker;
    @Override
    public int delete(CompanyAward record) {
        User currentUser = arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return companyAwardDaoAop.delete(record);
    }

    @Override
    public void save(CompanyAward record) {
        User currentUser = arsUtil.getCurrentUser();
        if(record.getId() == null){
            record.setId(idWorker.nextId());
            record.setCreateTime(new Date());
            if(StringUtil.isNotEmpty(record.getSignImgPath())){
                record.setSignImgPath(saveBase64Img(record.getSignImgPath()));
            }
        }else{
            CompanyAward dbRecord = companyAwardDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore(record,dbRecord,true);
            BeanUtils.copyPropertiesIgnore(dbRecord,record,false);
        }
        //自招单位公司是未驻入系统的，把输入的公司名称保存
        String isInSystem = record.getIsInSystem();
        if((!StringUtils.isEmpty(isInSystem))&&(isInSystem.equals(Constants.NOT_IN_SYS))){
            String companyNameDefine = record.getCompanyNameDefine();
            record.setCompanyName(companyNameDefine);
            record.setCompanyId(null);
        }
        record.setActive(true);
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(true);
        record.setUserid(currentUser.getId());
        record.setAreaCode(currentUser.getPolice().getAreacode());
        companyAwardDaoAop.save(record);
    }

    @Override
    public CompanyAward findById(Long id) {
        return companyAwardDao.findById(id);
    }

    @Override
    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        arsUtil.setPoliceSearch(dto);
        CompanyAwardPageSearchDto searchDto = (CompanyAwardPageSearchDto)dto;
        if(StringUtil.isNotEmpty(searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {// 省
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {// 市
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {// 区
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        companyAwardDao.searchForPage((CompanyAwardPageSearchDto)dto,page);
    }

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    public List<CompanyAward> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return companyAwardDao.searchForDataSynchronization(searchDto);
    }

    /**
     *外网数据同步到内网
     * @param list
     */
    public void  saveOrUpdateForDS(List<CompanyAward> list) {
        List<CompanyAward> dbList =new ArrayList<CompanyAward>();
        //将每一条数据导入内网
        //根据id在内网中查询是否存在，若存在，满足条件外网时间大于内网时间则更新,不满足则不更新
        //若不存在直接将数据新增到表中
        for (CompanyAward companyAward : list) {
            CompanyAward companyAwardIn = companyAwardDao.findById(companyAward.getId());
            if (companyAwardIn == null) {
                companyAward.setUpdateflag(false);
            } else {
                if (companyAward.getUpdateTime().getTime() < companyAwardIn.getUpdateTime().getTime()) {
                    dbList.add(companyAward);
                }
                companyAward.setUpdateflag(true);
            }
        }
        list.removeAll(dbList);
        companyAwardDaoAop.saveBatch(list);
    }
    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    public List<CompanyAward> findDSOutList(String startDate) {
        return companyAwardDao.findDSOutList(startDate);
    }

    /**
     * 内网数据同步到外网
     * @param list
     */
    public void importBatch(List<CompanyAward> list) {
        List<CompanyAward> dbList = companyAwardDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (CompanyAward companyAward : list) {
                companyAward.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        companyAward.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, companyAward.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            companyAwardDaoAop.saveBatch(list);
        }
    }

}
