package com.bcxin.ars.service.subsidy.impl;


import com.bcxin.ars.dao.subsidy.SubsidyOfflineBatchDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.subsidy.SubsidyOfflineBatch;
import com.bcxin.ars.service.subsidy.SubsidyOfflineBatchService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 线下补贴审批单关联批次Service业务层处理
 * 
 * @author lin
 * @date 2020-11-12
 */
@Service
public class SubsidyOfflineBatchServiceImpl implements SubsidyOfflineBatchService {
    
    Logger logger = LoggerFactory.getLogger(SubsidyOfflineBatchServiceImpl.class);
    
    @Autowired
    private SubsidyOfflineBatchDao subsidyOfflineBatchDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(SubsidyOfflineBatch subsidyOfflineBatch) {
        User currentUser = arsUtil.getCurrentUser();
        subsidyOfflineBatch.setUpdateTime(new Date());
        subsidyOfflineBatch.setUpdateBy(currentUser.getUsername());
        return subsidyOfflineBatchDao.delete(subsidyOfflineBatch);
    }

    @Override
    public int save(SubsidyOfflineBatch subsidyOfflineBatch) {
        User currentUser = arsUtil.getCurrentUser();
        if(subsidyOfflineBatch.getId() == null){
            subsidyOfflineBatch.setCreateTime(new Date());
        }else{
            SubsidyOfflineBatch dbSubsidyOfflineBatch = subsidyOfflineBatchDao.findById(subsidyOfflineBatch.getId());
            BeanUtils.copyPropertiesIgnore(subsidyOfflineBatch,dbSubsidyOfflineBatch,true);
            BeanUtils.copyPropertiesIgnore(dbSubsidyOfflineBatch,subsidyOfflineBatch,false);
        }

        subsidyOfflineBatch.setActive(true);
        subsidyOfflineBatch.setUpdateBy(currentUser.getUsername());
        subsidyOfflineBatch.setUpdateTime(new Date());
        subsidyOfflineBatch.setUpdateflag(true);
        subsidyOfflineBatch.setAreaCode(currentUser.getPolice().getAreacode());
        return subsidyOfflineBatchDao.save(subsidyOfflineBatch);
    }

    @Override
    public SubsidyOfflineBatch findById(Long id) {
        return subsidyOfflineBatchDao.findById(id);
    }

    @Override
    public void importBatch(List<SubsidyOfflineBatch> list) {
        List<SubsidyOfflineBatch> dbList = subsidyOfflineBatchDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (SubsidyOfflineBatch subsidyOfflineBatch : list) {
                subsidyOfflineBatch.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        subsidyOfflineBatch.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, subsidyOfflineBatch.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            subsidyOfflineBatchDao.saveBatch(list);
        }
    }

    @Override
    public List<SubsidyOfflineBatch> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return subsidyOfflineBatchDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<SubsidyOfflineBatch> findDSOutList(String startDate) {
        return subsidyOfflineBatchDao.findDSOutList(startDate);
    }

    @Override
    public List<SubsidyOfflineBatch> findByBatchId(List<SubsidyOfflineBatch> list) {
        return subsidyOfflineBatchDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(SubsidyOfflineBatch subsidyOfflineBatch) {
        User currentUser = arsUtil.getCurrentUser();
        subsidyOfflineBatch.setUpdateTime(new Date());
        subsidyOfflineBatch.setUpdateBy(currentUser.getUsername());
        subsidyOfflineBatchDao.updateSelective(subsidyOfflineBatch);
    }
}
