package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.YearReportInvestorDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInvestorSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.YearReportInvestor;
import com.bcxin.ars.service.sb.YearReportInvestorService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.webservice.ClientUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = YearReportInvestor.class)
public class YearReportInvestorServiceImpl implements YearReportInvestorService {

    @Autowired
    private YearReportInvestorDao investorDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    
    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;

    @Override
    public YearReportInvestor findById(long id) {
        return investorDao.findById(id);
    }

    @Override
    public void saveOrUpdate(YearReportInvestor investor) {
        User currentUser = arsUtil.getCurrentUser();
        if (investor.getId() == null) {
            investor.setActive(true);
            investor.setCreateTime(new Date());
            investor.setUpdateTime(new Date());
            investor.setUpdateBy(currentUser.getUsername());
            investor.setUserid(currentUser.getId());
            investorDao.save(investor);

        } else {
            YearReportInvestor dbYearReportInvestor = investorDao.findById(investor.getId());
            dbYearReportInvestor.setUpdateBy(currentUser.getUsername());
            dbYearReportInvestor.setUpdateTime(new Date());
            dbYearReportInvestor.setAddress(investor.getAddress());
            dbYearReportInvestor.setFundedNumber(investor.getFundedNumber());
            dbYearReportInvestor.setIdNumber(investor.getIdNumber());
            dbYearReportInvestor.setInvestorsType(investor.getInvestorsType());
            dbYearReportInvestor.setName(investor.getName());
            dbYearReportInvestor.setNation(investor.getNation());
            dbYearReportInvestor.setNational(investor.getNational());
            dbYearReportInvestor.setNowaddress(investor.getNowaddress());
            dbYearReportInvestor.setPhone(investor.getPhone());
            dbYearReportInvestor.setSex(investor.getSex());
            dbYearReportInvestor.setStockProportion(investor.getStockProportion());
            dbYearReportInvestor.setRatioTransfer(investor.getRatioTransfer());
            dbYearReportInvestor.setShareholderBefore(investor.getShareholderBefore());
            dbYearReportInvestor.setRatioBefor(investor.getRatioBefor());
            dbYearReportInvestor.setTransferTime(investor.getTransferTime());
            dbYearReportInvestor.setChangeRecord(investor.getChangeRecord());
            investorDao.update(dbYearReportInvestor);
        }
    }

    @Override
    public YearReportInvestorSearchDto search(YearReportInvestorSearchDto dto) {
        YearReportInvestorSearchDto resultDto = new YearReportInvestorSearchDto();
        List<YearReportInvestor> list = investorDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(investorDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public void delete(YearReportInvestor investor) {
        User currentUser = arsUtil.getCurrentUser();
        investor.setUpdateBy(currentUser.getUsername());
        investor.setUpdateTime(new Date());
        investorDao.delete(investor);
    }

    @Override
    public List<YearReportInvestor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return investorDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForDS(YearReportInvestor investor) {

        if (investor.getActive() == null) {
            investor.setActive(true);
        }

        if (!investor.getActive()) {
            investorDao.delete(investor);
        } else {
            YearReportInvestor dbYearReportInvestor = investorDao.findById(investor.getId());
            if (dbYearReportInvestor == null) {
                investorDao.saveForDS(investor);
            } else {
                if (investor.getUpdateTime().getTime() > dbYearReportInvestor.getUpdateTime().getTime()) {
                    investorDao.update(investor);
                }
            }
        }
    }

    @Override
    public List<YearReportInvestor> findByUserId(Long userId) {
        return investorDao.findByUserId(userId);
    }


}
