package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.TraincompanyapplyDao;
import com.bcxin.ars.dao.sb.TraincompanyapplyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.TraincompanyapplySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.TraincompanyapplyService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Traincompanyapply.class)
public class TraincompanyapplyServiceImpl implements TraincompanyapplyService {

    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;

    @Autowired
    private TraincompanyapplyDaoAop traincompanyapplyDaoAop;

    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private SecurityPersonDao securityPersonDao;


    @Autowired
    private ClientUtil clientUtil;

    @Override
    public Map searchForPrintf(long id) {
        return traincompanyapplyDao.searchForPrintf(id);
    }

    @Override
    public Traincompanyapply findById(long id) {
        Traincompanyapply result = traincompanyapplyDao.findById(id);
        if (result != null) {
            //查询审批日志信息
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.PXDW));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public  List<Traincompanyapply> findByBatchId(List<Approval> approvalList){
        return  traincompanyapplyDao.findByBatchId(approvalList);
    }
    @Override
    public  void updateBatch(List<Traincompanyapply> list){
        traincompanyapplyDaoAop.updateBatch(list);
    }

    @Override
    public void updatePoliceId(Traincompanyapply traincompanyapply) {
        Approval approval =  approvalDAO.getById(traincompanyapply.getApprovalId());
        Traincompanyapply dbtraincompanyapply1  = traincompanyapplyDao.findById(traincompanyapply.getId());
        dbtraincompanyapply1.setPoliceid(traincompanyapply.getPoliceid());
        traincompanyapplyDaoAop.update(dbtraincompanyapply1);
        /***
         * 更新民警 ID
         */
        approval.setPoliceid(traincompanyapply.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        approvalDAO.update(approval);
    }
    @Override
    public void saveOrUpdate(Traincompanyapply traincompanyapply) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(traincompanyapply.getOrgid() == null){
            if(traincompanyapply.getDistrictOrgId() != null){
                traincompanyapply.setOrgid(Long.parseLong(traincompanyapply.getDistrictOrgId()));
            }else if(traincompanyapply.getCityOrgId() != null){
                traincompanyapply.setOrgid(Long.parseLong(traincompanyapply.getCityOrgId()));
            }else{
                Police police = policeDao.findByType(Constants.ORGTYPE_PROVINCE).get(0);
                traincompanyapply.setOrgid(police.getId());
            }
        }

        if (traincompanyapply.getId() == null) {
            if(!traincompanyapply.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Traincompanyapply checkTraincompanyapply = traincompanyapplyDao.findApproveByCompanyName(traincompanyapply.getTraincompanyname());
                if(checkTraincompanyapply != null){
                    throw new ArsException(traincompanyapply.getTraincompanyname() + "已备案，不能重复备案！");
                }
            }

            traincompanyapply.setActive(true);
            traincompanyapply.setCreateTime(new Date());
            traincompanyapply.setUpdateTime(new Date());
            traincompanyapply.setUpdateBy(currentUser.getUsername());
            //TODO
            if(currentUser.getPlatform()==2 || currentUser.getPlatform()==4){
                traincompanyapply.setUserid(currentUser.getId());
            }
            traincompanyapply.setApprovalstate(ApprovalState.DSH);
            traincompanyapplyDao.save(traincompanyapply);
            if(traincompanyapply.getApprovalstate().equals(ApprovalState.DSH)) {
            	approvalUtil.saveApproval(BusinessType.PXDW, traincompanyapply.getId(),Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY);
            }
        } else {
            if(!traincompanyapply.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Traincompanyapply checkTraincompanyapply = traincompanyapplyDao.findApproveByCompanyName(traincompanyapply.getTraincompanyname());
                if(checkTraincompanyapply != null && checkTraincompanyapply.getId().longValue() != traincompanyapply.getId().longValue()){
                    throw new ArsException(traincompanyapply.getTraincompanyname() + "已备案，不能重复备案！");
                }
            }


            Traincompanyapply dbTraincompanyapply = traincompanyapplyDao.findById(traincompanyapply.getId());
            boolean activity = true;
            if(StringUtil.isNotEmpty(dbTraincompanyapply.getApprovalstate()) && dbTraincompanyapply.getApprovalstate().equals(ApprovalState.DSH)){
                if(dbTraincompanyapply.getOrgid().toString().equals(traincompanyapply.getOrgid().toString())){
                    activity = false;
                    if(!dbTraincompanyapply.getCompanyname().equals(traincompanyapply.getCompanyname())) {
                        Approval approval = approvalDAO.findBybusinessidAndType(traincompanyapply.getId(), BusinessType.PXDW);
                        if (approval != null) {
                            approvalUtil.updateContent(approval, traincompanyapply.getCompanyname());
                        }
                    }
                 }
            }
            if(ApprovalState.WTJ.equals(traincompanyapply.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(traincompanyapply,dbTraincompanyapply,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(traincompanyapply,dbTraincompanyapply,true);
            }
            dbTraincompanyapply.setUpdateTime(new Date());
            dbTraincompanyapply.setUpdateBy(currentUser.getUsername());


            if (traincompanyapply.getPoliceid() != null && !"".equals(traincompanyapply.getPoliceid())) {
                dbTraincompanyapply.setPoliceid(traincompanyapply.getPoliceid());
            }
            //待审批
            if (StringUtil.isNotEmpty(traincompanyapply.getApprovalstate()) && !traincompanyapply.getApprovalstate().equals(ApprovalState.DSH)) {
                dbTraincompanyapply.setApprovalstate(traincompanyapply.getApprovalstate());
            } else {
                dbTraincompanyapply.setApprovalstate(ApprovalState.DSH);
                dbTraincompanyapply.setReplyreason("");
                dbTraincompanyapply.setInfoRar("");
                dbTraincompanyapply.setReplyState("");
                dbTraincompanyapply.setReplyRar("");
                dbTraincompanyapply.setCensorStatus("");
                dbTraincompanyapply.setPlanCensorStatus("");
            }
            traincompanyapplyDaoAop.update(dbTraincompanyapply);

            if(dbTraincompanyapply.getApprovalstate().equals(ApprovalState.DSH) && activity) {
                approvalUtil.saveApproval(BusinessType.PXDW, dbTraincompanyapply.getId(),Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY);
            }
        }

    }
    @Override
    public void saveOrUpdateForIntegrate(Traincompanyapply traincompanyapply,User currentUser) {
        if(!traincompanyapply.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
            //开发任务 #10165
            Traincompanyapply checkTraincompanyapply = traincompanyapplyDao.findApproveByCompanyName(traincompanyapply.getTraincompanyname());
            if(checkTraincompanyapply != null){
                throw new ArsException(traincompanyapply.getTraincompanyname() + "已备案，不能重复备案！");
            }
        }
        traincompanyapply.setActive(true);
        traincompanyapply.setCreateTime(new Date());
        traincompanyapply.setUpdateTime(new Date());
        traincompanyapply.setUpdateBy(currentUser.getUsername());
        //TODO
        if(currentUser.getPlatform()==2 || currentUser.getPlatform()==4){
            traincompanyapply.setUserid(currentUser.getId());
        }
        traincompanyapply.setApprovalstate(ApprovalState.DSH);
        traincompanyapplyDao.save(traincompanyapply);

        if(traincompanyapply.getApprovalstate().equals(ApprovalState.DSH)) {
            approvalUtil.saveApprovalForIntegrate(BusinessType.PXDW, traincompanyapply.getId(),Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY,currentUser);
        }


    }

    @Override
    public void saveOrUpdateForDS(Traincompanyapply traincompanyapply) {

        if (traincompanyapply.getActive() == null) {
            traincompanyapply.setActive(true);
        }

        Traincompanyapply dbTraincompanyapply = traincompanyapplyDao.findById(traincompanyapply.getId());
        if (dbTraincompanyapply != null) {
            if (traincompanyapply.getUpdateTime().getTime() > dbTraincompanyapply.getUpdateTime().getTime()) {
                traincompanyapply.setCensorStatus(dbTraincompanyapply.getCensorStatus());
                traincompanyapply.setReplyState(dbTraincompanyapply.getReplyState());
                traincompanyapply.setPlanCensorStatus(dbTraincompanyapply.getPlanCensorStatus());
                traincompanyapply.setCardState(dbTraincompanyapply.getCardState());
                traincompanyapply.setReplyState(dbTraincompanyapply.getReplyState());
                traincompanyapplyDaoAop.update(traincompanyapply);
            }
        } else {
            traincompanyapplyDao.save(traincompanyapply);
        }
    }

    @Override
    public TraincompanyapplySearchDto search(TraincompanyapplySearchDto dto) {
        TraincompanyapplySearchDto resultDto = new TraincompanyapplySearchDto();


        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        String areacode =  police.getAreacode();
        if(areacode.endsWith("0000")){//省
            dto.setDistrict(areacode.substring(0,2)+"____");
        }else if(areacode.endsWith("00")){//市
            dto.setDistrict(areacode.substring(0,4)+"__");
        }else{//区
            dto.setDistrict(areacode);
        }


        List<Traincompanyapply> list = traincompanyapplyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(traincompanyapplyDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public Traincompanyapply findByUser(Long userid) {
        // TODO Auto-generated method stub
        return traincompanyapplyDao.findByUser(userid);
    }

    @Override
    public List<Traincompanyapply> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return traincompanyapplyDao.searchForDataSynchronization(searchDto);
    }
    @Override
    public List<Traincompanyapply> findAll() {
        // TODO Auto-generated method stub
        return traincompanyapplyDao.findAll();
    }
    @Override
    public void temporarySave(Traincompanyapply traincompanyapply) {
        User currentUser = arsUtil.getCurrentUser();

        if(traincompanyapply.getId() == null) {

            traincompanyapply.setApprovalstate(Constants.APPROVALSTATE_WTJ);
            traincompanyapply.setCreateTime(new Date());
            traincompanyapply.setUpdateTime(new Date());
            traincompanyapply.setActive(true);
            traincompanyapply.setUserid(currentUser.getId());
            traincompanyapply.setUpdateBy(currentUser.getUsername());
            traincompanyapplyDao.save(traincompanyapply);
        }else{


            Traincompanyapply dbTraincompanyapply = traincompanyapplyDao.findById(traincompanyapply.getId());

            if(ApprovalState.WTJ.equals(traincompanyapply.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(traincompanyapply,dbTraincompanyapply,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(traincompanyapply,dbTraincompanyapply,true);
            }


            dbTraincompanyapply.setUpdateTime(new Date());
            dbTraincompanyapply.setUpdateBy(currentUser.getUsername());

            if (traincompanyapply.getPoliceid() != null) {
                dbTraincompanyapply.setPoliceid(traincompanyapply.getPoliceid());
            }

            traincompanyapplyDaoAop.update(dbTraincompanyapply);
        }
    }
    
	@Override
	public List<ReportData> findByAreaReport(ReportDataSearchDto searchDto) {
		User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
		return traincompanyapplyDao.findByAreaReport(searchDto);
	}

    @Override
    public PageResult searchTraincompanyapplyList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();

        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }

        if (police != null) {
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }


        return new PageResult(traincompanyapplyDao.countTraincompanyapplyList(p), traincompanyapplyDao.searchTraincompanyapplyList(p));
    }

    @Override
    public void saveOrUpdateForApproval(Traincompanyapply traincompanyapply) {
        traincompanyapply.setUpdateTime(new Date());
        traincompanyapplyDaoAop.update(traincompanyapply);
    }

    @Override
    public void updateCensorStatus(Traincompanyapply traincompanyapply) {
        traincompanyapplyDaoAop.update(traincompanyapply);
    }

    @Override
    public void saveOrUpdateForApprovalImport(Traincompanyapply traincompanyapply) {
        traincompanyapplyDaoAop.update(traincompanyapply);
    }

    @Override
    public void savePermitDoc(Traincompanyapply traincompanyapply) {
        Traincompanyapply dbTraincompanyapply = traincompanyapplyDao.findById(traincompanyapply.getId());
        if(null != dbTraincompanyapply){
            if (StringUtil.isNotEmpty(traincompanyapply.getPermitPath())) {
                dbTraincompanyapply.setPermitPath(traincompanyapply.getPermitPath());
            }
            if (StringUtil.isNotEmpty(traincompanyapply.getPermitVideoPath())) {
                dbTraincompanyapply.setPermitVideoPath(traincompanyapply.getPermitVideoPath());
            }
            dbTraincompanyapply.setUpdateTime(new Date());
            traincompanyapplyDaoAop.update(dbTraincompanyapply);
        }
    }

    @Override
    public void searchForPage(TraincompanyapplySearchDto dto, AjaxPageResponse<Traincompanyapply> page) {
        arsUtil.setPoliceSearch(dto);
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }
        traincompanyapplyDao.searchForPage(dto,page);
    }

}