package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.SubsidiarypersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SubsidiarypersonSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Subsidiaryperson;
import com.bcxin.ars.service.sb.SubsidiarypersonService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Subsidiaryperson.class)
public class SubsidiarypersonServiceImpl implements SubsidiarypersonService{

	@Autowired
	private SubsidiarypersonDao subsidiarypersonDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Subsidiaryperson findById(long id) {
		return subsidiarypersonDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Subsidiaryperson subsidiaryperson) {
		User currentUser = arsUtil.getCurrentUser();
		if(subsidiaryperson.getId() == null){
			subsidiaryperson.setActive(true);
			subsidiaryperson.setCreateTime(new Date());
			subsidiaryperson.setUpdateTime(new Date());
			subsidiaryperson.setUpdateBy(currentUser.getUsername());
			subsidiarypersonDao.save(subsidiaryperson);
		}else{
			Subsidiaryperson dbSubsidiaryperson = subsidiarypersonDao.findById(subsidiaryperson.getId());
			dbSubsidiaryperson.setUpdateTime(new Date());
			dbSubsidiaryperson.setUpdateBy(currentUser.getUsername());
			dbSubsidiaryperson.setUpdateTime(new Date());
			subsidiarypersonDao.update(dbSubsidiaryperson);
		}
	}

	@Override
	public void saveOrUpdateForDS(Subsidiaryperson subsidiaryperson) {
		
		if(subsidiaryperson.getActive() == null){
			subsidiaryperson.setActive(true);
		}
		
		Subsidiaryperson dbSubsidiaryperson = subsidiarypersonDao.findById(subsidiaryperson.getId());
		if (dbSubsidiaryperson != null) {
			if(subsidiaryperson.getUpdateTime().getTime() > dbSubsidiaryperson.getUpdateTime().getTime()){
				subsidiarypersonDao.update(subsidiaryperson);
			}
		} else {
			subsidiarypersonDao.saveForDS(subsidiaryperson);
		}
	}

	@Override
	public SubsidiarypersonSearchDto search(SubsidiarypersonSearchDto dto) {
		SubsidiarypersonSearchDto resultDto = new SubsidiarypersonSearchDto();
		List<Subsidiaryperson> list =  subsidiarypersonDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(subsidiarypersonDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<Subsidiaryperson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return subsidiarypersonDao.searchForDataSynchronization(searchDto);
	}
}
