package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.SbSponsorlicenseManagerDaoAop;
import com.bcxin.ars.dao.sb.SbSponsorlicenseManagerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSponsorlicenseManagerSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.service.sb.SbSponsorlicenseManagerService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbSponsorlicenseManager.class)
public class SbSponsorlicenseManagerServiceImpl implements SbSponsorlicenseManagerService {

	@Autowired
	private SbSponsorlicenseManagerDao sbSponsorlicenseManagerDao;

	@Autowired
	private SbSponsorlicenseManagerDaoAop sbSponsorlicenseManagerDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public SbSponsorlicenseManager findById(long id) {
		return sbSponsorlicenseManagerDao.findById(id);
	}

	@Override
	public void saveOrUpdate(SbSponsorlicenseManager shareholder) {
		User currentUser = arsUtil.getCurrentUser();
		if(shareholder.getId() == null){
			shareholder.setActive(true);
			shareholder.setCreateTime(new Date());
			shareholder.setUpdateTime(new Date());
			shareholder.setUpdateBy(currentUser.getUsername());
			sbSponsorlicenseManagerDao.save(shareholder);
		}else{
			SbSponsorlicenseManager dbSbSponsorlicenseManager = sbSponsorlicenseManagerDao.findById(shareholder.getId());
			dbSbSponsorlicenseManager.setUpdateTime(new Date());
			dbSbSponsorlicenseManager.setUpdateBy(currentUser.getUsername());
			dbSbSponsorlicenseManager.setName(shareholder.getName());
			dbSbSponsorlicenseManager.setIdnum(shareholder.getIdnum());
			dbSbSponsorlicenseManager.setPhone(shareholder.getPhone());
			sbSponsorlicenseManagerDaoAop.update(dbSbSponsorlicenseManager);
		}
	}

	@Override
	public void saveOrUpdateForDS(SbSponsorlicenseManager sbSponsorlicenseManager) {
		if(sbSponsorlicenseManager.getActive() == null){
			sbSponsorlicenseManager.setActive(true);
		}

		SbSponsorlicenseManager dbSbSponsorlicenseManager = sbSponsorlicenseManagerDao.findById(sbSponsorlicenseManager.getId());
		if (dbSbSponsorlicenseManager != null) {
			if(sbSponsorlicenseManager.getUpdateTime().getTime() > dbSbSponsorlicenseManager.getUpdateTime().getTime()){
				sbSponsorlicenseManagerDao.update(sbSponsorlicenseManager);
			}
		} else {
			sbSponsorlicenseManagerDao.saveForDS(sbSponsorlicenseManager);
		}
	}

	@Override
	public SbSponsorlicenseManagerSearchDto search(SbSponsorlicenseManagerSearchDto dto) {
		SbSponsorlicenseManagerSearchDto resultDto = new SbSponsorlicenseManagerSearchDto();
		List<SbSponsorlicenseManager> list =  sbSponsorlicenseManagerDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbSponsorlicenseManagerDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<SbSponsorlicenseManager> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbSponsorlicenseManagerDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteBySid(long sponsorlicenseid){
		sbSponsorlicenseManagerDao.deleteBySid(sponsorlicenseid);
	}

	@Override
	public void updateCensorStatus(SbSponsorlicenseManager sbSponsorlicenseManager) {
		User currentUser = arsUtil.getCurrentUser();
		sbSponsorlicenseManager.setUpdateBy(currentUser.getUsername());
		sbSponsorlicenseManager.setUpdateTime(new Date());
		sbSponsorlicenseManagerDaoAop.updateCensorStatus(sbSponsorlicenseManager);
	}
}
