package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dao.sb.HandleGuideDao;
import com.bcxin.ars.dto.sb.HandleGuideSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.model.sb.HandleGuide;
import com.bcxin.ars.service.sb.HandleGuideService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
public class HandleGuideServiceImpl implements HandleGuideService {

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private HandleGuideDao handleGuideDao;

	@Autowired
	private SysAttachmentDao sysAttachmentDao;

	@Override
	public Long save(HandleGuide handleGuide) {
		return handleGuideDao.save(handleGuide);
	}

	@Override
	public HandleGuide findById(Long id) {
		HandleGuide handleGuide = handleGuideDao.findById(id);
		//获取附件
		handleGuide.setSysAttachment(sysAttachmentDao.findByBusiness(id.toString(),Constants.FILE_BUSINESSTYPE_BSZN));
		return handleGuide;
	}

	@Override
	public HandleGuide findByBusinessType(String businessType, String type) {
		return handleGuideDao.findByBusinessType(businessType,type);
	}

	@Override
	public void update(HandleGuide handleGuide) {
		handleGuideDao.update(handleGuide);
	}

	@Override
	public PageResult search(HandleGuideSearchDto searchDto) {
		List<NewsnoticePolice> list = handleGuideDao.search(searchDto);
		Long count = handleGuideDao.searchCount(searchDto);
		return new PageResult(count.intValue(), list);
	}

	@Override
	public void saveOrUpdate(HandleGuide handleGuide) {
		if(handleGuide.getId() == null){
			throw new ArsException("办理指南信息错误，请刷新重试！");
		}
		User currentUser = arsUtil.getCurrentUser();
		HandleGuide dbHandleGuide = handleGuideDao.findById(handleGuide.getId());
		if(StringUtil.isNotEmpty(handleGuide.getContent())) {
			dbHandleGuide.setContent(handleGuide.getContent());
		}

		handleGuideDao.update(dbHandleGuide);
		SysAttachment sysAttachment = new SysAttachment();
		sysAttachment.setBusinessid(dbHandleGuide.getId());
		sysAttachment.setBusinesstype(Constants.FILE_BUSINESSTYPE_BSZN);
		sysAttachmentDao.delete(sysAttachment);
		//保存附件
		if (StringUtil.isNotEmpty(handleGuide.getSysAttachmentId())) {
			SysAttachment dbSysAttachment = sysAttachmentDao.findById(Long.parseLong(handleGuide.getSysAttachmentId()));
			dbSysAttachment.setBusinessid(dbHandleGuide.getId());
			dbSysAttachment.setBusinesstype(Constants.FILE_BUSINESSTYPE_BSZN);
			dbSysAttachment.setUpdateBy(currentUser.getUsername());
			dbSysAttachment.setUpdateTime(new Date());
			sysAttachmentDao.update(dbSysAttachment);
		}
	}

	@Override
	public void searchForPage(HandleGuideSearchDto searchDto, AjaxPageResponse<HandleGuide> page) {
		arsUtil.setPoliceSearch(searchDto);
		handleGuideDao.searchForPage(searchDto,page);
	}

}
