package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sb.GradePersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.dto.sb.GradePersonSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.service.sb.GradePersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;

/***
 * 等级证服务器实现类
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradePerson.class,getSeq=20000,getDataSyncType = SyncType.SYNC)
@DataSyncOutAnnotation(getClazz = GradePerson.class)
public class GradePersonServiceImpl implements GradePersonService {

    /***
     * 日志
     */
    private static final Logger loger =  LoggerFactory.getLogger(GradePersonServiceImpl.class);

    @Autowired
    private GradePersonDao gradePersonDao;

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    @Autowired
    private PoliceDao policeDao;

    @Override
    public GradePerson findById(Long id) {
        return gradePersonDao.findById(id);
    }


    @Override
    public List<GradePerson> findDSOutList(String startDate) {
        return gradePersonDao.searchForExport(startDate);
    }
    @Override
    public void insert(GradePerson gradePerson) {
        gradePersonDao.insert(gradePerson);
    }

    @Override
    public void update(GradePerson gradePerson) {
        //获取数据库等级证信息
        GradePerson dbGradPerson=  gradePersonDao.findById(gradePerson.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(gradePerson,dbGradPerson,true);
        //当前用户信息
        User user  =arsUtil  .getCurrentUser();
        //设置修改信息
        dbGradPerson.setUpdateBy(user.getUsername());
        dbGradPerson.setUpdateTime(new Date());
        dbGradPerson.setApprovalState(null);
        dbGradPerson.setCensorStatus(null);
        dbGradPerson.setNoPassEdit(null);
        dbGradPerson.setReson(null);
        //更新
        gradePersonDao.update(dbGradPerson);
    }
    @Override
    public void saveAppeal(GradePerson gradePerson) {
        //获取数据库等级证信息
        GradePerson dbGradPerson=  gradePersonDao.findById(gradePerson.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(gradePerson,dbGradPerson,true);
        //当前用户信息
        User user  =arsUtil  .getCurrentUser();
        dbGradPerson.setUpdateBy(user.getUsername());
        dbGradPerson.setUpdateTime(new Date());
        Police p =  policeDao.findById(gradePerson.getOrgId());
        dbGradPerson.setOrgName(p.getOrgname());
        //更新
        gradePersonDao.update(dbGradPerson);
    }

    @Override
    public void saveAppealApproval(GradePerson gradePerson) {
        //获取数据库等级证信息
        GradePerson dbGradPerson=  gradePersonDao.findById(gradePerson.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(gradePerson,dbGradPerson,true);
        //当前用户信息
        User user  =arsUtil  .getCurrentUser();
        dbGradPerson.setUpdateBy(user.getUsername());
        dbGradPerson.setUpdateTime(new Date());
        dbGradPerson.setUpdateflag(true);
        //申诉不通过
        if(Constants.APPEAL_PASS.equals(dbGradPerson.getAppealState())){
            dbGradPerson.setReson(null);
            dbGradPerson.setCensorStatus(Constants.CENSORSTATUS_PASS);
            /****
             * 检查是否有资格证
             */
            SecurityCertificate securityCertificate =   securityCertificateDao.findByIdnum(gradePerson.getIdnum());
            if(securityCertificate!=null) {
                //不可以修改
                dbGradPerson.setNoPassEdit(Constants.NOPASSDIT_NO);
                //审批通过
                dbGradPerson.setApprovalState(Constants.APPROVALSTATE_TG);
                //设置证书编号
                dbGradPerson.setSecurityCertificateNo(securityCertificate.getZsbh());
                //设置发证日期
                dbGradPerson.setFzrq(securityCertificate.getFzrq());
            }else{
                //审批不通过
                dbGradPerson.setApprovalState(Constants.APPROVALSTATE_BTG);
                dbGradPerson.setReson(Constants.PERSON_OUTTIME_BTG_MES);
                dbGradPerson.setNoPassEdit(Constants.NOPASSDIT_NO);
            }
        }
        //更新
        gradePersonDao.update(dbGradPerson);
    }
    @Override
    public List<Map<String, String>> insertBatchForImport(List<Map<String, String>> dataList) {
        //当前用户信息
        User user  =arsUtil  .getCurrentUser();
        //随机产生3位数
        Random random = new Random();
        int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取3位随机数
        String importBatchId =DateUtil.getCurrentDateTime(DateUtil.FORMAT8)+rannum;
        /**** 数据量太大导致java内存溢出 ,这里分批插入 ****/
        int insertLength = dataList.size();
        int i = 0;
        while (insertLength > 2000) {
            gradePersonDao.insertTempBatchGradePersonImport(dataList.subList(i, i + 2000), importBatchId);
            i = i + 2000;
            insertLength = insertLength - 2000;
        }
        if (insertLength > 0) {
            gradePersonDao.insertTempBatchGradePersonImport(dataList.subList(i, i + insertLength), importBatchId);
        }

        /***** 导入逻辑 start ***/
        /******验证导入的Excel是否有重复身份证数据**************/
        gradePersonDao.checkIdNumNoRepeat(importBatchId);
        /******验证需要导入的数据身份证是否已存在人员对比库**************/
        gradePersonDao.checkInOtherCom(importBatchId,user.getId());
        /***** 插入数据 ***/
        gradePersonDao.insertGradePersonInfo(importBatchId);
        /***** 导入逻辑 end ***/

        /***** 查询本次校验失败的导入保安师信息 ****/
        List<Map<String, String>> tempInputPerList = gradePersonDao.getTempImportGradePersonList(importBatchId);
        /***** 删除本次导入的保安师信息 ****/
        gradePersonDao.deleteTempBatchGradePersonImport(importBatchId);
        return tempInputPerList;
    }
    @Override
    public void importBatch(List<GradePerson> list) {
        //批量获取
        List<GradePerson> dbList = gradePersonDao.findByBatchId(list);
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if(list!=null && list.size()>0){
            //去悼更新标识并加一秒，内网不再导出来
            for (GradePerson gradePerson:list
                 ) {
                try {
                    gradePerson.setUpdateflag(false);
                    gradePerson.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, gradePerson.getUpdateTime(), 1));
                }catch (Exception e){
                    loger.error(e.getMessage());
                }
            }
            try {
                gradePersonDao.updateBatch(list);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<GradePerson> query(GradePersonSearchDto dto, AjaxPageResponse<GradePerson> ajaxPageResponse) {
        return gradePersonDao.query(dto,ajaxPageResponse);
    }

    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     * @param gradePerson
     */
    @Override
    public void saveOrUpdateForDS(GradePerson gradePerson){
        GradePerson dbGradePerson = gradePersonDao.findById(gradePerson.getId());
        if (dbGradePerson != null) {
            if(gradePerson.getUpdateTime().getTime() > dbGradePerson.getUpdateTime().getTime()) {
                gradePersonDao.update(gradePerson);
            }
        }else {
            gradePersonDao.insert(gradePerson);
        }
    }
    /**
     * 查询需要生成同步文件的等级证记录
     * @param dto
     * @return
     */
    @Override
    public List<GradePerson> searchForDataSynchronization(DataSynchronizationSearchDto dto){
        return gradePersonDao.searchForDataSynchronization(dto);
    }
    @Override
    public List<GradePerson> findNoCensorStatus(){
        return gradePersonDao.findNoCensorStatus();
    }

    @Override
    public List<String> queryImportBatchIdList() {
        User user  = arsUtil.getCurrentUser();
        return gradePersonDao.queryImportBatchIdList(user.getId());
    }

    @Override
    public void autoUpdateCensorStatus() {
        /****
         * 未背景筛查列表
         */
        /*List<GradePerson> gradePersonList =  gradePersonDao.findNoCensorStatus();
        if(gradePersonList!=null && gradePersonList.size()>0) {
            *//***
             * 开始背景筛查
             *//*
            updateCensorStatusForAuto(gradePersonList);
        }*/
    }
    public void updateCensorStatusForAuto(List<GradePerson> gradePersonList){
        for(GradePerson gradePerson:gradePersonList) {
            try {
                    Boolean pass = true;
                    Date d = new Date();
                    //背景筛查开始
                    BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                    backgroundApprovalDto.setBusinessid(gradePerson.getId());
                    backgroundApprovalDto.setBusinesstype(Constants.GRADEPERSON_CENSORSTATUS);
                    backgroundApprovalDto.setIdNumber(gradePerson.getIdnum());
                    backgroundApprovalDto.setRealName(gradePerson.getName());
                    //查询结果
                    String approvalReason = null;
                    List<BackgroundApproval> list = gradePerson.getBackgroundApprovals();
                    //背景筛查结果为空则证明背景筛查异常
                    if(list == null || list.size()==0){
                        continue;
                    }
                    for (BackgroundApproval backgroundApproval : list) {
                        if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                            if (Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType())) {
                                approvalReason = "背景筛查不通过，原因：" + backgroundApproval.getApprovalreason();
                                //可以修改
                                gradePerson.setNoPassEdit(Constants.NOPASSDIT_YES);
                            } else {
                                approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;
                                //不可以修改
                                gradePerson.setNoPassEdit(Constants.NOPASSDIT_NO);
                            }
                            pass = false;
                            break;
                        }
                    }
                    gradePerson.setReson(approvalReason);
                    if (pass) {
                        //背景筛查通过
                        gradePerson.setCensorStatus(Constants.CENSORSTATUS_PASS);
                        /****
                         * 检查是否有资格证
                         */
                        SecurityCertificate securityCertificate =   securityCertificateDao.findByIdnum(gradePerson.getIdnum());
                        if(securityCertificate!=null) {
                            //不可以修改
                            gradePerson.setNoPassEdit(Constants.NOPASSDIT_NO);
                            //审批通过
                            gradePerson.setApprovalState(Constants.APPROVALSTATE_TG);
                            //设置证书编号
                            gradePerson.setSecurityCertificateNo(securityCertificate.getZsbh());
                            //设置发证日期
                            gradePerson.setFzrq(securityCertificate.getFzrq());
                        }else{
                            //审批不通过
                            gradePerson.setApprovalState(Constants.APPROVALSTATE_BTG);
                            gradePerson.setReson(Constants.PERSON_OUTTIME_BTG_MES);
                            gradePerson.setNoPassEdit(Constants.NOPASSDIT_NO);
                        }
                    } else {
                        //背景筛查不通过
                        gradePerson.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                        //审批不通过
                        gradePerson.setApprovalState(Constants.APPROVALSTATE_BTG);
                    }
                    //更新背景筛查状态
                    gradePerson.setUpdateTime(d);
                    gradePerson.setUpdateflag(true);
            }catch (Exception e){
                loger.error("异常"+gradePerson.getIdnum());
            }
        }
        /***
         * 批量更新
         */
        gradePersonDao.updateBatch(gradePersonList);
    }

}
