package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.GradeClassDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeClassPageSearchDto;
import com.bcxin.ars.dto.sb.GradeClassDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeClass;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.GradeClassService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/****
 * 等级证班级信息
 * @author  subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradeClass.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
@DataSyncOutAnnotation(getClazz = GradeClass.class)
public class GradeClassServiceImpl extends BaseService implements GradeClassService {

    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradeClassServiceImpl.class);

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private GradeClassDao gradeClassDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Resource
    private IdWorker idWorker;

    @Resource
    private PersonGradeDao personGradeDao;

    @Resource
    private SecurityCompanyDao securityCompanyDao;

    @Override
    public List<GradeClass> query(GradeClassPageSearchDto dto, AjaxPageResponse<GradeClass> ajaxPageResponse) {

        arsUtil.setPoliceSearch(dto);
        return gradeClassDao.query(dto, ajaxPageResponse);
    }

    @Override
    public List<GradeClass> findDSOutList(String startDate) {
        return  gradeClassDao.searchForExport(startDate);
    }

    @Override
    public GradeClass findById(Long id) {
        return gradeClassDao.findById(id);
    }

    @Override
    public List<GradeClass> findByBatchId(List<GradeClass> list) {
        return null;
    }

    @Override
    public void saveOrUpdateForDS(GradeClass gradeClass) {
        GradeClass dbGradeClass = findById(gradeClass.getId());
        if (dbGradeClass != null) {
            if(gradeClass.getUpdateTime().getTime() > dbGradeClass.getUpdateTime().getTime()) {
                gradeClassDao.update(gradeClass);
            }
        }else {
            gradeClassDao.insert(gradeClass);
        }
    }
    @Override
    public void saveAppealApproval(GradeClass gradeClass) {
        //获取数据库等级证班级信息
        GradeClass dbGradeClass = findById(gradeClass.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(gradeClass,dbGradeClass,true);
        //当前用户信息
        User user = arsUtil.getCurrentUser();
        dbGradeClass.setUpdateBy(user.getUsername());
        dbGradeClass.setUpdateTime(new Date());
        dbGradeClass.setUpdateflag(true);
        //更新
        gradeClassDao.update(dbGradeClass);
    }

    @Override
    public void importBatch(List<GradeClass> list) {
        //批量获取
        List<GradeClass> dbList = gradeClassDao.findByBatchId(list);
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if(list!=null && list.size()>0){
            //审批状态同步级百课堂
            Map<Long, GradeClass> dbMap = dbList.stream().collect(Collectors.toMap(GradeClass::getId, Function.identity()));
            List<GradeClass> approvals = new ArrayList<>();
            for (GradeClass gradeClass:list) {
                if(!configUtils.isIntranet()){
                    if(dbMap.get(gradeClass.getId()) != null
                            && StringUtil.isNotEmpty(gradeClass.getApprovalState())
                            && !gradeClass.getApprovalState().equals(dbMap.get(gradeClass.getId()).getApprovalState())
                    ) {
                        approvals.add(gradeClass);
                    }
                }
                //去掉更新标识并加一秒，内网不再导出来
                try {
                    gradeClass.setUpdateflag(false);
                    gradeClass.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, gradeClass.getUpdateTime(), 1));
                }catch (Exception e){
                    logger.error(e.getMessage());
                }
            }
            try {
                gradeClassDao.updateBatch(list);
            }catch (Exception e){
                logger.error(e.getMessage());
            }
            // TODO 审批状态同步级百课堂
            if(approvals != null && approvals.size() >0){
                for (GradeClass gradeClass : approvals) {
                    Map<String,Object> paramMap = new HashMap<>();
                    paramMap.put("gradeClassId", gradeClass.getId());
                    paramMap.put("approvalStatus", gradeClass.getApprovalState());
                    bktInterfaceUtil.callInterface(Constants.BKT_GRADECLASS_CENSOR_URL,paramMap);
                }
            }
        }
    }

    @Override
    public List<GradeClass> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return gradeClassDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdate(GradeClassDto gradeClass) {
        //当前用户
       // User currentUser = arsUtil.getCurrentUser();
        //更新时间
        gradeClass.setUpdateTime(new Date());
        //用户ID
       // gradeClass.setUserid(currentUser.getId());
        //更新标记
        gradeClass.setUpdateflag(false);
        //等级默认五级
        if(StringUtil.isEmpty(gradeClass.getGradeLevel())){
            gradeClass.setGradeLevel(Constants.GRADE_LEVEL_DEFAULT);
        }
        if(StringUtil.isNotEmpty(gradeClass.getPracticeScheduleUrl())){
            gradeClass.setPracticeScheduleUrl(getPhotoPath(gradeClass.getPracticeScheduleUrl()));
        }
        if(StringUtil.isNotEmpty(gradeClass.getPracticeSignUrl())){
            gradeClass.setPracticeSignUrl(getPhotoPath(gradeClass.getPracticeSignUrl()));
        }
        if(StringUtil.isNotEmpty(gradeClass.getPoliceCheckUrl())){
            gradeClass.setPoliceCheckUrl(getPhotoPath(gradeClass.getPoliceCheckUrl()));
        }
        //逻辑判断 TODO
        //1.更新等级证报名信息与班级关联
        if(gradeClass.getClassPersonIds() != null && gradeClass.getClassPersonIds().length>0) {
            gradeClassDao.addPersonClass(gradeClass);
        }
        //2.更新班级信息
        GradeClass dbGradeClass = findById(gradeClass.getId());
        if (dbGradeClass != null) {
            BeanUtils.copyPropertiesIgnore(gradeClass,dbGradeClass,true);
            gradeClassDao.update(dbGradeClass);
        }else {
            //创建时间
            gradeClass.setCreateTime(new Date());
            //有效标记
            gradeClass.setActive(true);
            //更新者 TODO
            gradeClass.setUpdateBy("System");
            //待审批
            gradeClass.setApprovalState(Constants.APPROVALSTATE_DSP);
            gradeClassDao.insert(gradeClass);
        }
    }
    @Override
    public void updateCancelClass(GradeClassDto gradeClass) {
        //获取信息并且复制值
        GradeClass dbGradeClass = findById(gradeClass.getId());
        //当前用户
//        User currentUser = arsUtil.getCurrentUser();
        //更新者
        dbGradeClass.setUpdateBy("system");
        //更新时间
        dbGradeClass.setUpdateTime(new Date());
        //取消
        dbGradeClass.setApprovalState(Constants.GRADECLASS_APPROVALSTATE_CANCEL);
        dbGradeClass.setPerNum(0);
        //1.更新等级证报名信息与班级关联
        gradeClassDao.update(dbGradeClass);
        //取消班级删除人员信息
        gradeClassDao.delPersonClassByCancel(gradeClass);
    }
    @Override
    public void updateClassPersonInfo(GradeClassDto dto) {
        //获取信息并且复制值
        GradeClass dbGradeClass = findById(dto.getId());
        BeanUtils.copyPropertiesIgnore(dbGradeClass,dto,true);
        //更新等级证报名信息与班级关联
        //新增 TODO
        if(Constants.CLASS_OPERATION_TYPE_ADD.equals(dto.getType())){
            gradeClassDao.addPersonClass(dto);
        }else{
            //删除
            gradeClassDao.delPersonClass(dto);
        }
        //更新班级人数
        gradeClassDao.updatePerNum(dto);
    }

    @Override
    public void autoUpdateApprovalState(String hour) {
        gradeClassDao.autoUpdateApprovalState(hour);
    }

    @Override
    public AjaxResult addGradeClassRequest(String gradeClassInfo) {
        AjaxResult ajaxResult = new AjaxResult();
        // 解密string
        String subject = JwtUtil.parseJWT(gradeClassInfo).getSubject();
        GradeClassDto gradeClass = JSON.parseObject(subject, GradeClassDto.class);
        // 判断下开班名称
        if (StringUtil.isBlank(gradeClass.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("提交失败, 缺少班级名称");
            return ajaxResult;
        }
        // 根据名称查询是否已开过
        int gradeClassCount = gradeClassDao.getByGradeName(gradeClass.getName());
        // 如果该名称存在, 则失败
        if (gradeClassCount > 0) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("提交失败, 该名称已存在");
            return ajaxResult;
        }
        // 获取comId
        User currentUser = arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        long id = idWorker.nextId();
        Date now = new Date();
        gradeClass.setId(id);
        gradeClass.setUserid(userId);
        gradeClass.setApprovalState(Constants.APPROVALSTATE_DSP);
        gradeClass.setUpdateTime(now);
        gradeClass.setCreateTime(now);
        gradeClass.setActive(true);
        gradeClass.setPerNum(gradeClass.getIdNumberList().size());
        gradeClass.setGradeLevel(Constants.GRADE_LEVEL_DEFAULT);

        // 添加开班
        gradeClassDao.insert(gradeClass);
        // 关联人员 如果关联人员的话, 则添加
        if (gradeClass.getIdNumberList().size() > 0) {
            gradeClassDao.addPersonClassByIdNumberList(gradeClass);
        }
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("操作成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult getGradeClassRequestResult(String gradeClassName) {
        String name = JwtUtil.parseJWT(gradeClassName).getSubject();
        AjaxResult ajaxResult = new AjaxResult();
        // 判断下开班名称
        if (StringUtil.isBlank(name)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("查询失败, 缺少班级名称");
            return ajaxResult;
        }
        User currentUser = arsUtil.getCurrentUser();
        String trainId = currentUser.getComId();
        String approvalState = gradeClassDao.getApprovalStateByGradeName(name, trainId);
        ajaxResult.setData(JwtUtil.createJWT(approvalState));
        ajaxResult.setMsg("查询成功");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    @Override
    public AjaxResult addGradeClassPerson(String gradeClass) {
        AjaxResult ajaxResult = new AjaxResult();
        // 解密string
        String subject = JwtUtil.parseJWT(gradeClass).getSubject();
        GradeClassDto gradeClassDto = JSON.parseObject(subject, GradeClassDto.class);
        List<String> idNumberList = gradeClassDto.getIdNumberList();
        // 判断下开班名称
        if (StringUtil.isBlank(gradeClassDto.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("添加失败, 缺少班级名称");
            return ajaxResult;
        }
        if (CollectionUtil.isEmpty(idNumberList)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("添加失败, 身份证列表为空");
            return ajaxResult;
        }

        User currentUser = arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        gradeClassDto.setUserid(userId);

        // 获取班级的id
        Long classId = gradeClassDao.getClassIdByGradeName(gradeClassDto);
        if (classId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("添加失败, 班级不存在");
            return ajaxResult;
        }
        gradeClassDto.setId(classId);
        // 添加班级成员
        gradeClassDao.addPersonClassByIdNumberList(gradeClassDto);
        gradeClassDao.updatePerNum(gradeClassDto);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("添加成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult removeGradeClassPerson(String gradeClass) {
        AjaxResult ajaxResult = new AjaxResult();
        // 解密string
        String subject = JwtUtil.parseJWT(gradeClass).getSubject();
        GradeClassDto gradeClassDto = JSON.parseObject(subject, GradeClassDto.class);
        List<String> idNumberList = gradeClassDto.getIdNumberList();

        // 判断下开班名称
        if (StringUtil.isBlank(gradeClassDto.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("删除失败, 缺少班级名称");
            return ajaxResult;
        }
        // 判断下身份证列表
        if (CollectionUtil.isEmpty(idNumberList)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("删除失败, 身份证列表为空");
            return ajaxResult;
        }

        User currentUser = arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        gradeClassDto.setUserid(userId);

        // 获取classId
        Long classId = gradeClassDao.getClassIdByGradeName(gradeClassDto);
        if (classId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("删除失败, 班级不存在");
            return ajaxResult;
        }
        gradeClassDto.setId(classId);
        // 删除班级成员
        gradeClassDao.removePersonClassByIdNumberList(gradeClassDto);
        gradeClassDao.updatePerNum(gradeClassDto);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("删除成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult commitGradeClassAdditionalInfo(String gradeClass) {
        AjaxResult ajaxResult = new AjaxResult();
        // 解密string
        String subject = JwtUtil.parseJWT(gradeClass).getSubject();
        GradeClassDto gradeClassDto = JSON.parseObject(subject, GradeClassDto.class);
        // 没传必传参数
        if (StringUtil.isBlank(gradeClassDto.getName())) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("添加失败, 缺少班级名称");
            return ajaxResult;
        }

        User currentUser = arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        // 实操培训签到表
        String practiceScheduleUrl = gradeClassDto.getPracticeScheduleUrl();

        // 公安督导检查表
        String policeCheckUrl = gradeClassDto.getPoliceCheckUrl();

        // 转为本地地址
        gradeClassDto.setPracticeScheduleUrl(getPhotoPath(practiceScheduleUrl));

        gradeClassDto.setPoliceCheckUrl(getPhotoPath(policeCheckUrl));

        gradeClassDto.setUserid(userId);

        // 保存
        gradeClassDao.updateByGradeClassName(gradeClassDto);

        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("添加成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult confirmGradeResult(String gradeResult) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(gradeResult).getSubject();
        GradeClassDto gradeClassDto = JSON.parseObject(subject, GradeClassDto.class);
        // 开班名
        String gradeClassName = gradeClassDto.getName();
        List<PersonGrade> personGradeList = gradeClassDto.getPersonGradeList();
        if (StringUtil.isBlank(gradeClassName)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("操作失败, 缺少班级名称");
            return ajaxResult;
        }

        if (CollectionUtil.isEmpty(personGradeList)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("操作失败, 缺少成绩列表");
            return ajaxResult;
        }
        User currentUser = arsUtil.getCurrentUser();
        Long userId = currentUser.getId();
        gradeClassDto.setUserid(userId);
        Long classId = gradeClassDao.getClassIdByGradeName(gradeClassDto);
        if (classId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("操作失败, 班级不存在");
            return ajaxResult;
        }

        Map<String, String> resultData = Maps.newHashMap();
        // 添加到数据库
        for (PersonGrade personGrade : personGradeList) {
            String cerNo = personGrade.getCerNo();
            if (StringUtil.isBlank(cerNo)) {
                resultData.put(personGrade.getIdNum(), "缺少等级证书编号");
                continue;
            }
            personGrade.setClassId(classId);
            personGradeDao.updateByClassId(personGrade);
            resultData.put(personGrade.getIdNum(), "成功");
        }

        ajaxResult.setMsg("成功");
        ajaxResult.setSuccessful(true);
        ajaxResult.setData(JwtUtil.createJWT(resultData));
        return ajaxResult;
    }
}
