package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.FirearmsDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.sb.FirearmsService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.Bacydwqzpbxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Firearms.class)
public class FirearmsServiceImpl implements FirearmsService{
	private static Logger logger = LoggerFactory.getLogger(FirearmsServiceImpl.class);
	@Autowired
	private FirearmsDao firearmsDao;
	
	@Autowired
	private ArsUtil arsUtil;
	@Autowired
	private SecurityCompanyService securityCompanyService;
    @Autowired
    private SecurityPersonDao personDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;

	@Autowired
	private ClientUtil clientUtil;

	
	@Override
	public Firearms findById(long id) {
		return firearmsDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Firearms firearms) {

		User currentUser = arsUtil.getCurrentUser();
		User user = currentUser;

		if(firearms.getId() == null){
			firearms.setActive(true);
			firearms.setCreateTime(new Date());
			firearms.setUpdateTime(new Date());
			//新增时默认在库
			firearms.setFirearmsstate("2");
			firearms.setUpdateBy(currentUser.getUsername());
			firearms.setUserid(user.getId());
			firearmsDao.save(firearms);

		}else{
			Firearms dbFirearms = firearmsDao.findById(firearms.getId());
			dbFirearms.setUpdateBy(currentUser.getUsername());
			dbFirearms.setUpdateTime(new Date());
			dbFirearms.setFirearmsbuydate(firearms.getFirearmsbuydate());
			dbFirearms.setFirearmscompany(firearms.getFirearmscompany());
			dbFirearms.setFirearmscontext(firearms.getFirearmscontext());
			dbFirearms.setFirearmsnum(firearms.getFirearmsnum());
			dbFirearms.setFirearmsperson(firearms.getFirearmsperson());
			dbFirearms.setFirearmsxh(firearms.getFirearmsxh());
			dbFirearms.setRemarks(firearms.getRemarks());
			dbFirearms.setFirearmcertification(firearms.getFirearmcertification());
			firearmsDao.update(dbFirearms);
		}
		
	}

	@Override
	public FirearmsSearchDto search(FirearmsSearchDto dto) {
		FirearmsSearchDto resultDto = new FirearmsSearchDto();
		List<Firearms> list =  firearmsDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(firearmsDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(Firearms firearms) {
		User currentUser = arsUtil.getCurrentUser();
		firearms.setUpdateBy(currentUser.getUsername());
		firearms.setUpdateTime(new Date());
		firearmsDao.delete(firearms);
	}

	@Override
	public List<Firearms> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return firearmsDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(Firearms firearms) {

		if(firearms.getActive() == null){
			firearms.setActive(true);
		}
		
		if(!firearms.getActive()){
			firearmsDao.delete(firearms);
		}else{
			Firearms dbFirearms = firearmsDao.findById(firearms.getId());
			if(dbFirearms == null){
				firearmsDao.saveForDS(firearms);
				/**********************************部级上报开始 start**************************************************************************/
				SecurityCompany securityCompany = securityCompanyDao.findByUserid(firearms.getUserid());
				//部级接口对接
				new Thread(()->{ //异步处理
					try {
						SecurityCompany dbcompany = securityCompanyService.findByUserid(dbFirearms.getUserid());
						//确定对接的属性对应关系
						//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
						String[] key={"bagsbm","qzbh"};
						//TODO 部级接口
						String[] value={dbcompany.getCompanyCode(),"1"};
						//源实体类的列，目标实体类的列
						String[] srccol = {"firearmsnum","firearmscompany","firearmcertification"};
						String[] desccol = {"qh","zzqymc","fzdwmc"};
						//生成实体
						Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,dbFirearms,new Bacydwqzpbxx(),key,value);
						Bacydwqzpbxx bacydwqzpbxx =(Bacydwqzpbxx)desc;
						//调用send方法完成对接
						clientUtil.send(Constants.XXBA_BACYDWQZPBXX,bacydwqzpbxx);

					} catch(Exception e) {
						logger.error(e.getMessage(),e);
					}
				}).start();
				/**********************************部级上报开始 end**************************************************************************/
			}else{
				if(firearms.getUpdateTime().getTime() > dbFirearms.getUpdateTime().getTime()){
					firearmsDao.update(firearms);
				}
			}
		}
	}

	@Override
	public void searchForPage(FirearmsSearchDto searchDto, AjaxPageResponse<Firearms> page) {

		arsUtil.setPoliceSearch(searchDto);
		firearmsDao.searchForPage(searchDto,page);

	}

}
