package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.CrosscompanyDao;
import com.bcxin.ars.dao.sb.CrosscompanyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CrosscompanySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Crosscompany;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.CrosscompanyService;
import com.bcxin.ars.service.sys.impl.ApprovalServiceImpl;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.Bafwgskqjyxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Crosscompany.class)
public class CrosscompanyServiceImpl implements CrosscompanyService {
    private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);
    @Autowired
    private CrosscompanyDao crosscompanyDao;
    @Autowired
    private CrosscompanyDaoAop crosscompanyDaoAop;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private ClientUtil clientUtil;

    @Override
    public Crosscompany findById(long id) {
        Crosscompany result = crosscompanyDao.findById(id);
        if (result != null) {
            //查询审批信息
            //ApprovalDTO dto = new ApprovalDTO();
            //dto.setBusinessid(id);
            //dto.setBusinesstype(BusinessType.KQYBAGS);
            //List list = approvalDAO.getBusinessidAndType(dto);
            //result.setApprovallist(list);
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.KQYBAGS));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public  List<Crosscompany> findByBatchId(List<Approval> approvalList){
        return  crosscompanyDao.findByBatchId(approvalList);
    }

    @Override
    public  void updateBatch(List<Crosscompany> list){
        crosscompanyDao.updateBatch(list);
    }

    @Override
    public void saveOrUpdate(Crosscompany crosscompany) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(crosscompany.getOrgid() == null){
            if(crosscompany.getDistrictOrgId() != null){
                crosscompany.setOrgid(Long.parseLong(crosscompany.getDistrictOrgId()));
            }else if(crosscompany.getCityOrgId() != null){
                crosscompany.setOrgid(Long.parseLong(crosscompany.getCityOrgId()));
            }
        }

        if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4){
            crosscompany.setUserid(currentUser.getId());
        }

        if (crosscompany.getId() == null) {
            if(!crosscompany.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                if(StringUtil.isNotEmpty(crosscompany.getManagerproject()) && crosscompany.getStartdate()!=null && crosscompany.getEnddate()!=null ){
                    Crosscompany checkCrosscompany = crosscompanyDao.findApproveByManagerproject(crosscompany);
                    if(checkCrosscompany != null){
                        throw new ArsException("拟跨区域经营的保安服务项目【"+crosscompany.getManagerproject()+"】在" + DateUtil.convertDateToString(crosscompany.getStartdate(),"YYYY-MM-dd")+"至"+DateUtil.convertDateToString(crosscompany.getEnddate(),"YYYY-MM-dd")+ "已备案，不能重复备案！");
                    }
                }
            }


            crosscompany.setActive(true);
            crosscompany.setCreateTime(new Date());
            crosscompany.setUpdateTime(new Date());
            crosscompany.setUpdateBy(currentUser.getUsername());

            //待审批
            crosscompany.setApprovalstate(ApprovalState.DSH);
            crosscompanyDao.save(crosscompany);
            //TODO 保存审批信息
            if(crosscompany.getApprovalstate().equals(ApprovalState.DSH)) {
            	approvalUtil.saveApproval(BusinessType.KQYBAGS, crosscompany.getId(),Constants.ACTIVITI_PROCESS_CROSSCOMPANY);
            }

        } else {
            if(!crosscompany.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                if(StringUtil.isNotEmpty(crosscompany.getManagerproject()) && crosscompany.getStartdate()!=null && crosscompany.getEnddate()!=null ){
                    Crosscompany checkCrosscompany = crosscompanyDao.findApproveByManagerproject(crosscompany);
                    if(checkCrosscompany != null && checkCrosscompany.getId().longValue() != crosscompany.getId().longValue()){
                        throw new ArsException(crosscompany.getManagerproject()+"在" + DateUtil.convertDateToString(crosscompany.getStartdate(),"YYYY-MM-dd")+"至"+DateUtil.convertDateToString(crosscompany.getEnddate(),"YYYY-MM-dd")+ "已备案，不能重复备案！");
                    }
                }
            }


            Crosscompany dbCrosscompany = crosscompanyDao.findById(crosscompany.getId());

            boolean activity = true;
            if(StringUtil.isNotEmpty(dbCrosscompany.getApprovalstate()) && dbCrosscompany.getApprovalstate().equals(ApprovalState.DSH)){
                if(dbCrosscompany.getOrgid().toString().equals(crosscompany.getOrgid().toString())){
                    activity = false;
                    if(!dbCrosscompany.getCompanyname().equals(crosscompany.getCompanyname())) {
                        Approval approval = approvalDAO.findBybusinessidAndType(crosscompany.getId(), BusinessType.KQYBAGS);
                        if (approval != null) {
                            approvalUtil.updateContent(approval, crosscompany.getCompanyname());
                        }
                    }
                }
            }

            if(ApprovalState.WTJ.equals(crosscompany.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(crosscompany,dbCrosscompany,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(crosscompany,dbCrosscompany,true);
            }
            dbCrosscompany.setUpdateTime(new Date());
            dbCrosscompany.setUpdateBy(currentUser.getUsername());

            //待审批
            if (crosscompany.getApprovalstate() != null && !"".equals(crosscompany.getApprovalstate()) && !ApprovalState.DSH.equals(crosscompany.getApprovalstate())) {
                dbCrosscompany.setApprovalstate(crosscompany.getApprovalstate());
            } else {
                dbCrosscompany.setApprovalstate(ApprovalState.DSH);
                dbCrosscompany.setChargecensorstatus("");
                dbCrosscompany.setLegalcensorstatus("");

            }
            crosscompanyDaoAop.update(dbCrosscompany);

            //TODO 保存审批信息
            if(activity && ApprovalState.DSH.equals(crosscompany.getApprovalstate())){
                approvalUtil.saveApproval(BusinessType.KQYBAGS, dbCrosscompany.getId(),Constants.ACTIVITI_PROCESS_CROSSCOMPANY);
            }

            	/*
			*//**
             * 部级接口对接
             * 数据项名称	数据项标识符	是否必输
             保安服务公司编码	bagsbm	N
             经营地省市区（县）	jydz	Y
             联系方式	lxfs	N
             保安服务类型	fwlx	N
             负责人公民身份号码  	fzrsfzh 	N
             负责人姓名  	fzrxm   	N
             负责人职务  	fzrzw   	N
             负责人联系电话  	fzrdh   	N
             备案公安机关编码	bajgbm	N
             备案公安机关名称	bajgmc	N
             备案日期	barq	N
             开始经营日期	ksjyrq	N
             备注1	bz1	N
             备注2	bz2	N
             备注3	bz3	N
             保安服务许可证号	bafwxkz	Y
             *
             **/
			if(dbCrosscompany.getApprovalstate()!=null && dbCrosscompany.getApprovalstate().equals(ApprovalState.SHTG)) {
                new Thread(() -> { //异步处理
                    try {
                        SecurityCompany company = securityCompanyDao.findByUserid(dbCrosscompany.getUserid());
                        Bafwgskqjyxx bafwgskqjyxx = new Bafwgskqjyxx();
                        bafwgskqjyxx.setBafwxkz(company.getPublicSecurityLicenseNumber());
                        bafwgskqjyxx.setJydz(company.getAreaCode());
                        bafwgskqjyxx.setBagsbm(company.getCompanyCode());
                        //调用send方法完成对接
                        clientUtil.send(Constants.XXBA_BAFWGSKQJYXX, bafwgskqjyxx);
                    } catch (Exception e) {
                        logger.error(e.getMessage(),e);
                    }
                }).start();

            }
        }
    }

    @Override
    public void saveOrUpdateForDS(Crosscompany crosscompany) {

		if(crosscompany.getActive() == null){
			crosscompany.setActive(true);
		}
		
        Crosscompany dbCrosscompany = crosscompanyDao.findById(crosscompany.getId());
        if (dbCrosscompany != null) {
        	if(crosscompany.getUpdateTime().getTime() > dbCrosscompany.getUpdateTime().getTime()){
        		crosscompany.setLegalcensorstatus(dbCrosscompany.getLegalcensorstatus());
        		crosscompany.setChargecensorstatus(dbCrosscompany.getChargecensorstatus());
				crosscompanyDao.updateForDS(crosscompany);
			}
        } else {
            crosscompanyDao.saveForDS(crosscompany);
        }
    }

    @Override
    public Crosscompany findByUser(Long userid) {
        return crosscompanyDao.findByUser(userid);
    }

    @Override
    public CrosscompanySearchDto search(CrosscompanySearchDto dto) {
        CrosscompanySearchDto resultDto = new CrosscompanySearchDto();



        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        String areacode =  police.getAreacode();
        if(areacode.endsWith("0000")){//省
            dto.setDistrict(areacode.substring(0,2)+"____");
        }else if(areacode.endsWith("00")){//市
            dto.setDistrict(areacode.substring(0,4)+"__");
        }else{//区
            dto.setDistrict(areacode);
        }
        List<Crosscompany> list = crosscompanyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(crosscompanyDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public List<Crosscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return crosscompanyDao.searchForDataSynchronization(dto);
    }

	@Override
	public List<Crosscompany> findAll() {
		return crosscompanyDao.findAll();
	}

	@Override
	public void temporarySave(Crosscompany crosscompany) {
		User currentUser = arsUtil.getCurrentUser();
		if(crosscompany.getId() == null) {


            crosscompany.setApprovalstate(Constants.APPROVALSTATE_WTJ);
			crosscompany.setCreateTime(new Date());
			crosscompany.setUpdateTime(new Date());
			crosscompany.setActive(true);
			crosscompany.setUserid(currentUser.getId());
			crosscompany.setUpdateBy(currentUser.getUsername());
			crosscompanyDao.save(crosscompany);
	    }else{

	    	Crosscompany dbCrosscompany = crosscompanyDao.findById(crosscompany.getId());


            if(ApprovalState.WTJ.equals(crosscompany.getApprovalstate())){
                BeanUtils.copyPropertiesIgnore(crosscompany,dbCrosscompany,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(crosscompany,dbCrosscompany,true);
            }
            dbCrosscompany.setUpdateTime(new Date());
            dbCrosscompany.setUpdateBy(currentUser.getUsername());
	    	
	    	crosscompanyDaoAop.update(dbCrosscompany);
	    }
	}

    @Override
    public PageResult searchCrosscompanyList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }
        if (police != null) {
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }
        if (p.get("checkType")!=null) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (user.getPlatform() == 2) {
                    p.put("userid",user.getId());
                } else{
                    //角色列表
                    List<PoliceRole> roles = user.getRoles();
                    if(roles!=null&&roles.size()>0) {
                        p.put("roles",roles);
                    }
                }
            }
        }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }
        return new PageResult(crosscompanyDao.countCrosscompanyList(p), crosscompanyDao.searchCrosscompanyList(p));
    }

    @Override
    public void saveOrUpdateForApproval(Crosscompany crosscompany) {
        crosscompany.setUpdateTime(new Date());
        crosscompanyDaoAop.update(crosscompany);
    }

    /**
     * 根据单据id查询申请人信息
     * @param id
     * @return
     */
    @Override
    public Map<String,Object> selectApplyUserInfoWithId(Long id){
        return crosscompanyDao.selectApplyUserInfoWithId(id);
    }

    @Override
    public void updateCensorStatus(Crosscompany crosscompany) {
        crosscompanyDaoAop.update(crosscompany);
    }

    @Override
    public void saveOrUpdateForApprovalImport(Crosscompany crosscompany) {
        crosscompanyDaoAop.update(crosscompany);
    }

    @Override
    public void searchForPage(CrosscompanySearchDto dto, AjaxPageResponse<Crosscompany> page) {
        arsUtil.setPoliceSearch(dto);
        crosscompanyDao.searchForPage(dto,page);
    }

}
