package com.bcxin.ars.service.sb.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.CerLearnRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CerLearnRecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.CerLearnRecord;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.CerLearnRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 资格证/等级证学习记录Service业务层处理
 * 
 * @author lin
 * @date 2020-09-08
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = CerLearnRecord.class,getMethodName="importBatch",getImportType= ImportType.BATCH)
public class CerLearnRecordServiceImpl extends BaseService implements CerLearnRecordService {
    
    Logger logger = LoggerFactory.getLogger(CerLearnRecordServiceImpl.class);
    
    @Autowired
    private CerLearnRecordDao cerLearnRecordDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(CerLearnRecord cerLearnRecord) {
        User currentUser = arsUtil.getCurrentUser();
        cerLearnRecord.setUpdateTime(new Date());
        cerLearnRecord.setUpdateBy(currentUser.getUsername());
        return cerLearnRecordDao.delete(cerLearnRecord);
    }

    @Override
    public int save(CerLearnRecord cerLearnRecord) {
        //User currentUser = arsUtil.getCurrentUser();

        if(StringUtil.isNotEmpty(cerLearnRecord.getPhoto())){
            cerLearnRecord.setPhoto(getPhotoPath(cerLearnRecord.getPhoto()));
        }
        if(cerLearnRecord.getId() == null){
            cerLearnRecord.setCreateTime(new Date());
        }else{
            CerLearnRecord dbCerLearnRecord = cerLearnRecordDao.findById(cerLearnRecord.getId());
            BeanUtils.copyPropertiesIgnore(cerLearnRecord,dbCerLearnRecord,true);
            BeanUtils.copyPropertiesIgnore(dbCerLearnRecord,cerLearnRecord,false);
        }

        cerLearnRecord.setActive(true);
        cerLearnRecord.setUpdateTime(new Date());
        cerLearnRecord.setUpdateflag(true);
        cerLearnRecord.setUpdateBy("apiSystem");
        //cerLearnRecord.setUpdateBy(currentUser.getUsername());
        //cerLearnRecord.setUserid(currentUser.getId());
        //cerLearnRecord.setAreaCode(currentUser.getPolice().getAreacode());
        return cerLearnRecordDao.save(cerLearnRecord);
    }

    @Override
    public CerLearnRecord findById(Long id) {
        return cerLearnRecordDao.findById(id);
    }

    @Override
    public void searchForPage(CerLearnRecordPageSearchDto dto, AjaxPageResponse page) {
        User currentUser = arsUtil.getCurrentUser();
        if(currentUser.getPlatform()== Constants.PLATFORM_COMPANY){
            SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
            if(Constants.INSTITUTIONTYPE_PXDW.equals(company.getInstitutionType())){
                dto.setTrainId(company.getComId());
            }else {
                dto.setComId(company.getComId());
            }
        }else{
            arsUtil.setPoliceSearch(dto);
        }
        cerLearnRecordDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<CerLearnRecord> list) {
        List<CerLearnRecord> dbList = cerLearnRecordDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (CerLearnRecord cerLearnRecord : list) {
                cerLearnRecord.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        cerLearnRecord.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, cerLearnRecord.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            cerLearnRecordDao.saveBatch(list);
        }
    }

    @Override
    public List<CerLearnRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return cerLearnRecordDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<CerLearnRecord> findDSOutList(String startDate) {
        return cerLearnRecordDao.findDSOutList(startDate);
    }

    @Override
    public List<CerLearnRecord> findByBatchId(List<CerLearnRecord> list) {
        return cerLearnRecordDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(CerLearnRecord cerLearnRecord) {
        User currentUser = arsUtil.getCurrentUser();
        cerLearnRecord.setUpdateTime(new Date());
        cerLearnRecord.setUpdateBy(currentUser.getUsername());
        cerLearnRecordDao.updateSelective(cerLearnRecord);
    }
}
