package com.bcxin.ars.service.sb.impl;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ArmtrainorgSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Armorgcharge;
import com.bcxin.ars.model.sb.Armorgteach;
import com.bcxin.ars.model.sb.Armtraincharge;
import com.bcxin.ars.model.sb.Armtrainorg;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.ArmtrainorgService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Armtrainorg.class)
public class ArmtrainorgServiceImpl implements ArmtrainorgService {

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private ArmtrainorgDao armtrainorgDao;

    @Autowired
    private ArmtrainorgDaoAop armtrainorgDaoAop;

    @Autowired
    private ArmorgchargeDao armorgchargeDao;

    @Autowired
    private ArmtrainchargeDao armtrainchargeDao;

    @Autowired
    private ArmorgteachDao armorgteachDao;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Override
    public Armtrainorg findById(long id) {
        Armtrainorg result = armtrainorgDao.findById(id);
        if (result != null) {
            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public  List<Armtrainorg> findByBatchId(List<Approval> approvalList){
        return  armtrainorgDao.findByBatchId(approvalList);
    }
    @Override
    public  void updateBatch(List<Armtrainorg> list){
        armtrainorgDaoAop.updateBatch(list);
    }

    @Override
    public void saveOrUpdate(Armtrainorg armtrainorg) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(armtrainorg.getOrgid() == null){
            if(armtrainorg.getDistrictOrgId() != null){
                armtrainorg.setOrgid(Long.parseLong(armtrainorg.getDistrictOrgId()));
            }else if(armtrainorg.getCityOrgId() != null){
                armtrainorg.setOrgid(Long.parseLong(armtrainorg.getCityOrgId()));
            }
        }

        if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4){
            armtrainorg.setUserid(currentUser.getId());
        }
        //机构负责人信息
        String[] name = new String[0];
        String[] idnum = new String[0];
        String[] phone = new String[0];

        //培训负责人信息
        String[] pxname = new String[0];
        String[] pxidnum = new String[0];
        String[] pxphone = new String[0];

        //教员信息
        String[] jyname = new String[0];
        String[] jyidnum = new String[0];
        String[] jyage = new String[0];
        String[] jysex = new String[0];
        String[] jygunnum = new String[0];


        //机构负责人信息
        if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getName())) {
            name = armtrainorg.getArmorgcharge().getName().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getIdnum())) {
            idnum = armtrainorg.getArmorgcharge().getIdnum().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getPhone())) {
            phone = armtrainorg.getArmorgcharge().getPhone().split(",");
        }

        //培训负责人信息
        if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxname())) {
            pxname = armtrainorg.getArmtraincharge().getPxname().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxidnum())) {
            pxidnum = armtrainorg.getArmtraincharge().getPxidnum().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxphone())) {
            pxphone = armtrainorg.getArmtraincharge().getPxphone().split(",");
        }
        //教员信息
        if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyname())) {
            jyname = armtrainorg.getArmorgteach().getJyname().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyidnum())) {
            jyidnum = armtrainorg.getArmorgteach().getJyidnum().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyage())) {
            jyage = armtrainorg.getArmorgteach().getJyage().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJysex())) {
            jysex = armtrainorg.getArmorgteach().getJysex().split(",");
        }
        if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJygunnum())) {
            jygunnum = armtrainorg.getArmorgteach().getJygunnum().split(",");
        }

        int[] a = {name.length, idnum.length, phone.length};
        int count = StringUtil.getMax(a);

        int[] b = {pxname.length, pxidnum.length, pxphone.length};
        int countb = StringUtil.getMax(b);

        int[] c = {jyname.length, jyidnum.length, jyage.length, jysex.length, jygunnum.length};
        int countc = StringUtil.getMax(c);

        if (armtrainorg.getId() == null) {
            if(!armtrainorg.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Armtrainorg checkArmtrainorg = armtrainorgDao.findApproveByOrgname(armtrainorg.getOrgname());
                if(checkArmtrainorg != null){
                    throw  new ArsException(armtrainorg.getOrgname() + "已备案，不能重复备案！");
                }
            }

            armtrainorg.setActive(true);
            armtrainorg.setCreateTime(new Date());
            armtrainorg.setUpdateTime(new Date());
            armtrainorg.setUpdateBy(currentUser.getUsername());
            //待审批或暂存
            armtrainorgDao.save(armtrainorg);

            //机构负责人信息
            for (int i = 0; i < count; i++) {
                Armorgcharge armorgcharge = new Armorgcharge();
                armorgcharge.setActive(true);
                armorgcharge.setCreateTime(new Date());
                armorgcharge.setUpdateTime(new Date());
                armorgcharge.setUpdateBy(currentUser.getUsername());
                armorgcharge.setArmtrainorgid(armtrainorg.getId());
                //判断是否非空，非空则保存
                if (armtrainorg.getArmorgcharge() != null) {
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getName())) {
                        if (name.length > i && !name[i].equals("")) {
                            armorgcharge.setName(name[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getIdnum())) {
                        if (idnum.length > i && !idnum[i].equals("")) {
                            armorgcharge.setIdnum(idnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getPhone())) {
                        if (phone.length > i && !phone[i].equals("")) {
                            armorgcharge.setPhone(phone[i]);
                        }

                    }
                }
                armorgchargeDao.save(armorgcharge);
            }

            //培训负责人信息
            for (int i = 0; i < countb; i++) {
                Armtraincharge armtraincharge = new Armtraincharge();
                armtraincharge.setActive(true);
                armtraincharge.setCreateTime(new Date());
                armtraincharge.setUpdateTime(new Date());
                armtraincharge.setUpdateBy(currentUser.getUsername());
                armtraincharge.setArmtrainorgid(armtrainorg.getId());
                //判断是否非空，非空则保存
                if (armtrainorg.getArmtraincharge() != null) {
                    if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxname())) {
                        if (pxname.length > i && !pxname[i].equals("")) {
                            armtraincharge.setPxname(pxname[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxidnum())) {
                        if (pxidnum.length > i  && !pxidnum[i].equals("")) {
                            armtraincharge.setPxidnum(pxidnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxphone())) {
                        if (pxphone.length > i && !pxphone[i].equals("")) {
                            armtraincharge.setPxphone(pxphone[i]);
                        }

                    }
                }
                armtrainchargeDao.save(armtraincharge);
            }

            //教员信息
            for (int i = 0; i < countc; i++) {
                Armorgteach armorgteach = new Armorgteach();
                armorgteach.setActive(true);
                armorgteach.setCreateTime(new Date());
                armorgteach.setUpdateTime(new Date());
                armorgteach.setUpdateBy(currentUser.getUsername());
                armorgteach.setArmtrainorgid(armtrainorg.getId());
                //判断是否非空，非空则保存
                if (armtrainorg.getArmorgteach() != null) {
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyname())) {
                        if (jyname.length > i  && !jyname[i].equals("")) {
                            armorgteach.setJyname(jyname[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyidnum())) {
                        if (jyidnum.length > i && !jyidnum[i].equals("")) {
                            armorgteach.setJyidnum(jyidnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyage())) {
                        if (jyage.length > i && !jyage[i].equals("")) {
                            armorgteach.setJyage(jyage[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJysex())) {
                        if (jysex.length > i && !jysex[i].equals("")) {
                            armorgteach.setJysex(jysex[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJygunnum())) {
                        if (jygunnum.length > i  && !jygunnum[i].equals("")) {
                            armorgteach.setJygunnum(jygunnum[i]);
                        }

                    }
                }
                armorgteachDao.save(armorgteach);
            }
            //TODO 保存审批信息
            if(armtrainorg.getApprovalstate().equals(ApprovalState.DSH)) {
                approvalUtil.saveApproval(BusinessType.QZPX, armtrainorg.getId(), Constants.ACTIVITI_PROCESS_ARMTRAINORG);
            }

            } else {
            if(!armtrainorg.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Armtrainorg checkArmtrainorg = armtrainorgDao.findApproveByOrgname(armtrainorg.getOrgname());
                if(checkArmtrainorg != null && checkArmtrainorg.getId().longValue() != armtrainorg.getId().longValue()){
                    throw  new ArsException(armtrainorg.getOrgname() + "已备案，不能重复备案！");
                }
            }

                Armtrainorg dbArmtrainorg = armtrainorgDao.findById(armtrainorg.getId());

                boolean activity = true;
                if(StringUtil.isNotEmpty(dbArmtrainorg.getApprovalstate()) && dbArmtrainorg.getApprovalstate().equals(ApprovalState.DSH)){
                    if(dbArmtrainorg.getOrgid().toString().equals(armtrainorg.getOrgid().toString())){
                        activity = false;
                        if(!dbArmtrainorg.getOrgname().equals(armtrainorg.getOrgname())) {
                            Approval approval = approvalDAO.findBybusinessidAndType(armtrainorg.getId(), BusinessType.QZPX);
                            if (approval != null) {
                                approvalUtil.updateContent(approval, armtrainorg.getOrgname());
                            }
                        }
                    }
                }

                dbArmtrainorg.setUpdateTime(new Date());
                dbArmtrainorg.setUpdateBy(currentUser.getUsername());
                dbArmtrainorg.setOrgadd(armtrainorg.getOrgadd());
                dbArmtrainorg.setOrgname(armtrainorg.getOrgname());
                dbArmtrainorg.setLegalcardnumber(armtrainorg.getLegalcardnumber());
                dbArmtrainorg.setLegalname(armtrainorg.getLegalname());
                dbArmtrainorg.setLegalphone(armtrainorg.getLegalphone());
                dbArmtrainorg.setTraincontext(armtrainorg.getTraincontext());
                dbArmtrainorg.setGunnum(armtrainorg.getGunnum());
                dbArmtrainorg.setTemplateRar(armtrainorg.getTemplateRar());
                dbArmtrainorg.setSzss(armtrainorg.getSzss());
                dbArmtrainorg.setProvince(armtrainorg.getProvince());
                dbArmtrainorg.setCity(armtrainorg.getCity());
                dbArmtrainorg.setDistrict(armtrainorg.getDistrict());
                dbArmtrainorg.setOrgarea(armtrainorg.getOrgarea());
                dbArmtrainorg.setOrgid(armtrainorg.getOrgid());

                dbArmtrainorg.setReplyreason(armtrainorg.getReplyreason());
            //待审批
            if (armtrainorg.getApprovalstate() != null && !"".equals(armtrainorg.getApprovalstate()) && !armtrainorg.getApprovalstate().equals(ApprovalState.DSH)) {
                dbArmtrainorg.setApprovalstate(armtrainorg.getApprovalstate());
            } else {
                dbArmtrainorg.setApprovalstate(ApprovalState.DSH);
                dbArmtrainorg.setReplyreason("");
                dbArmtrainorg.setInfoRar("");
                dbArmtrainorg.setReplyState("");
                dbArmtrainorg.setReplyRar("");
                dbArmtrainorg.setLegalcensorstatus("");

            }
            armtrainorgDaoAop.update(dbArmtrainorg);
            //TODO 更新审批信息
            if(activity && ApprovalState.DSH.equals(dbArmtrainorg.getApprovalstate())) {
                approvalUtil.saveApproval(BusinessType.QZPX, dbArmtrainorg.getId(), Constants.ACTIVITI_PROCESS_ARMTRAINORG);
            }

                //先删除原有的
                armorgchargeDao.deleteBySid(armtrainorg.getId().toString());
                //更新机构负责人
                for (int i = 0; i < count; i++) {
                    Armorgcharge armorgcharge = new Armorgcharge();
                    armorgcharge.setActive(true);
                    armorgcharge.setCreateTime(new Date());
                    armorgcharge.setUpdateTime(new Date());
                    armorgcharge.setUpdateBy(currentUser.getUsername());
                    armorgcharge.setArmtrainorgid(armtrainorg.getId());
                    //判断是否非空，非空则保存
                    if (armtrainorg.getArmorgcharge() != null) {
                        if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getName())) {
                            if (name.length > i && !name[i].equals("")) {
                                armorgcharge.setName(name[i]);
                            }

                        }
                        if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getIdnum())) {
                            if (idnum.length > i  && !idnum[i].equals("")) {
                                armorgcharge.setIdnum(idnum[i]);
                            }

                        }
                        if (!StringUtils.isEmpty(armtrainorg.getArmorgcharge().getPhone())) {
                            if (phone.length > i  && !phone[i].equals("")) {
                                armorgcharge.setPhone(phone[i]);
                            }

                        }

                    }
                    armorgchargeDao.save(armorgcharge);
                }

            //先删除原有的
            armtrainchargeDao.deleteBySid(armtrainorg.getId().toString());
            //更新培训负责人
            for (int i = 0; i < countb; i++) {
                Armtraincharge armtraincharge = new Armtraincharge();
                armtraincharge.setActive(true);
                armtraincharge.setCreateTime(new Date());
                armtraincharge.setUpdateTime(new Date());
                armtraincharge.setUpdateBy(currentUser.getUsername());
                armtraincharge.setArmtrainorgid(armtrainorg.getId());
                //判断是否非空，非空则保存
                if (armtrainorg.getArmorgcharge() != null) {
                    if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxname())) {
                        if (pxname.length > i  && !pxname[i].equals("")) {
                            armtraincharge.setPxname(pxname[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxidnum())) {
                        if (pxidnum.length > i  && !pxidnum[i].equals("")) {
                            armtraincharge.setPxidnum(pxidnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmtraincharge().getPxphone())) {
                        if (pxphone.length > i  && !pxphone[i].equals("")) {
                            armtraincharge.setPxphone(pxphone[i]);
                        }

                    }

                }
                armtrainchargeDao.save(armtraincharge);
            }

            //先删除原有的
            armorgteachDao.deleteBySid(armtrainorg.getId().toString());
            //更新教员
            for (int i = 0; i < countc; i++) {
                Armorgteach armorgteach = new Armorgteach();
                armorgteach.setActive(true);
                armorgteach.setCreateTime(new Date());
                armorgteach.setUpdateTime(new Date());
                armorgteach.setUpdateBy(currentUser.getUsername());
                armorgteach.setArmtrainorgid(armtrainorg.getId());
                //判断是否非空，非空则保存
                if (armtrainorg.getArmorgteach() != null) {
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyname())) {
                        if (jyname.length > i && !jyname[i].equals("")) {
                            armorgteach.setJyname(jyname[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyidnum())) {
                        if (jyidnum.length > i && !jyidnum[i].equals("")) {
                            armorgteach.setJyidnum(jyidnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJyage())) {
                        if (jyage.length > i && !jyage[i].equals("")) {
                            armorgteach.setJyage(jyage[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJysex())) {
                        if (jysex.length > i && !jysex[i].equals("")) {
                            armorgteach.setJysex(jysex[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(armtrainorg.getArmorgteach().getJygunnum())) {
                        if (jygunnum.length > i && !jygunnum[i].equals("")) {
                            armorgteach.setJygunnum(jygunnum[i]);
                        }

                    }

                }
                armorgteachDao.save(armorgteach);
            }

        }
    }

    @Override
    public void saveOrUpdateForDS(Armtrainorg armtrainorg) {
        if (armtrainorg.getActive() == null) {
            armtrainorg.setActive(true);
        }
        Armtrainorg dbArmtrainorg = armtrainorgDao.findById(armtrainorg.getId());
        if (dbArmtrainorg != null) {
            if (armtrainorg.getUpdateTime().getTime() > dbArmtrainorg.getUpdateTime().getTime()) {
                armtrainorg.setPoliceid(dbArmtrainorg.getPoliceid());
                armtrainorg.setLegalcensorstatus(dbArmtrainorg.getLegalcensorstatus());
                armtrainorgDaoAop.update(armtrainorg);
            }
        } else {
            armtrainorgDao.save(armtrainorg);
        }
    }



    @Override
    public Armtrainorg findByUser(Long userid) {
        // TODO Auto-generated method stub
        return armtrainorgDao.findByUser(userid);
    }

    @Override
    public ArmtrainorgSearchDto search(ArmtrainorgSearchDto dto) {
        ArmtrainorgSearchDto resultDto = new ArmtrainorgSearchDto();
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        String areacode =  police.getAreacode();
        if(areacode.endsWith("0000")){//省
            dto.setDistrict(areacode.substring(0,2)+"____");
        }else if(areacode.endsWith("00")){//市
            dto.setDistrict(areacode.substring(0,4)+"__");
        }else{//区
            dto.setDistrict(areacode);
        }
        List<Armtrainorg> list = armtrainorgDao.search(dto);

        resultDto.setData(list);
        resultDto.setTotalCount(armtrainorgDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public void updateCensorStatus(Armtrainorg armtrainorg) {
        armtrainorg.setUpdateTime(new Date());
        armtrainorgDaoAop.updateCensorStatus(armtrainorg);

    }

    @Override
    public List<Armtrainorg> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return armtrainorgDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForApproval(Armtrainorg armtrainorg) {
        armtrainorg.setUpdateTime(new Date());
        armtrainorgDaoAop.update(armtrainorg);
    }

    @Override
    public PageResult searchArmtrainorgList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        if(police!=null){
            String areacode =  police.getAreacode();
            if (StringUtil.isNotEmpty(areacode)) {
                if (areacode.endsWith("0000")) {//省
                    p.put("district", areacode.substring(0, 2) + "____");
                } else if (areacode.endsWith("00")) {//市
                    p.put("district", areacode.substring(0, 4) + "__");
                } else {//区
                    p.put("district", areacode);
                }
                if (police.getOrgtype().equals("4")) {
                    p.put("orgid", police.getId());
                }
            }
        }

        if (police != null) {
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }


        return new PageResult(armtrainorgDao.countArmtrainorgList(p), armtrainorgDao.searchArmtrainorgList(p));
    }

    @Override
    public void saveOrUpdateForApprovalImport(Armtrainorg armtrainorg) {
        armtrainorgDaoAop.update(armtrainorg);
    }

    @Override
    public void searchForPage(ArmtrainorgSearchDto searchDto, AjaxPageResponse<Armtrainorg> page) {
        User currentUser = arsUtil.getCurrentUser();
        arsUtil.setPoliceSearch(searchDto);
        //机构信息
        Police police = currentUser.getPolice();

        if (police != null) {
            if (police.getOrgtype().equals("4")) {

                searchDto.setOrgid(police.getId());
            }
        }

        armtrainorgDao.searchForPage(searchDto,page);
    }

}
