package com.bcxin.ars.service.sb.custompersoncertificate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.ActivityRepairDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.sb.CustomPersoncertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/***
 * 保安员资格打回校验实在类
 */
@Service
public class DefaultCustomPersoncertificateServiceImpl implements CustomPersoncertificateService {

    @Autowired
    private ActivityRepairDao activityRepairDao;

    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    /***
     * 配置缓存工具类
     */
    private static ConfigUtils configUtils;
    /**
     * 查询哪些数据不能打回
     * @param
     * @return
     */
    @Override
    public AjaxResult checkReturn(Long[] perIds) {
        AjaxResult result = new AjaxResult();
        List<Personcertificate>   mapList =  activityRepairDao.checkReturnForSn(perIds);
        result.setMsg("流程打回-人员信息查询-返回成功");
        result.setSuccessful(true);
        if (mapList.size() > 0) {
            String personsInfo = "";
            for (Personcertificate detail : mapList) {
                if (StringUtil.isNotEmpty(detail.getName())) {
                    personsInfo += detail.getName();
                }
                personsInfo += "|";
                if (StringUtil.isNotEmpty(detail.getCardnumber())) {
                    personsInfo += detail.getCardnumber();
                }
                personsInfo += " ,";
            }
            if (personsInfo.length()>0){
                personsInfo=   personsInfo.substring(0, personsInfo.length() - 1);
            }
            result.setData("下列人员已经获取指纹，避免公安网内外网数据冲突无法打回，其余人可以继续打回，无法打回具体名单如下："+personsInfo);
            int mapSize=mapList.size();
            int personIdSize=     perIds.length;
            if (personIdSize==mapSize){
                result.setMsg("流程打回失败，所选人员都不可打回");
                result.setSuccessful(false);
                result.setData("");
                return result;
            }
        } else {
            result.setData("");
        }
        return result;
    }

    @Override
    public List<Personcertificate> getNoReturnList(Long[] perIds) {
        return activityRepairDao.checkReturnForSn(perIds);
    }


    @Override
    public SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO) {
        SecurityPersonSearchRerurnDTO securityPersonSearch = new SecurityPersonSearchRerurnDTO();
        securityPersonSearch.setData(personDao.findByCompanyIdReturnDTOForBj(securityPersonSearchRerurnDTO));
        securityPersonSearch.setTotalCount(personDao.countByCompanyIdReturnDTOForBj(securityPersonSearchRerurnDTO));
        return securityPersonSearch;
    }

    @Override
    public String getMsgTemp(String tempType, String testState) {
        if(Constants.TEST_STATE_TG.equals(testState)) {
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_MSG_NO_OPERATE;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT_NO_OPERATE;

            }
        }else{
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_FAIL_MSG;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_FAIL_CONTENT;
            }
        }
    }

    @Override
    public String getMsgTemp_V1171(String tempType, String testState) {
        if(Constants.TEST_STATE_WTG.equals(testState)) {
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_CONTENT_MSG_V1171_NO_OPERATE;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_CONTENT_APP_V1171_NO_OPERATE;
            }
        }else{
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT_MSG_V1171_NO_OPERATE;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT_APP_V1171_NO_OPERATE;
            }
        }
    }

    @Override
    public String getMsgTemp_V1172(String tempType, String testState) {
        if(Constants.TEST_STATE_WTG.equals(testState)) {
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_MSG_NO_OPERATE;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_TEST_FAIL_CONTENT_NO_OPERATE;
            }
        }else{
            if (Constants.TEMPTYPE_TITLE.equals(tempType)) {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_MSG_NO_OPERATE;
            } else {
                return Constants.APPROVAL_PERSONCERTIFICATE_PASS_CONTENT_NO_OPERATE;
            }
        }
    }

    @Override
    public void updateForDSByDiffArea(Personcertificate personcertificate) {
        personcertificateDaoAop.update(personcertificate);
    }

    @Override
    public JSONArray checkReturnList(List<Personcertificate> list) {
        JSONArray failList = new JSONArray();
        if(list.size() > 0) {
            list.forEach(detail -> {
                JSONObject obj = new JSONObject();
                obj.put("id", detail.getId());
                obj.put("successful", false);
                obj.put("message", "已经获取指纹，避免公安网内外网数据冲突无法打回");
                failList.add(obj);
            });
        }
        return failList;
    }
}
