package com.bcxin.ars.service.old;

import com.bcxin.ars.dao.old.BafwjbxxDao;
import com.bcxin.ars.model.old.Bafwjbxx;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2019/10/29 0029 13:51
 */
@Service
public class BafwjbxxServiceImpl implements BafwjbxxService {

    @Autowired
    private BafwjbxxDao baBafwjbxxDao;

    @Override
    public Bafwjbxx findById(String id) {
        return baBafwjbxxDao.findById(id);
    }

    @Override
    public List<Bafwjbxx> search(Bafwjbxx dto, AjaxPageResponse<Bafwjbxx> page) {
        if(StringUtil.isNotEmpty(dto.getSzdssx())){
            String areaCode = dto.getSzdssx();
            if (areaCode.endsWith("0000")) {// 省
                dto.setSzdssx(null);
            } else if (areaCode.endsWith("00")) {// 市
                dto.setSzdssx(areaCode.substring(0, 4) + "__");
            } else {// 区
                dto.setSzdssx(areaCode);
            }
        }
        return baBafwjbxxDao.search(dto,page);
    }
}
