package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/***
 * 单点用户登陆抽象类
 */
public abstract class SingleUserLoginBaseServiceImpl extends BaseService {
    /***
     * 日志
     */
    private static Logger logger = LoggerFactory.getLogger(SingleUserLoginBaseServiceImpl.class);
    /***
     * 获取用户信息
     * @param userInfo
     */
    public abstract User getUserInfo(SingleUserDTO userInfo);
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserDaoAop userDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Value("${login-timeout}")
    private int loginTimeout = 10;
    /***
     * 登陆日志
     */
    @Autowired
    private LoginLogService loginLogService;
    /***
     * 用户注册
     */
    @Autowired
    private RegisterpersonService registerpersonService;

    /***
     * 根据用户名查询用户镟
     * @param userName
     * @return
     */
    public User findByUsername(String userName, String platform){
        return userDao.findByUsername(userName,platform);
    }
    /***
     * 登陆
     */
    public AjaxResult login(SingleUserDTO userInfo,HttpServletRequest request) {
        /**
         *  1.获取第三方单点登陆的用户信息
         */
        if(request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN) != null){
            userInfo.setAccessToken(request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN).toString());
        }
        User u =  getUserInfo(userInfo);
        if(u == null){
            throw new ArsException("用户信息有误！");
        }

        if(StringUtil.isNotEmpty(u.getUniqueId())){
            request.getSession().setAttribute(Constants.SINGLELOGINBJ_UNIQUEID,u.getUniqueId());
        }
        if(StringUtil.isNotEmpty(u.getToken())){
            request.getSession().setAttribute(Constants.SINGLELOGINBJ_TOKEN,u.getToken());
        }
        /***
         * 2.注册用户信息
         */
        User dbUser =  userDao.findByUsername(u.getUsername(),String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
        //如果不存在该用户 帮其注册
        if (dbUser == null){
            //注册
            AjaxResult userAjaxResult = registerpersonService.singleUserRegister(u);
            //注册失败
            if (!userAjaxResult.isSuccessful()){
                userAjaxResult.setState(Constants.STATUS_ERROR);
                userAjaxResult.setMsg("注册失败");
                throw new ArsException("注册失败！");
            }
            //如果自动注册则设置手机号码后六位
            u.setPassword(u.getPhone().substring(u.getPhone().length()-6,u.getPhone().length()));
        }else{
            //获取已经存在的用户信息
            if(StringUtil.isEmpty(dbUser.getIdNumber()) || StringUtil.isNotEmpty(u.getIdNumber())) {
                if(StringUtil.isEmpty(dbUser.getIdNumber())) {
                    dbUser.setIdNumber(u.getIdNumber());
                }
                if(StringUtil.isNotEmpty(u.getIdNumber())) {
                    dbUser.setRealname(u.getRealname());
                }
                userDao.update(dbUser);
            }

            u = dbUser;
        }
        /**
         * 3.登陆
         */
        return webLogin(u.getUsername(),u.getPassword(),u.getPlatform(),request);
    }
    /**
     * 登陆
     * @param username 用户名
     * @param password 密码
     * @param platform 角色
     * @return
     * @throws Exception
     */
    public AjaxResult webLogin(String username, String password, Integer platform,HttpServletRequest request) {
       return webLogin(username,password,platform, Constants.SXNWCode,request);
    }

    /**
     * 登陆
     * @param username 用户名
     * @param password 密码
     * @param platform 角色
     * @param host 环境标识
     * @return
     * @throws Exception
     */
    public AjaxResult webLogin(String username, String password, Integer platform,String host,HttpServletRequest request) {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password,host);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
            }
            //判断是否登录成功！
            if(currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = userDao.findByUsername(username,platform.toString());
                //更新一下登陆状态
                user.setLoginstate(1);
                //登录次数+1
                if (user.getLoginNum() != null) {
                    user.setLoginNum(user.getLoginNum() + 1);
                } else {
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userDaoAop.updateLoginState(user);
                //sessionID
                user.setSessionId(session.getId().toString());
                //城市名称
                user.setCityName("南宁市");


                user.setCity("450100");
                //设置超时时间
                arsUtil.setCurrentUser(user, 1000 * 120 * loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }
        } catch (UnknownAccountException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("登录失败多次，账户锁定10分钟");
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
