package com.bcxin.ars.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.certificate.GradeCertificateDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dao.task.UrgentTeamPersonDAO;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.PersonDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.old.BayjbxxService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.message.messageUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.util.thread.ThreadPoolManager;
import com.bcxin.ars.webservice.Baycqqkb;
import com.bcxin.ars.webservice.Bayxxb;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Zpxxb;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityPerson.class)
public class SecurityPersonServiceImpl extends BaseService implements SecurityPersonService {

    private static Logger logger = LoggerFactory.getLogger(SecurityPersonServiceImpl.class);

    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private SecurityPersonDaoAop personDaoAop;

    @Autowired
    private CompanyPersonLogDao companyPersonLogDao;

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    @Autowired
    private EduService eduService;

    @Autowired
    private UrgentTeamPersonDAO urgentTeamPersonDAO;

    @Autowired
    private SearchHistoryService searchHistoryService;

    @Autowired
    private SecurityProfessionLevelService proLevelService;

    @Autowired
    private SecurityCompanyService companyService;

    @Autowired
    private SecurityCompanyPersonService companyPersonService;
    @Autowired
    private SecurityCompanyPersonDao securityCompanyPersonDao;
    @Autowired
    private UserService userService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserDaoAop userDaoAop;
    @Autowired
    private UserRoleService userRoleService;
    @Value("${ftpServerTemp}")
    private String ftpServerTemp;

    @Value("${heiweiPrefixKey}")
    private String heiweiPrefixKey;
    @Autowired
    private RoleService roleService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private SecurityCompanyDao companyDao;

    @Autowired
    private SecurityCompanyDaoAop companyDaoAop;

    @Autowired
    private ComTaskDao comTaskDao;

    @Autowired
    private ComTaskPerDao comTaskPerDao;

    @Autowired
    private ConfigService configService;

    @Autowired
    private NationService nationService;

    @Autowired
    private OrderDao orderDao;

    @Autowired
    private ClientUtil clientUtil;



    @Autowired
    private BayjbxxService bayjbxxService;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Autowired
    private MessageLogDao messageLogDao;

    @Value("${temp-folder}")
    private String tempFolder;

    @Value("${base-folder}")
    private String baseFolder;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private SecurityCertificateDao securityCertificateDao;


    @Autowired
    private OrganizationDao orgDao;
    @Autowired
    private UserRoleDao userRoleDao;

    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;

    @Autowired
    private GradeCertificateDao gradeCertificateDao;

    @Autowired
    private SecurityPersonExperienceService securityPersonExperienceService;

    @Autowired
    private SecurityCertificateService securityCertificateService;

    @Override
    public SecurityPerson findById(Long id) {
        SecurityPerson result= personDao.findById(id);
        //获取人员驻勤点信息
        if(result!=null) {
            result.setComTaskList(comTaskDao.findByPerId(result.getId()));
        }
        return result;
    }

    @Override
    public SecurityPerson findByIdGoodThing(Long id) {
        return personDao.findByIdGoodThing(id);
    }

    /**
     * 新增或修改劳动合同
     *
     * @param person
     */
    @Override
    public void saveOrUpdateHt(SecurityPerson person) {
        if (person.getId() == null) {
            throw new ArsException("保安人员ID不能为空！");
        }
        SecurityPerson dbPerson = personDao.findById(person.getId());
        if (dbPerson != null) {

            if (person.getHtbh() != null && person.getHtbh() != "") {
                dbPerson.setHtbh(person.getHtbh());
            }
            if (person.getHtenddate() != null) {
                dbPerson.setHtenddate(person.getHtenddate());
            }
            if (person.getHtLife() != null && person.getHtLife() != "") {
                dbPerson.setHtLife(person.getHtLife());
            }
            if (person.getHtstartdate() != null) {
                dbPerson.setHtstartdate(person.getHtstartdate());
            }
            if (person.getHtstate() != null && person.getHtstate() != "") {
                //如果结束时间小于当前时间，则为已结束
                //【劳动合同管理】产品经理补充规则：如果合同结束时间已经过去，就是小于当前日期，则合同状态要自动变成已完成，因为有可能线下合同 是补录进来的。不能限制结束时间大于当前日期。
                if (person.getHtenddate().getTime() > System.currentTimeMillis()) {
                    dbPerson.setHtstate(person.getHtstate());
                } else {
                    dbPerson.setHtstate(Constants.HTSTATE_YWC);
                }


            }
            if (person.getSigndate() != null) {
                dbPerson.setSigndate(person.getSigndate());
            }
            if (person.getEntrydate() != null && person.getEntrydate() != null) {
                dbPerson.setEntrydate(person.getEntrydate());
            }

            personDaoAop.update(dbPerson);
        } else {
            throw new RuntimeException("保安员不存在，ID:" + person.getId());
        }
    }

    @Override
    public void updateCensorStatus(SecurityPerson securityPerson) {
        //securityPerson.setUpdateTime(new Date());
        personDaoAop.updateSelective(securityPerson);
    }

    @Override
    public List<SecurityPerson> findALl(int start,int numPerPage) {
        return personDao.findAllBJ(start,numPerPage);
    }
    /**
     * 批量更新保安员身份认证状态(SAAS接口)
     * @param personList 人员列表
     * @return
     */
    @Override
    public void batchUpdateIdentityAuthStateForSaas(List<SecurityPersonDTO> personList) {
        if (CollectionUtil.isEmpty(personList)) {
            return;
        }
        for (SecurityPersonDTO person : personList) {
            //设置更新时间
            person.setUpdateTime(new Date());

        }
        //批量更新认证状态
        personDaoAop.updatePersonidentityAuthStateBatch(personList);
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            List<SecurityPerson> list = personDao.findByBatchId(personList);
            new Thread(() -> {
                for (SecurityPerson securityPerson : list) {
                    //旧数据资格证关联人员信息表
                    oldSecurityCertificate(securityPerson);
                }
            }).start();
        }

    }
    /**
     * 批量更新保安员身份认证状态(用于更新头像)
     * @param personList 人员列表
     * @return
     */
    @Override
    public void updatePersonidentityAuthStateBatchForPhoto(List<SecurityPersonDTO> personList) {
        if (CollectionUtil.isEmpty(personList)) {
            return;
        }
        //批量更新认证状态
        personDaoAop.updatePersonidentityAuthStateBatchForPhoto(personList);
    }
    /*@Override
    public void searchForPage(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        arsUtil.setPoliceSearch(dto);
        String nativePlace = dto.getNativePlace();
        if (StringUtil.isNotEmpty(nativePlace)) {
            if (nativePlace.endsWith("0000")) {
                dto.setNativePlace(nativePlace.substring(0, 2) + "________________");
            } else if (nativePlace.endsWith("00")) {
                //市、设置机构类型 市级2
                dto.setNativePlace(nativePlace.substring(0, 4) + "______________");
            }
        }
        personDao.searchForPage(dto, page);

    }*/
    @Override
    public void searchForPage(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        arsUtil.setPoliceSearch(dto);
        //地区查询条件的设置
        String nativePlace = dto.getNativePlace();
        if (StringUtil.isNotEmpty(nativePlace)) {
            dto.setNativePlace(arsUtil.changeNativePlace(nativePlace));
        }
        //新系统数据
        page.setData(personDao.searchForPage(dto));
        page.setTotal(personDao.searchForPageCount(dto));
    }


    @Override
    public void searchForReality(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        //设置数据区域
        arsUtil.setPoliceSearch(dto);
        page.setData(personDao.searchForReality(dto));
        page.setTotal(personDao.searchForRealityCount(dto));
    }
    @Override
    public void searchForFrequently(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        arsUtil.setPoliceSearch(dto);
        personDao.searchForFrequently(dto, page);

    }
    public static void main(String[] args) {
        SecurityPerson person1 = new SecurityPerson();

        person1.setNation("中国111");
        person1.setArmcertificatejgtime("111111");
        SecurityPerson person2 = new SecurityPerson();

        person2.setNation("中国2222");
        person2.setArmcertificatejgtime("22222");
        person2.setAreacode("640000");
        BeanUtils.copyPropertiesIgnore(person2,person1,true);

    }

    @Override
    public void batchUpdateCertificate(List<SecurityPersonDTO> personDTOList) {
        if(CollUtil.isEmpty(personDTOList)){
            return;
        }
        List<SecurityPerson> securityPersonList = personDao.findByBatchId(personDTOList);

        Map<Long, SecurityPersonDTO> personMap = personDTOList.stream().collect(Collectors.toMap(SecurityPersonDTO::getId, Function.identity()));

        List<SecurityPerson> updateList = new Vector<>();
        if(CollUtil.isNotEmpty(securityPersonList)){

            CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch(securityPersonList.size());
            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
            for(SecurityPerson person : securityPersonList){
                threadPoolExecutor.execute(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            //证书等级	*证书编号	*发证机关	*发证日期
                            Boolean edit = false;
                            SecurityPersonDTO personDTO = personMap.get(person.getId());
                            if(personDTO == null){
                                return;
                            }
                            //持枪证开始
                            //证书编号
                            if(StringUtil.isEmpty(person.getArmNumber()) && StringUtil.isNotEmpty(personDTO.getArmNumber())){
                                person.setArmNumber(personDTO.getArmNumber());
                                edit = true;
                            }
                            //持枪证发证机关
                            if(StringUtil.isEmpty(person.getArmcertificatejgname()) && StringUtil.isNotEmpty(personDTO.getArmcertificatejgname())){
                                person.setArmcertificatejgname(personDTO.getArmcertificatejgname());
                                edit = true;
                            }
                            //持枪证发证日期
                            if(StringUtil.isEmpty(person.getArmcertificatejgtime()) && StringUtil.isNotEmpty(personDTO.getArmcertificatejgtime())){
                                person.setArmcertificatejgtime(personDTO.getArmcertificatejgtime());
                                edit = true;
                            }
                            //持枪证结束

                            //资格证开始
                            //证书编号
                            if(StringUtil.isEmpty(person.getZgcredential()) && StringUtil.isNotEmpty(personDTO.getZgcredential())){
                                person.setZgcredential(personDTO.getZgcredential());
                                edit = true;
                            }
                            //资格证发证机关
                            if(StringUtil.isEmpty(person.getZgcertificatejgname()) && StringUtil.isNotEmpty(personDTO.getZgcertificatejgname())){
                                person.setZgcertificatejgname(personDTO.getZgcertificatejgname());
                                edit = true;
                            }
                            //资格证发证日期
                            if(StringUtil.isEmpty(person.getZgcertificatejgtime()) && StringUtil.isNotEmpty(personDTO.getZgcertificatejgtime())){
                                person.setZgcertificatejgtime(personDTO.getZgcertificatejgtime());
                                edit = true;
                            }
                            //资格证结束

                            //等级证开始
                            //证书编号
                            if(StringUtil.isEmpty(person.getCredential()) && StringUtil.isNotEmpty(personDTO.getCredential())){
                                person.setCredential(personDTO.getCredential());
                                edit = true;
                            }
                            if(person.getProfessionLevel() == null && personDTO.getProfessionLevel() != null){
                                person.setProfessionLevel(personDTO.getProfessionLevel());
                                edit = true;
                            }
                            //等级证发证机关
                            if(StringUtil.isEmpty(person.getCertificatejgname()) && StringUtil.isNotEmpty(personDTO.getCertificatejgname())){
                                person.setCertificatejgname(personDTO.getCertificatejgname());
                                edit = true;
                            }
                            //等级证发证日期
                            if(StringUtil.isEmpty(person.getCertificatejgtime()) && StringUtil.isNotEmpty(personDTO.getCertificatejgtime())){
                                person.setCertificatejgtime(personDTO.getCertificatejgtime());
                                edit = true;
                            }
                            //等级证结束
                            if(edit){
                                person.setUpdateTime(new Date());
                                updateList.add(person);
                            }

                        }finally {
                            countDownLatch.countDown();
                        }
                    }
                });
            }

            try {
                //线程等待全部完成
                countDownLatch.await();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
                try {
                    throw e;
                } catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            threadPoolExecutor.shutdown();
            if(CollUtil.isNotEmpty(updateList)) {
                personDaoAop.batchUpdateCertificate(updateList);
            }
        }
    }

    @Override
    public void updateIdPhoto(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.updateSelective(person);
        //if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
        //    SecurityPerson securityPerson = personDao.findById(person.getId());
        //    securityCertificateDao.resetDraw(securityPerson.getIdNumber(),securityPerson.getIdPhoto());
        //}
    }

    /*@Override
    public void updateComIdPhoto(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.updateSelective(person);
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            SecurityPerson securityPerson = personDao.findById(person.getId());
            securityCertificateDao.resetDraw(securityPerson.getIdNumber(),securityPerson.getComIdPhoto());
        }
    }*/

    @Override
    public void delIdPhoto(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.delIdPhoto(person);
    }

    @Override
    public void updateIdNumber(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.updateSelective(person);
    }

    /**
     * 保全公司分页查询
     */
    @Override
    public PageResult querySercurityPersonList(Map<Object, Object> p) {
        return new PageResult(personDao.queryAllCnt(p), personDao.querySercurityPersonList(p));
    }

    @Override
    public int getAllCount(Map<Object, Object> p) {
        return personDao.queryAllCnt(p);
    }

    @Override
    public Map getInitCount(Map<Object, Object> p) {
        return personDao.queryInitCnt(p);
    }

    @Override
    public int getNotInitCount(Map<Object, Object> p) {
        return personDao.queryNotInitCnt(p);
    }

    @Override
    public int queryIidentityCnt(Map<Object, Object> p) {
        return personDao.queryIidentityCnt(p);
    }

    @Override
    public int queryNotIidentityCnt(Map<Object, Object> p) {
        return personDao.queryNotIidentityCnt(p);
    }

    @Override
    public int queryLevelCnt(Map<Object, Object> p) {
        return personDao.queryLevelCnt(p);
    }

    @Override
    public int getNewAddCount(Map<Object, Object> p) {
        return personDao.queryNewAddCnt(p);
    }

    @Override
    public void updateGuardStatus(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.updateSelective(person);
    }

    @Override
    public void saveOrUpdate(SecurityPerson person) {
        if (person.getIdNumber() != null && person.getIdNumber().length() > 0) {
            person.setIdNumber(person.getIdNumber().trim().toUpperCase());
        }
        //取得当前用户跟当前公司
        User currentUser = arsUtil.getCurrentUser();

        //获取单位信息
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = companyDao.findByUserid(currentUser.getId());
        }

        User existUser = null;
        if (person.getId() == null) {

            SecurityPerson dbPerson = personDao.findActiveByIdCard(person.getIdNumber());
            if (dbPerson == null) {
                dbPerson = personDao.findActiveByPhone(person.getPhone());
            }
            if (dbPerson != null) {
                if (dbPerson.getRelation() != null && dbPerson.getIncumbencyStatus().equals(Constants.INCUMBENCYSTATUS_Y)) {
                    if (dbPerson.getRelation().getCompany().getId().longValue() == company.getId().longValue()) {
                        throw new ArsException("该人员已在贵公司就职，不需要再添加哦");
                    } else {
                        throw new ArsException("当前人员目前在职，不允许添加！请联系该人员退出在职公司之后再添加！");
                    }
                } else {
                    delete(dbPerson);
                }
            }


            //区域
            person.setAreacode(company.getAreaCode());
            person.setId(idGeneratorUtil.createID());  // personId 排除自增 by llc 2018-08-29
            person.setNativeCode(arsUtil.getCurrentNatvie());
            person.setUpdateBy(currentUser.getRealname());
            person.setUpdateTime(new Date());
            person.setCreateTime(person.getCreateTime());
            person.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);//默认在职
            person.setQualified(true);//默认合格#1315
            person.setGuardStatus(3);//默认离线#1315
            //所属区域，与公司一样，add 2018-05-09 subh start
            person.setAreacode(company.getAreaCode());
            //所属区域，与公司一样，add 2018-05-09 subh end


            //人员新增时，增加认证状态默认为否 add 2018-05-13 subh start
            person.setIdentityAuthState(Constants.IDENTITYAUTHSTATE_N);
            //人员新增时，增加认证状态默认为否 add 2018-05-13 subh end

            if (person.getExp() == null) {
                person.setExp(0);//#2466
            }
            if (person.getInsured() == null) {
                person.setInsured(Constants.INSURED_NO);//#2466
            }
            if (person.getEdu() == null) {
                person.setEdu(4);//#2466
            }

            personDao.save(person);

            logger.info("update relationship...");

            person.getRelation().setCompany(company);
            person.getRelation().setPerson(person);
            person.getRelation().setActive(true);
            person.getRelation().setCreateTime(new Date());
            person.getRelation().setUpdateTime(new Date());
            person.getRelation().setNativeCode(company.getNativeCode());
            person.getRelation().setUpdateBy(currentUser.getUsername());
            //保险默认值
            person.setInsured(Constants.INSURED_NO);
            companyPersonService.save(person.getRelation());

            String companyId = company.getComId();
            //更新公司人员数量
          /*  new Thread(()->{
                securityCompanyDao.updatePersonNumber(companyId);
            }).start();*/
            companyDaoAop.update(company);
        } else {
            SecurityPerson checkPerson = personDao.findActiveByIdCard(person.getIdNumber());
            if (checkPerson == null) {
                checkPerson = personDao.findActiveByPhone(person.getPhone());
            }

    		/*if(checkPerson != null ) {
    			if(checkPerson.getRelation() != null && checkPerson.getIncumbencyStatus().equals(Constants.INCUMBENCYSTATUS_Y)) {
    				if(checkPerson.getRelation().getCompany().getId().longValue() == company.getId().longValue()) {
    					throw new ArsException("该人员已在贵公司就职，不需要再添加哦");
    				}else {
    					throw new ArsException("当前人员目前在职，不允许添加！请联系该人员退出在职公司之后再添加！");
    				}
    			}else {
    				delete(checkPerson);
    			}
    		}
        	*/
            SecurityPerson dbPerson = personDao.findById(person.getId());
            if (dbPerson != null) {
                dbPerson.setUpdateBy(currentUser.getUsername());
                dbPerson.setUpdateTime(new Date());
                dbPerson.setActive(true);
                dbPerson.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);
                if (person.getAge() != null && person.getAge() > 0) {
                    dbPerson.setAge(person.getAge());
                }
                if (person.getGender() != null && person.getGender().length() > 0) {
                    dbPerson.setGender(person.getGender());
                }
                if (person.getNation() != null && person.getNation().length() > 0) {
                    dbPerson.setNation(person.getNation());
                }
                if (person.getNatives() != null && person.getNatives() > 0) {
                    dbPerson.setNatives(person.getNatives());
                }
                if (person.getStature() != null && person.getStature() > 0) {
                    dbPerson.setStature(person.getStature());
                }
                if (person.getBlood() != null && person.getBlood().length() > 0) {
                    dbPerson.setBlood(person.getBlood());
                }
                if (person.getEdu() != null && person.getEdu().intValue() > 0) {
                    dbPerson.setEdu(person.getEdu());
                }
                if (person.getExp() != null && person.getExp() >= 0) {
                    dbPerson.setExp(person.getExp());
                }
                if (person.getIdNumber() != null && person.getIdNumber().length() > 0) {
                    dbPerson.setIdNumber(person.getIdNumber());
                }
                if (person.getIdCardFront() != null && person.getIdCardFront().length() > 0) {
                    dbPerson.setIdCardFront(person.getIdCardFront());
                }
                if (person.getIdCardReverse() != null && person.getIdCardReverse().length() > 0) {
                    dbPerson.setIdCardReverse(person.getIdCardReverse());
                }
                if (person.getResidence() != null && person.getResidence().length() > 0) {
                    dbPerson.setResidence(person.getResidence());
                }
                if (person.getIdCardAddress() != null && person.getIdCardAddress().length() > 0) {
                    dbPerson.setIdCardAddress(person.getIdCardAddress());
                }
                if (person.getCurrentAddress() != null && person.getCurrentAddress().length() > 0) {
                    dbPerson.setCurrentAddress(person.getCurrentAddress());
                }

                if (StringUtil.isNotEmpty(person.getDiseasesHistory())) {
                    dbPerson.setDiseasesHistory(person.getDiseasesHistory());
                }


                if (person.getEmergencyContactPerson() != null && person.getEmergencyContactPerson().length() > 0) {
                    dbPerson.setEmergencyContactPerson(person.getEmergencyContactPerson());
                }
                if (person.getEmergencyContactPhone() != null && person.getEmergencyContactPhone().length() > 0) {
                    dbPerson.setEmergencyContactPhone(person.getEmergencyContactPhone());
                }
                //保安员等级证信息可删除
                //#5725 M-陕西西安未央保安服务有限公司反馈，保安员信息修改保存不成功
                dbPerson.setProfessionLevel(person.getProfessionLevel());
                dbPerson.setCredential(person.getCredential());
                //#5725 END
                if (person.getInsured() != null) {
                    dbPerson.setInsured(person.getInsured());
                }
                if (person.getDrivingLevel() != null && person.getDrivingLevel().length() > 0) {
                    dbPerson.setDrivingLevel(person.getDrivingLevel());
                }
                //抢证
                dbPerson.setArmNumber(person.getArmNumber());
                if (person.getArmStart() != null && person.getArmStart() != null) {
                    dbPerson.setArmStart(person.getArmStart());
                }
                if (person.getArmEnd() != null && person.getArmEnd() != null) {
                    dbPerson.setArmEnd(person.getArmEnd());
                }
                //持枪证单位
                dbPerson.setArmUnit(person.getArmUnit());
                if (person.getEnrolled() != null && person.getEnrolled() != null) {
                    dbPerson.setEnrolled(person.getEnrolled());
                }
                if (person.getEscorted() != null && person.getEscorted() != null) {
                    dbPerson.setEscorted(person.getEscorted());
                }
                if (person.getArmLicence() != null && person.getArmLicence() != null) {
                    dbPerson.setArmLicence(person.getArmLicence());
                }
                if (person.getQualified() != null && person.getQualified() != null) {
                    dbPerson.setQualified(person.getQualified());
                }
                if (person.getUnqualified() != null && person.getUnqualified().length() > 0) {
                    dbPerson.setUnqualified(person.getUnqualified());
                }
                if (person.getStarLevel() != null && person.getStarLevel().intValue() > 0) {
                    dbPerson.setStarLevel(person.getStarLevel());
                }

                if (person.getHtbh() != null && person.getHtbh() != "") {
                    dbPerson.setHtbh(person.getHtbh());
                }
                if (person.getHtenddate() != null) {
                    dbPerson.setHtenddate(person.getHtenddate());
                }
                if (person.getHtLife() != null && person.getHtLife() != "") {
                    dbPerson.setHtLife(person.getHtLife());
                }
                if (person.getHtstartdate() != null) {
                    dbPerson.setHtstartdate(person.getHtstartdate());
                }
                if (person.getHtstate() != null && person.getHtstate() != "") {
                    dbPerson.setHtstate(person.getHtstate());
                }
                if (person.getSigndate() != null) {
                    dbPerson.setSigndate(person.getSigndate());
                }
                if (person.getEntrydate() != null && person.getEntrydate() != null) {
                    dbPerson.setEntrydate(person.getEntrydate());
                }

                if (StringUtil.isNotEmpty(person.getApplicant_name())) {
                    dbPerson.setApplicant_name(person.getApplicant_name());
                }
                if (StringUtil.isNotEmpty(person.getArmcertificatejgname())) {
                    dbPerson.setArmcertificatejgname(person.getArmcertificatejgname());
                }
                if (StringUtil.isNotEmpty(person.getArmcertificatejgtime())) {
                    dbPerson.setArmcertificatejgtime(person.getArmcertificatejgtime());
                }
                if (StringUtil.isNotEmpty(person.getArmcertificateno())) {
                    dbPerson.setArmcertificateno(person.getArmcertificateno());
                }
                if (StringUtil.isNotEmpty(person.getArmtraincompanyname())) {
                    dbPerson.setArmtraincompanyname(person.getArmtraincompanyname());
                }
                if (StringUtil.isNotEmpty(person.getArmtraincompanyno())) {
                    dbPerson.setArmtraincompanyno(person.getArmtraincompanyno());
                }
                if (StringUtil.isNotEmpty(person.getArmtrainstarttime())) {
                    dbPerson.setArmtrainstarttime(person.getArmtrainstarttime());
                }
                if (StringUtil.isNotEmpty(person.getArmtrainendtime())) {
                    dbPerson.setArmtrainendtime(person.getArmtrainendtime());
                }
                if (StringUtil.isNotEmpty(person.getArmtraintime())) {
                    dbPerson.setArmtraintime(person.getArmtraintime());
                }
                if (StringUtil.isNotEmpty(person.getArmtype())) {
                    dbPerson.setArmtype(person.getArmtype());
                }
                if (StringUtil.isNotEmpty(person.getCertificatejgname())) {
                    dbPerson.setCertificatejgname(person.getCertificatejgname());
                }

                if (StringUtil.isNotEmpty(person.getCertificatejgno())) {
                    dbPerson.setCertificatejgno(person.getCertificatejgno());
                }

                if (StringUtil.isNotEmpty(person.getCertificatejgtime())) {
                    dbPerson.setCertificatejgtime(person.getCertificatejgtime());
                }
                if (StringUtil.isNotEmpty(person.getFingerprintsno())) {
                    dbPerson.setFingerprintsno(person.getFingerprintsno());
                }
                if (StringUtil.isNotEmpty(person.getGross_premium())) {
                    dbPerson.setGross_premium(person.getGross_premium());
                }
                if (StringUtil.isNotEmpty(person.getInception_date())) {
                    dbPerson.setInception_date(person.getInception_date());
                }
                if (StringUtil.isNotEmpty(person.getIndustryassociation())) {
                    dbPerson.setIndustryassociation(person.getIndustryassociation());
                }
                if (StringUtil.isNotEmpty(person.getIns_count())) {
                    dbPerson.setIns_count(person.getIns_count());
                }
                if (StringUtil.isNotEmpty(person.getInsurance_ame())) {
                    dbPerson.setInsurance_ame(person.getInsurance_ame());
                }
                if (StringUtil.isNotEmpty(person.getMarriage())) {
                    dbPerson.setMarriage(person.getMarriage());
                }
                if (StringUtil.isNotEmpty(person.getNationality())) {
                    dbPerson.setNationality(person.getNationality());
                }
                if (StringUtil.isNotEmpty(person.getPlanned_end_date())) {
                    dbPerson.setPlanned_end_date(person.getPlanned_end_date());
                }
                if (StringUtil.isNotEmpty(person.getPolitics())) {
                    dbPerson.setPolitics(person.getPolitics());
                }
                if (StringUtil.isNotEmpty(person.getProduct_name())) {
                    dbPerson.setProduct_name(person.getProduct_name());
                }
                if (StringUtil.isNotEmpty(person.getSfcq())) {
                    dbPerson.setSfcq(person.getSfcq());
                }
                if (StringUtil.isNotEmpty(person.getTraincompanyname())) {
                    dbPerson.setTraincompanyname(person.getTraincompanyname());
                }
                if (StringUtil.isNotEmpty(person.getTraincompanyno())) {
                    dbPerson.setTraincompanyno(person.getTraincompanyno());
                }
                if (StringUtil.isNotEmpty(person.getTraintime())) {
                    dbPerson.setTraintime(person.getTraintime());
                }
                if (StringUtil.isNotEmpty(person.getZgcertificatejgname())) {
                    dbPerson.setZgcertificatejgname(person.getZgcertificatejgname());
                }
                if (StringUtil.isNotEmpty(person.getZgcertificatejgno())) {
                    dbPerson.setZgcertificatejgno(person.getZgcertificatejgno());
                }
                if (StringUtil.isNotEmpty(person.getZgcertificatejgtime())) {
                    dbPerson.setZgcertificatejgtime(person.getZgcertificatejgtime());
                }
                if (StringUtil.isNotEmpty(person.getZgcredential())) {
                    dbPerson.setZgcredential(person.getZgcredential());
                }
                if (StringUtil.isNotEmpty(person.getZgtraincompanyname())) {
                    dbPerson.setZgtraincompanyname(person.getZgtraincompanyname());
                }
                if (StringUtil.isNotEmpty(person.getZgtraincompanyno())) {
                    dbPerson.setZgtraincompanyno(person.getZgtraincompanyno());
                }
                if (StringUtil.isNotEmpty(person.getZgtrainendtime())) {
                    dbPerson.setZgtrainendtime(person.getZgtrainendtime());
                }
                if (StringUtil.isNotEmpty(person.getZgtrainstarttime())) {
                    dbPerson.setZgtrainstarttime(person.getZgtrainstarttime());
                }
                if (StringUtil.isNotEmpty(person.getZgtraintime())) {
                    dbPerson.setZgtraintime(person.getZgtraintime());
                }
                if (StringUtil.isNotEmpty(person.getCensorStatus())) {
                    dbPerson.setCensorStatus(person.getCensorStatus());
                }
                if (StringUtil.isNotEmpty(person.getPersonType())) {
                    dbPerson.setPersonType(person.getPersonType());
                }
                if (StringUtil.isNotEmpty(person.getSocialSecurity())) {
                    dbPerson.setSocialSecurity(person.getSocialSecurity());
                }


                //修改保安培训平台
                Config coninsConfig = configService.findByKey(Constants.TRAIN);
                String path = coninsConfig.getValue() + "train/systemuser/updateByIdentitynumber"
                        + "?identitynumber=" + dbPerson.getIdNumber() //身份证
                        + "&truename=" + dbPerson.getRealName()//姓名
                        + "&fullname=" + dbPerson.getRealName()//姓名
                        + "&certificate=" + dbPerson.getProfessionLevel();//证书 = 保安员证书等级水平
                /*+ "&purInsurance=" + (dbPerson.getInsured() ? "1" : "0");//是否已购保险*/
                try {
                    URL url = new URL(path.trim());
                    //打开连接
                    HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
                    if (200 == urlConnection.getResponseCode()) {
                        //得到输入流
                        InputStream is = urlConnection.getInputStream();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        while (-1 != (len = is.read(buffer))) {
                            baos.write(buffer, 0, len);
                            baos.flush();
                        }
                    }
                } catch (IOException e) {
                }

                dbPerson.setAreacode(company.getAreaCode());
                personDaoAop.update(dbPerson);


                logger.info("update relationship...");
                if (person.getRelation() != null) {
                    SecurityCompanyPerson relation = companyPersonService.findByPersonAndCompany(dbPerson.getId(), company.getId());
                    if (relation != null) {
                        if(person.getRelation().getOrg() != null && person.getRelation().getOrg().getId() != null) {
                            relation.setOrg(person.getRelation().getOrg());
                        }
//                          relation.setRole(person.getRelation().getRole());
                        relation.setUpdateBy(currentUser.getRealname());
                        relation.setUpdateTime(new Date());
                        relation.setActive(true);
                        companyPersonService.update(relation);
                    } else {
                        //3.保存人员与公司关系信息
                        person.getRelation().setCompany(company);
                        person.getRelation().setPerson(person);
                        person.getRelation().setActive(true);
                        person.getRelation().setCreateTime(new Date());
                        person.getRelation().setUpdateTime(new Date());
                        person.getRelation().setUpdateBy(currentUser.getUsername());
                        person.getRelation().setNativeCode(arsUtil.getCurrentNatvie());
                        companyPersonDao.save(person.getRelation());
                    }
                }

                String companyId = company.getComId();
                //更新公司人员数量
               /* new Thread(()->{
                    securityCompanyDao.updatePersonNumber(companyId);
                }).start();*/
            } else {
                throw new RuntimeException("保安员不存在，ID:" + person.getId());
            }
        }
    }

    @Override
    public void updateBX(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.updateSelective(person);
    }

    @Override
    public void delete(SecurityPerson person) {
        SecurityPerson dbPerson = personDao.findById(person.getId());
        SecurityCompanyPerson companyPerson = companyPersonService.findSingleByPerson(dbPerson);
        if (companyPerson != null) {
            //获取公司信息并更新人数
            SecurityCompany company = companyPerson.getCompany();
            //删除人员与公司的关系
            companyPerson.setUpdateTime(new Date());
            companyPersonService.delete(companyPerson);
            String companyId = company.getComId();
            //更新公司人员数量
           /* new Thread(()->{
                securityCompanyDao.updatePersonNumber(companyId);
            }).start();*/
        }
    }

    @Override
    public List<SecurityPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return personDao.searchForDataSynchronization(dto);
    }

    @Override
    public PersonSearchDto search(PersonSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }

        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyService.findByUserid(user.getId());
            //判断单位信息是否存在
            if(company!=null) {
                dto.setCompanyId(company.getId());
            }
        }
        List<SecurityPerson> data = personDao.search(dto);
        Long count = personDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }


    @Override
    public PersonSearchDto searchForMap(PersonSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 1) {
            dto.setNativeCode(user.getNativeCode());
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if (dto.getAreaCode() != null) {
            if (dto.getAreaCode().endsWith("0000")) {//省
                dto.setAreaCode(dto.getAreaCode().substring(0, 2) + "____");
            } else if (dto.getAreaCode().endsWith("00")) {//市
                dto.setAreaCode(dto.getAreaCode().substring(0, 4) + "__");
            } else {//区
                dto.setAreaCode(dto.getAreaCode());
            }
        }


        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }

        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        List<SecurityPerson> data = personDao.searchForMap(dto);
        Long count = personDao.searchForMapCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public SecurityPerson findByIdCardAndCompanyId(String idNumber, Long id) {
        return personDao.findByIdCardAndCompanyId(idNumber, id);
    }

    @Override
    public SecurityPerson findByPhoneAndCompanyId(String phone, Long id) {
        return personDao.findByPhoneAndCompanyId(phone, id);
    }

    @Override
    public SecurityPerson findByPhone(String phone) {
        return personDao.findByPhone(phone);
    }

    @Override
    public AjaxResult searchBatch(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        List<SecurityPerson> listperson = new ArrayList<SecurityPerson>();
        if (personIds != null) {
            for (Long personId : personIds) {
                SecurityPerson person = personDao.findById(personId);
                if (person.getIncumbencyStatus().equals("0")) {
                    listperson.add(person);
                }
            }
        }
        result.setData(listperson);
        result.setSuccessful(true);
        return result;
    }

    @Override
    public List<SecurityPerson> searchForExport(PersonPageSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        arsUtil.setPoliceSearch(dto);
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }

        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId().toString());
        }

        String nativePlace = dto.getNativePlace();
        if (StringUtil.isNotEmpty(nativePlace)) {
            if (nativePlace.endsWith("0000")) {
                dto.setNativePlace(nativePlace.substring(0, 2) + "________________");
            } else if (nativePlace.endsWith("00")) {
                //市、设置机构类型 市级2
                dto.setNativePlace(nativePlace.substring(0, 4) + "______________");
            }
        }
        return personDao.searchForExport(dto);
    }

    @Override
    public PersonSearchDto searchForManage(PersonSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        //保存搜索记录
        if (StringUtil.isNotEmpty(dto.getKeyword())) {
            searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }

        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        List<SecurityPerson> data = personDao.searchForManage(dto);
        Long count = personDao.searchCountForManage(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public PersonSearchDto searchForPersonInsuredState(PersonSearchDto dto) {
        List<SecurityPerson> data = personDao.search(dto);
        Long count = personDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    @Override
    public List<ReportData> findLevelReport() {
        SecurityCompany company = companyService.getCurrentUserCompany();
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 1) {
            if (company == null) {
                company = new SecurityCompany();
                company.setPath(user.getPolice().getPath());
                company.setUserid(user.getId());
            }
        }
        return personDao.findLevelReport(company);
    }

    @Override
    public Map<String, String[]> findAgeReport() {
        SecurityCompany company = companyService.getCurrentUserCompany();
        Map<String, String[]> data = new HashMap<String, String[]>();
        User user = arsUtil.getCurrentUser();
        //区域
        if (user.getPlatform().intValue() == 1) {
            if (company == null) {
                company = new SecurityCompany();
                company.setPath(user.getPolice().getPath());
                company.setUserid(user.getId());
            }
        }
        List<ReportData> list = personDao.findAgeReport(company);
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public List<ReportData> findGenderReport() {
        User user = arsUtil.getCurrentUser();
        SecurityCompany company = companyService.getCurrentUserCompany();
        //区域
        if (user.getPlatform().intValue() == 1) {
            if (company == null) {
                company = new SecurityCompany();
                company.setPath(user.getPolice().getPath());
                company.setUserid(user.getId());
            }
        }
        return personDao.findGenderReport(company);
    }

    @Override
    public Map<String, String[]> findNativeReport() {
        Map<String, String[]> data = new HashMap<String, String[]>();
        SecurityCompany company = companyService.getCurrentUserCompany();
        User user = arsUtil.getCurrentUser();
        //区域
        if (user.getPlatform().intValue() == 1) {
            if (company == null) {
                company = new SecurityCompany();
                company.setPath(user.getPolice().getPath());
                company.setUserid(user.getId());
            }
        }
        List<ReportData> list = personDao.findNativeReport(company);
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO) {
        SecurityPersonSearchRerurnDTO securityPersonSearch = new SecurityPersonSearchRerurnDTO();
        securityPersonSearch.setData(personDao.findByCompanyIdReturnDTO(securityPersonSearchRerurnDTO));
        securityPersonSearch.setTotalCount(personDao.countByCompanyIdReturnDTO(securityPersonSearchRerurnDTO));
        return securityPersonSearch;
    }

    @Override
    public PersonSearchDto searchUrgentPerson(PersonSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }

        SecurityCompany company = null;
        if (user.getPlatform() == 2) {
            company = companyDao.findByUserid(user.getId());
        }

        if (company != null) {
            dto.setCompanyId(company.getId());
        }
        List<SecurityPerson> data = personDao.searchUrgentPerson(dto);
        dto.setData(data);
        return dto;
    }

    @Override
    public Map<String, String[]> findAbilityReport(Long id) {
        Map<String, String[]> data = new HashMap<String, String[]>();
        User user = arsUtil.getCurrentUser();
        Map<String, Integer> list = personDao.findAbilityReport(id);
        String[] name = new String[4];
        String[] value = new String[4];
        String[] limit = new String[4];
        String k = "年龄";
        name[0] = k + ":" + list.get(k);
        value[0] = list.get(k) + "";
        limit[0] = 60 + "";
        k = "工作年限";
        name[1] = "从事" + k + ":" + list.get(k) + "年";
        value[1] = list.get(k) + "";
        limit[1] = 60 + "";
        k = "保安等级";
        name[2] = k + ":" + list.get("level");
        value[2] = list.get(k) + "";
        limit[2] = 5 + "";
        k = "学历";
        name[3] = k + ":" + list.get("name");
        value[3] = list.get(k) + "";
        limit[3] = 7 + "";
//		int j = 0;
//		for(Iterator<String> i = list.keySet().iterator(); i.hasNext(); j++) {
//			String k = i.next();
//			name[j] = k;
//			value[j] = list.get(k)+"";
//		}
        data.put("name", name);
        data.put("value", value);
        data.put("limit", limit);
        return data;
    }

    @Override
    public PersonStudyDTO findPersonStudyReport(PersonStudySearchDTO dto) {
        User user = arsUtil.getCurrentUser();
        return personDao.findPersonStudyReport(dto);
    }

    @Override
    public List<Long> getAllPersonStudy() {
        return personDao.getAllPersonStudy();
    }

    @Override
    public List<ReportData> findTaskTypeReport(Long id) {
        User user = arsUtil.getCurrentUser();
        return personDao.findTaskTypeReport(id);
    }

    @Override
    public Map<String, String[]> findTaskCatalogReport(Long id) {
        Map<String, String[]> data = new HashMap<String, String[]>();
        User user = arsUtil.getCurrentUser();
        List<ReportData> list = personDao.findTaskCatalogReport(id);
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            ReportData rd = list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    @Override
    public List<ReportData> findTaskLevelReport(Long id) {
        User user = arsUtil.getCurrentUser();
        return personDao.findTaskLevelReport(id);
    }

    @Override
    public void updateLocation(SecurityPerson person) {
        person.setUpdateTime(new Date());
        personDaoAop.updateSelective(person);
    }

    @Override
    public List<SecurityPerson> findByCompanyId(Long companyId) {
        return personDao.findByCompanyId(companyId);
    }


    @Override
    public List<SecurityPerson> findByCompanyIdForInsurance(Long companyId) {
        return personDao.findByCompanyIdForInsurance(companyId);
    }

    @Override
    public List<SecurityPerson> findByCompanyIdForInsuranceAndCheckId(PersonSearchDto personSearchDto) {
        //2018年8月3日17:29:45 wjb 百联保投保人数改成可配置的
        personSearchDto.setPaging(true);
        Config blbPersonLimitConfig = configService.findByKey(Constants.BLB_PERSON_LIMIT);
        if (null != blbPersonLimitConfig && null != blbPersonLimitConfig.getValue() && !"".equals(blbPersonLimitConfig.getValue())) {
            personSearchDto.setNumPerPage(Integer.parseInt(blbPersonLimitConfig.getValue()));
        } else {
            personSearchDto.setNumPerPage(500);
        }
        return personDao.findByCompanyIdForInsuranceAndCheckId(personSearchDto);
    }

    @Override
    public Long searchAllCount(PersonSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        } else {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
            dto.setNativeCode(user.getNativeCode());
        }
        return personDao.searchAllCount(dto);
    }

    @Override
    public List<UrgentPerson> queryUrgentPersonByCompnyId() {
        User user = arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (user.getPlatform() == 2) {
            company = companyDao.findByUserid(user.getId());
        }
        if (company == null) {
            throw new RuntimeException("当前登录ID无法找到对应公司信息：Userid:" + user.getId());
        }
        return urgentTeamPersonDAO.queryUrgentPersonByCompnyId(company.getId());
    }


    @Override
    public void publicAuth(Long id, String photo) {
        User user = arsUtil.getCurrentUser();
        //获取人员信息及照片
        SecurityPerson person = personDao.findById(id);
        if (person != null) {
            //TODO 调用公安一所的服务验证是否通过
            //更新人员信息的身份认定的状态
            person.setIdentityAuthState("1");
            person.setUpdateTime(new Date());
            personDaoAop.updateSelective(person);
            //更新照片
            user.setPhoto(photo);
            //更新图片时，同时也更新update_time
            user.setUpdateTime(new Date());
            userService.saveOrUpdate(user,String.valueOf(Constants.PLATFORM_PERSON));
        }

    }

    @Override
    public AjaxResult updateCertificate(SecurityPerson person) {
        AjaxResult result = new AjaxResult();
        if (person.getId() == null) {
            throw new ArsException("人员id不能为空");
        }
        SecurityPerson securityPerson = personDao.findById(person.getId());
        if (securityPerson == null) {
            throw new ArsException("找不到人员信息");
        }
        /**
         * 没有传值不复制
         * */
        BeanUtils.copyPropertiesIgnore(person, securityPerson, true);
        personDaoAop.update(securityPerson);
        result.setMsg("更新成功");
        result.setSuccessful(true);
        result.setData(person);
        return result;
    }


    @Override
    public AjaxResult updatePersonInsuredState(SecurityPersonDTO dto) {
        AjaxResult result = new AjaxResult();
        //更新人员信息投保状态
        personDaoAop.updatePersonInsuredState(dto.getPersons(),dto.getStatus());
        //公司根据userId或者saas的comId更新在职人员数、投保人数
        //  new Thread(()->{
        //  securityCompanyDao.updateNumber(dto);
        //}).start();
        result.setMsg("更新成功");
        result.setSuccessful(true);
        return result;
    }
    @Override
    public AjaxResult batchDelete(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        //批量离职人员信息
        personDaoAop.updateDeletePerson(personIds,new Date(),user.getUsername(),new Date());
        //公司根据userId或者saas的comId更新在职人员数、投保人数
        new Thread(()->{
            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            //人员离职后，需从已安排的驻勤中移除
            comTaskPerDao.updateDeletePerson(personIds);
            // securityCompanyDao.updateNumber(securityPersonDTO);

        }).start();
        result.setSuccessful(true);
        return result;
    }

    @Override
    public AjaxResult batchAttrition(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 2) {
            result.setSuccessful(false);
        } else {
            SecurityCompany company = companyService.findByUserid(user.getId());
            List<InsPreservationDetailVo> orders = new ArrayList<InsPreservationDetailVo>();
            if (company.getOrderNo() != null && !"".equals(company.getOrderNo())) {

                String[] ordernos = company.getOrderNo().split(",");

                InsPreservationDetailVo orderVo = null;
                List<SecurityPerson> listperson = new ArrayList<SecurityPerson>();
                for (Long personId : personIds) {
                    SecurityPerson person = personDao.findById(personId);
                    orderVo = new InsPreservationDetailVo();
                    orderVo.setOid(user.getId() + "");
                    //				orderVo.setBirthday();
                    //				orderVo.setCareer();
                    orderVo.setId_card(person.getIdNumber());
                    orderVo.setName(person.getRealName());
                    orderVo.setSex(person.getGender());
                    orderVo.setId_type(Constants.POLICY_ATTRITION);
                    listperson.add(person);
                    orders.add(orderVo);
                }

                Map<String, Object> map = new HashMap<String, Object>();
                map.put("vo", orders);

                map.put("orderNo", ordernos[ordernos.length - 1]);
                map.put("webType", Constants.POLICY_WEBTYPE);
                map.put("token", Sha1Util.entryptPassword(Constants.POLICY_WEBTYPE + user.getId()));//生成密钥 当密钥相同的时候才进行插入数据
                //保存分销商
                String url = ThirdPartyURL.BAILIANBAO + ThirdPartyURL.INCREASED_ATTRITION;
                try {
                    String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                    String status = messageUtils.getStringValueByKey(resultStr, "status");
                    if (StringUtil.isNotEmpty(status) && "200".equals(status)) {
                        for (SecurityPerson p : listperson) {
                            p.setInsured(Constants.INSURED_NO);
                            p.setUpdateTime(new Date());
                            personDaoAop.updateSelective(p);
                        }
                        result.setSuccessful(true);
                    } else {
                        result.setSuccessful(false);
                    }
                } catch (Exception e) {
                    result.setSuccessful(false);
                }
            }
        }
        return result;
    }


    @Override
    public void exportPersons(List<SecurityPerson> persons, File file, Map<Long, Native> nativeData) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("人员信息");
//			wb.setSheetHidden(1, true);
            //标题
            String[] handers = {"部门名称", "姓名", "手机号码", "身份证",  "性别", "身高", "学历", "年龄", "职业水平", "证书号", "保安员资格证书号", "血型", " 民族", "家庭地址", "居住地址", "籍贯", "所属公司","离职时间"}; //列标题
            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            //写标题

            //文本格式
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;
            Map<Long, SecurityProfessionLevel> levels = proLevelService.findMap();
            Map<Long, Edu> edus = eduService.findMap();
            for (SecurityPerson person : persons) {
                row = sheet1.createRow(index++);
                HSSFCell orgCell = row.createCell(0);
                orgCell.setCellStyle(style);
                orgCell.setCellValue(person.getRelation() == null || person.getRelation().getOrg() == null ? "" : person.getRelation().getOrg().getName()); //往单元格里写数据

                HSSFCell realnameCell = row.createCell(1);
                realnameCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getRealName())) {
                    realnameCell.setCellValue(person.getRealName()); //往单元格里写数据
                }

                HSSFCell phoneCell = row.createCell(2);
                phoneCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getPhone())) {
                    phoneCell.setCellValue(person.getPhone()); //往单元格里写数据
                }

                HSSFCell idNoCell = row.createCell(3);
                idNoCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getIdNumber())) {
                    idNoCell.setCellValue(person.getIdNumber()); //往单元格里写数据
                }



                HSSFCell sexCell = row.createCell(4);
                sexCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getGender())) {
                    sexCell.setCellValue(person.getGender()); //往单元格里写数据
                }

                HSSFCell statureCell = row.createCell(5);
                statureCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getStature())) {
                    statureCell.setCellValue(person.getStature()); //往单元格里写数据
                }

                HSSFCell eduCell = row.createCell(6);
                eduCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getEdu())) {
                    if (!StringUtils.isEmpty(edus.get(person.getEdu().longValue()))) {
                        eduCell.setCellValue(edus.get(person.getEdu().longValue()).getName()); //往单元格里写数据
                    }
                }


                HSSFCell ageCell = row.createCell(7);
                ageCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getAge())) {
                    ageCell.setCellValue(person.getAge()); //往单元格里写数据
                }


                HSSFCell levelCell = row.createCell(8);
                levelCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getProfessionLevel())) {
                    if (!StringUtils.isEmpty(levels.get(person.getProfessionLevel()))) {
                        levelCell.setCellValue(levels.get(person.getProfessionLevel()).getLevel()); //往单元格里写数据
                    }
                }


                HSSFCell credentialCell = row.createCell(9);
                credentialCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getCredential())) {
                    credentialCell.setCellValue(person.getCredential()); //往单元格里写数据
                }

                HSSFCell zgcredentialCell = row.createCell(10);
                zgcredentialCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getZgcredential())) {
                    zgcredentialCell.setCellValue(person.getZgcredential()); //往单元格里写数据
                }


                HSSFCell bloodCell = row.createCell(11);
                bloodCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getBlood())) {
                    bloodCell.setCellValue(person.getBlood()); //往单元格里写数据
                }


                HSSFCell nationCell = row.createCell(12);
                nationCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getNation())) {
                    nationCell.setCellValue(person.getNation()); //往单元格里写数据
                }


                HSSFCell idCardAddressCell = row.createCell(13);
                idCardAddressCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getIdCardAddress())) {
                    idCardAddressCell.setCellValue(person.getIdCardAddress()); //往单元格里写数据
                }


                HSSFCell currentAddressCell = row.createCell(14);
                currentAddressCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getCurrentAddress())) {
                    currentAddressCell.setCellValue(person.getCurrentAddress()); //往单元格里写数据
                }


                HSSFCell nativesCell = row.createCell(15);
                nativesCell.setCellStyle(style);
                //modify zjh time :2018年9月3日 17:14:52 判段区域不为空,nativeData.get(person.getNatives())，get不是long型找不到数据的
                if (!StringUtils.isEmpty(person.getNatives())) {
                    if (!StringUtils.isEmpty(nativeData.get(person.getNatives().longValue()))) {
                        nativesCell.setCellValue(nativeData.get(person.getNatives().longValue()).getNativeName()); //往单元格里写数据
                    }
                }



                HSSFCell companynameCell = row.createCell(16);
                companynameCell.setCellStyle(style);
                if (person.getRelation() != null && person.getRelation().getCompany() != null) {
                    companynameCell.setCellValue(person.getRelation().getCompany().getName()); //所属公司
                }

                HSSFCell leaveDateCell = row.createCell(17);
                leaveDateCell.setCellStyle(style);
                if (!StringUtils.isEmpty(person.getLeaveDate())) {
                    //转换时间的格式
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    leaveDateCell.setCellValue(sdf.format(person.getLeaveDate())); //离职时间
                }

            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public List<SecurityPerson> findUrgentPersons(String latitude, String longitude, Integer scope) {
        Map map = MapDistance.getAround(latitude, longitude, scope + "");
        //获取在线人员
        PersonSearchDto dto = new PersonSearchDto();
        /*位置纬度区间*/
        String minLat = (String) map.get("minLat");
        dto.setMinLat(minLat);
        String maxLat = (String) map.get("maxLat");
        dto.setMaxLat(maxLat);
        /*位置经度区间*/
        String minLng = (String) map.get("minLng");
        dto.setMinLng(minLng);
        String maxLng = (String) map.get("maxLng");
        dto.setMaxLng(maxLng);
        return personDao.findUrgentPersons(dto);
    }

    @Override
    public List<SecurityPerson> findOnlinePersons(String latitude, String longitude, Integer scope) {
        Map map = MapDistance.getAround(latitude, longitude, scope + "");
        //获取在线人员
        PersonSearchDto dto = new PersonSearchDto();
        /*位置纬度区间*/
        String minLat = (String) map.get("minLat");
        dto.setMinLat(minLat);
        String maxLat = (String) map.get("maxLat");
        dto.setMaxLat(maxLat);
        /*位置经度区间*/
        String minLng = (String) map.get("minLng");
        dto.setMinLng(minLng);
        String maxLng = (String) map.get("maxLng");
        dto.setMaxLng(maxLng);
        return personDao.findOnlinePersons(dto);
    }

    @Override
    public AjaxResult checkUserPolicy(Long personId) {
        return null;
    }

    @Override
    public AjaxResult checkUserPolicy(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() == 1) {
            result.setSuccessful(false);
            result.setMsg("登录异常");
        } else {
            try {
                JSONArray personArray = new JSONArray();
                for (Long personId : personIds) {
                    SecurityPerson person = personDao.findById(personId);
                    if (!checkUserPolicyFromBLB(person.getId())) {
                        JSONObject personObj = new JSONObject();
                        personObj.put("id", personId);
                        personObj.put("name", person.getRealName());
                        personArray.add(personObj);
                    }
                }
                if (personArray != null && personArray.size() > 0) {
                    result.setSuccessful(false);
                    result.setData(personArray);
                } else {
                    result.setSuccessful(true);
                }
            } catch (Exception e) {
                result.setSuccessful(false);
                result.setMsg(e.toString());
                logger.error(e.getMessage(), e);
            }
        }
        return result;
    }

    private boolean checkUserPolicyFromBLB(Long personId) {
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() == 1) {
            return false;
        } else {
            SecurityCompany company = companyService.findByUserid(user.getId());
            SecurityPerson person = personDao.findById(personId);
            return (person.getInsured().equals(Constants.INSURED_NO) ? false : true);
//            if (company != null && company.getOrderNo() != null && !company.getOrderNo().equals("")) {
//                String[] ordernos = company.getOrderNo().split(",");
//                for (int i = 0; i < ordernos.length; i++) {
//                    /*Map<String, Object> map = new HashMap<String, Object>();
//                    map.put("oid", ordernos[i]);
//					map.put("webType", Constants.POLICY_WEBTYPE);
//					map.put("idCard", person.getIdNumber());
//					map.put("token", Sha1Util.entryptPassword(Constants.POLICY_WEBTYPE + user.getId()));//生成密钥 当密钥相同的时候才进行插入数据
//					//保存分销商
//					String url = ThirdPartyURL.BAILIANBAO + ThirdPartyURL.CHECK_USER_POLICY;
//					String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
//					String status = messageUtils.getStringValueByKey(resultStr, "status");
//					String flag = messageUtils.getStringValueByKey(resultStr, "flag");
//					if (StringUtil.isNotEmpty(status) && "200".equals(status)) {
//						boolean b1 = Boolean.valueOf(flag).booleanValue();
//						person.setInsured(b1);
//						personDao.updateBX(person);
//						return b1;
//					}*/
//                    return person.getInsured();
//                }
//            }
//            return false;
        }
    }

    @Override
    @Deprecated
    public AjaxResult policy_increased(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() != 2) {
            result.setSuccessful(false);
        } else {
            SecurityCompany company = companyService.findByUserid(user.getId());
            List<InsPreservationDetailVo> orders = new ArrayList<InsPreservationDetailVo>();
            if (StringUtil.isNotEmpty(company.getOrderNo())) {
                String[] ordernos = company.getOrderNo().split(",");
                InsPreservationDetailVo orderVo = null;
                List<SecurityPerson> listperson = new ArrayList<SecurityPerson>();
                Config coninsConfig = configService.findByKey(Constants.TRAIN);
                for (Long personId : personIds) {
                    SecurityPerson person = personDao.findById(personId);
                    orderVo = new InsPreservationDetailVo();
                    orderVo.setOid(user.getId() + "");
                    //				orderVo.setBirthday();
                    //				orderVo.setCareer();
                    orderVo.setId_card(person.getIdNumber());
                    orderVo.setName(person.getRealName());
                    orderVo.setSex(person.getGender());
                    orderVo.setId_type(Constants.POLICY_INCREASED);
                    Order order = orderDao.findByRandomOrderNo(ordernos[ordernos.length - 1]);
                    if (order != null) {
                        Config groupid = configService.findByKey("groupid");
                        String groupidValue = "11";
                        if (groupid != null) {
                            groupidValue = groupid.getValue();
                        }
                        //保险增员 培训平台加入相应权限
                        String url = coninsConfig.getValue() + ThirdPartyURL.ADDAUTH + "?identitynumber=" + person.getIdNumber()
                                + "&groupid=" + groupidValue + "&name=" + person.getRealName()
                                + "&mobile=" + person.getPhone() + "&orderID=" + order.getOrdernumber()
                                + "&startdate=" + order.getEffectivestarttime() + "&enddate=" + order.getEffectiveendtime()
                                + "&companyid=" + company.getId() + "&companyname=" + company.getName();
                        messageUtils.getJsonByInternet(url);
                    }
                    listperson.add(person);
                    orders.add(orderVo);

                }

                Map<String, Object> map = new HashMap<String, Object>();
                map.put("vo", orders);


                map.put("orderNo", ordernos[ordernos.length - 1]);
                map.put("inceptionDate", DateUtil.getCurrentDate());
                map.put("reviseType", "1");
                map.put("token", Sha1Util.entryptPassword(Constants.POLICY_WEBTYPE + user.getId()));//生成密钥 当密钥相同的时候才进行插入数据
                //保存分销商
                String url = ThirdPartyURL.BAILIANBAO + ThirdPartyURL.INCREASED_ATTRITION;
                try {
                    String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                    String status = messageUtils.getStringValueByKey(resultStr, "status");
                    if (StringUtil.isNotEmpty(status) && "200".equals(status)) {
                        result.setSuccessful(true);
                        List<InsPreservationDetailVo> returnList = messageUtils.getList(resultStr, InsPreservationDetailVo.class, "list");
                        for (InsPreservationDetailVo order : returnList) {
                            SecurityPerson person = personDao.findActiveByIdCard(order.getId_card());
                            person.setInsured(Constants.INSURED_YES);
                            person.setBxOrderno(ordernos[0]);
                            person.setUpdateTime(new Date());
                            personDaoAop.updateSelective(person);
                        }
                    } else {
                        result.setSuccessful(false);
                    }
                } catch (Exception e) {
                    result.setSuccessful(false);
                }

            }
        }
        return result;
    }

    @Override
    public AjaxResult relieveHt(Long personId) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (user == null || user.getPlatform().intValue() == 1) {
            result.setSuccessful(false);
        } else {
            SecurityPerson person = personDao.findById(personId);
            person.setHtstate(Constants.HTSTATE_JC);
            person.setUpdateBy(user.getUsername());
            person.setUpdateTime(new Date());
            personDaoAop.update(person);
            result.setSuccessful(true);
        }
        return result;
    }

    @Override
    public List<PersonStudyDTO> getStudyListDesc(PersonStudySearchDTO dto) {
        return personDao.getStudyListDesc(dto);
    }

    @Override
    public void saveOrUpdateForDS(SecurityPerson securityPerson) {
        if (securityPerson.getActive() == null) {
            securityPerson.setActive(true);
        }
        //获取外网公司关联表
        List<SecurityCompanyPerson> companyPersonList = securityPerson.getRelationList();
        SecurityCompanyPerson companyPerson =null;
        if(companyPersonList!=null){
            for (SecurityCompanyPerson securityCompanyPerson : companyPersonList) {
                securityCompanyPerson.setPerson(securityPerson);
                if(securityCompanyPerson.getActive()){
                    companyPerson = securityCompanyPerson;
                    securityPerson.setRelation(securityCompanyPerson);
                }
            }
        }
        SecurityPerson dbSecurityPerson = findById(securityPerson.getId());
        if (dbSecurityPerson == null) {
            /****
             * 1.根据身份证号获取是否有等级证信息
             * 2.如果有等级证信息，则更新人员信息
             * 3.更新等级证信息的人员ID，便于后面关联
             */
            GradeCertificate gradeCertificate =  gradeCertificateDao.findByIdNumAndGradeLevel(securityPerson.getIdNumber(),Constants.APPRAISALGRADE_1);
            if(gradeCertificate!=null){
                //证书等级
                if(gradeCertificate.getAppraisalGrade()!=null) {
                    securityPerson.setProfessionLevel(gradeCertificate.getAppraisalGrade());
                }
                //证书编号
                securityPerson.setCredential(gradeCertificate.getCertificateNo());
                //培训机构
                securityPerson.setTraincompanyname(gradeCertificate.getTrainOrgName());
                //人员ID
                gradeCertificate.setPersonId(securityPerson.getId());
                gradeCertificateDao.updateByPersonId(gradeCertificate);
            }
            personDao.save(securityPerson);
            /**********************************部级上报开始 start**************************************************************************/
            //部级接口对接  ---保安员持枪情况基本信息上报
            new Thread(() -> { //异步处理
                try {
                    if (StringUtil.isNotEmpty(securityPerson.getArmNumber())) {
                        //确定对接的属性对应关系
                        //源实体类的列，目标实体类的列
                        String[] srccol = {"idNumber", "armNumber", "armEnd", "armcertificateno", "armcertificatejgname"};
                        String[] desccol = {"sfzh", "cqzbh", "yxrq", "jgbh", "jgmc"};
                        //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
                        String[] key = {"xm", "xb", "ssbags"};
                        String[] value = {securityPerson.getRealName(), securityPerson.getGender() == "男" ? "1" : "2", securityPerson.getUpdateBy()};
                        //生成实体
                        Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol, desccol, securityPerson, new Baycqqkb(), key, value);
                        Baycqqkb baycqqkb = (Baycqqkb) desc;
                        //调用send方法完成对接
                        clientUtil.send(Constants.XXBA_BAYCQQKB, baycqqkb);
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }).start();

            //部级接口对接  ---保安员持枪情况基本信息上报
            new Thread(() -> { //异步处理
                try {
                    //部级接口对接  ---保安员信息
                    //调用webService服务
                    //婚姻状况婚姻状况
                    Map<String,String> marriage = new HashMap<>();
                    marriage.put("1", "10");
                    marriage.put("2", "20");
                    marriage.put("3", "30");
                    marriage.put("4", "40");
                    marriage.put("9", "90");
                    securityPerson.setMarriage(marriage.get(securityPerson.getMarriage()));
                    buildWebServiceEntity(securityPerson);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }).start();

            //部级接口图片上传
            new Thread(() -> { //异步处理
                try {
                    String photo = securityPerson.getPhoto();
                    if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=")) {
                        String fileType = photo.substring(photo.lastIndexOf("."));
                        //图片转BASE64字符串
                        if (!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                            photo = Base64Img.encodeBase64File(photo, baseFolder);
                        } else {
                            photo = Base64Img.encodeBase64FileBJ(photo, ftpServerTemp);
                        }
                        Zpxxb zpxxb = new Zpxxb();
                        zpxxb.setSfzh(securityPerson.getIdNumber());
                        zpxxb.setZpxx(securityPerson.getIdNumber() + fileType);
                        zpxxb.setZpnr(photo);
                        zpxxb.setZpfl("01");//01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                        clientUtil.send(Constants.XXBA_ZPXXB, zpxxb);
                    }

                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }).start();

            /**********************************部级上报结束 end **************************************************************************/
        } else {
            //是否背景筛查标记
            boolean censorStatusFlag = false;
            if(companyPerson == null){
                censorStatusFlag = true;
            }else {
                if (companyPersonList != null && companyPersonList.size() > 0) {
                    List<SecurityCompanyPerson> dbCompanyPersonList = companyPersonDao.findBatchById(securityPerson.getRelationList());
                    //companyPersonList.removeAll(dbCompanyPersonList);
                    if (dbCompanyPersonList.size() > 0) {
                        for (SecurityCompanyPerson securityCompanyPerson : dbCompanyPersonList) {
                            if (companyPerson == null || (companyPerson.getId().longValue() == securityCompanyPerson.getId().longValue())) {
                                censorStatusFlag = true;
                            }
                        }
                    }
                }
            }

            if (securityPerson.getUpdateTime().getTime() > dbSecurityPerson.getUpdateTime().getTime() || !censorStatusFlag) {
                //如果身份证号没有修改的话，无需再进行
                if(dbSecurityPerson.getIdNumber().equals(securityPerson.getIdNumber()) && censorStatusFlag){
                    securityPerson.setCensorStatus(dbSecurityPerson.getCensorStatus());
                }else{
                    securityPerson.setCensorStatus(null);
                }
                personDaoAop.update(securityPerson);
            }

        }
        companyPersonService.saveBatch(companyPersonList);

        //if(companyPersonList != null && companyPersonList.size()>0){
        //    companyPersonService.saveBatch(companyPersonList);
            /*for (SecurityCompanyPerson securityCompanyPerson : companyPersonList) {
                //                    if(companyPerson.getActive()){
//                        //从业信息
//                        new Thread(() -> { //异步处理
//                            if(companyPerson!=null && companyPerson.getCompany()!=null) {
//                                Baycyqkxx baycyqkxx = new Baycyqkxx();
//                                baycyqkxx.setXm(securityPerson.getUser().getRealname());
//                                baycyqkxx.setSfzh(securityPerson.getIdNumber());
//                                baycyqkxx.setCydwlx("1");
//                                baycyqkxx.setRzrq(DateUtil.convertDateToString(companyPerson.getCreateTime(),DateUtil.FORMAT11));
//                                baycyqkxx.setCydwmc(companyPerson.getCompany().getName());
//                                baycyqkxx.setCydwbh(companyPerson.getCompany().getCompanyCode());
//                                //调用send方法完成对接
//                                clientUtil.send(Constants.XXBA_BAYCYQKXX,baycyqkxx);
//                            }
//                        }).start();
//                    }
            }*/
        //}
    }

    /***
     * 旧数据资格证关联人员信息表
     * @param securityPerson 人员信息
     */
    private void oldSecurityCertificate(SecurityPerson securityPerson){
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            /****
             * 1.根据身份证号获取是否有资格证
             * 2.如果有资格证信息，则更新人员信息
             * 3.更新资格证信息的人员ID，便于后面关联
             */
            SecurityCertificate securityCertificate = securityCertificateDao.findByIdnum(securityPerson.getIdNumber());
            if (securityCertificate != null && Constants.PRINT_TYPE_OLD_YES.equals(securityCertificate.getIsOldData()) && Constants.IDENTITYAUTHSTATE_Y.equals(securityPerson.getIdentityAuthState())) {
                //旧数据
                if(securityCertificate.getSnapshotId() == null) {
                    String photo = securityCertificateService.getPhotoUrl(securityCertificate);
                    securityCertificateService.savePerCerSnapshot(securityCertificate, photo);
                    securityCertificate.setUpdateTime(new Date());
                    securityCertificate.setUpdateflag(true);
                    securityCertificateDao.update(securityCertificate);
                }
                securityCertificateService.updateSecurityPersonCertificateInfo(securityCertificate);
            }
        }
    }
    /**
     * 创建WebService数据实体类
     *
     * @param person
     */
    private void buildWebServiceEntity(SecurityPerson person) {
        logger.info("上报部级数据【保安员信息】……");
        //System.out.println("person==" + person.toString());
        Bayxxb bayxxb = new Bayxxb();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("sfzh", new KeyAndDefauleVal("idNumber", null));
        map.put("xm", new KeyAndDefauleVal("realname", person.getRealName()));
        //性别
        String gender = IdNumUtil.getSexByIdCard(person.getIdNumber());
        map.put("xb", new KeyAndDefauleVal("gender", gender.equals("男") ? "1" : "2"));
        map.put("csrq", new KeyAndDefauleVal("idNumber", IdNumUtil.getBirthByIdCard(person.getIdNumber())));
        Nation nation = nationService.findByName(person.getNation());
        if (nation != null) {
            map.put("mz", new KeyAndDefauleVal("nation", nation.getCode()));
        } else {
            map.put("mz", new KeyAndDefauleVal("nation", "01"));
        }
        map.put("whcd", new KeyAndDefauleVal("edu", person.getEdu() != null ? person.getEdu().toString() : ""));
        map.put("zzmm", new KeyAndDefauleVal("politics", null));
        map.put("hj", new KeyAndDefauleVal("natives", person.getNatives() != null ? person.getNatives().toString() : ""));
        map.put("xxdz", new KeyAndDefauleVal("idCardAddress", null));
        map.put("hyzk", new KeyAndDefauleVal("marriage", "90"));
        map.put("byzk", new KeyAndDefauleVal("enrolled", person.getEnrolled() != null ? "1" : "0"));
        map.put("sg", new KeyAndDefauleVal("stature", person.getStature() != null ? person.getStature().toString() : ""));
        map.put("fzjgbm", new KeyAndDefauleVal("certificatejgno", null));
        map.put("fzjgmc", new KeyAndDefauleVal("certificatejgname", null));
        map.put("fzrq", new KeyAndDefauleVal("certificatejgtime", null));
        map.put("zwxx", new KeyAndDefauleVal("fingerprintsno", null));
        map.put("zpxx", new KeyAndDefauleVal("photo", null));
        map.put("pxdwbm", new KeyAndDefauleVal("traincompanyno", null));
        map.put("baydj", new KeyAndDefauleVal("starLevel", person.getStarLevel() != null ? person.getStarLevel().toString() : ""));
        map.put("sflz", new KeyAndDefauleVal("guardStatus", person.getGuardStatus() != null ? person.getGuardStatus().toString() : ""));

        //无
        map.put("bayzbm", new KeyAndDefauleVal("realname", ""));
        map.put("dxjdjgbm", new KeyAndDefauleVal("realname", ""));
        map.put("dxjdjg", new KeyAndDefauleVal("realname", ""));
        map.put("lrjgbm", new KeyAndDefauleVal("realname", ""));
        map.put("lrjgmc", new KeyAndDefauleVal("realname", ""));
        map.put("lrd", new KeyAndDefauleVal("realname", ""));
        map.put("bz1", new KeyAndDefauleVal("realname", ""));
        map.put("bz2", new KeyAndDefauleVal("realname", ""));
        map.put("bz3", new KeyAndDefauleVal("realname", ""));
        map.put("sfybaz", new KeyAndDefauleVal("realname", ""));

        try {
            EntityForWebServiceUtil.copy(map, person, bayxxb);
            clientUtil.send(Constants.XXBA_BAYXXB, bayxxb);
            logger.info("上报成功……");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public Long findUnPolicyByCompanyId(Long companyId) {
        return personDao.findUnPolicyByCompanyId(companyId);
    }

    @Override
    public List<SecurityPerson> searchForTrain(PersonSearchDto dto) {
        User currentUser = arsUtil.getCurrentUser();
        if (currentUser == null || currentUser.getPlatform().intValue() == 1) {
            return null;
        }

        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = companyService.findByUserid(currentUser.getId());
        }
        if (company == null) {
            throw new ArsException("公司信息错误");
        }
        dto.setCompanyId(company.getId());
        return personDao.searchForTrain(dto);
    }

    @Override
    public List<SecurityPerson> findPersonByCompanyIdAndStatus(Long companyId, String work_status) {
        //获取人员信息
        if ("1".equals(work_status)) {
            //在职--获取未投保人员信息
            return personDao.findForUnPolicy(companyId);
        } else {
            //离职--获取离职人员已投保的人员信息
            return personDao.findPolicyForLeave(companyId);
        }
    }

    @Override
    public AjaxResult checkPersonStatus(String checkValue) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        //取得当前用户跟当前公司
        User currentUser = arsUtil.getCurrentUser();
        //获取单位信息
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = companyDao.findByUserid(currentUser.getId());
        }
        SecurityPerson checkPerson = personDao.findActiveByIdCard(checkValue);
        if (checkPerson == null) {
            checkPerson = personDao.findActiveByPhone(checkValue);
        }
        if (checkPerson != null) {
            if (checkPerson.getIncumbencyStatus().equals(Constants.INCUMBENCYSTATUS_Y) && checkPerson.getRelation() != null && checkPerson.getRelation().getActive()) {
                if (checkPerson.getRelation().getCompany().getId().longValue() == company.getId().longValue()) {
                    result.setCode("200");
                    result.setMsg("该人员已在贵公司就职，不需要再添加哦");
                    result.setSuccessful(false);
                } else {
                    result.setCode("200");
                    result.setMsg("当前人员目前在职，不允许添加！请联系该人员退出在职公司之后再添加！");
                    result.setSuccessful(false);
                }
            } else {
                if (null != checkPerson.getRelation() && checkPerson.getRelation().getCompany().getId().longValue() != company.getId().longValue()) {
                    checkPerson = personDao.findByIdCardAndCompanyId(checkValue, company.getId());
                    if (checkPerson == null) {
                        checkPerson = personDao.findByPhoneAndCompanyId(checkValue, company.getId());
                    }
                    if (checkPerson == null) {
                        checkPerson = personDao.findByIdCard(checkValue);
                        if (checkPerson == null) {
                            checkPerson = personDao.findByPhone(checkValue);
                        }
                        if (checkPerson != null) {
                            checkPerson.setId(null);
                        }
                    }
                }
                result.setCode("100");
                result.setMsg("当前人员在系统中已有账号，不需要再新增，是否把该人员加入贵公司？");
                result.setSuccessful(true);
                result.setData(checkPerson);
            }
        } else {
            checkPerson = personDao.findByIdCardAndCompanyId(checkValue, company.getId());
            if (checkPerson == null) {
                checkPerson = personDao.findByPhoneAndCompanyId(checkValue, company.getId());
            }
            if (checkPerson == null) {
                checkPerson = personDao.findByIdCard(checkValue);
                if (checkPerson == null) {
                    checkPerson = personDao.findByPhone(checkValue);
                }
                if (checkPerson != null) {
                    checkPerson.setId(null);
                }
            }
            if (checkPerson != null) {
                result.setCode("100");
                result.setMsg("当前人员在系统中已有账号，不需要再新增，是否把该人员加入贵公司？");
                result.setSuccessful(true);
                result.setData(checkPerson);
            }
        }

        return result;
    }

    @Override
    public SecurityPerson findByIdCard(String idNumber) {
        return personDao.findByIdCard(idNumber);
    }

    @Override
    public List<SecurityPersonAppDto> findAppByCompanyId(Long companyId) {
        return personDao.findAppByCompanyId(companyId);
    }

    @Override
    public PersonReportData dataStatisticsReport(ReportDataSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());

        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {//区
                searchDto.setAreaCode(areacode);
            }
        }

        DecimalFormat df = new DecimalFormat("#0.00");
        ReportDataSearchDto searchLastWeekDto = new ReportDataSearchDto();
        ReportDataSearchDto searchThisWeekDto = new ReportDataSearchDto();
        ReportDataSearchDto searchLastMonthDto = new ReportDataSearchDto();
        ReportDataSearchDto searchthisMonthDto = new ReportDataSearchDto();
        ReportDataSearchDto searchLastDto = new ReportDataSearchDto();
        searchLastDto.setAreaCode(searchDto.getAreaCode());

        searchLastDto.setPath(currentUser.getPolice().getPath());
        searchLastDto.setUserid(currentUser.getId());

        searchLastWeekDto.setAreaCode(searchDto.getAreaCode());
        searchLastWeekDto.setPath(currentUser.getPolice().getPath());
        searchLastWeekDto.setUserid(currentUser.getId());
        searchLastWeekDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTWEEK);

        searchThisWeekDto.setAreaCode(searchDto.getAreaCode());
        searchThisWeekDto.setPath(currentUser.getPolice().getPath());
        searchThisWeekDto.setUserid(currentUser.getId());
        searchThisWeekDto.setType(Constants.DATASTATISTICS_DATETYPE_THISWEEK);

        searchLastMonthDto.setAreaCode(searchDto.getAreaCode());
        searchLastMonthDto.setPath(currentUser.getPolice().getPath());
        searchLastMonthDto.setUserid(currentUser.getId());
        searchLastMonthDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTMONTH);

        searchthisMonthDto.setAreaCode(searchDto.getAreaCode());

        searchthisMonthDto.setPath(currentUser.getPolice().getPath());
        searchthisMonthDto.setUserid(currentUser.getId());
        searchthisMonthDto.setType(Constants.DATASTATISTICS_DATETYPE_THISMONTH);


        if (StringUtil.isNotEmpty(searchDto.getType())) {
            if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISDAY)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTDAY);
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISWEEK)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTWEEK);
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISMONTH)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTMONTH);
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISYEAR)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTYEAR);
            }
        }
        Long lastTotal = null;
        Long lastAuthCount = null;
        if (StringUtil.isNotEmpty(searchDto.getType()) && !searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_DIY)) {
            lastTotal = personDao.dataStatisticsAddReport(searchLastDto);
            lastAuthCount = personDao.dataStatisticsAuthReport(searchLastDto);
        }
        PersonReportData data = new PersonReportData();
        Long total = personDao.dataStatisticsAddReport(searchDto);
        Long authCount = personDao.dataStatisticsAuthReport(searchDto);
        data.setTotal(total);
        data.setAuthCount(authCount);
        if (lastTotal != null && lastAuthCount != null) {
            if (lastTotal > 0) {
                data.setTotalRate(df.format((total - lastTotal) * 100.0 / lastTotal));
            } else if (total < 1) {
                data.setTotalRate("0");
            } else {
                data.setTotalRate("100");
            }

            if (lastAuthCount > 0) {
                data.setAuthRate(df.format((authCount - lastAuthCount) * 100.0 / lastAuthCount));
            } else if (authCount < 1) {
                data.setAuthRate("0");
            } else {
                data.setAuthRate("100");
            }
        }
        if (StringUtil.isEmpty(searchDto.getType())) {
            Long thisWeekTotal = personDao.dataStatisticsAddReport(searchThisWeekDto);
            Long lastWeekTotal = personDao.dataStatisticsAddReport(searchLastWeekDto);
            Long thisMonthTotal = personDao.dataStatisticsAddReport(searchthisMonthDto);
            Long lastMonthTotal = personDao.dataStatisticsAddReport(searchLastMonthDto);
            if (thisWeekTotal == null) {
                thisWeekTotal = 0l;
            }
            if (lastWeekTotal == null) {
                lastWeekTotal = 0l;
            }
            if (thisMonthTotal == null) {
                thisMonthTotal = 0l;
            }
            if (lastMonthTotal == null) {
                lastMonthTotal = 0l;
            }

            data.setThisWeekTotal(thisWeekTotal);
            data.setThisMonthTotal(thisMonthTotal);

            if (lastWeekTotal > 0) {
                data.setThisWeekRate(df.format((thisWeekTotal - lastWeekTotal) * 100.0 / lastWeekTotal));
            } else if (thisWeekTotal < 1) {
                data.setThisWeekRate("0");
            } else {
                data.setThisWeekRate("100");
            }

            if (thisMonthTotal > 0) {
                data.setThisMonthRate(df.format((thisMonthTotal - lastMonthTotal) * 100.0 / lastMonthTotal));
            } else if (thisWeekTotal < 1) {
                data.setThisMonthRate("0");
            } else {
                data.setThisMonthRate("100");
            }
        }

        return data;
    }

    @Override
    public Long[] findUnPolicyPersonIdByCompanyId(Long companyId) {
        return personDao.findUnPolicyPersonIdByCompanyId(companyId);
    }

    @Override
    public SecurityPerson findActiveByIdCard(String idNum) {
        return personDao.findActiveByIdCard(idNum);
    }


    @Override
    public SecurityPerson find(SecurityPerson person) {
        return personDao.find(person);
    }

    @Override
    public void sendNewUserMessage(SecurityPerson person) {
        User currentUser = arsUtil.getCurrentUser();
        //获取单位信息
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = companyDao.findByUserid(currentUser.getId());
        }
        MessageUtil.sendMessage(person.getPhone(), Constants.NEW_USER_MESSAGE.replaceAll("%COMPANYNAME%", company.getName()), messageLogDao);
    }

    /**
     * author wjb
     *
     * @param listSecurityPerson 批量更新相关保险信息
     * @time 2018年8月9日14:14:16
     */
    @Override
    public void updateBXBatch(List<SecurityPerson> listSecurityPerson) {
        personDaoAop.updateBXBatch(listSecurityPerson);
    }

    /**
     * 查询全部未做背景筛查的保安人员
     *
     * @return
     */
    @Override
    public List<SecurityPerson> findUnCensor() {
        return personDao.findUnCensor();
    }

    /**
     * 查询重新背景筛查的保安人员
     *
     * @return
     */
    @Override
    public List<SecurityPerson> findReCensor(int backGroupFrequency) {
        return personDao.findReCensor(backGroupFrequency);
    }

    /**
     * 查询背景筛查不通过人员，重新背景筛查
     *
     * @return
     */
    @Override
    public List<SecurityPerson> findNoPassCensorStatus() {
        return personDao.findNoPassCensorStatus();
    }
    /**
     * 查询全部未做背景筛查的保安人员
     * @return
     */
    @Override
    public List<SecurityPerson> findUnCensorForTest() {
        return personDao.findUnCensorForTest();
    }

    @Override
    public SecurityPerson findActiveByPhone(String phone) {
        return personDao.findActiveByPhone(phone);
    }

    @Override
    public AjaxResult batchAdjDeptForSaas(List<String> perIds, Long deptId) {
        AjaxResult result = new AjaxResult();
        String persons = "";
        User currentUser = arsUtil.getCurrentUser();
        Date date = new Date();
        //获取单位信息
        //取得当前用户跟当前公司
        SecurityCompany company = companyDao.findByUserid(currentUser.getId());

        if(deptId != null && deptId> 0){

        }else{
            //获取公司“无部门人员”部门信息，对应SaaS人员挂在企业下
            Organization dborg = orgDao.findByCompanyWithSaasSpecial(company.getId());
            //如果没有"无部门人员"部门信息，则创建一个
            if (null == dborg) {
                dborg = new Organization();
                dborg.setName("无部门人员");
                dborg.setCompany(company);
                //  org.setCompanyId(company.getId());
                dborg.setActive(true);
                dborg.setCreateTime(new Date());
                dborg.setUpdateTime(new Date());
                dborg.setUpdateBy(currentUser.getUsername());
                dborg.setNativeCode(currentUser.getNativeCode());
                dborg.setIsSaasSpecial(Constants.IS_SAAS_SPECIAL_YES);
                orgDao.save(dborg);
            }
            deptId = dborg.getId();
        }


        if (perIds.size() > 0 && null != deptId) {

            List<SecurityCompanyPersonDTO> relationList = new ArrayList<>();
            for (String perId : perIds) {
                persons += perId;
                SecurityPersonDTO person = new SecurityPersonDTO();
                person.setId(Long.parseLong(perId));

                SecurityCompanyPerson relation = companyPersonService.findByPersonAndCompany(person.getId(), company.getId());
                if (relation != null) {
                    SecurityCompanyPersonDTO securityCompanyPersonDTO = new SecurityCompanyPersonDTO();
                    BeanUtils.copyPropertiesIgnore(relation, securityCompanyPersonDTO, true);
                    securityCompanyPersonDTO.setCompanyId(company.getId());
                    securityCompanyPersonDTO.setOrgId(deptId);
                    securityCompanyPersonDTO.setPersonId(person.getId());
                    securityCompanyPersonDTO.setUpdateBy(currentUser.getRealname());
                    securityCompanyPersonDTO.setUpdateTime(date);
                    relationList.add(securityCompanyPersonDTO);
                } else {
                    SecurityCompanyPersonDTO newRelation = new SecurityCompanyPersonDTO();
                    newRelation.setCompanyId(company.getId());
                    newRelation.setPersonId(person.getId());
                    newRelation.setNativeCode(currentUser.getNativeCode());
                    newRelation.setActive(true);
                    newRelation.setOrgId(deptId);
                    newRelation.setCreateTime(date);
                    newRelation.setUpdateTime(date);
                    newRelation.setUpdateBy(currentUser.getUsername());
                    relationList.add(newRelation);
                }
            }
            if (relationList.size() > 0) {
                securityCompanyPersonDao.updateBatch(relationList);
                result.setMsg("更新成功");
                result.setData("更新个数：" + relationList.size() + "，更新人员Id：" + persons + "，更新部门Id：" + deptId);
                result.setSuccessful(true);
            } else {
                result.setMsg("没有更新内容");
                result.setData(perIds);
                result.setSuccessful(false);
            }
        }
        return result;
    }

    @Override
    public AjaxResult batchSaveOrUpdateForSaas(List<SecurityPersonDTO> personDTOList) {
        AjaxResult result = new AjaxResult();
        if (personDTOList.size() > 0) {
            List<String> idNnums = new ArrayList<>();
            User currentUser = arsUtil.getCurrentUser();
            Date date = new Date();
            //获取单位信息
            //取得当前用户跟当前公司
            SecurityCompany company = companyDao.findByUserid(currentUser.getId());

            //数据库的PersonList
            List<SecurityPerson> dbExistPersonList = personDao.findByBatchId(personDTOList);

            Map<Long, SecurityPerson> dbExistPersonMap = new HashMap<>();

            if(dbExistPersonList.size() > 0){
                dbExistPersonMap = dbExistPersonList.stream().collect(Collectors.toMap(SecurityPerson::getId,Function.identity()));
            }

            //不存在的personlist
            List<SecurityPersonDTO> dbNoExistPersonList = new ArrayList<>();
            //最终保存的personlist
            List<SecurityPerson> dbExistList = new ArrayList<>();
            List<SecurityCompanyPersonDTO> relationList = new ArrayList<>();
            for (SecurityPersonDTO securityPerson : personDTOList) {
                securityPerson.setRealName(securityPerson.getRealname());
                //身份证号不为空，籍贯取身份证前6位
                if(StringUtil.isNotEmpty(securityPerson.getIdNumber())) {
                    securityPerson.setNatives(Integer.parseInt(securityPerson.getIdNumber().substring(0, 6)));
                    //#5405 人员信息同步后，年龄为空。应该可以通过身份证计算得出
                    securityPerson.setAge(IdNumUtil.getAgeByIdCard(securityPerson.getIdNumber()));
                    //性别通过身份证得出
                    securityPerson.setGender(IdNumUtil.getGenderByIdCard(securityPerson.getIdNumber()));
                }
                if (securityPerson.getId() == null) {
                    throw new ArsException("保安人员信息错误，缺失id!");
                }
                //如果没有头像则不更新头像
                if (StringUtil.isNotEmpty(securityPerson.getPhoto())) {
                    //将SaaS地址转换成百保盾地址信息
                    securityPerson.setPhoto(getPhotoPath(securityPerson.getPhoto())) ;
                }
                SecurityPerson dbPerson = dbExistPersonMap.get(securityPerson.getId());
                if (dbPerson == null) {
                    idNnums.add(securityPerson.getIdNumber());
                    dbNoExistPersonList.add(securityPerson);
                }else {
                    //复制不为空的值
                    BeanUtils.copyPropertiesIgnore(securityPerson, dbPerson, true);

                    dbPerson.setUpdateBy(currentUser.getUsername());
                    dbPerson.setUpdateTime(date);
                    dbPerson.setActive(true);
                    dbPerson.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);
                    dbPerson.setLeaveDate(null);

                    dbPerson.setAreacode(company.getAreaCode());

                    if(StringUtil.isNotEmpty(securityPerson.getIdNumber()) && !securityPerson.getIdNumber().equals(dbPerson.getIdNumber())){
                        dbPerson.setZgcertificatejgname(null);
                        dbPerson.setZgcertificatejgno(null);
                        dbPerson.setZgcertificatejgtime(null);
                        dbPerson.setZgcredential(null);
                        dbPerson.setProfessionLevel(null);
                        dbPerson.setCredential(null);
                        dbPerson.setZgcertificatejgtime(null);
                        dbPerson.setTraincompanyname(null);

                        if(StringUtil.isNotEmpty(dbPerson.getIdNumber())) {
                            idNnums.add(dbPerson.getIdNumber());
                        }
                        idNnums.add(securityPerson.getIdNumber());
                    }
                    dbExistList.add(dbPerson);

                }

                SecurityCompanyPerson relation = companyPersonService.findSingleByPerson(securityPerson);


                //人员关系表保存
                logger.info("update relationship...");

                boolean editRelation = true;

                //判断人员与公司关系表是否存在，不存在则创建一条
                if (relation == null) {
                    //定义一个人员与公司关系信息
                    relation = new SecurityCompanyPerson();
                    //公司信息
                    relation.setCompany(company);
                    //人员信息
                    relation.setPerson(securityPerson);
                    relation.setCreateTime(date);
                }else{
                    if (securityPerson.getDeptId() != null && securityPerson.getDeptId().longValue() == relation.getOrg().getId().longValue()){
                        editRelation = false;
                    }else if(Constants.IS_SAAS_SPECIAL_YES.equals(relation.getOrg().getIsSaasSpecial())){
                        editRelation = false;
                    }
                }
                //入职时间 edit 2020-04-02 06:55
                if(securityPerson.getEntrydate() != null) {
                    relation.setEntryDate(securityPerson.getEntrydate());
                }

                if(editRelation) {
                    //定义部门信息对象
                    Organization org = new Organization();
                    //判断有传部门ID参数，如果没有传则人员挂在企业下
                    if (securityPerson.getDeptId() != null) {
                        //部门ID
                        org.setId(securityPerson.getDeptId());
                        relation.setOrg(org);
                    } else {
                        //获取公司“无部门人员”部门信息，对应SaaS人员挂在企业下
                        Organization dborg = orgDao.findByCompanyWithSaasSpecial(company.getId());
                        //如果没有"无部门人员"部门信息，则创建一个
                        if (null == dborg) {
                            org.setName("无部门人员");
                            org.setCompany(company);
                            //  org.setCompanyId(company.getId());
                            org.setActive(true);
                            org.setCreateTime(new Date());
                            org.setUpdateTime(new Date());
                            org.setUpdateBy(currentUser.getUsername());
                            org.setNativeCode(currentUser.getNativeCode());
                            org.setIsSaasSpecial(Constants.IS_SAAS_SPECIAL_YES);
                            orgDao.save(org);
                            relation.setOrg(org);
                        } else {
                            relation.setOrg(dborg);
                        }
                    }

                    SecurityCompanyPersonDTO relationDto = new SecurityCompanyPersonDTO();
                    BeanUtils.copyPropertiesIgnore(relation, relationDto, true);
                    relationDto.setCompanyId(company.getId());
                    relationDto.setOrgId(relation.getOrg().getId());
                    relationDto.setPersonId(securityPerson.getId());
                    //更新者
                    relationDto.setUpdateBy(currentUser.getRealname());
                    relationDto.setNativeCode(company.getNativeCode());
                    //更新时间
                    relationDto.setUpdateTime(date);
                    //有效标记
                    relationDto.setActive(true);

                    relationList.add(relationDto);
                }

            }


            //批量增加user
            //批量增加personList
            if (dbNoExistPersonList.size() > 0) {
                for (SecurityPersonDTO person : dbNoExistPersonList) {
                    //区域
                    person.setAreacode(company.getAreaCode());
                    person.setNativeCode(currentUser.getNativeCode());
                    //person.setNativeCode(arsUtil.getCurrentNatvie());
                    person.setUpdateBy(currentUser.getRealname());
                    person.setUpdateTime(date);
                    person.setCreateTime(new Date());
                    person.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);//默认在职
                    person.setQualified(true);//默认合格#1315
                    person.setGuardStatus(3);//默认离线#1315
                    //拿userid
                    person.setActive(true);
                    if (person.getExp() == null) {
                        person.setExp(0);//#2466
                    }
                    if (person.getInsured() == null) {
                        person.setInsured(Constants.INSURED_NO);//#2466
                    }
                    if (person.getEdu() == null) {
                        person.setEdu(4);//#2466
                    }

                    dbExistList.add(person);
                }
            }

            personDaoAop.updateBatch(dbExistList);
            if (relationList.size() > 0) {
                securityCompanyPersonDao.updateBatch(relationList);
            }

            if(idNnums != null && idNnums.size() > 0) {
                ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                threadPoolManager.addExecuteTask(new Runnable() {
                    @Override
                    public void run() {
                        securityCertificateDao.updatePushState(idNnums, false);
                        gradeCertificateDao.updatePushState(idNnums, false);
                    }
                });
            }

            //更新公司人员数量
           /*
              String companyId = company.getComId();
             new Thread(()->{
                securityCompanyDao.updatePersonNumber(companyId);
            }).start();*/
        }
        return result;
    }

    @Override
    public void changePersonPhone(SecurityPersonDTO person) {
        SecurityPerson dbPerson = personDao.findById(person.getId());
        if (dbPerson != null) {
            dbPerson.setPhone(person.getPhone());
            personDaoAop.updateSelective(dbPerson);
        } else {
            throw new ArsException("保安人员信息错误，找不到该人员!");
        }

    }

    @Override
    public void saveOrUpdateForSaas(SecurityPersonDTO person,SecurityCompany company) {
        logger.info("===========> person/update.json.saveOrUpdateForSaas:star");
        System.out.println("===========> person/update.json.saveOrUpdateForSaas:star");
        //身份证号不为空，籍贯取身份证前6位
        List<String> idNnums = new ArrayList<>();
        if(StringUtil.isNotEmpty(person.getIdNumber())) {
            System.out.println("===========> person/update.json.saveOrUpdateForSaas:1");
            person.setIdNumber(person.getIdNumber().toUpperCase().trim());

            person.setNatives(Integer.parseInt(person.getIdNumber().substring(0, 6)));
            //#5405 人员信息同步后，年龄为空。应该可以通过身份证计算得出
            person.setAge(IdNumUtil.getAgeByIdCard(person.getIdNumber()));
            //性别通过身份证得出
            person.setGender(IdNumUtil.getGenderByIdCard(person.getIdNumber()));
        }
        //判断前端是否有传参数人员ID，没有则抛出异常
        if (person.getId() == null) {
            System.out.println("===========> person/update.json.saveOrUpdateForSaas:2");
            throw new ArsException("保安人员信息错误，缺失id!");
        } else {
            System.out.println("===========> person/update.json.saveOrUpdateForSaas:3");
            Date date = new Date();
            //取得当前用户跟当前公司
            User currentUser = arsUtil.getCurrentUser();
            if(company == null) {
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:4");
                //获取单位信息
                //1、判断用户类型，如果是公司，直接用用户ID查询公司信息
                if (Constants.PLATFORM_COMPANY == currentUser.getPlatform()) {
                    company = companyDao.findByUserid(currentUser.getId());
                }
            }else{
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:5");
                currentUser = company.getUser();
            }

            //如果没有头像则不更新头像
            if (StringUtil.isNotEmpty(person.getPhoto())) {
                //将SaaS地址转换成百保盾地址信息
                person.setPhoto(getPhotoPath(person.getPhoto())) ;
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:6");
            }
            System.out.println("===========> person/update.json.saveOrUpdateForSaas:7");

            if (StringUtil.isNotEmpty(person.getIdPhoto())) {
                //将SaaS地址转换成百保盾地址信息
                person.setIdPhoto(getPhotoPath(person.getIdPhoto()));
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:8");
            }

            System.out.println("===========> person/update.json.saveOrUpdateForSaas:9");
            //获取人员信息
            SecurityPerson dbPerson = personDao.findById(person.getId());

            System.out.println("===========> person/update.json.saveOrUpdateForSaas:dbPerson:"+ JSON.toJSONString(dbPerson));
            //定义人员与公司关系，如果人员存在获取人员信息，不存在则新建
            SecurityCompanyPerson relation =null;
            if (dbPerson != null) {
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:10");
                dbPerson.setUpdateBy(currentUser.getUsername());
                dbPerson.setUpdateTime(date);
                dbPerson.setActive(true);
                //在职标记
                dbPerson.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);



                //关联资格证书、等级证信息
                if(StringUtil.isNotEmpty(person.getIdNumber()) && !person.getIdNumber().equals(dbPerson.getIdNumber())){
                    System.out.println("===========> person/update.json.saveOrUpdateForSaas:11");
                    dbPerson.setZgcertificatejgname(null);
                    dbPerson.setZgcertificatejgno(null);
                    dbPerson.setZgcertificatejgtime(null);
                    dbPerson.setZgcredential(null);
                    dbPerson.setProfessionLevel(null);
                    dbPerson.setCredential(null);
                    dbPerson.setZgcertificatejgtime(null);
                    dbPerson.setTraincompanyname(null);
                    if(StringUtil.isNotEmpty(dbPerson.getIdNumber())){
                        idNnums.add(dbPerson.getIdNumber());
                    }
                    idNnums.add(person.getIdNumber());
                }

                System.out.println("===========> person/update.json.saveOrUpdateForSaas:12");

                //复制不为空的值
                BeanUtils.copyPropertiesIgnore(person, dbPerson, true);
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:13");
                //根据人员ID 获取人员与公司的关系表
                //relation =  companyPersonService.findByPersonAndCompany(dbPerson.getId(), company.getId());
                relation =  companyPersonService.findSingleByPerson(dbPerson);
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:relation："+JSON.toJSONString(relation));
                //区域
                dbPerson.setAreacode(company.getAreaCode());
                dbPerson.setLeaveDate(null);
                personDaoAop.update(dbPerson);
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:14");
            } else {
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:15");
                //区域
                person.setCreateTime(new Date());
                person.setAreacode(company.getAreaCode());
                person.setNativeCode(currentUser.getNativeCode());
                //person.setNativeCode(arsUtil.getCurrentNatvie());
                person.setUpdateBy(currentUser.getRealname());
                person.setUpdateTime(date);
                person.setCreateTime(person.getCreateTime());
                person.setIncumbencyStatus(Constants.INCUMBENCYSTATUS_Y);//默认在职
                person.setQualified(true);//默认合格#1315
                person.setGuardStatus(3);//默认离线#1315
                person.setActive(true);
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:16");
                //如果为空设置默认值
                if (person.getExp() == null) {
                    person.setExp(0);//#2466
                }
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:17");
                //如果为空设置默认值
                if (person.getInsured() == null) {
                    person.setInsured(Constants.INSURED_NO);//#2466
                }
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:18");
                //如果为空设置默认值
                if (person.getEdu() == null) {
                    person.setEdu(4);//#2466
                }
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:19");
                personDao.save(person);
                dbPerson = person;
                idNnums.add(person.getIdNumber());
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:20");
            }
            //人员关系表保存
            logger.info("update relationship...");

            boolean editRelation = true;

            System.out.println("===========> person/update.json.saveOrUpdateForSaas:21");
            //判断人员与公司关系表是否存在，不存在则创建一条
            if (relation == null) {
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:22");
                //定义一个人员与公司关系信息
                relation = new SecurityCompanyPerson();
                relation.setCreateTime(new Date());
                //公司信息
                relation.setCompany(company);
                //人员信息
                relation.setPerson(person);
            }else{
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:23");
                if (person.getDeptId() != null && person.getDeptId().longValue() == relation.getOrg().getId().longValue()){
                    editRelation = false;
                }else if(Constants.IS_SAAS_SPECIAL_YES.equals(relation.getOrg().getIsSaasSpecial())){
                    editRelation = false;
                }
            }
            //入职时间 edit 2020-04-02 06:55
            if(person.getEntrydate() != null) {
                relation.setEntryDate(person.getEntrydate());
            }
            System.out.println("===========> person/update.json.saveOrUpdateForSaas:24");

            if(editRelation) {
                //定义部门信息对象
                Organization org = new Organization();
                //判断有传部门ID参数，如果没有传则人员挂在企业下
                if (person.getDeptId() != null) {
                    //部门ID
                    org.setId(person.getDeptId());
                    relation.setOrg(org);
                    System.out.println("===========> person/update.json.saveOrUpdateForSaas:25");
                } else {

                    System.out.println("===========> person/update.json.saveOrUpdateForSaas:26");
                    //获取公司“无部门人员”部门信息，对应SaaS人员挂在企业下
                    Organization dborg = orgDao.findByCompanyWithSaasSpecial(company.getId());
                    //如果没有"无部门人员"部门信息，则创建一个
                    if (null == dborg) {
                        System.out.println("===========> person/update.json.saveOrUpdateForSaas:27");
                        org.setName("无部门人员");
                        org.setCompany(company);
                        //  org.setCompanyId(company.getId());
                        org.setActive(true);
                        org.setCreateTime(new Date());
                        org.setUpdateTime(new Date());
                        org.setUpdateBy(currentUser.getUsername());
                        org.setNativeCode(currentUser.getNativeCode());
                        org.setIsSaasSpecial(Constants.IS_SAAS_SPECIAL_YES);
                        orgDao.save(org);
                        relation.setOrg(org);
                    } else {
                        relation.setOrg(dborg);
                        System.out.println("===========> person/update.json.saveOrUpdateForSaas:28");
                    }
                }
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:29");
                //更新者
                relation.setUpdateBy(currentUser.getRealname());
                relation.setNativeCode(company.getNativeCode());
                //更新时间
                relation.setUpdateTime(date);
                //有效标记
                relation.setActive(true);
                //判断人员与公司的关系表是否存在，不存在则保存，存在则更新

                System.out.println("===========> person/update.json.saveOrUpdateForSaas:30");
                //companyPersonService.deleteByPersonId(person.getId());
                if (relation.getId() == null) {
                    //保存方法
                    companyPersonService.save(relation);
                    System.out.println("===========> person/update.json.saveOrUpdateForSaas:31");
                } else {
                    //更新方法
                    companyPersonService.update(relation);
                    System.out.println("===========> person/update.json.saveOrUpdateForSaas:32");
                }


                if(idNnums != null && idNnums.size() > 0) {
                    System.out.println("===========> person/update.json.saveOrUpdateForSaas:33");
                    ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                    threadPoolManager.addExecuteTask(new Runnable() {
                        @Override
                        public void run() {
                            securityCertificateDao.updatePushState(idNnums, false);
                            gradeCertificateDao.updatePushState(idNnums, false);
                        }
                    });
                }
                System.out.println("===========> person/update.json.saveOrUpdateForSaas:end...............");

                //更新公司人员数量
              /*
                String companyId = company.getComId();
                new Thread(()->{
                    securityCompanyDao.updatePersonNumber(companyId);
                }).start();*/
            }
        }
    }

    @Override
    public PageResult searchPersonList_table(Map<Object, Object> p) {
        User user = arsUtil.getCurrentUser();
        if (user.getPlatform().intValue() == 1) {
            p.put("nativeCode", user.getNativeCode());
            p.put("path", user.getPolice().getPath());
            p.put("userId", user.getId());
        }
        if (p.get("areaCode") != null) {
            if (p.get("areaCode").toString().endsWith("0000")) {//省
                p.put("areaCode", p.get("areaCode").toString().substring(0, 2) + "____");
            } else if (p.get("areaCode").toString().endsWith("00")) {//市
                p.put("areaCode", p.get("areaCode").toString().substring(0, 4) + "__");
            } else {//区
                p.put("areaCode", p.get("areaCode").toString());
            }
        }


        //保存搜索记录
        if (null != p.get("keyword") && StringUtil.isNotEmpty(p.get("keyword").toString())) {
            searchHistoryService.saveOrUpdate(p.get("keyword").toString(), Constants.SEARCHTYPE_PERSON, user);
        }

        if (user.getPlatform().intValue() == 2) {
            SecurityCompany company = companyService.findByUserid(user.getId());
            p.put("companyId", company.getId());
        }
        return new PageResult(personDao.queryAllCntPersonListtable(p), personDao.queryPersonListtable(p));
    }
    @Override
    public void refreshPersonCensorStatus() {
        personDao.refreshPersonCensorStatus();
    }
    @Override
    public void refreshPersonCensorCriminalStatus() {
        personDao.refreshPersonCensorCriminalStatus();
    }
    @Override
    public Map<String,Object> countNewOldSystemPerson(PersonPageSearchDto dto) {
        Map<String,Object>  result = new HashMap<>();
        //旧数据在职人数
        Long oldCount = personDao.searchForPageForOldCount(dto);
        //设置数据权限
        arsUtil.setPoliceSearch(dto);
        //新数据在职人数
        Long newCount = personDao.searchForPageForNewCount(dto);
        result.put("oldCount",oldCount);
        result.put("newCount",newCount);
        //总人数
        result.put("countSum",newCount+oldCount);
        return result;
    }

    @Override
    public List<SecurityPerson> findByOrgId(Long orgId) {
        return  personDao.findByOrgId(orgId);
    }

    /**
     * 根据personId查询工作经历
     * @param id
     * @return
     */
    @Override
    public void selectExperienceById(Long id,Long relationId,AjaxPageResponse<PersonDto> page) {
        personDao.selectExperienceById(id,relationId,page);
    }

    @Override
    public void updateCensorStatusList(List<SecurityPerson> successPersonList) {
        personDaoAop.updateCensorStatusList(successPersonList);
    }

}
