package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SecurityGuardWorkDao;
import com.bcxin.ars.dto.SecurityGuardWorkSearchDto;
import com.bcxin.ars.model.SecurityGuardWork;
import com.bcxin.ars.service.SecurityGuardWorkService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class SecurityGuardWorkServiceImpl implements SecurityGuardWorkService {
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SecurityGuardWorkDao securityGuardWorkDao;
    @Override
    public List<SecurityGuardWork> search(SecurityGuardWorkSearchDto dto, AjaxPageResponse<SecurityGuardWorkSearchDto> page) {
        return securityGuardWorkDao.search(dto,page);
    }

    @Override
    public SecurityGuardWork findById(long id) {
        return securityGuardWorkDao.findById(id);
    }

    @Override
    public void save(SecurityGuardWork securityGuardWork) {
        //初始信息
        String realname = arsUtil.getCurrentUser().getRealname();
        securityGuardWork.setCreateTime(new Date());
        securityGuardWork.setUpdateTime(new Date());
        securityGuardWork.setActive(true);
        securityGuardWork.setUpdateBy(realname);
        securityGuardWorkDao.save(securityGuardWork);
    }

    @Override
    public void update(SecurityGuardWork securityGuardWork) {
        //初始信息
        String realname = arsUtil.getCurrentUser().getRealname();
        securityGuardWork.setUpdateTime(new Date());
        securityGuardWork.setActive(true);
        securityGuardWork.setUpdateBy(realname);

        securityGuardWorkDao.update(securityGuardWork);
    }

    @Override
    public void del(SecurityGuardWork securityGuardWork) {
        //初始信息
        String realname = arsUtil.getCurrentUser().getRealname();
        securityGuardWork.setUpdateTime(new Date());
        securityGuardWork.setActive(false);
        securityGuardWork.setUpdateBy(realname);
        securityGuardWorkDao.update(securityGuardWork);
    }
}
