package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityCompanyInsuranceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SecurityCompanyInsuranceSearchDto;
import com.bcxin.ars.model.SecurityCompanyInsurance;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityCompanyInsuranceService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityCompanyInsurance.class)
public class SecurityCompanyInsuranceServiceImpl implements SecurityCompanyInsuranceService {

	@Autowired
	private SecurityCompanyInsuranceDao securityCompanyInsuranceDao;

	@Autowired
	private SecurityCompanyDao companyDao;


	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 保存或更新
	 * @param securityCompanyInsurance
	 */
	@Override
	public void saveOrUpdate(SecurityCompanyInsurance securityCompanyInsurance) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		SecurityCompanyInsurance dbSecurityCompanyInsurance = securityCompanyInsuranceDao.findById(securityCompanyInsurance.getId());
		if(dbSecurityCompanyInsurance != null) {
			//设置修改时间
			dbSecurityCompanyInsurance.setUpdateTime(new Date());
			//设置修改者
			dbSecurityCompanyInsurance.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值
			if(!StringUtils.isEmpty(securityCompanyInsurance.getInsurance_company())) {
				dbSecurityCompanyInsurance.setInsurance_company(securityCompanyInsurance.getInsurance_company());
			}
			if(!StringUtils.isEmpty(securityCompanyInsurance.getInsurance_product())) {
				dbSecurityCompanyInsurance.setInsurance_product(securityCompanyInsurance.getInsurance_product());
			}
			if(!StringUtils.isEmpty(securityCompanyInsurance.getInsured_num())) {
				dbSecurityCompanyInsurance.setInsured_num(securityCompanyInsurance.getInsured_num());
			}
			if(!StringUtils.isEmpty(securityCompanyInsurance.getPremium_person())) {
				dbSecurityCompanyInsurance.setPremium_person(securityCompanyInsurance.getPremium_person());
			}
			if(!StringUtils.isEmpty(securityCompanyInsurance.getProtection_date())) {
				dbSecurityCompanyInsurance.setProtection_date(securityCompanyInsurance.getProtection_date());
			}

			securityCompanyInsuranceDao.update(dbSecurityCompanyInsurance);
		}else{
			//修改时间，创建时间在保存的时候一样
			securityCompanyInsurance.setCreateTime(new Date());
			securityCompanyInsurance.setUpdateTime(securityCompanyInsurance.getCreateTime());
			//默认可用
			securityCompanyInsurance.setActive(true);
			securityCompanyInsurance.setUpdateBy(user.getUsername());
			securityCompanyInsuranceDao.save(securityCompanyInsurance);
		}
		}

	/**
	 * 删除
	 * @param securityCompanyInsurance
	 */

	@Override
	public void delete(SecurityCompanyInsurance securityCompanyInsurance) {
		securityCompanyInsurance.setUpdateTime(new Date());
		securityCompanyInsuranceDao.delete(securityCompanyInsurance);
	}

	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public SecurityCompanyInsurance findById(long id){
		return securityCompanyInsuranceDao.findById(id);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SecurityCompanyInsuranceSearchDto search(SecurityCompanyInsuranceSearchDto dto) {
		SecurityCompanyInsuranceSearchDto resultDto = new SecurityCompanyInsuranceSearchDto();
		List<SecurityCompanyInsurance> list =  securityCompanyInsuranceDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(securityCompanyInsuranceDao.count(dto));
		return resultDto;
	}

	@Override
	public List<SecurityCompanyInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return securityCompanyInsuranceDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SecurityCompanyInsurance securityCompanyInsurance) {
		if(securityCompanyInsurance.getActive() == null){
			securityCompanyInsurance.setActive(true);
    	}
    	
		SecurityCompanyInsurance dbSecurityCompanyInsurance = securityCompanyInsuranceDao.findById(securityCompanyInsurance.getId());
        if (dbSecurityCompanyInsurance != null) {
        	if(securityCompanyInsurance.getUpdateTime().getTime() > dbSecurityCompanyInsurance.getUpdateTime().getTime()){
        		securityCompanyInsuranceDao.updateForDS(securityCompanyInsurance);
			}
        } else {
        	securityCompanyInsuranceDao.saveForDS(securityCompanyInsurance);
        }
	}

    @Override
    public List<SecurityCompanyInsurance> findByUserId(Long userId) {
        return securityCompanyInsuranceDao.findByCompanyId(userId);
    }
}


