package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.TrainOrderVo;
import com.bcxin.ars.dto.sb.OrderSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.OrderNoLogService;
import com.bcxin.ars.service.OrderService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ThirdPartyURL;
import com.bcxin.ars.util.message.messageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 订单服务类
 * @author Ethan
 */

@Service
@Transactional
@DataSyncAnnotation(getClazz = Order.class)
public class OrderServiceImpl implements OrderService{

	private Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
	
	@Autowired
	private OrderDao orderDao;
	
	@Autowired
	private OrderPersonDao orderPersonDao;
	
	@Autowired
	private SecurityCompanyDao companyDao;
	
	@Autowired
	private SecurityPersonDao personDao;
	
	@Autowired
	private UserDao userDao;
	
	@Autowired
	private OrderTransactionDao orderTransactionDao;
	
	@Autowired
	private OrderNoLogService orderNoLogService;

	@Autowired
	private ConfigService configService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void save(Order order) {
		orderDao.save(order);
	}

	@Override
	public void saveOrUpdate(Order order) {
		User user = arsUtil.getCurrentUser();
		
		if(order.getId() == null){
			order.setCreateTime(new Date());
			order.setUpdateBy(user.getUsername());
			order.setUpdateTime(new Date());
			orderDao.save(order);
		}else{
			Order dbOrder = orderDao.findById(order.getId());
			dbOrder.setAmount(order.getAmount());
			dbOrder.setRandomOrderNo(order.getRandomOrderNo());
			dbOrder.setRemarks(order.getRemarks());
			dbOrder.setSendaddress(order.getSendaddress());
			dbOrder.setSignatory(order.getSignatory());
			dbOrder.setTel(order.getTel());
			dbOrder.setUpdateTime(new Date());
			dbOrder.setUpdateBy(user.getUsername());
			orderDao.update(dbOrder);
		}
	}
	
	@Override
	public Order findById(Long id) {
		return orderDao.findById(id);
	}

	@Override
	public void createOrder(Order order, Long[] personIds) {
		User currentUser = arsUtil.getCurrentUser();
		SecurityCompany company = companyDao.findByUserid(currentUser.getId());

		Date date=new   Date();//取时间 
	    Calendar   calendar   =   new   GregorianCalendar(); 
	    calendar.setTime(date); 
	    if(order.getDateType().equals(Constants.DATETYPE_MONTH)){
	    	calendar.add(calendar.MONTH,1);//把日期往后增加一月.整数往后推,负数往前移动 
	    }else if(order.getDateType().equals(Constants.DATETYPE_SEASON)){
	    	calendar.add(calendar.MONTH,3);//把日期往后增加三个月.整数往后推,负数往前移动 
	    }else if(order.getDateType().equals(Constants.DATETYPE_HALFYEAR)){
	    	calendar.add(calendar.MONTH,6);//把日期往后增加六个月.整数往后推,负数往前移动 
	    }else{
	    	calendar.add(calendar.YEAR,1);//把日期往后增加一年.整数往后推,负数往前移动 
	    }
	     
		if(order.getId() != null){
			Order dbOrder = orderDao.findById(order.getId());
			if(dbOrder == null){
				throw new ArsException("订单异常，请重试");
			}

			dbOrder.setUpdateTime(new Date());
			dbOrder.setCountnumber(personIds.length);
			dbOrder.setEffectiveendtime(calendar.getTime());
			dbOrder.setEffectivestarttime(date);
			dbOrder.setAmount(Double.parseDouble(order.getUnitprice())*dbOrder.getCountnumber()+"");

			dbOrder.setSendaddress(order.getSendaddress());
			dbOrder.setSignatory(order.getSignatory());
			dbOrder.setTel(order.getTel());

			dbOrder.setRandomOrderNo(DateUtil.getCurrentDateTime(DateUtil.FORMAT8));
			orderDao.update(dbOrder);
			
			OrderPerson orderPerson = new OrderPerson();
			orderPerson.setOrderid(order.getId());
			orderPerson.setUpdateBy(currentUser.getUsername());
			orderPerson.setUpdateTime(new Date());
			orderPersonDao.removeByOrderId(orderPerson);
		}else{
			order.setOrdernumber(orderNoLogService.getNewOrderNo());
			order.setRandomOrderNo(DateUtil.getCurrentDateTime(DateUtil.FORMAT8));
			order.setCreateTime(new Date());
			order.setUpdateTime(new Date());
			order.setUserid(currentUser.getId());
			order.setUpdateBy(currentUser.getUsername());
			order.setActive(true);
			order.setCompanyname(company.getName());
			order.setCountnumber(personIds.length);
			 
			order.setEffectiveendtime(calendar.getTime());
			order.setEffectivestarttime(date);
			// order.setGoodsname(goodsname);
			// order.setInvoiceid(invoiceid);
			// order.setInvoicename(invoicename);
			// order.setOrdernumber(ordernumber);
			order.setOrderstate("1");//1待付款
			order.setPaystate("1");//1待付款
			order.setOrdertype("1");//订单状态 单独购买
			order.setAmount(Double.parseDouble(order.getUnitprice())*order.getCountnumber()+"");
			// order.setSendaddress(sendaddress);
			// order.setSignatory(signatory);
			// order.setTel(tel);
			// order.setTrainorgid(trainorgid);
			// order.setTraintype(traintype);
			// order.setUnitprice(unitprice);
			orderDao.save(order);
			createTransactionByOrderId(order.getId());
		}

		for (Long personId : personIds) {//保存订单关联保安人员
			SecurityPerson person = personDao.findById(personId);
			OrderPerson orderPerson = new OrderPerson();
			orderPerson.setActive(true);
			orderPerson.setCompanyid(company.getId());
			orderPerson.setCompanyname(company.getName());
			orderPerson.setCreateTime(new Date());
//					orderPerson.setEndtime(endtime);
			orderPerson.setName(person.getRealName());
			orderPerson.setOrderid(order.getId());
			orderPerson.setPersonid(personId);
			orderPerson.setPersonlevel(person.getProfessionLevel() == null ?"":(person.getProfessionLevel()+""));
			orderPerson.setPhone(person.getPhone());
//					orderPerson.setSigntime(signtime);
//					orderPerson.setStudylong(studylong);
//					orderPerson.setStudyprogress(studyprogress);
//					orderPerson.setStudystate(studystate);
			orderPerson.setTrainorgid(order.getTrainorgid());
			orderPerson.setTraintype(order.getTraintype());
			orderPerson.setUpdateBy(currentUser.getUsername());
			orderPerson.setUpdateTime(new Date());
			//身份证
			orderPerson.setIdentitynumber(person.getIdNumber());
			//根据初级还是继续课程设置
			orderPerson.setGroupid(order.getTraintype());
//					orderPerson.setVideonum(videonum);
			orderPersonDao.save(orderPerson);
		}
	}

	@Override
	public void createOrderForBxMF(Order order, Long[] personIds,User user) {
		SecurityCompany company = companyDao.findByUserid(user.getId());
		order.setCreateTime(new Date());
		order.setUpdateTime(new Date());
		order.setUserid(user.getId());
		order.setCountnumber(personIds.length);
		order.setUpdateBy(user.getUsername());
		order.setActive(true);
		orderDao.save(order);
		
		Config coninsConfig = configService.findByKey(Constants.TRAIN);

         //2018年8月9日17:46:58 wjb  改完批量
        //保存订单关联保安人员
		List<SecurityPerson> securityPersonList;
		if(personIds.length>0){
			securityPersonList = personDao.findBatch(personIds);
		}else{
			securityPersonList =new ArrayList<>();
		}


		if(null!=securityPersonList&& securityPersonList.size()>0){

			List<OrderPerson> orderPersonList = new ArrayList<>();
			for (SecurityPerson person:securityPersonList) {
				OrderPerson orderPerson = new OrderPerson();
				orderPerson.setActive(true);
				orderPerson.setCompanyid(company.getId());
				orderPerson.setCompanyname(company.getName());
				orderPerson.setCreateTime(new Date());
					orderPerson.setName(person.getRealName());
					orderPerson.setPhone(person.getPhone());
				orderPerson.setOrderid(order.getId());
				orderPerson.setPersonid(person.getId());
				orderPerson.setPersonlevel(person.getProfessionLevel()+"");
				orderPerson.setIdentitynumber(person.getIdNumber());
				orderPerson.setGroupid(order.getTraintype());
				orderPerson.setUpdateBy(user.getUsername());
				orderPerson.setUpdateTime(new Date());
				orderPerson.setTraintype("2");
				orderPersonList.add(orderPerson);
			}
			orderPersonDao.saveBatch(orderPersonList);

			new Thread(()-> {
				for (SecurityPerson person:securityPersonList) {
					/************************************购买保险之后推送给百课堂 start*********************************/
					Config groupid = configService.findByKey("groupid");
					String groupidValue = "11";
					if (groupid != null) {
						groupidValue = groupid.getValue();
					}
					//取时间
					Date date = new Date();
					Calendar calendar = new GregorianCalendar();
					calendar.setTime(date);
					//把日期往后增加一年.整数往后推,负数往前移动
					calendar.add(Calendar.YEAR, 1);
					String url = coninsConfig.getValue() + ThirdPartyURL.ADDAUTH
							+ "?identitynumber=" + person.getIdNumber() //身份证
							+ "&groupid=" + groupidValue //课程id
							+ "&name=" + person.getRealName()//姓名
							+ "&mobile=" + person.getPhone()//手机号
							+ "&orderID=" + person.getRelation().getCompany().getUser().getUsername() + person.getRelation().getCompany().getUser().getId()+DateUtil.convertDateToString(date, DateUtil.FORMAT11)//订单号 = 公司登录名+公司userid
							//开始时间 当前时间
							+ "&startdate=" + DateUtil.convertDateToString(date, DateUtil.FORMAT2)
							//结束时间 = 开始时间+1年
							+ "&enddate=" + DateUtil.convertDateToString(calendar.getTime(), DateUtil.FORMAT2)
							//公司id
							+ "&companyid=" + person.getRelation().getCompany().getId()
							//公司名称
							+ "&companyname=" + person.getRelation().getCompany().getName()
							//订单类型 暂定为 1 陕西免费继续再教育课程
							+ "&tOrderType=1"
							//证书 = 保安员证书等级水平
							+ "&certificate=" + (person.getProfessionLevel() == null ? "" : person.getProfessionLevel());
							//是否已购保险
							/*+ "&purInsurance=" + (person.getInsured() ? "1" : "0");*/
					messageUtils.getJsonByInternet(url);
					/************************************购买保险之后推送给百课堂 end *********************************/
				}
			}).start();

		}

	}


	@Override
	public void createOrderForBx(Order order, Long[] personIds,User user) {
		SecurityCompany company = companyDao.findByUserid(user.getId());
		order.setCreateTime(new Date());
		order.setUpdateTime(new Date());
		order.setUserid(user.getId());
		order.setUpdateBy(user.getUsername());
		order.setActive(true);
		order.setCountnumber(personIds.length);
		orderDao.save(order);

		for (Long personId : personIds) {//保存订单关联保安人员
			SecurityPerson person = personDao.findById(personId);
			OrderPerson orderPerson = new OrderPerson();
			orderPerson.setActive(true);
			orderPerson.setCompanyid(company.getId());
			orderPerson.setCompanyname(company.getName());
			orderPerson.setCreateTime(new Date());
//					orderPerson.setEndtime(endtime);
			orderPerson.setName(person.getRealName());
			orderPerson.setOrderid(order.getId());
			orderPerson.setPersonid(personId);
			orderPerson.setPersonlevel(person.getProfessionLevel()+"");
			orderPerson.setPhone(person.getPhone());
			orderPerson.setIdentitynumber(person.getIdNumber());
			orderPerson.setGroupid("1");

			orderPerson.setUpdateBy(user.getUsername());
			orderPerson.setUpdateTime(new Date());
//					orderPerson.setVideonum(videonum);
			orderPersonDao.save(orderPerson);
		}
	}
	@Override
	public void createTransactionByOrderId(Long orderId) {
		User user = arsUtil.getCurrentUser();
		Order order = findById(orderId);
		OrderTransaction transaction = new OrderTransaction();
		transaction.setActive(true);
		transaction.setCreateTime(new Date());
		transaction.setOrderid(orderId);
		transaction.setPaystate("1");
		transaction.setSubmitordertime(new Date());
		transaction.setUpdateBy(user.getRealname());
		transaction.setUpdateTime(new Date());
		transaction.setOrdernum(order.getOrdernumber());
		orderTransactionDao.save(transaction);
	}

	@Override
	public Order findByOrderNo(String orderNo) {
		return orderDao.findByOrderNo(orderNo);
	}

	@Override
	public void update(Order order) {
		order.setUpdateTime(new Date());
		orderDao.update(order);
	}

	@Override
	public List<Order> findByUserid(Long userid) {
		return orderDao.findByUserid(userid);
	}

	@Override
	public OrderSearchDto findByTrainorgid(OrderSearchDto dto) {
		OrderSearchDto resultDto = new OrderSearchDto();
		List<Order> list =  orderDao.findByTrainorgid(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(orderDao.countOrder(dto));
		return resultDto;
	}
	
	@Override
	public void sendOrderInfoToFENXIAO(Order order){
		User user = userDao.findById(order.getUserid());
		SecurityCompany company = companyDao.findByUserid(order.getUserid());
		TrainOrderVo trainOrder = new TrainOrderVo();
		trainOrder.setAmount(order.getAmount()+"");
		trainOrder.setBuyPolicy("是");
		trainOrder.setDealDate(DateUtil.getCurrentDateTime());
		trainOrder.setEndDate(DateUtil.convertDateToString(order.getEffectiveendtime(),DateUtil.FORMAT1));
		trainOrder.setFcy(order.getAmount()+"");
		trainOrder.setName(order.getGoodsname());
		trainOrder.setNumber(order.getCountnumber()+"");
		trainOrder.setOrderDate(DateUtil.convertDateToString(order.getCreateTime(),DateUtil.FORMAT1));
		trainOrder.setOrderNo(order.getOrdernumber());
		trainOrder.setPaymentDate(DateUtil.getCurrentDateTime());
		trainOrder.setPaymentStage("1");
		trainOrder.setPaymentType("银联");
		trainOrder.setPurchaser(user.getRealname());
		trainOrder.setSign("ARS");
		trainOrder.setStartDate(DateUtil.convertDateToString(order.getEffectivestarttime(),DateUtil.FORMAT1));
		//TODO
		if(order.getTrainorgid() == 100l){
			trainOrder.setCompanyId("857766457153536000");
			trainOrder.setVenue("851309406021816320");
		}else if(order.getTrainorgid() == 200l){
			trainOrder.setCompanyId("859346883567841280");
			trainOrder.setVenue("851309406021816320");
		}else if(order.getTrainorgid() == 300l){
			trainOrder.setCompanyId("859302890435952640");
			trainOrder.setVenue("851309407473045504");
		}
		
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("reportVo", trainOrder);
		//保存分销
		String url = ThirdPartyURL.FENXIAO+ ThirdPartyURL.SENDORDERINFOTOFENXIAO;
		
		try {
			String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map,"ARS"));
			String status = messageUtils.getStringValueByKey(resultStr, "status");
			if(StringUtil.isNotEmpty(status)&&"200".equals(status)){
				System.out.print("成功");
			}
		} catch (Exception e) {
			logger.error(e.getMessage(),e);
		}
	}

	@Override
	public void orderCancel(Long orderId) {
		Order dbOrder = orderDao.findById(orderId);
		dbOrder.setOrderstate(Constants.ORDERSTATE_ORDERCANCEL);
		dbOrder.setUpdateTime(new Date());
		orderDao.update(dbOrder);
	}

	@Override
	public List<Order> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return orderDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(Order order) {

		if(order.getActive() == null){
			order.setActive(true);
		}
		
		if(!order.getActive()){
			orderDao.delete(order);
		}else{
			Order dbOrder = orderDao.findById(order.getId());
			if(dbOrder == null){
				orderDao.saveForDS(order);
			}else{
				if(order.getUpdateTime().getTime() > dbOrder.getUpdateTime().getTime()){
					orderDao.update(order);
				}
			}
		}
		
	}

	@Override
	public Order findByRandomOrderNo(String orderNo) {
		return orderDao.findByRandomOrderNo(orderNo);
	}

	@Override
	public AjaxResult checkExistOrderByPersonIds(Long[] personIds,String traintype) {
		AjaxResult result = new AjaxResult();
		List<String> personList = orderDao.checkExistOrderByPersonIds(personIds, traintype);
		if(personList != null && personList.size() > 0){
			result.setData(personList);
			result.setSuccessful(false);
		}else{
			result.setSuccessful(true);
		}
		return result;
	}

	@Override
	public void personTrainInit() {
		DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
		searchDto.setPaging(false);
		searchDto.setStartDate(DateUtil.getYesterday());
		searchDto.setEndDate(DateUtil.getTomorrow());
		List<SecurityPerson> personList = personDao.findAll(searchDto);
		Config coninsConfig = configService.findByKey(Constants.TRAIN);
		Date date=new Date();//取时间 
	    Calendar   calendar   =   new   GregorianCalendar(); 
	    calendar.setTime(date); 
	    calendar.add(calendar.YEAR,1);//把日期往后增加一年.整数往后推,负数往前移动 
	    
		for (SecurityPerson person : personList) {
			Config groupid = configService.findByKey("groupid");
			String groupidValue ="11";
			if(groupid!=null ){
				groupidValue  = groupid.getValue();
			}
			if(person.getRelation() != null && person.getRelation().getCompany() != null) {
				String url = coninsConfig.getValue() + ThirdPartyURL.ADDAUTH
					+"?identitynumber="+person.getIdNumber() //身份证
					+"&groupid="+groupidValue //课程id
					+"&name="+person.getRealName()//姓名
					+"&mobile="+person.getPhone()//手机号
					+"&orderID="+person.getRelation().getCompany().getUser().getUsername()+person.getRelation().getCompany().getUser().getId()//订单号 = 公司登录名+公司userid
					+"&startdate="+DateUtil.convertDateToString(date, DateUtil.FORMAT1)//开始时间 当前时间
					+"&enddate="+DateUtil.convertDateToString(calendar.getTime(), DateUtil.FORMAT1)//结束时间 = 开始时间+1年
					+"&companyid="+person.getRelation().getCompany().getId()//公司id
					+"&companyname="+person.getRelation().getCompany().getName()//公司名称
					+"&tOrderType=1"//订单类型 暂定为 1 陕西免费继续再教育课
					+"&certificate="+( person.getProfessionLevel()==null?"":person.getProfessionLevel());//证书 = 保安员证书等级水平
					/*+"&purInsurance=" + (person.getInsured() ? "1":"0");//是否已购保险*/
				
				messageUtils.getJsonByInternet(url);
			}
		}
	}
}