package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.CyFirearmsLogDao;
import com.bcxin.ars.dao.sb.FirearmsDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CyFirearmsLogSearchDto;
import com.bcxin.ars.model.CyFirearmsLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.service.CyFirearmsLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = CyFirearmsLog.class)
public class CyFirearmsLogServiceImpl implements CyFirearmsLogService {

	@Autowired
	private CyFirearmsLogDao cyFirearmsLogDao;

	@Autowired
	private FirearmsDao firearmsDao;

	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 保存或更新
	 * @param cyFirearmsLog
	 */
	@Override
	public void saveOrUpdate(CyFirearmsLog cyFirearmsLog) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		CyFirearmsLog dbCyFirearmsLog = cyFirearmsLogDao.findById(cyFirearmsLog.getId());
		if(dbCyFirearmsLog != null) {
			//设置修改时间
			dbCyFirearmsLog.setUpdateTime(new Date());
			//设置修改者
			dbCyFirearmsLog.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值

			cyFirearmsLogDao.update(dbCyFirearmsLog);
		}else{
			cyFirearmsLog.setUserid(user.getId());
			//修改时间，创建时间在保存的时候一样
			cyFirearmsLog.setCreateTime(new Date());
			cyFirearmsLog.setUpdateTime(cyFirearmsLog.getCreateTime());
			//默认可用
			cyFirearmsLog.setActive(true);
			cyFirearmsLog.setUpdateBy(user.getUsername());
			cyFirearmsLogDao.save(cyFirearmsLog);
		}


		//根据日志类型确定枪支状态
		//1根据主键获取枪支信息
		Firearms firearms = firearmsDao.findById(new Long(cyFirearmsLog.getFirearmsid()));
		//2获取日志状态,并设置为枪支状态
		firearms.setFirearmsstate(cyFirearmsLog.getType());

		//如果为领用同步领用信息,否则清空领用信息
		if("1".equals(cyFirearmsLog.getType())){
			firearms.setUsename(cyFirearmsLog.getName());
			firearms.setUsedate(cyFirearmsLog.getTime());
			firearms.setUseexplain(cyFirearmsLog.getRemarks());
		}else{
			firearms.setUsename("");
			firearms.setUsedate(null);
			firearms.setUseexplain("");
		}
		//3更新枪支信息
		firearms.setUpdateTime(new Date());
		firearmsDao.update(firearms);
		}


	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public CyFirearmsLog findById(long id){
		return cyFirearmsLogDao.findById(id);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public CyFirearmsLogSearchDto search(CyFirearmsLogSearchDto dto) {
		CyFirearmsLogSearchDto resultDto = new CyFirearmsLogSearchDto();
		List<CyFirearmsLog> list =  cyFirearmsLogDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(cyFirearmsLogDao.count(dto));
		return resultDto;
	}


	@Override
	public List<CyFirearmsLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return cyFirearmsLogDao.searchForDataSynchronization(searchDto);
	}


	@Override
	public void saveOrUpdateForDS(CyFirearmsLog cyFirearmsLog) {
		if(cyFirearmsLog.getActive() == null){
			cyFirearmsLog.setActive(true);
		}
		
		if(!cyFirearmsLog.getActive()){
			cyFirearmsLogDao.delete(cyFirearmsLog);
		}else{
			CyFirearmsLog dbCyFirearmsLogLog = cyFirearmsLogDao.findById(cyFirearmsLog.getId());
			if(dbCyFirearmsLogLog == null){
				cyFirearmsLogDao.saveForDS(cyFirearmsLog);
			}else{
				if(cyFirearmsLog.getUpdateTime().getTime() > dbCyFirearmsLogLog.getUpdateTime().getTime()){
					cyFirearmsLogDao.update(cyFirearmsLog);
				}
			}
		}
	}

	@Override
	public void searchForPage(CyFirearmsLogSearchDto searchDto, AjaxPageResponse<CyFirearmsLog> page) {

		arsUtil.setPoliceSearch(searchDto);
		cyFirearmsLogDao.searchForPage(searchDto,page);

	}
}


