package com.bcxin.ars.service.impl;

import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Random;

/**
 * Service 基类
 * 服务层通用方法
 */
public class BaseService {
    /***
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(BaseService.class);
    /**
     * 上传文件路径
     */
    @Value("${upload-folder}")
    private String uploadFolder;

    @Value("${base-folder}")
    private String baseFolder;

    @Value("${temp-folder}")
    private String tempFolder;

    @Value("${pdf-folder}")
    private String pdfFolder;
    @Value("${personImg-folder}")
    private String personImg;
    public String getLocalPhotoPath(String url){
        StringBuffer result = new StringBuffer("");
        //多张照片用，号隔开
        String[] urls = url.split(Constants.COMMA);
        for (String urlStr: urls){
            urlStr = urlStr.substring(urlStr.indexOf(Constants.FILE_GETRESOURCE));
            if(StringUtil.isNotEmpty(urlStr)){

                if(StringUtil.isEmpty(result.toString())) {
                    result.append(urlStr);
                }else{
                    result.append("&&"+urlStr);
                }
            }
        }
        return result.toString();
    }


    public String saveBase64Img(String base64Img){
        if(StringUtil.isNotEmpty(base64Img)){
            Date now = new Date();
            String fileName = now.getTime() +".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = "upload/" + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = baseFolder + key;

            if(ImgUtils.generateImage(base64Img,targetPath)) {
                return url;
            }
        }
        return null;
    }


  /***
     * 根据url获取SaaS的附件
     * @param url 华为云地址
     *
     * @return 百保盾路径
     */
    public String getAttPath(String url) {
        //定义输出流对象，用于生成文件
        FileOutputStream outStream = null;
        //定义输入流对象，用于获取文件流
        InputStream inStream = null;
        //返回对易用
        StringBuffer result = new StringBuffer("");
        try {
            //多张照片用，号隔开
            String[] urls = url.split(Constants.COMMA);
            for (String urlStr: urls){
                //获取图片地址信息
                URL imgPath = new URL(urlStr);
                //打开链接
                HttpURLConnection conn = (HttpURLConnection)imgPath.openConnection();
                //设置请求方式为"GET"
                conn.setRequestMethod("GET");
                //超时响应时间为5秒
                conn.setConnectTimeout(5 * 1000);
                //通过输入流获取图片数据
                inStream = conn.getInputStream();
                //得到图片的二进制数据，以二进制封装得到数据，具有通用性
                byte[] data = readInputStream(inStream);
                //日期
                Date now = new Date();
                //对图片地址以逗号，如 XXXX.png 分割成数据，array[0]=XXXX,array[1]=png
                String[] fileTypes = urlStr.split("\\.");
                //获取文件类型
                String materialFileType = fileTypes[fileTypes.length-1]; //文件类型
                Random random = new Random();
                int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
                //生成新的文件名，格式 时间戳+文件类型
                StringBuffer fileName =new StringBuffer();
                fileName.append(now.getTime());
                fileName.append(rannum).append("."+ materialFileType);
                //获取当前日期
                String dirDate = DateUtil.systemDate.format(now);
                //定义目录file对象，用于判断文件夹是否存在
                File dir = new File(uploadFolder + dirDate);
                //判断文件是否存在，如不存在则创建
                if(!dir.exists()) {
                    dir.mkdirs();
                }
                //文件的完整路径
                String key = "upload/" + dirDate + "/" + fileName;
                //生成请求地址 多个地址用&&隔开
                if(StringUtil.isEmpty(result.toString())) {
                    result.append("getResource.do?path=" + key);
                }else{
                    result.append("&&getResource.do?path=" + key);
                }
                //操作系统真实路径
                String targetPath = uploadFolder + dirDate + "/" + fileName;
                //new一个文件对象用来保存图片，默认保存当前工程根目录
                File imageFile = new File(targetPath);
                //创建输出流
                outStream = new FileOutputStream(imageFile);
                //写入文件数据
                outStream.write(data);
                //刷新输出流
                outStream.flush();
                logger.info("本地文件上传成功!");
            }
        } catch(Exception e) {
            e.printStackTrace();
           throw new ArsException("附件转换异常");
        } finally {
            try {
                //关闭输入流
                if (inStream != null) {
                    inStream.close();
                }
                //关闭输出流
                if (outStream != null) {
                    outStream.close();
                }
            }catch (Exception e){
                logger.error(e.getMessage(), e);
            }
        }
        return result.toString();
    }
    /***
     * 根据url获取SaaS的图片信息
     * @param url 图片地址
     * @return 百保盾路径
     */
    public String getPhotoPath(String url) {
        //定义输出流对象，用于生成文件
        FileOutputStream outStream = null;
        //定义输入流对象，用于获取文件流
        InputStream inStream = null;
        //返回对易用
        StringBuffer result = new StringBuffer("");
        try {
            //多张照片用，号隔开
            String[] urls = url.split(Constants.COMMA);
            for (String urlStr: urls){
                //获取图片地址信息
                URL imgPath = new URL(urlStr);
                //打开链接
                HttpURLConnection conn = (HttpURLConnection)imgPath.openConnection();
                //设置请求方式为"GET"
                conn.setRequestMethod("GET");
                //超时响应时间为5秒
                conn.setConnectTimeout(5 * 1000);
                //通过输入流获取图片数据
                inStream = conn.getInputStream();
                //得到图片的二进制数据，以二进制封装得到数据，具有通用性
                byte[] data = readInputStream(inStream);
                //日期
                Date now = new Date();
                //对图片地址以逗号，如 XXXX.png 分割成数据，array[0]=XXXX,array[1]=png
                String[] fileTypes = urlStr.split("\\.");
                //获取文件类型
                String materialFileType = fileTypes[fileTypes.length-1]; //文件类型
                Random random = new Random();
                int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
                //生成新的文件名，格式 时间戳+文件类型
                StringBuffer fileName =new StringBuffer();
                fileName.append(now.getTime());
                fileName.append(rannum).append("."+ materialFileType);
                //获取当前日期
                String dirDate = DateUtil.systemDate.format(now);
                //定义目录file对象，用于判断文件夹是否存在
                File dir = new File(uploadFolder + dirDate);
                //判断文件是否存在，如不存在则创建
                if(!dir.exists()) {
                    dir.mkdirs();
                }
                //文件的完整路径
                String key = "upload/" + dirDate + "/" + fileName;
                //生成请求地址 多个地址用&&隔开
                if(StringUtil.isEmpty(result.toString())) {
                    result.append("getResource.do?path=" + key);
                }else{
                    result.append("&&getResource.do?path=" + key);
                }
                //操作系统真实路径
                String targetPath = uploadFolder + dirDate + "/" + fileName;
                //new一个文件对象用来保存图片，默认保存当前工程根目录
                File imageFile = new File(targetPath);
                //创建输出流
                outStream = new FileOutputStream(imageFile);
                //写入文件数据
                outStream.write(data);
                //刷新输出流
                outStream.flush();
                logger.info("本地文件上传成功!");
            }

        } catch(Exception e) {
            result.append(url);
            logger.error(e.getMessage(), e);
        } finally {
            try {
                //关闭输入流
                if (inStream != null) {
                    inStream.close();
                }
                //关闭输出流
                if (outStream != null) {
                    outStream.close();
                }
            }catch (Exception e){
                logger.error(e.getMessage(), e);
            }
        }
        return result.toString();
    }
    /****
     * 读取输入流信息
     * @param inStream 输入流对接
     * @return 文件byte
     * @throws Exception 异常信息
     */
    public static byte[] readInputStream(InputStream inStream) throws Exception{
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        //创建一个Buffer字符串
        byte[] buffer = new byte[1024];
        //每次读取的字符串长度，如果为-1，代表全部读取完毕
        int len = 0;
        //使用一个输入流从buffer里把数据读取出来
        while( (len=inStream.read(buffer)) != -1 ){
            //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
            outStream.write(buffer, 0, len);
        }
        //关闭输入流
        inStream.close();
        //把outStream里的数据写入内存
        return outStream.toByteArray();
    }



    /**
     * 下载文件
     * @param path
     * @throws IOException
     */
    public String  getResourcePath(String path) throws Exception {
        String result = "";
        path = path.replaceAll("getResource.do\\?path=","");
        if (path.startsWith("upload")) {
            result= baseFolder + path  ;
        } else if (path.startsWith("temp")) {
            result = baseFolder + path ;
        } else if (path.startsWith("pdf")) {
            result = baseFolder + path ;
        } else if (path.startsWith("sysAttachment")) {
            result = baseFolder + path ;
        } else if(path.startsWith("personImg")) {
            result = baseFolder + path;
        }else{
            throw new Exception("系统错误！！！");
        }

        return result;
    }
    public static void main(String[] args) {
        BaseService baseService = new BaseService();
        String url = "https://bcxin-saas-prod.obs.cn-north-1.myhuaweicloud.com:443/upload%2F2019-06-20%2F1561011269961011569.jpg";

        System.out.println("getResource.do?path=upload/2019-08-14/1565747021393.jpg".replaceAll("getResource.do\\?path=",""));

        //System.out.println(baseService.getPhotoPath("http://qiye.baibaodun.cn:9009/public/common/file/get-resource?path=2019-01-01/male.png"));

    }



}
