package com.bcxin.ars.service.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.AnnualSurveyReportDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.AnnualSurveyReportPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.AnnualSurveyReport;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.AnnualSurveyReportService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;

/**
 * 北京保安从业单位和从业人员情况年度调查Service业务层处理
 * 
 * @author lin
 * @date 2020-11-20
 */
@Service
@DataSyncAnnotation(getClazz = AnnualSurveyReport.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
public class AnnualSurveyReportServiceImpl implements AnnualSurveyReportService {
    
    Logger logger = LoggerFactory.getLogger(AnnualSurveyReportServiceImpl.class);
    
    @Autowired
    private AnnualSurveyReportDao annualSurveyReportDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(AnnualSurveyReport annualSurveyReport) {
        User currentUser = arsUtil.getCurrentUser();
        annualSurveyReport.setUpdateTime(new Date());
        annualSurveyReport.setUpdateBy(currentUser.getUsername());
        return annualSurveyReportDao.delete(annualSurveyReport);
    }

    @Override
    public int save(AnnualSurveyReport annualSurveyReport) {
        User currentUser = arsUtil.getCurrentUser();
        if(annualSurveyReport.getId() == null){
            annualSurveyReport.setCreateTime(new Date());
        }else{
            AnnualSurveyReport dbAnnualSurveyReport = annualSurveyReportDao.findById(annualSurveyReport.getId());
            BeanUtils.copyPropertiesIgnore(annualSurveyReport,dbAnnualSurveyReport,true);
            BeanUtils.copyPropertiesIgnore(dbAnnualSurveyReport,annualSurveyReport,false);
        }

        annualSurveyReport.setAppraiseTotal(annualSurveyReport.getPrimaryNum()+annualSurveyReport.getMiddleNum()+annualSurveyReport.getAdminNum());
        annualSurveyReport.setBeTotalNum(annualSurveyReport.getBeCollegeNum()
                +annualSurveyReport.getBePrivateNum()
                +annualSurveyReport.getBeTrainNum()
                +annualSurveyReport.getBeSelfNum()
                +annualSurveyReport.getBeOther());
        annualSurveyReport.setBeTotalPerNum(annualSurveyReport.getBeCollegePerNum()
                +annualSurveyReport.getBePrivatePerNum()
                +annualSurveyReport.getBeTrainPerNum()
                +annualSurveyReport.getBeSelfPerNum()
                +annualSurveyReport.getBeOtherPer());
        annualSurveyReport.setOnTotalNum(annualSurveyReport.getOnCollegeNum()
                +annualSurveyReport.getOnPrivateNum()
                +annualSurveyReport.getOnTrainNum()
                +annualSurveyReport.getOnSelfNum()
                +annualSurveyReport.getOnOther());
        annualSurveyReport.setOnTotalPerNum(annualSurveyReport.getOnCollegePerNum()
                +annualSurveyReport.getOnPrivatePerNum()
                +annualSurveyReport.getOnTrainPerNum()
                +annualSurveyReport.getOnSelfPerNum()
                +annualSurveyReport.getOnOtherPer());

        if(StringUtil.isEmpty(annualSurveyReport.getFillYear())){
            annualSurveyReport.setFillYear(DateUtil.getCurrentDate(DateUtil.FORMAT10));
        }
        annualSurveyReport.setActive(true);
        annualSurveyReport.setUpdateBy(currentUser.getUsername());
        annualSurveyReport.setUpdateTime(new Date());
        annualSurveyReport.setUpdateflag(true);
        annualSurveyReport.setUserId(currentUser.getId());

        if(Constants.PLATFORM_COMPANY == currentUser.getPlatform()){
            SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
            annualSurveyReport.setComId(company.getId());
            if(StringUtil.isNotEmpty(company.getOrgId())){
                annualSurveyReport.setOrgId(Long.parseLong(company.getOrgId()));
            }
            annualSurveyReport.setAreaCode(company.getAreaCode());

        }

        return annualSurveyReportDao.save(annualSurveyReport);
    }

    @Override
    public AnnualSurveyReport findById(Long id) {
        return annualSurveyReportDao.findById(id);
    }

    @Override
    public void searchForPage(AnnualSurveyReportPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        annualSurveyReportDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<AnnualSurveyReport> list) {
        List<AnnualSurveyReport> dbList = annualSurveyReportDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (AnnualSurveyReport annualSurveyReport : list) {
                annualSurveyReport.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        annualSurveyReport.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, annualSurveyReport.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            annualSurveyReportDao.saveBatch(list);
        }
    }

    @Override
    public List<AnnualSurveyReport> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return annualSurveyReportDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<AnnualSurveyReport> findDSOutList(String startDate) {
        return annualSurveyReportDao.findDSOutList(startDate);
    }

    @Override
    public List<AnnualSurveyReport> findByBatchId(List<AnnualSurveyReport> list) {
        return annualSurveyReportDao.findByBatchId(list);
    }

    @Override
    public AnnualSurveyReport findByUserId(Long userId) {
        return annualSurveyReportDao.findByUserId(userId);
    }

    @Override
    public AnnualSurveyReport findByUserIdAndFillYear(Long userId,String fillYear) {
        return annualSurveyReportDao.findByUserIdAndFillYear(userId,fillYear);
    }

    @Override
    public void updateSelective(AnnualSurveyReport annualSurveyReport) {
        User currentUser = arsUtil.getCurrentUser();
        annualSurveyReport.setUpdateTime(new Date());
        annualSurveyReport.setUpdateBy(currentUser.getUsername());
        annualSurveyReportDao.updateSelective(annualSurveyReport);
    }



    @Override
    public String exportTotal(HttpServletRequest request) throws Exception {


        /**
         *  //获取浏览器
         *  不同的浏览器的编码不一样
         *  */
        String userAgent = request.getHeader("user-agent");
        String tableExcelName ="保安从业单位和从业人员情况年度调查表";
        if (userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0
                || userAgent.indexOf("Safari") >= 0) {
            tableExcelName= new String((tableExcelName).getBytes(), "ISO8859-1");
        } else {
            tableExcelName= URLEncoder.encode(tableExcelName,"UTF8"); //其他浏览器
        }

        String fillYear = DateUtil.getCurrentDate(DateUtil.FORMAT10);
        AnnualSurveyReport report = annualSurveyReportDao.findToTal(fillYear);

        if(report == null){
            throw new ArsException("暂无数据可导出");
        }
        this.getBigDecimalTotal(report,fillYear);


        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(configUtils.tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_total.xls";
        String filePath = configUtils.tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        logger.info("路径： " + filePath);
        /**** 生成file ****/
        FileUtil.copyTempFile(Constants.FILETEMPPATH + "annualSurveyReportTemp.xls",filePath,request); // 绝对路径文件实现

        File file = new File(filePath);

        if (file != null) {
            //读取excel模板
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            CellStyle valueStyle = getStringStyle(workbook);
            //读取了模板内所有sheet内容
            HSSFSheet sheet1 = workbook.getSheetAt(1);
            sheet1.setForceFormulaRecalculation(true);

            this.setUnitInfo(report,sheet1.getRow(13),valueStyle);
            this.setPersonInfo(report,sheet1.getRow(34),valueStyle);
            this.setPersonInfo(report,sheet1.getRow(33),valueStyle);


            HSSFSheet sheet2 = workbook.getSheetAt(2);
            sheet2.setForceFormulaRecalculation(true);

            this.setTrainAppraisalInfo(report,sheet2,valueStyle);
            this.setTrainInfo(report,sheet2,valueStyle);


            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return filePath;
        }
        return null;
    }

    private void getBigDecimalTotal(AnnualSurveyReport report,String fillYear ){
        List<AnnualSurveyReport> list = annualSurveyReportDao.findByFillYear(fillYear);

        report.setFixedAssets("0");
        report.setAnnualTurnover("0");
        report.setAnnualProfitTax("0");
        report.setFine("0");
        report.setIncome("0");
        report.setRetrieve("0");

        for (AnnualSurveyReport surveyReport : list) {

            report.setFixedAssets(new BigDecimal(StringUtil.isEmpty(report.getFixedAssets())? "0":report.getFixedAssets()).
                    add(new BigDecimal(StringUtil.isEmpty(surveyReport.getFixedAssets())? "0":surveyReport.getFixedAssets())).toString());

            report.setAnnualTurnover(new BigDecimal(StringUtil.isEmpty(report.getAnnualTurnover())? "0":report.getAnnualTurnover()).
                    add(new BigDecimal(StringUtil.isEmpty(surveyReport.getAnnualTurnover())? "0":surveyReport.getAnnualTurnover())).toString());

            report.setAnnualProfitTax(new BigDecimal(StringUtil.isEmpty(report.getAnnualProfitTax())? "0":report.getAnnualProfitTax()).
                    add(new BigDecimal(StringUtil.isEmpty(surveyReport.getAnnualProfitTax())? "0":surveyReport.getAnnualProfitTax())).toString());

            report.setFine(new BigDecimal(StringUtil.isEmpty(report.getFine())? "0":report.getFine()).
                    add(new BigDecimal(StringUtil.isEmpty(surveyReport.getFine())? "0":surveyReport.getFine())).toString());

            report.setIncome(new BigDecimal(StringUtil.isEmpty(report.getIncome())? "0":report.getIncome()).
                    add(new BigDecimal(StringUtil.isEmpty(surveyReport.getIncome())? "0":surveyReport.getIncome())).toString());

            report.setRetrieve(new BigDecimal(StringUtil.isEmpty(report.getRetrieve())? "0":report.getRetrieve()).
                    add(new BigDecimal(StringUtil.isEmpty(surveyReport.getRetrieve())? "0":surveyReport.getRetrieve())).toString());

        }
    }

    private void setUnitInfo(AnnualSurveyReport report,Row row,CellStyle valueStyle){
        this.setCellValue(row,valueStyle,14,report.getCustNum()+"");
        this.setCellValue(row,valueStyle,15,report.getFixedAssets()+"");
        this.setCellValue(row,valueStyle,16,report.getAnnualTurnover()+"");
        this.setCellValue(row,valueStyle,17,report.getAnnualProfitTax()+"");
        this.setCellValue(row,valueStyle,23,report.getRubberNum()+"");
        this.setCellValue(row,valueStyle,24,report.getVestNum()+"");
        this.setCellValue(row,valueStyle,25,report.getWarnrNum()+"");
        this.setCellValue(row,valueStyle,26,report.getFine()+"");
        this.setCellValue(row,valueStyle,27,report.getIncome()+"");
        this.setCellValue(row,valueStyle,28,report.getRevokeLiceNum()+"");
        this.setCellValue(row,valueStyle,29,report.getCriminalNum()+"");
        this.setCellValue(row,valueStyle,30,report.getCrimeOther()+"");
    }

    private void setPersonInfo(AnnualSurveyReport report,Row row,CellStyle valueStyle){
        this.setCellValue(row,valueStyle,4,report.getPerNum()+"");
        this.setCellValue(row,valueStyle,6,report.getFePerNum()+"");
        this.setCellValue(row,valueStyle,7,report.getCerNum()+"");
        this.setCellValue(row,valueStyle,8,report.getManageNum()+"");
        this.setCellValue(row,valueStyle,9,report.getCaseClueNum()+"");
        this.setCellValue(row,valueStyle,11,report.getCaptureNum()+"");
        this.setCellValue(row,valueStyle,13,report.getPreventNum()+"");
        this.setCellValue(row,valueStyle,15,report.getRetrieve()+"");
        this.setCellValue(row,valueStyle,17,report.getEventNum()+"");
        this.setCellValue(row,valueStyle,18,report.getEventPerNum()+"");
        this.setCellValue(row,valueStyle,19,report.getHandleNum()+"");
        this.setCellValue(row,valueStyle,20,report.getHandlePerNum()+"");
        this.setCellValue(row,valueStyle,21,report.getCudgelsNum()+"");
        this.setCellValue(row,valueStyle,22,report.getInjuriesNum()+"");
        this.setCellValue(row,valueStyle,23,report.getSacrificeNum()+"");
        this.setCellValue(row,valueStyle,24,report.getNationalAdCollNum()+"");
        this.setCellValue(row,valueStyle,25,report.getProvAdCollNum()+"");
        this.setCellValue(row,valueStyle,26,report.getNationalAdindiNum()+"");
        this.setCellValue(row,valueStyle,27,report.getProvAdindiNum()+"");
        this.setCellValue(row,valueStyle,28,report.getRevokeCerNum()+"");
        this.setCellValue(row,valueStyle,29,report.getPunishNum()+"");
        this.setCellValue(row,valueStyle,30,report.getCriminalPerNum()+"");
    }

    private void setTrainInfo(AnnualSurveyReport report,HSSFSheet sheet,CellStyle valueStyle){
        Row row1 = sheet.getRow(13);
        this.setCellValue(row1,valueStyle,4,report.getBeCollegeNum()+"");
        this.setCellValue(row1,valueStyle,5,report.getBeCollegePerNum()+"");
        this.setCellValue(row1,valueStyle,6,report.getOnCollegeNum()+"");
        this.setCellValue(row1,valueStyle,7,report.getOnCollegePerNum()+"");
        Row row2 = sheet.getRow(14);
        this.setCellValue(row2,valueStyle,4,report.getBePrivateNum()+"");
        this.setCellValue(row2,valueStyle,5,report.getBePrivatePerNum()+"");
        this.setCellValue(row2,valueStyle,6,report.getOnPrivateNum()+"");
        this.setCellValue(row2,valueStyle,7,report.getOnPrivatePerNum()+"");
        Row row3 = sheet.getRow(15);
        this.setCellValue(row3,valueStyle,4,report.getBeVocationalNum()+"");
        this.setCellValue(row3,valueStyle,5,report.getBeVocationalPerNum()+"");
        this.setCellValue(row3,valueStyle,6,report.getOnVocationalNum()+"");
        this.setCellValue(row3,valueStyle,7,report.getOnVocationalPerNum()+"");
        Row row4 = sheet.getRow(16);
        this.setCellValue(row4,valueStyle,4,report.getBeMartialNum()+"");
        this.setCellValue(row4,valueStyle,5,report.getBeMartialPerNum()+"");
        this.setCellValue(row4,valueStyle,6,report.getOnMartialNum()+"");
        this.setCellValue(row4,valueStyle,7,report.getOnMartialPerNum()+"");

        Row row5 = sheet.getRow(18);
        this.setCellValue(row5,valueStyle,4,report.getBeSelfNum()+"");
        this.setCellValue(row5,valueStyle,5,report.getBeSelfPerNum()+"");
        this.setCellValue(row5,valueStyle,6,report.getOnSelfNum()+"");
        this.setCellValue(row5,valueStyle,7,report.getOnSelfPerNum()+"");

        Row row6 = sheet.getRow(21);
        this.setCellValue(row6,valueStyle,4,report.getBeOther()+"");
        this.setCellValue(row6,valueStyle,5,report.getBeOtherPer()+"");
        this.setCellValue(row6,valueStyle,6,report.getOnOther()+"");
        this.setCellValue(row6,valueStyle,7,report.getOnOtherPer()+"");
    }

    private void setTrainAppraisalInfo(AnnualSurveyReport report,HSSFSheet sheet,CellStyle valueStyle){
        Row row1 = sheet.getRow(12);
        this.setCellValue(row1,valueStyle,4,report.getBeTotalNum()+"");
        this.setCellValue(row1,valueStyle,5,report.getBeTotalPerNum()+"");
        this.setCellValue(row1,valueStyle,6,report.getOnTotalNum()+"");
        this.setCellValue(row1,valueStyle,7,report.getOnTotalPerNum()+"");
        this.setCellValue(row1,valueStyle,10,report.getAppraiseTotal()+"");
        this.setCellValue(row1,valueStyle,11,report.getPrimaryNum()+"");
        this.setCellValue(row1,valueStyle,12,report.getMiddleNum()+"");
        this.setCellValue(row1,valueStyle,14,report.getAdminNum()+"");
        Row row2 = sheet.getRow(17);
        this.setCellValue(row2,valueStyle,4,report.getBeTrainNum()+"");
        this.setCellValue(row2,valueStyle,5,report.getBeTrainPerNum()+"");
        this.setCellValue(row2,valueStyle,6,report.getOnTrainNum()+"");
        this.setCellValue(row2,valueStyle,7,report.getOnTrainPerNum()+"");
        this.setCellValue(row2,valueStyle,10,report.getAppraiseTotal()+"");
        this.setCellValue(row2,valueStyle,11,report.getPrimaryNum()+"");
        this.setCellValue(row2,valueStyle,12,report.getMiddleNum()+"");
        this.setCellValue(row2,valueStyle,14,report.getAdminNum()+"");

    }

    private void setCellValue(Row row,CellStyle valueStyle,int cellIndex,String value){
        Cell cell29 = row.getCell(cellIndex);
        cell29.setCellStyle(valueStyle);
        cell29.setCellValue(value);
    }

    private static CellStyle getStringStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        HSSFFont font = wb.createFont();
        font.setFontName("等线");
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框  
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框  
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框  
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框 
        return style;
    }
}
