package com.bcxin.ars.service.gx;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.gx.DataViewDao;
import com.bcxin.ars.dto.gx.DataViewDTO;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gx.DataView;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/***
 * 数据获取服务层
 */
@Service
public class DataViewServiceImpl implements DataViewService {
    @Autowired
    private DataViewDao dataViewDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao ;
    @Override
    public DataView query(SingleUserDTO userInfo) {
        //获取用户信息
        User u = userDao.findByUsername(userInfo.getUser(), String.valueOf(Constants.PLATFORM_POLICE));
        DataViewDTO dto = new DataViewDTO();
        if(u!=null){
           Police p =  policeDao.findById(u.getOrgid());
           //机构区域编码
           String areaCode = p.getAreacode();
            if (areaCode.endsWith("0000")) {// 省
                dto.setAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {// 市
                dto.setAreaCode(areaCode.substring(0, 4) + "__");
            } else {// 区
                dto.setAreaCode(areaCode);
            }
            //派出所
            if (Constants.POLICE_ORGTYPE_PCS.equals(p.getOrgtype())) {
                dto.setOrgId(p.getId());
            }
        }
        return dataViewDao.query(dto);
    }
}
