package com.bcxin.ars.service.gx;

import cn.hutool.http.HttpUtil;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.model.SecurityCompany;
import net.sf.json.JSONObject;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.model.gx.CerPermit;
import com.bcxin.ars.model.gx.SysResult;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.util.DateUtil;
import net.sf.json.JSONArray;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/***
 * 广西推送数据信息
 */
@Service
public class CerPermitServiceImpl implements CerPermitService{

    private static Logger logger = LoggerFactory.getLogger(CerPermitServiceImpl.class);

    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Override
    public void send() {
        List<SecurityCompany> list =  securityCompanyDao.findByAll("0102");
        for (SecurityCompany p:
                list) {
            List<SysResult> list1 = new ArrayList<>();
            InterfaceLog interfaceLog = new InterfaceLog();
            try {

                interfaceLog.setCreateTime(new Date());
                interfaceLog.setActive(true);
                interfaceLog.setUrl("http://10.148.77.151:8652/was2/rest/insert/insertResult");
//                SysResult sysResult = new SysResult();
//                //主键
//                sysResult.setBsnum("ZJQZAJ_" + p.getId() + "_"+DateUtil.getCurrentDate(DateUtil.FORMAT2));
//                //EntName
//                sysResult.setEntName(p.getCompanyname());
//                sysResult.setCerNO(p.getLegalPersonNo());
//                sysResult.setUniSCID("91450700ma5kbnjq0d");
//                sysResult.setLeRep("法定代表人");
//                sysResult.setCerType("身份证号");
//                sysResult.setName(p.getRepresentative());
//                sysResult.setItemNo("保安服务公司设立许可");
//                sysResult.setItmenNo(p.getId().toString());
//                sysResult.setState("已办结");
//                sysResult.setFlag("0");
//                Map<String, Object> paramMap = new HashMap<>();
//                list1.add(sysResult);
//                paramMap.put("sgsBjData", JSONObject.toJSONString(list1));
//                interfaceLog.setParameters(JSONObject.toJSONString(paramMap));


                JSONObject retJSON = new JSONObject();
                //主键（关联SgsForm的bsnum）
                retJSON.put("bsnum", "ZJQZAJ_" + p.getId() + "_"+DateUtil.getCurrentDate(DateUtil.FORMAT2));
                //行政相对人（企业）名称（个体可以为空）
                retJSON.put("EntName", p.getName());
                //行政相对人 统一社会信用代码
                retJSON.put("UniSCID", p.getSocialCode());
                //组织机构代码 TODO
                retJSON.put("OrgCode", "");
                //数据来源单位名称 TODO
                retJSON.put("DataDept", "广西壮族自治区公安厅治安警察总队二支队");
                //法定代表人, 企业、农专必填、个体非必填
                retJSON.put("LeRep", "法定代表人");
                //证件类型(申请人证件类型)
                retJSON.put("CerType", "身份证号");
                //证件号码
                retJSON.put("CerNO", p.getLegalPersonNo());
                //行政相对人（自然人）姓名
                retJSON.put("Name", p.getLegalPerson());
                //事项名称
                retJSON.put("itemNo", "保安服务公司设立许可");
                //事项编码
                retJSON.put("itmenNo", p.getId().toString());
                //办件状态: 已办结, 未办结
                retJSON.put("state", "已办结");
                retJSON.put("DataDeptUniSCID", "");
                retJSON.put("DataUpdateDept", "");
                retJSON.put("Remark", "");
                retJSON.put("create_time", "");
                retJSON.put("back1", "");
                retJSON.put("back2", "");
                retJSON.put("back3", "");
                retJSON.put("back4", "");
                retJSON.put("back5", "");
                retJSON.put("flag", "1");

                JSONArray jsonArray = new JSONArray();
                jsonArray.add(retJSON);//可传多条，最多20条
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("sgsBjData",jsonArray);
                System.out.println(jsonArray);
                System.out.println(jsonObject);
                /*String url="http://127.0.0.1:8080/test/test2";*/
                String result = HttpRequest.sendPost("http://10.148.77.151:8652/was2/rest/insert/insertResult",jsonObject);//发送请求
                //获取结果
              //  String resultStr =deviceRequest("http://10.148.77.152:8652/was2/rest/insert/insertResult", null);
                interfaceLog.setResult(result);
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                interfaceLog.setResult(e.getMessage());
            }
            /**
             * 异步保存
             */
            new Thread(()->{
                interfaceLogDao.insert(interfaceLog);
            }).start();


        }
    }

    @Override
    public void send1() {
        List<SecurityCompany> list =  securityCompanyDao.findByAll("0102");
        for (SecurityCompany p:
                list) {
            List<SysResult> list1 = new ArrayList<>();
            InterfaceLog interfaceLog = new InterfaceLog();
            try {

                interfaceLog.setCreateTime(new Date());
                interfaceLog.setActive(true);
                String url ="http://10.148.77.151:8652/was2/rest/insert/insertForm";
                interfaceLog.setUrl(url);
                JSONObject retJSON = new JSONObject();
                retJSON.put("bsnum", "ZJQZAJ_" + p.getId() + "_"+DateUtil.getCurrentDate(DateUtil.FORMAT2));
                retJSON.put("dataId", "");
                retJSON.put("ProjectNo", "");
                retJSON.put("CheXiaoRiQi", "");
                retJSON.put("XingZhengXuKeJueDingWenShuMing", "保安服务公司许可证");
                retJSON.put("FaRenShenFenZhengHao",p.getLegalPerson());
                retJSON.put("XuKeBianHao",p.getPublicSecurityLicenseNumber());
                retJSON.put("XingZhengXuKeJueDingShuWenHao", "");
                retJSON.put("ShuiWuDengJiHao", "");
                retJSON.put("XuKeShengXiaoQi",p.getGiveLicenseDate());
                retJSON.put("TongYiSheHuiXinYongDaiMa", p.getSocialCode());
                retJSON.put("XingZhengXiangDuiRenMingChen", p.getName());
                retJSON.put("DangQianZhuangTaiXiaLaKuang", "有效");
                retJSON.put("BianGengQianNaRong", "");
                retJSON.put("XingZhengXiangDuiRenDaiMa_5Shi", "");
                retJSON.put("XuKeCheXiaoYuanYin", "");
                retJSON.put("XuKeJiGuanTongYiSheHuiXinYongD", "");
                retJSON.put("ShuJuGengXinShiJianChuo", "");
                retJSON.put("XuKeJieZhiQi", "");
                retJSON.put("ZhengJianLeiXing", "保安服务公司许可证");
                retJSON.put("BeiZhu", "");
                retJSON.put("XuKeZhuXiaoYuanYin", "");
                retJSON.put("BianGengShiXiang", "");
                retJSON.put("QiTaWuXiaoRiQi", "");
                retJSON.put("FaDingDaiBiaoRenXingMing", p.getLegalPerson());
                retJSON.put("XuKeZhengShuMingChen", "保安服务公司许可证");
                retJSON.put("XingZhengXuKeLeiBie", "行政许可设立信息");
                retJSON.put("XuKeNaRong", "服务范围");
                retJSON.put("BianGengHouNaRong", "服务范围");
                retJSON.put("XuKeDiaoXiaoYuanYin", "服务范围");
                retJSON.put("QiTaWuXiaoYuanYin", "");

                retJSON.put("ShenPiLeiBieXiaLaKuang", "普通");
                retJSON.put("XingZhengXiangDuiRenDaiMa_6Shi", "");
                retJSON.put("XuKeJiGuan", "广西壮族自治区公安厅治安警察总队二支队");
                retJSON.put("DiFangBianMa", "450000");
                retJSON.put("GaiXiangMuShiFuSheMi", "");
                retJSON.put("YouXiaoQiZi", "");
                retJSON.put("GongShangDengJiMa", "");
                retJSON.put("XiangMuMingChen", "保安服务公司设立");
                retJSON.put("ZuZhiJiGouDaiMa", "");
                retJSON.put("JiMinShenFenZhengHao", "");
                retJSON.put("BianGengRiQi", "");
                retJSON.put("ZhuXiaoRiQi", "");
                retJSON.put("flag", "0");
                retJSON.put("DiaoXiaoRiQi", "");
                retJSON.put("status", "1");
                retJSON.put("insert_time", "");
                JSONArray jsonArray = new JSONArray();
                jsonArray.add(retJSON);//可传多条，最多20条
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("sgsFormData",jsonArray);
                System.out.println(jsonArray);
                System.out.println(jsonObject);
                interfaceLog.setParameters(jsonArray.toString());
                String result = HttpRequest.sendPost(url,jsonObject);//发送请求
                interfaceLog.setResult(result);
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                interfaceLog.setResult(e.getMessage());
            }
            /**
             * 异步保存
             */
            new Thread(()->{

                interfaceLogDao.insert(interfaceLog);
            }).start();


        }
    }

    /**
     * java发送raw
     * @author zengwei
     */
    private   String deviceRequest(String url,String paramMap) {


        JSONObject retJSON = new JSONObject();
        retJSON.put("bsnum", "123");
        retJSON.put("EntName", "dsd");
        retJSON.put("UniSCID", "fv");
        retJSON.put("docUnid", "sds");
        retJSON.put("OrgCode", "df");
        retJSON.put("LeRep", "Zsd");
        retJSON.put("CerType", "sds");
        retJSON.put("CerNO", "cc");
        retJSON.put("Name", "bb");
        retJSON.put("itemNo", "ss");
        retJSON.put("itmenNo", "asa");
        retJSON.put("state", "sda");
        retJSON.put("DataDept", "df");
        retJSON.put("DataDeptUniSCID", "fgf");
        retJSON.put("DataUpdateDept", "sdfs");
        retJSON.put("Remark", "asd");
        retJSON.put("create_time", "ads");
        retJSON.put("back1", "df");
        retJSON.put("back2", "sdf");
        retJSON.put("back3", "fgc");
        retJSON.put("back4", "ghxcvf");
        retJSON.put("back5", "as");
        retJSON.put("flag", "1");

        JSONArray jsonArray = new JSONArray();
        jsonArray.add(retJSON);//可传多条，最多20条
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sgsBjData",jsonArray);
        System.out.println(jsonArray);
        System.out.println(jsonObject);
        /*String url="http://127.0.0.1:8080/test/test2";*/
        String result = HttpRequest.sendPost(url,jsonObject);//发送请求
        return result;

//        try {
//            JSONObject json = new JSONObject();
//            json.put("sgsBjData",paramMap);
//            @SuppressWarnings({"resource"})
//            HttpClient httpClient = new DefaultHttpClient();
//            HttpPost post = new HttpPost(url);
//            StringEntity postingString = new StringEntity(json.toJSONString(),"utf-8");
//            post.setEntity(postingString);
//            post.setHeader("Content-type", "application/json");
//            HttpResponse response = httpClient.execute(post);
//            String content = EntityUtils.toString(response.getEntity(),"utf-8");
//            System.out.println(content);
//            return content;
//        } catch (Exception e) {
//            e.printStackTrace();
//            return e.getMessage();
//        }


    }
}
