package com.bcxin.ars.service.conference.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.UserDto;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.conference.*;
import com.bcxin.ars.service.conference.CloudConferenceRoomService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.huawei.HuaweiMeetConst;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Base64;
import java.util.List;
import java.util.Map;

/**
 * @author zhangyutong
 */
@Service
@Slf4j
public class CloudConferenceRoomServiceImpl implements CloudConferenceRoomService {

    @Resource
    private UserDao userDao;

    @Resource
    private ConfigUtils configUtils;

    @Resource
    private ArsUtil arsUtil;

    @Override
    public AjaxPageResponse<CloudConferenceRoomSearchDto> listCloudConferenceRoom(CloudConferenceRoomSearchDto cloudConferenceRoomSearchDto) {

        AjaxPageResponse<CloudConferenceRoomSearchDto> ajaxPageResponse = new AjaxPageResponse<>();

        // 获取鉴权token请求头
        String accessToken = arsUtil.getHuaweiMeetAccessToken(configUtils.getValueByKey(Constants.HeiweiconferenceAccount), configUtils.getValueByKey(Constants.HeiweiconferencePassword), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());

        // 请求url拼接
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_CLOUD_MEETING_ROOM;

        // 参数列表, 接口详见https://apiexplorer.developer.huaweicloud.com/apiexplorer/doc?product=Meeting&api=SearchCorpVmr
        Map<String, Object> params = Maps.newHashMapWithExpectedSize(10);
        params.put("offset", cloudConferenceRoomSearchDto.getPageNum());
        params.put("limit", cloudConferenceRoomSearchDto.getNumPerPage());
        params.put("searchKey", cloudConferenceRoomSearchDto.getSearchKey());
        params.put("status", cloudConferenceRoomSearchDto.getStatus());

        // 构建http请求
        HttpResponse response = HttpUtil
                .createGet(url)
                .form(params)
                .header("Authorization", "Basic " + authorization)
                .execute();

        // 获取响应体
        String responseBody = response.body();
        JSONObject responseJson = JSONUtil.parseObj(responseBody);
        // 请求失败 400/401/403/
        if (response.getStatus() != HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
            String errorCode = responseJson.getStr("error_code");
            String errorMsg = responseJson.getStr("error_msg");
            log.error("请求获取华为云会议室接口错误,error_code:{},error_msg:{}", errorCode, errorMsg);
            ajaxPageResponse.setCode(errorCode);
            ajaxPageResponse.setMessage("请求华为云会议接口错误" + errorMsg);
            return ajaxPageResponse;
        }

        // 请求成功 200
        List data = responseJson.get("data", List.class);
        List<CloudConferenceRoomDto> cloudConferenceRooms = Lists.newArrayList();
        for (Object item : data) {
            CloudConferenceRoom roomInstance = JSONUtil.toBean((JSONObject) item,CloudConferenceRoom.class);
            CloudConferenceRoomDto roomDto = new CloudConferenceRoomDto();
            BeanUtils.copyProperties(roomInstance, roomDto);
            CloudConferenceRoomDevice device = roomInstance.getDevice();
            if (device != null) {
                roomDto.setDeviceId(roomInstance.getDevice().getId());
                roomDto.setDeviceMark(roomInstance.getDevice().getMark());
            }
            CloudConferenceRoomMember member = roomInstance.getMember();
            if (member != null) {
                roomDto.setMemberId(roomInstance.getMember().getId());
                roomDto.setMemberMark(roomInstance.getMember().getMark());
            }
            cloudConferenceRooms.add(roomDto);
        }
        log.info("华为云会议返回云会议室列表:{}", data);
        ajaxPageResponse.setData(cloudConferenceRooms);
        ajaxPageResponse.setTotal(responseJson.getInt("count"));
        ajaxPageResponse.setPageNumber(responseJson.getInt("offset"));
        ajaxPageResponse.setPageSize(responseJson.getInt("limit"));
        return ajaxPageResponse;
    }

    @Override
    public AjaxResult recycleVmr(String[] ids, String memberId) {
        AjaxResult ajaxResult = new AjaxResult();
        ajaxResult.setSuccessful(true);
        if (ids == null || memberId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode(Constants.REQUEST_CODE_FAIL);
            ajaxResult.setMsg("参数不能为空");
            return ajaxResult;
        }
        // 获取鉴权token请求头
        String accessToken = arsUtil.getHuaweiMeetAccessToken(configUtils.getValueByKey(Constants.HeiweiconferenceAccount), configUtils.getValueByKey(Constants.HeiweiconferencePassword), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());

        // 请求url拼接
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.RECYCLE_CLOUD_MEETING_ROOM.replace("{account}",memberId);

        // 接口详见https://apiexplorer.developer.huaweicloud.com/apiexplorer/doc?product=Meeting&api=DisassociateVmr
        HttpResponse response = HttpUtil.createRequest(Method.POST,url)
                .header("Authorization", "Basic " + authorization)
                .body(JSONUtil.toJsonStr(ids))
                .execute();

        String body = response.body();
        // 请求不成功
        if (response.getStatus() != HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
            JSONObject jsonObject = JSONUtil.parseObj(body);
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode(jsonObject.getStr("error_code"));
            ajaxResult.setMsg(jsonObject.getStr("error_msg"));
            return ajaxResult;
        }
        ajaxResult.setMsg("回收成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult assignVmr(String[] ids, String memberId) {
        AjaxResult ajaxResult = new AjaxResult();
        ajaxResult.setSuccessful(true);
        if (ids == null || memberId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode(Constants.REQUEST_CODE_FAIL);
            ajaxResult.setMsg("参数不能为空");
            return ajaxResult;
        }
        // 获取鉴权token请求头
        String accessToken = arsUtil.getHuaweiMeetAccessToken(configUtils.getValueByKey(Constants.HeiweiconferenceAccount), configUtils.getValueByKey(Constants.HeiweiconferencePassword), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString((accessToken).getBytes());

        // 请求url拼接
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.ASSIGN_CLOUD_MEETING_ROOT.replace("{account}",memberId);

        // 接口详见https://apiexplorer.developer.huaweicloud.com/apiexplorer/doc?product=Meeting&api=DisassociateVmr
        HttpResponse response = HttpUtil.createRequest(Method.POST,url)
                .header("Authorization", "Basic " + authorization)
                .body(JSONUtil.toJsonStr(ids))
                .execute();

        String body = response.body();
        // 请求不成功
        if (response.getStatus() != HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
            JSONObject jsonObject = JSONUtil.parseObj(body);
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode(jsonObject.getStr("error_code"));
            ajaxResult.setMsg(jsonObject.getStr("error_msg"));
            return ajaxResult;
        }
        ajaxResult.setMsg("分配成功");
        return ajaxResult;
    }

    @Override
    public AjaxPageResponse<UserDto> getAssignList(UserSearchDto userSearchDto,
                                                   AjaxPageResponse<UserDto> userDtoAjaxPageResponse) {
        List<UserDto> users = userDao.searchForAssign(userSearchDto, userDtoAjaxPageResponse);
        return userDtoAjaxPageResponse;
    }

}
