package com.bcxin.ars.service.certificate.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.certificate.CertificatePrintLogDao;
import com.bcxin.ars.dao.certificate.PerCerSnapshotDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.certificate.SecurityCerDto;
import com.bcxin.ars.dto.certificate.SecurityCertificateSearchDto;
import com.bcxin.ars.dto.page.SecurityCertificateDto;
import com.bcxin.ars.dto.page.SecurityCertificatePageSearchDto;
import com.bcxin.ars.dto.v5.SecurityCertificateV5Dto;
import com.bcxin.ars.dto.v5.V5ResultDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.certificate.CertificatePrintLog;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.*;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityCertificate.class, getSeq = 20000, getDataSyncType = SyncType.SYNC)
@DataSyncOutAnnotation(getClazz = SecurityCertificate.class, getSeq = 20000, getDataSyncType = SyncType.SYNC)
public class SecurityCertificateServiceImpl extends BaseService implements SecurityCertificateService {
    /***
     * 日志
     */
    public static final Logger logger = LoggerFactory.getLogger(SecurityCertificateServiceImpl.class);
    @Autowired
    private SecurityCertificateDao securityCertificateDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private CertificatePrintLogDao certificatePrintLogDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;

    @Autowired
    private GetPersonImgUtil getPersonImgUtil;

    @Autowired
    private ConfigDao configDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;

    @Autowired
    private PersonImgDao personImgDao;

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    @Autowired
    private PerCerSnapshotDao perCerSnapshotDao;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private SysDictUtils sysDictUtils;

    @Autowired
    private PersonBaseInfoService personBaseInfoService;

    @Autowired
    private PhotoUtil photoUtil;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private OrgnoDao orgnodao;

    @Value("${temp-folder}")
    private String tempFolder;

    @Value("${BBD_H5_URL}")
    private String bbdH5Url;


    @Override
    public SecurityCertificate findById(Long id) {
        return securityCertificateDao.findById(id);
    }

    @Override
    public void saveOrUpdate(SecurityCertificate securityCertificate) {
        User currentUser = arsUtil.getCurrentUser();

        if (securityCertificate.getId() == null) {
            SecurityCertificate dbPersonCertificate = securityCertificateDao.findBySecuritypersonid(securityCertificate.getSecuritypersonid());
            if (dbPersonCertificate != null) {
                //复制值
                BeanUtils.copyPropertiesIgnore(securityCertificate, dbPersonCertificate, true);
                dbPersonCertificate.setUpdateBy(currentUser.getUsername());
                dbPersonCertificate.setUpdateTime(new Date());
                securityCertificateDao.update(dbPersonCertificate);
            } else {
                securityCertificate.setActive(true);
                securityCertificate.setCreateTime(new Date());
                securityCertificate.setUpdateTime(new Date());
                securityCertificate.setUpdateBy(currentUser.getUsername());
                //默认录入证书的时候，打印状态为未打印
                securityCertificate.setIsprint(false);

                //TODO
                //保安员证编号规则：第一个字为省、自治区、直辖市简称，后面12位数字中，前两位是发证设区市公安机关编号，中间四位是发证年份，最后六位是发证顺序号，从000001开始。
                SimpleDateFormat simpleDateFormat;
                simpleDateFormat = new SimpleDateFormat("yyyy");
                Date date = new Date();
                String native_short = configUtils.getValueByKey("current_native_short");
                String year = "";
                if (StringUtil.isNotEmpty(native_short)) {
                    year = native_short + securityCertificate.getFzjgbh().substring(0, 2) + simpleDateFormat.format(date);
                }
                SecurityCertificateSearchDto searchdto = new SecurityCertificateSearchDto();
                searchdto.setZsbh(year);
                String maxZsbh_year = securityCertificateDao.searchMaxZsbhCount(searchdto);
                if (StringUtils.isEmpty(maxZsbh_year)) {
                    maxZsbh_year = year + "000001";
                } else {
                    maxZsbh_year = maxZsbh_year.substring(0, 3)
                            + String.valueOf((Long.valueOf(maxZsbh_year.substring(3)) + 1));
                }
                securityCertificate.setZsbh(maxZsbh_year);

                securityCertificate.setId(idWorker.nextId());


                String photo = getPhotoUrl(securityCertificate);
                savePerCerSnapshot(securityCertificate, photo);

                securityCertificateDao.save(securityCertificate);

            }

            /***
             * 更新一下审核状态
             */
            ApprovalDTO policeapp = new ApprovalDTO();
            policeapp.setBusinessid(securityCertificate.getSecuritypersonid());
            policeapp.setBusinesstype(BusinessType.BAYZ);
            policeapp.setOrgid(567l);
            List list = approvalDAO.getBusinessidAndType(policeapp);
            if (list != null && list.size() > 0) {
                Approval temp = (Approval) list.get(0);
                temp.setApprovalstate("003");//上传批复文件
                temp.setUpdateTime(new Date());
                approvalDAO.update(temp);
            }
            /***
             * 如果录入证书，状态改成已制证
             */
            Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
            personcertificate.setCardState(Constants.CARD_STATE_YZZ);
            personcertificate.setApplyforstate("003");
            personcertificateDaoAop.update(personcertificate);

            SecurityPerson securityPerson = securityPersonDao.findByIdCard(dbPersonCertificate.getIdnum());
            if (null != securityPerson) {
                securityPerson.setZgcredential(dbPersonCertificate.getZsbh());
                securityPerson.setZgcertificatejgno(dbPersonCertificate.getFzjgbh());
                securityPerson.setZgcertificatejgname(dbPersonCertificate.getFzjgmc());
                securityPerson.setZgcertificatejgtime(dbPersonCertificate.getFzrq() == null ? "" : DateUtil.convertDateToString(dbPersonCertificate.getFzrq(), "yyyy-MM-dd"));
                securityPerson.setZgtraincompanyname(personcertificate.getCompanyname());
                securityPerson.setUpdateTime(new Date());
                securityPersonDaoAop.update(securityPerson);
            }

        } else {
            SecurityCertificate dbPersonCertificate = securityCertificateDao.findById(securityCertificate.getId());
            dbPersonCertificate.setUpdateBy(currentUser.getUsername());
            dbPersonCertificate.setUpdateTime(new Date());
            dbPersonCertificate.setAddress(securityCertificate.getAddress());
            dbPersonCertificate.setCsrq(securityCertificate.getCsrq());
            dbPersonCertificate.setFzrq(securityCertificate.getFzrq());
            dbPersonCertificate.setIdnum(securityCertificate.getIdnum());
            dbPersonCertificate.setXm(securityCertificate.getXm());
            dbPersonCertificate.setZsbh(securityCertificate.getZsbh());
            dbPersonCertificate.setZzrq(securityCertificate.getZzrq());
            dbPersonCertificate.setZzzt(securityCertificate.getZzzt());

            dbPersonCertificate.setFzjgbh(securityCertificate.getFzjgbh());
            dbPersonCertificate.setFzjgmc(securityCertificate.getFzjgmc());


            securityCertificateDao.update(dbPersonCertificate);

            SecurityPerson securityPerson = securityPersonDao.findByIdCard(securityCertificate.getIdnum());
            if (null != securityPerson) {
                securityPerson.setZgcredential(securityCertificate.getZsbh());
                securityPerson.setZgcertificatejgno(securityCertificate.getFzjgbh());
                securityPerson.setZgcertificatejgname(securityCertificate.getFzjgmc());
                securityPerson.setZgcertificatejgtime(securityCertificate.getFzrq() == null ? "" : DateUtil.convertDateToString(securityCertificate.getFzrq(), "yyyy-MM-dd"));
                securityPerson.setUpdateTime(new Date());
                securityPersonDaoAop.update(securityPerson);
            }
        }
    }

    @Override
    public SecurityCertificateSearchDto search(SecurityCertificateSearchDto dto) {
        SecurityCertificateSearchDto resultDto = new SecurityCertificateSearchDto();
        List<SecurityCertificate> list = securityCertificateDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(securityCertificateDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public void delete(SecurityCertificate securityCertificate) {
        User currentUser = arsUtil.getCurrentUser();
        securityCertificate.setUpdateBy(currentUser.getUsername());
        securityCertificate.setUpdateTime(new Date());
        securityCertificateDao.delete(securityCertificate);
    }

    /**
     * 根据申请ID查询证书信息
     *
     * @param securitypersonid
     * @return
     */
    @Override
    public SecurityCertificate findBySecuritypersonid(long securitypersonid, String type) {
        SecurityCertificate result = securityCertificateDao.findBySecuritypersonid(securitypersonid);
        Config config = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
        Config H5UrlConfig = configDao.findByKey("H5URL" + config.getValue());
        //保安员报名信息
        Personcertificate personcertificate = personcertificateDao.findById(result.getSecuritypersonid());
        String data = "";
        String pathName = "";
        //设置图片信息
        setPhotoData(result);
        try {
            //二维码
            //寻找匹配ID所对应的  personID  并加密 拼接到 URL地址，并生成二维码
            data = DES3.encode(JSON.toJSONString(result.getSecuritypersonid(), SerializerFeature.WriteDateUseDateFormat));
            //民族
            result.setNation(sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty(personcertificate.getNation()) ? "01" : personcertificate.getNation()));
            //选择打印地址
            if (Constants.ADDRESS_TYPE_POPULATION.equals(type)) {
                result.setAddress(personcertificate.getPopulationAddress());
            } else {
                result.setAddress(personcertificate.getAddress());
            }
            if (null != config && null != H5UrlConfig) {
                pathName = QRCodeUtil.generateQRCode(bbdH5Url + Constants.SELECT_CARD_URL + URLEncoder.encode(data, Constants.CHARSETUTF8) + H5UrlConfig.getValue(), 100, 100, "jpg", tempFolder + "qrcode.jpg");
                result.setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);

        }
        return result;
    }

    @Override
    public String getQRCode(String snapshotId) throws Exception {
        System.out.println(getElectronCerUrl(snapshotId));
        return QRCodeUtil.generateBase64QRCode(getElectronCerUrl(snapshotId), 100, 100, "jpg");
    }

    @Override
    public String getQRCodeForThirdParty(String snapshotId) throws Exception {
        /*System.out.println(getElectronCerUrl(snapshotId));*/
        return QRCodeUtil.generateBase64QRCodeForThirdParty(getElectronCerUrl(snapshotId), 100, 100, "jpg");
    }

    @Override
    public String getElectronCerUrl(String snapshotId) throws Exception {
        String cerUrl = configUtils.getValueByKey("PERCERURL" + configUtils.getCurrentProvince());
        snapshotId = URLEncoder.encode(snapshotId, "UTF-8");
        return cerUrl + "/securityCertificate/viewCer.do?snapshotId=" + snapshotId;
    }

    @Override
    public SecurityCertificate previewById(Long id, String type) {
        SecurityCertificate securityCertificate = securityCertificateDao.findById(id);
        //民族
        securityCertificate.setNation(sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty(securityCertificate.getNation()) ? "01" : securityCertificate.getNation()));
        //选择打印地址
        if (Constants.ADDRESS_TYPE_POPULATION.equals(type)) {
            securityCertificate.setAddress(securityCertificate.getPopulationAddress());
        }
        //设置图片信息
        String photo = setPhotoData(securityCertificate);
        Long snapshotId = savePerCerSnapshot(securityCertificate, photo);

        try {
            //二维码
            Base64Utils.encodeToString(snapshotId.toString().getBytes("UTF-8"));
            securityCertificate.setQrcode(this.getQRCode(DES3.encode(snapshotId.toString())));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }

        securityCertificate.setSnapshotId(snapshotId);
        return securityCertificate;
    }

    @Override
    public Long savePerCerSnapshot(SecurityCertificate securityCertificate, String photo) {
        User currentUser = arsUtil.getCurrentUser();
        //生成预览记录
        PerCerSnapshot perCerSnapshot = new PerCerSnapshot();
        perCerSnapshot.setPersonId(securityCertificate.getPersonId());
        perCerSnapshot.setCerId(securityCertificate.getId());
        perCerSnapshot.setName(securityCertificate.getXm());
        perCerSnapshot.setBirthDate(securityCertificate.getCsrq());
        perCerSnapshot.setPhone(securityCertificate.getPhone());
        perCerSnapshot.setIdNum(securityCertificate.getIdnum());
        perCerSnapshot.setComName(securityCertificate.getCompanyName());
        perCerSnapshot.setPhoto(photo);
        perCerSnapshot.setAddress(securityCertificate.getAddress());
        perCerSnapshot.setCerNo(securityCertificate.getZsbh());
        perCerSnapshot.setIssueDate(DateUtil.convertDateToString(securityCertificate.getFzrq(), DateUtil.FORMAT2));
        perCerSnapshot.setOrgName(securityCertificate.getFzjgmc());
        perCerSnapshot.setUpdateflag(true);
        perCerSnapshot.setId(idWorker.nextId());
        perCerSnapshot.setActive(true);
        perCerSnapshot.setCreateTime(new Date());
        perCerSnapshot.setUpdateTime(new Date());
        if (currentUser != null) {
            perCerSnapshot.setUpdateBy(currentUser.getUsername());
            perCerSnapshot.setUserid(currentUser.getId());
        } else {
            perCerSnapshot.setUpdateBy("system");
        }
        perCerSnapshotDao.save(perCerSnapshot);
        securityCertificate.setSnapshotId(perCerSnapshot.getId());
        return perCerSnapshot.getId();
    }

    @Override
    public List<SecurityCertificate> previewByIdArr(SecurityCertificateSearchDto dto) {
        Map<Long, String> typeMap = new HashMap<>();
        for (int i = 0; i < dto.getIdArray().length; i++) {
            typeMap.put(dto.getIdArray()[i], dto.getTypes()[i]);
        }

        List<SecurityCertificate> securityCertificateList = securityCertificateDao.findByIdArr(dto.getIdArray());
        for (SecurityCertificate securityCertificate : securityCertificateList) {
            //民族
            securityCertificate.setNation(sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty(securityCertificate.getNation()) ? "01" : securityCertificate.getNation()));
            //选择打印地址
            if (Constants.ADDRESS_TYPE_POPULATION.equals(typeMap.get(securityCertificate.getId()))) {
                securityCertificate.setAddress(securityCertificate.getPopulationAddress());
            } else {
                securityCertificate.setAddress(securityCertificate.getAddress());
            }
            //设置图片信息
            String photo = setPhotoData(securityCertificate);

            //生成预览记录
            Long snapshotId = savePerCerSnapshot(securityCertificate, photo);
            try {
                //二维码
                Base64Utils.encodeToString(snapshotId.toString().getBytes("UTF-8"));
                securityCertificate.setQrcode(this.getQRCode(DES3.encode(snapshotId.toString())));
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }

            securityCertificate.setSnapshotId(snapshotId);
        }

        return securityCertificateList;
    }

    @Override
    public Boolean checkCerStatus(String idNum) {
        SecurityCertificate certificate = securityCertificateDao.findByIdnum(idNum);
        if (certificate != null) {
            return true;
        }
        return false;
    }

    @Override
    public AjaxResult checkStatusForApply(String idNum) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        Boolean flag = false;
        SecurityPerson securityPerson = securityPersonDao.findByIdCard(idNum);
        if (securityPerson == null) {
            result.setMsg("该学员不存在入职记录！");
        } else if (Constants.IDENTITYAUTHSTATE_Y.equals(securityPerson.getIdentityAuthState())) {
            flag = true;
        } else {
            result.setMsg("该学员未实名认证通过！");
        }
        if (flag) {
            SecurityCompany company = securityPerson.getRelation().getCompany();
            if (company != null && StringUtil.isNotEmpty(company.getAreaCode()) && (
                    Constants.YANAN_S.equals(company.getAreaCode().substring(0, 4))
                            || Constants.SHANGLUO_S.equals(company.getAreaCode().substring(0, 4)))) {
                SecurityCertificate certificate = securityCertificateDao.findByIdnum(idNum);
                //延安资格证报名去掉旧证校验 发证日期 2020.11.16之前考证的都为旧证
                if (certificate != null && certificate.getFzrq() != null && certificate.getFzrq().getTime() > DateUtil.convertStringToDate("2020-11-16").getTime()) {
                    flag = false;
                    result.setMsg("该学员已持有保安员资格证！");
                } else {
                    //通过保安员id查询待审批、审批中或者审批通过的数据
                    Personcertificate personcertificate = personcertificateDao.findApprovalingByIdNumForYanAn(idNum);
                    if (personcertificate != null) {
                        flag = false;
                        result.setMsg("该学员已报名保安员资格证！");
                    }
                }
            } else if (Constants.ZGZBT_SWITCH_1.equals(configUtils.getValueByKey(Constants.ZGZBT_SWITCH))) {
                SecurityCertificate certificate = securityCertificateDao.findByIdnum(idNum);
                if (certificate != null) {
                    flag = false;
                    result.setMsg("该学员已持有保安员资格证！");
                }

                if (flag) {
                    Personcertificate personcertificate = personcertificateDao.findApprovalingByIdNum(idNum);
                    if (personcertificate != null) {
                        flag = false;
                        result.setMsg("该学员已报名保安员资格证！");
                    }
                }
            } else {
                //通过保安员id查询待审批、审批中或者审批通过的数据
                Personcertificate personcertificate = personcertificateDao.findApprovaling(securityPerson.getId());
                if (personcertificate != null) {
                    flag = false;
                    result.setMsg("该学员已报名保安员资格证！");
                }
            }
        }
        result.setData(flag);
        return result;
    }

    @Override
    public void updateSnapshotId(SecurityCertificate securityCertificate) {
        securityCertificateDao.updateSnapshotId(securityCertificate);
    }

    @Override
    public void updateBatchSnapshotId(List<SecurityCertificate> list) {
        securityCertificateDao.updateBatchSnapshotId(list);
    }

    @Override
    public List<String> updateIsDraw(List<String> idNums) {
        //批量查询是否存在数据库中
        List<String> existIdNum = securityCertificateDao.selectIdNums(idNums);
        //更新在数据库中的isDraw为1
        if (existIdNum.size() > 0) {
            securityCertificateDao.updateIsDraw(existIdNum);
        }
        //返回不在数据库中的身份证集合
        if (existIdNum.size() < idNums.size()) {
            idNums.removeAll(existIdNum);
            return idNums;
        }
        return null;
    }

    @Override
    public List<SecurityCertificate> findAddressByIdArr(Long[] idArr) {
        return securityCertificateDao.findByIdArr(idArr);
    }

    @Override
    public void reCer(Long cerId) {
        //生成保安员证
        SecurityCertificate securityCertificate = securityCertificateDao.findById(cerId);
        securityCertificate.setActive(true);
        securityCertificate.setUpdateTime(new Date());
        //默认录入证书的时候，打印状态为未打印
        securityCertificate.setIsprint(false);

        //TODO
        //保安员证编号规则：第一个字为省、自治区、直辖市简称，后面12位数字中，前两位是发证设区市公安机关编号，中间四位是发证年份，最后六位是发证顺序号，从000001开始。
        SimpleDateFormat simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String current_native_short = configUtils.getValueByKey("current_native_short");
        String year = "";
        if (StringUtil.isNotEmpty(current_native_short)) {
            if (StringUtil.isNotEmpty(securityCertificate.getAreaCode())) {
                Orgno orgno = orgnodao.findByAreaCode(securityCertificate.getAreaCode().substring(0, 4));
                if (orgno != null && StringUtil.isNotEmpty(orgno.getOrgName())) {
                    securityCertificate.setFzjgmc(orgno.getOrgName());
                }
                if (orgno != null && StringUtil.isNotEmpty(orgno.getOrgnum())) {
                    year = current_native_short + orgno.getOrgnum().substring(2, 4) + simpleDateFormat.format(date);
                    securityCertificate.setFzjgbh(orgno.getOrgnum());
                }

            }

        }
        if (StringUtil.isEmpty(year)) {
            return;
        }
        SecurityCertificateSearchDto searchdto = new SecurityCertificateSearchDto();
        searchdto.setZsbh(year);
        String maxZsbh_year = securityCertificateDao.searchMaxZsbhCount(searchdto);

        if (StringUtils.isEmpty(maxZsbh_year)) {
            maxZsbh_year = year + "000001";
        } else {
            maxZsbh_year = maxZsbh_year.substring(0, 7)
                    + StringUtil.addZeroForNum(String.valueOf((Long.valueOf(maxZsbh_year.substring(7)) + 1)), 6);
        }

        securityCertificate.setZsbh(maxZsbh_year);

        securityCertificate.setUpdateflag(true);

        securityCertificateDao.update(securityCertificate);

        perCerSnapshotDao.updateByCer(securityCertificate);

        if (securityCertificate.getPersonId() != null) {
            //证书信息同步到保安人员
            updateSecurityPersonCertificateInfo(securityCertificate);
        }
    }


    @Override
    public SecurityCertificate findBySecuritypersonid(long securitypersonid) {
        return findBySecuritypersonid(securitypersonid, Constants.ADDRESS_TYPE_POPULATION);
    }

    /**
     * @param dto
     * @return
     * @author wjb
     * @time 2018年8月24日17:21:10 增加二维码
     * 批量打印
     */
    @Override
    public List<SecurityCertificate> findBySecuritypersonidArr(SecurityCertificateSearchDto dto) {
        Config config = configDao.findByKey("current_province");

        List<SecurityCertificate> securityCertificateList = securityCertificateDao.findBySecuritypersonidArr(dto);
        //返回图片
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

        String data;
        for (int i = 0; i < securityCertificateList.size(); i++) {
            if (null != securityCertificateList.get(i)) {
                securityCertificateList.get(i).setPhoto(getPersonImgUtil.getPersonImg(securityCertificateList.get(i).getIdnum()));
                try {
                    if (null != securityCertificateList.get(i).getSecuritypersonid()) {
                        //寻找匹配ID所对应的  personID  并加密 拼接到 URL地址，并生成二维码
                        data = DES3.encode(JSON.toJSONString(securityCertificateList.get(i).getSecuritypersonid(), SerializerFeature.WriteDateUseDateFormat));
                        String pathName = "";
                        if (null != config) {
                            Config H5UrlConfig = configDao.findByKey("H5URL" + config.getValue());
                            if (null != H5UrlConfig) {
                                pathName = QRCodeUtil.generateQRCode(bbdH5Url + Constants.SELECT_CARD_URL + URLEncoder.encode(data, "utf-8") + H5UrlConfig.getValue(), 100, 100, "jpg", tempFolder + "qrcode.jpg");
                            }
                            securityCertificateList.get(i).setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage(), e);
                }
            }
        }

        return securityCertificateList;
    }

    /**
     * 批量更新打印状态
     *
     * @param securitypersonid
     * @param printType        打印类型
     */
    @Override
    public void updatePrintedByLog(Long securitypersonid, String printType) {
        User currentUser = arsUtil.getCurrentUser();
        /***
         * 步骤1: 更新打印状态、打印次数、打印时间
         */

        SecurityCertificate securityCertificate = securityCertificateDao.findBySecuritypersonid(securitypersonid);
        if (securityCertificate.getPrintcount() == null || securityCertificate.getPrintcount().equals("")) {
            securityCertificate.setPrintcount("1");
        } else {
            int printcount = Integer.parseInt(securityCertificate.getPrintcount()) + 1;
            securityCertificate.setPrintcount(printcount + "");
        }
        //打印时间
        setSecurityCertificate(securityCertificate, currentUser.getUsername());
        securityCertificateDao.updatePrinteStateForBj(securityCertificate);
        /***
         * 步骤2: 记录打印日志
         */
        CertificatePrintLog log = setCertificatePrintLog(currentUser.getUsername(), securityCertificate.getXm(), securityCertificate.getIdnum(),
                securityCertificate.getZsbh(), currentUser.getRealname(), currentUser.getId());
        //打印类型
        log.setPrintType(printType);
        certificatePrintLogDao.save(log);
    }


    /**
     * 批量更新打印状态
     *
     * @param idArray
     */
    @Override
    public void updatePrintedByidArr(Long[] idArray) {
        User user = arsUtil.getCurrentUser();
        //获取打印列表
        SecurityCertificateSearchDto dto = new SecurityCertificateSearchDto();
        dto.setIdArray(idArray);
        dto.setPrintsort(null);
        dto.setPrintorder(null);
        List<SecurityCertificate> securityCertificateList = securityCertificateDao.findBySecuritypersonidArr(dto);
        for (SecurityCertificate securityCertificate : securityCertificateList) {
            CertificatePrintLog log = setCertificatePrintLog(user.getUsername(), securityCertificate.getXm(), securityCertificate.getIdnum(),
                    securityCertificate.getZsbh(), user.getRealname(), user.getId());
            //打印次数
            if (securityCertificate.getPrintcount() == null || securityCertificate.getPrintcount().equals("")) {
                securityCertificate.setPrintcount("1");
                log.setPrintType("1");
            } else {
                int printcount = Integer.parseInt(securityCertificate.getPrintcount()) + 1;
                securityCertificate.setPrintcount(printcount + "");
                log.setPrintType("2");
            }
            //更新打印状态
            setSecurityCertificate(securityCertificate, user.getUsername());
            securityCertificate.setUpdateflag(true);
            securityCertificateDao.updatePrinteCount(securityCertificate);
            certificatePrintLogDao.save(log);
        }
    }

    /**
     * 批量更新打印状态
     *
     * @param idArray
     */
    @Override
    public void updatePrinted(Long[] idArray, Long[] snapshotIdArr, String printType) {
        User user = arsUtil.getCurrentUser();
        //获取打印列表
        SecurityCertificateSearchDto dto = new SecurityCertificateSearchDto();
        dto.setIdArray(idArray);
        dto.setPrintsort(null);
        dto.setPrintorder(null);
        List<SecurityCertificate> securityCertificateList = securityCertificateDao.findBySecuritypersonidArr(dto);
        Map<Long, Long> logMap = new HashMap<>();
        for (int i = 0; i < idArray.length; i++) {
            logMap.put(idArray[i], snapshotIdArr[i]);
        }
        for (SecurityCertificate securityCertificate : securityCertificateList) {
            CertificatePrintLog log = setCertificatePrintLog(user.getUsername(), securityCertificate.getXm(), securityCertificate.getIdnum(),
                    securityCertificate.getZsbh(), user.getRealname(), user.getId());

            //打印次数
            if (securityCertificate.getPrintcount() == null || securityCertificate.getPrintcount().equals("")) {
                securityCertificate.setPrintcount("1");
                log.setPrintType("1");
            } else {
                int printcount = Integer.parseInt(securityCertificate.getPrintcount()) + 1;
                securityCertificate.setPrintcount(printcount + "");
                log.setPrintType("2");
            }
            //如果打印不为空
            if (StringUtil.isNotEmpty(printType)) {
                log.setPrintType(printType);
            }
            //更新打印状态
            setSecurityCertificate(securityCertificate, user.getUsername());
            securityCertificate.setUpdateflag(true);
            securityCertificate.setSnapshotId(logMap.get(securityCertificate.getSecuritypersonid()));
            securityCertificateDao.updatePrinteCount(securityCertificate);
            certificatePrintLogDao.save(log);
        }
    }

    /**
     * //更新打印状态参数设置
     *
     * @param securityCertificate
     * @param userName
     * @return
     */
    public SecurityCertificate setSecurityCertificate(SecurityCertificate securityCertificate, String userName) {
        securityCertificate.setPrintTime(new Date());
        securityCertificate.setUpdateTime(new Date());
        securityCertificate.setUpdateBy(userName);
        securityCertificate.setIsprint(true);
        return securityCertificate;
    }

    /**
     * 记录打印日志参数设置
     *
     * @param userName
     * @param scXm
     * @param idNum
     * @param scZsbh
     * @param realName
     * @param userId
     * @return
     */
    public CertificatePrintLog setCertificatePrintLog(String userName, String scXm, String idNum, String scZsbh, String realName, Long userId) {
        CertificatePrintLog log = new CertificatePrintLog();
        log.setActive(true);
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        log.setActive(true);
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        //操作者
        log.setUpdateBy(userName);
        //姓名
        log.setName(scXm);
        //身份证号
        log.setIdnum(idNum);
        //证书编号
        log.setSecurityCertificateNo(scZsbh);
        //打印人员
        log.setPrintName(realName);
        //打印机构ID
        log.setTrainOrgId(userId);
        return log;
    }

    @Override
    public void updatePrinteCount(SecurityCertificate securityCertificate) {
        securityCertificateDao.updatePrinteCount(securityCertificate);
    }

    @Override
    public List<SecurityCertificate> findDetail(SecurityCertificateSearchDto dto) {
        return securityCertificateDao.findDetail(dto);
    }

    @Override
    public List<SecurityCertificate> searchUpdateflagForExport() {
        return securityCertificateDao.searchUpdateflagForExport(DateUtil.getYesterday());
    }


    /**
     * 外网导入 --保存或者更新（更新到外网数据库）
     *
     * @param cert
     */
    @Override
    @Deprecated
    public void outerSaveOrUpdateForDS(SecurityCertificate cert) {
        logger.info("saveOrupdate... " + cert);
        try {
            if (cert.getId() == null) {
                throw new ArsException("id缺失");
            } else {
                Boolean isEdit = false;
                SecurityCertificate dbCert = securityCertificateDao.findById(cert.getId());
                if (dbCert == null) {
                    cert.setUpdateflag(false);
                    securityCertificateDao.save(cert);
                } else {
                    //对比下时间轴，验证时候更新  导入的时间 > 本地时间
                    if (cert.getUpdateTime().getTime() > dbCert.getUpdateTime().getTime()) {
                        cert.setUpdateflag(false);
                        securityCertificateDao.update(cert);
                    }
                }
                if (isEdit) {
                    //证书信息同步到保安人员
                    updateSecurityPersonCertificateInfo(cert);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 批量导入
     *
     * @param list
     */
    @Override
    public void importBatch(List<SecurityCertificate> list) {
        List<SecurityCertificate> dbList = securityCertificateDao.findByBatchId(list);
        //去掉重复的，通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        List<SecurityCertificate> errorList = new Vector<>();
        if (list.size() > 0) {
            /****
             * 步骤1 先更新子站证书数据，再异步调用saas保存消息ID
             */
            for (SecurityCertificate detail : list) {
                detail.setUpdateflag(false);
                try {
                    detail.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                } catch (Exception e) {
                    errorList.add(detail);
                    logger.error(e.getMessage(), e);
                }
            }
            //批量保存,北京打印在外网，只需要更新 updateflag 和updatetime 即可
            if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                securityCertificateDao.saveBatchForImportOutBj(list);
            } else {
                //其它环境所有字段更新
                securityCertificateDao.saveBatch(list);
            }
            /***
             * 步骤2 保安员资格申报审批通过生成证书同步保安员表
             */
            new Thread(() -> {
                //使用线程池
                CountDownLatch workCount = ThreadUtil.newCountDownLatch(list.size());
                ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
                for (SecurityCertificate detail : list) {
                    threadPoolExecutor.execute(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                //保安员资格申报审批通过生成证书同步保安员表
                                updateSecurityPersonCertificateInfo(detail);
                            } catch (Exception e) {
                                errorList.add(detail);
                                logger.error(e.getMessage(), e);
                            } finally {
                                workCount.countDown();
                            }
                        }
                    });
                }
                try {
                    //线程等待全部数据文件生成完成
                    workCount.await();
                } catch (InterruptedException e) {
                    logger.error(e.getMessage(), e);
                    Thread.currentThread().interrupt();
                } finally {
                    threadPoolExecutor.shutdown();
                }
            }).start();
        }
    }

    /**
     * 保安员资格申报审批通过生成证书同步保安员表
     *
     * @param detail 保安员证书信息
     */
    @Override
    public AjaxResult updateSecurityPersonCertificateInfo(SecurityCertificate detail) {
        //证书信息同步到保安人员
        SecurityPerson securityPerson = securityPersonDao.findByIdCard(detail.getIdnum());
        if (null != securityPerson) {

            securityPerson.setZgcredential(detail.getZsbh());
            securityPerson.setZgcertificatejgno(detail.getFzjgbh());
            securityPerson.setZgcertificatejgname(detail.getFzjgmc());
            securityPerson.setZgcertificatejgtime(detail.getFzrq() == null ? "" : DateUtil.convertDateToString(detail.getFzrq(), "yyyy-MM-dd"));
            securityPerson.setUpdateTime(new Date());
            securityPersonDaoAop.update(securityPerson);

            if (!configUtils.isIntranet()) {
                detail.setPersonId(securityPerson.getId());
                return pushPersonCertificateToSAAS(detail);
            }

        }
        return null;
    }

    @Override
    public AjaxResult pushPersonCertificateToSAAS(SecurityCertificate SecurityCertificate) {
        PersonInfoDto personDto = new PersonInfoDto();
        if (StringUtil.isNotEmpty(SecurityCertificate.getTrainName())) {
            personDto.setTrainOrganName(SecurityCertificate.getTrainName());
            //personDto.setTrainStartDate();
            //personDto.setTrainEndDate();
        }
        personDto.setIsOldData(StringUtil.isEmpty(SecurityCertificate.getIsOldData()) ? "0" : SecurityCertificate.getIsOldData());
        personDto.setPerId(SecurityCertificate.getPersonId());
        personDto.setCerNo(SecurityCertificate.getZsbh());
        personDto.setLicenceOrgNo(SecurityCertificate.getFzjgbh());
        personDto.setLicenceOrg(SecurityCertificate.getFzjgmc());
        personDto.setLicenceDate(SecurityCertificate.getFzrq() == null ? "" : DateUtil.convertDateToString(SecurityCertificate.getFzrq(), "yyyy-MM-dd"));
        try {
            if (SecurityCertificate.getSnapshotId() == null) {
                String data = DES3.encode(JSON.toJSONString(SecurityCertificate.getSecuritypersonid(), SerializerFeature.WriteDateUseDateFormat));
                Config config = configUtils.getConfigByKey("current_province");
                if (null != config) {
                    Config H5UrlConfig = configUtils.getConfigByKey("H5URL" + config.getValue());
                    if (null != H5UrlConfig) {
                        personDto.setElectronCerUrl(bbdH5Url.replace("/#/", "/$$/") + Constants.SELECT_CARD_URL + URLEncoder.encode(data, "utf-8") + H5UrlConfig.getValue());
                    }
                }
            } else {
                personDto.setElectronCerUrl(getElectronCerUrl(DES3.encode(SecurityCertificate.getSnapshotId().toString())));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }

        //将保安员证书信息推送给SaaS
        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_SECURITYCERTIFICATE_UPDATE, personDto);
        if (!result.isSuccessful()) {
            logger.error(SecurityCertificate.getXm() + result.getMsg());
        }
        return result;
    }


    @Override
    public void edit(SecurityCertificate securityCertificate) {
        User currentUser = arsUtil.getCurrentUser();
        SecurityCertificate dbSecurityCertificate = securityCertificateDao.findById(securityCertificate.getId());

        BeanUtils.copyPropertiesIgnore(securityCertificate, dbSecurityCertificate, true);
        BeanUtils.copyPropertiesIgnore(dbSecurityCertificate, securityCertificate, false);
        securityCertificate.setCsrq(IdNumUtil.getBirthdayByIdCard(securityCertificate.getIdnum()));
        securityCertificate.setUpdateflag(true);
        securityCertificate.setUpdateTime(new Date());
        securityCertificate.setUpdateBy(currentUser.getUsername());
        securityCertificateDao.update(securityCertificate);

        Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if (personcertificate != null) {
            boolean personEdit = false;
            if (StringUtil.isNotEmpty(securityCertificate.getPopulationAddress())
                    && !securityCertificate.getPopulationAddress().equals(personcertificate.getPopulationAddress())) {
                personcertificate.setPopulationAddress(securityCertificate.getPopulationAddress());
                personEdit = true;
            }
            if (StringUtil.isNotEmpty(securityCertificate.getNation())
                    && !securityCertificate.getNation().equals(personcertificate.getNation())) {
                personcertificate.setNation(securityCertificate.getNation());
                personEdit = true;
            }
            if (StringUtil.isNotEmpty(securityCertificate.getXm())
                    && !securityCertificate.getXm().equals(personcertificate.getName())) {
                personcertificate.setName(securityCertificate.getXm());
                personEdit = true;
            }
            if (StringUtil.isNotEmpty(securityCertificate.getIdnum())
                    && !securityCertificate.getIdnum().equals(personcertificate.getCardnumber())) {
                personcertificate.setCardnumber(securityCertificate.getIdnum());
                personEdit = true;
            }

            if (personEdit) {
                personcertificate.setUpdateflag(true);
                personcertificate.setUpdateTime(new Date());
                personcertificate.setUpdateBy(currentUser.getUsername());
                personcertificateDaoAop.update(personcertificate);
            }
        }
    }

    @Override
    public void searchForPage(SecurityCertificatePageSearchDto dto, AjaxPageResponse<SecurityCertificateDto> page) {
        dto.setPoliceBusiness(false);

        User user = arsUtil.getCurrentUser();
        Police police = user.getPolice();
        dto.setUserAreaCode(false);


        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
//				dto.setAreaCode(configUtils.getCurrentProvince());
        } else {
            //数据权限
            if (user.getAreasList() != null && user.getAreasList().size() > 0) {
                dto.setAreasList(user.getAreasList());
                dto.setUserAreaCode(true);
            }

            if (StringUtil.isNotEmpty(dto.getAreaCode())) {
                dto.setUserAreaCode(true);
            } else {
                dto.setAreaCode(police.getAreacode());
            }

        }
        arsUtil.setPoliceSearch(dto);

        //宁夏旧数据取消省市区过滤
        if (StringUtil.isNotEmpty(dto.getOldData()) && Constants.PRINT_TYPE_OLD_YES.equals(dto.getOldData())) {
            if (Constants.NINGXIACODE.equals(configUtils.getCurrentProvince())) {
                dto.setAreaCode(null);
            }
        }

        if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
            dto.setOrgId(police.getId());
        }

        securityCertificateDao.searchForPage(dto, page);
    }

    @Override
    public SecurityCertificate getDetail(Long id) {
        return securityCertificateDao.getDetail(id);
    }

    @Override
    public void relationOldCert(SecurityPerson person) {
        //查询是否有证书
        SecurityCertificate securityCertificate = securityCertificateDao.findByIdnum(person.getIdNumber());
        //有数据并且为旧数据
        if (securityCertificate != null && Constants.OLDDATA_YES.equals(securityCertificate.getIsOldData())) {
            //旧数据的话更新标识
            //证书记录表
            securityCertificate.setUpdateflag(true);
            securityCertificate.setUpdateTime(new Date());
            securityCertificateDao.update(securityCertificate);

            //保安员证记录表
            Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
            personcertificate.setUpdateflag(true);
            personcertificate.setUpdateTime(new Date());
            personcertificate.setPersonid(person.getId());
            personcertificateDaoAop.update(personcertificate);
        }


    }

    @Override
    public List<SecurityCertificate> findBySecuritypersonidArrBatch(SecurityCertificateSearchDto dto) {
        List<SecurityCertificate> securityCertificateList = securityCertificateDao.findBySecuritypersonidArr(dto);
        return securityCertificateList;
    }

    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     *
     * @param cert
     */
    @Override
    public void saveOrUpdateForDS(SecurityCertificate cert) {
        SecurityCertificate dbCert = securityCertificateDao.findById(cert.getId());
        if (dbCert != null) {
            if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                securityCertificateDao.updateForBJDS(cert);
            } else {
                securityCertificateDao.updateFlagForDS(cert.getId());
            }
        } else {
            securityCertificateDao.save(cert);
        }
    }

    /**
     * 查询需要生成同步文件的保安员资格证记录
     *
     * @param dto
     * @return
     */
    @Override
    public List<SecurityCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return securityCertificateDao.searchForDataSynchronization(dto);
    }

    /***
     * 设置保安员证书base64位的信息
     * @param securityCertificate 证书信息
     */
    @Override
    public String setPhotoData(SecurityCertificate securityCertificate) {
        String photo = null;
        //保安员资格证信息
        Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            try {
                //从人员信息取证件照片
                SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
                if (person == null) {
                    person = securityPersonDao.findByIdCard(securityCertificate.getIdnum());
                }
                /***
                 *  取照片优先级
                 *  0、取person_base_info
                 * 1、报名照片
                 * 2、证件照片
                 * 3、认证照片
                 * 4、人口库照片
                 */

                PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(personcertificate.getCardnumber());
                if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())) {
                    //北京人口库照片
                    photo = personBaseInfo.getImgPath();
                    securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr(getResourcePath(personBaseInfo.getImgPath())));
                } else if (personcertificate.getImglogo() != null && personcertificate.getImglogo().indexOf("getResource") >= 0) {
                    //报名照片
                    photo = personcertificate.getImglogo();
                    securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr(getResourcePath(personcertificate.getImglogo())));
                } else if (person != null && StringUtil.isNotEmpty(person.getIdPhoto())) {
                    //证件照片信息
                    photo = person.getIdPhoto();
                    securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr(getResourcePath(person.getIdPhoto())));
                } else {
                    //人员信息照片,认证
                    if (person != null) {
                        if (person.getPhoto().indexOf("getResource") >= 0) {
                            photo = person.getPhoto();
                            securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr(getResourcePath(person.getPhoto())));
                        } else {
                            //人口库照片
                            securityCertificate.setPhoto("data:image/jpg;base64," + getPersonImgUtil.getPersonImg(securityCertificate.getIdnum()));
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            //非北京取人口库照片
            try {

                String basePhoto = "data:image/{type};base64,";
                if (StringUtil.isEmpty(securityCertificate.getHeadImg())) {
                    PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(securityCertificate.getIdnum());
                    if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())) {
                        //北京人口库照片
                        photo = personBaseInfo.getImgPath();
                        basePhoto = basePhoto.replace("{type}",photo.substring(photo.lastIndexOf(".")+1)).toLowerCase();
                        securityCertificate.setPhoto(basePhoto + GetPersonImgUtil.GetImageStr(getResourcePath(personBaseInfo.getImgPath())));
                    } else {
                        securityCertificate.setPhoto("data:image/jpg;base64," + getPersonImgUtil.getPersonImg(securityCertificate.getIdnum()));
                    }
                } else {
                    photo = securityCertificate.getHeadImg();
                    basePhoto = basePhoto.replace("{type}",photo.substring(photo.lastIndexOf(".")+1)).toLowerCase();
                    securityCertificate.setPhoto(basePhoto + GetPersonImgUtil.GetImageStr(getResourcePath(securityCertificate.getHeadImg())));
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        return photo;
    }

    public static void main(String[] args) {

//        String basePhoto = "data:image/{type};base64,";
//        String photo = "aaa.jpg";
//        basePhoto = basePhoto.replace("{type}",photo.substring(photo.lastIndexOf(".")+1)).toLowerCase();
//
//        System.out.println(basePhoto);


        HttpResponse response = HttpUtil.createPost("http://v5qy.test.baibaodun.cn/v3/public/qualification-credentials")
                .contentType("application/json")
                .body(String.format("{'idnum':'%s'}","440901198008079256")).execute();

        V5ResultDto resultDto = JSON.parseObject(response.body(),V5ResultDto.class);
        System.out.println(resultDto.getStatus());
        System.out.println(response.body());
    }

    /***
     * 获取头像地址
     * @param securityCertificate 证书信息
     */
    @Override
    public String getPhotoUrl(SecurityCertificate securityCertificate) {
        String photo = null;
        //保安员资格证信息
        Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            try {
                //从人员信息取证件照片
                SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
                if (person == null) {
                    person = securityPersonDao.findByIdCard(securityCertificate.getIdnum());
                }
                /***
                 *  取照片优先级
                 *  0、取person_base_info
                 * 1、报名照片
                 * 2、证件照片
                 * 3、认证照片
                 * 4、人口库照片
                 */

                PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(personcertificate.getCardnumber());
                if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())) {
                    //北京人口库照片
                    photo = personBaseInfo.getImgPath();
                } else if (personcertificate.getImglogo() != null && personcertificate.getImglogo().indexOf("getResource") >= 0) {
                    //报名照片
                    photo = personcertificate.getImglogo();
                } else if (person != null && StringUtil.isNotEmpty(person.getIdPhoto())) {
                    //证件照片信息
                    photo = person.getIdPhoto();
                } else {
                    //人员信息照片,认证
                    if (person != null) {
                        if (person.getPhoto().indexOf("getResource") >= 0) {
                            photo = person.getPhoto();
                        }
                    } else {
                        //人口库照片
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            //非北京取人口库照片
            try {
                if (StringUtil.isEmpty(securityCertificate.getHeadImg())) {
                    PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(securityCertificate.getIdnum());
                    if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())) {
                        //北京人口库照片
                        photo = personBaseInfo.getImgPath();
                    }
                } else {
                    photo = securityCertificate.getHeadImg();
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        return photo;
    }


    /***
     * 设置保安员证书base64位的信息 for 联名卡
     * @param securityCertificate 证书信息
     */
    @Override
    public String setPhotoDataV1(SecurityCertificate securityCertificate, String headStr) {
        String photo = null;
        //保安员资格证信息
        Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            try {
                /***
                 *  取照片优先级
                 * 1、报名照片
                 * 2、证件照片
                 * 3、人口库照片 person_base_info
                 */
                if (StringUtil.isNotEmpty(personcertificate.getImglogo())) {
                    photo = personcertificate.getImglogo();
                } else {
                    //从人员信息取证件照片
                    SecurityPerson person = securityPersonDao.findUsedByIdNum(securityCertificate.getIdnum());

                    if (person != null && StringUtil.isNotEmpty(person.getIdPhoto())) {
                        photo = person.getIdPhoto();
                    } else {
                        PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(personcertificate.getCardnumber());
                        if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())) {
                            //北京人口库照片
                            photo = personBaseInfo.getImgPath();
                        }
                    }
                }

                if (StringUtil.isNotEmpty(photo)) {
                    securityCertificate.setPhoto(headStr + GetPersonImgUtil.GetImageStr(getResourcePath(photo)));
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            //非北京取人口库照片
            securityCertificate.setPhoto(headStr + getPersonImgUtil.getPersonImg(securityCertificate.getIdnum()));
        }
        return photo;
    }


    /**
     * @param decodeCertificateId
     * @param certificateId       加密的ID
     * @param path
     * @return SecurityCertificate
     * @athour wjb
     * @time 2018年8月21日09:48:48
     * @desc 查询保安员证书信息，包括返回照片跟二维码
     */
    @Override
    public SecurityCertificate findBySecuritypersonidWithPhotoAndQR(long decodeCertificateId, String certificateId, String path) {
        //查询保安员证书信息
        SecurityCertificate securityCertificate = securityCertificateDao.findBySecuritypersonid(decodeCertificateId);
        if (null != securityCertificate) {
            //设置图片信息
            setPhotoData(securityCertificate);
            try {
                //返回二维码 拼接二维码URL地址
                if (null != path && !"".equals(path)) {
                    Config config = configDao.findByKey("current_province");
                    Config H5UrlConfig = configDao.findByKey("H5URL" + config.getValue());
                    String pathName = "";
                    if (null != H5UrlConfig) {
                        pathName = QRCodeUtil.generateQRCode(bbdH5Url + Constants.SELECT_CARD_URL + URLEncoder.encode(certificateId, "utf-8") + H5UrlConfig.getValue(), 100, 100, "jpg", tempFolder + "qrcode.jpg");
                    }
                    //String pathName = QRCodeUtil.generateQRCode(bbdH5Url + Constants.SELECT_CARD_URL+URLEncoder.encode( certificateId, "utf-8"), 100, 100, "jpg", tempFolder + "qrcode.jpg");
                    securityCertificate.setQrcode(Base64Img.GetImageStr(pathName, "jpg"));
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        return securityCertificate;
    }

    /**
     * @param personId
     * @return SecurityCertificate
     * @athour wjb
     * @time 2018年8月21日16:42:56
     * @desc 查询保安员证书信息（APP）
     */
    @Override
    public SecurityCertificate findBySecuritypersonidForApp(long personId) {
        Personcertificate dbPersoncertificate = new Personcertificate();
        dbPersoncertificate.setPersonid(personId);
        //查询保安员考试报名信息
        Personcertificate personcertificate = personcertificateDao.findByPersonid(dbPersoncertificate);
        SecurityCertificate securityCertificate = null;
        if (null != personcertificate) {
            //根据报名信息查询证书信息
            securityCertificate = securityCertificateDao.findBySecuritypersonid(personcertificate.getId());
        } else {

        }
        return securityCertificate;
    }

    @Override
    public void getPersonImg(Long[] idArrays) throws IOException {
        for (Long id : idArrays) {
            getPersonImg(id);
        }
    }

    @Override
    public String getPersonImg(Long id) {
        try {
            /***
             * 根据环境获取对应背景筛查实现类
             */
            BackGroupCensorService backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
            SecurityCertificate securityCertificate = findById(id);
            if (securityCertificate == null || securityCertificate.isHavephoto()) {
                return "数据错误";
            }

            String resultMsg = "没有获取到人口库头像";
            logger.info("正在获取的身份证号码：" + securityCertificate.getIdnum());

            securityCertificate.setHavephoto(false);

            PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(securityCertificate.getIdnum(),true);

            if(!Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
                if (personBaseInfo != null) {
                    personBaseInfo.setCreateTime(new Date());
                    personBaseInfo.setActive(true);
                    if (StringUtil.isNotEmpty(personBaseInfo.getPhoto())) {
                        photoUtil.savePhoto(personBaseInfo);
                        //更新security_certificate表中图片的状态
                        securityCertificate.setHavephoto(true);
                        securityCertificate.setHeadImg(personBaseInfo.getImgPath());
                        personBaseInfoService.save(personBaseInfo);
                        resultMsg = "操作成功";
                    }
                }
            }
            securityCertificateDao.updateHavePhotodByIdnum(securityCertificate);
            return resultMsg;
        } catch (Exception e) {
            return e.getMessage();
        }

    }

    /**
     * 批量证书领取状态
     *
     * @param idArr 证书信息ID列表
     * @return 无
     * @desc edit 2019-03-30 subh 14:33
     */
    @Override
    public void updateReceiveState(Long[] idArr) {
        securityCertificateDao.updateReceiveState(idArr);
    }

    @Override
    public void searchForTrain(SecurityCertificateSearchDto dto, AjaxPageResponse<Personcertificate> ajaxPageResponse) {
        securityCertificateDao.searchForTrain(dto, ajaxPageResponse);
    }

    @Override
    public List<SecurityCertificate> findDSOutList(String startDate) {
        return securityCertificateDao.searchUpdateflagForExport(startDate);
    }

    @Override
    public void batchSaveElectronCerUrlForOldData() {
        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            List<SecurityCertificate> certificateList = securityCertificateDao.findOldDataForPerson();
            List<SecurityCertificate> list = new ArrayList<>();
            if (certificateList.size() > 0) {
                certificateList.forEach(detail -> {
                    //电子证书
                    try {
                        String data = DES3.encode(JSON.toJSONString(detail.getSecuritypersonid(), SerializerFeature.WriteDateUseDateFormat));
                        detail.setElectronCerUrl("http://www.bktang.cn/pxxtfront/bbdapp/#/certificate?certificateId=" + URLEncoder.encode(data, "utf-8") + "$http://bjapi.baibaodun.cn:8803/");
                        list.add(detail);
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                });

                //根据数据数量情况，切分不同的大小
                int limit = configUtils.limitSize;
                //计算拆分次数
                int count = new Double(Math.ceil(list.size() * 1.0 / limit)).intValue();
                //存放拆分数据
                List<SecurityCertificate> subList = null;
                //循环拆分次数 生成相应数据文件
                for (int i = 0; i < count; i++) {
                    subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                    securityCertificateDao.batchSaveElectronCerUrl(subList);
                }

            }
        }
    }


    @Override
    public List<String> batchUpdateState(String idNums, String isState, String makeCard) throws IOException {
        String currentDate = DateUtil.getCurrentDate("yyyy-MM-dd");
        List<String> downloadUrl = new ArrayList<>();
        int index = 0;
        int count = 0;
        if (StringUtil.isNotEmpty(idNums)) {
//            idNums = idNums.replaceAll(",", "");
////            idNums = idNums.replaceAll("\"", "");
////            idNums = idNums.replaceAll("\r\n", ",");
////            idNums = idNums.replaceAll("\n", ",");
            idNums = idNums.replaceAll("([^a-zA-Z0-9])", ",");
            String[] idNumArr = idNums.split(",");
            count = idNumArr.length;
            List<String> existCertificateList = new ArrayList<>(); //证件存在的list
            List<String> existHavePhotoList = new ArrayList<>(); //照片存在的list
            List<String> noExistCertificateList = new ArrayList<>(); //证件不存在的list
            List<String> noExistHavePhotoList = new ArrayList<>(); //照片不存在的list

            List<SecurityCertificate> list = securityCertificateDao.findByIdNums(idNumArr);
            if (idNumArr != null && idNumArr.length > 0) {
                list.forEach(securityCertificate -> {
                    //证件存在的list
                    existCertificateList.add(securityCertificate.getIdnum().toUpperCase());
                    //照片存在list
                    if (StringUtil.isNotEmpty(securityCertificate.getHeadImg())) {
                        existHavePhotoList.add(securityCertificate.getIdnum().toUpperCase());
                    } else {
                        //查询人口库
                        //如果人口库有照片  使用人口库照片
                        //如果人口库没照片 ，查询app照片，如果有使用app照片
                        String idnum = securityCertificate.getIdnum();
                        PersonBaseInfo baseInfo = personBaseInfoDao.findByIdNum(idnum);
                        if (null != baseInfo && StringUtil.isNotEmpty(baseInfo.getImgPath())) {
                            securityCertificateDao.updateHeadImg(idnum, baseInfo.getImgPath());
                            existHavePhotoList.add(idnum.toUpperCase());
                        } else {
                            SecurityPerson securityPerson = securityPersonDao.findByIdCard(idnum);
                            if (null != securityPerson && StringUtil.isNotEmpty(securityPerson.getIdPhoto())) {
                                securityCertificateDao.updateHeadImg(idnum, securityPerson.getIdPhoto());
                                existHavePhotoList.add(idnum.toUpperCase());
                            }
                        }
                    }
                });
                if (existHavePhotoList.size() > 0) {
                    //批量修改
                    securityCertificateDao.updateBatchByidNum(existHavePhotoList, Constants.ISDRAW_WAITPASH);

                }
                //证件不存在的  和照片不存在的 导出
                List<String> asList = new ArrayList<>();
                for (int i = 0; i < idNumArr.length; i++) {
                    if (StringUtil.isNotEmpty(idNumArr[i])) {
                        asList.add(idNumArr[i].toUpperCase());
                    }

                }
                noExistCertificateList.addAll(asList);
                noExistCertificateList.removeAll(existCertificateList);
                noExistHavePhotoList.addAll(existCertificateList);
                noExistHavePhotoList.removeAll(existHavePhotoList);


                //导出
                if (Constants.MAKE_CARD.equals(makeCard)) {
                    String txtfileName = configUtils.tempfolder + "/" + currentDate + "/securityCertificate.txt";
                    batchImportTxt(txtfileName, existHavePhotoList);
//					downloadUrl.add("getResource.do?path=temp/"+currentDate+"/securityCertificate.txt");
                    downloadUrl.add(txtfileName);
                }

                if (noExistCertificateList.size() > 0 || noExistHavePhotoList.size() > 0) {
                    //导出
                    String fileName = configUtils.tempfolder + "/" + currentDate + "/noPass.xls";
                    batchUpdateStateExcel(fileName, noExistCertificateList, noExistHavePhotoList);
//                    String excelUrl = "getResource.do?path=temp/" + currentDate + "/noPass.xls";
                    downloadUrl.add(fileName);
                }

                List<String> url = new ArrayList<>();

                //打包并且返回url地址sss
                if (downloadUrl.size() > 0) {
                    String zipFileName = FileUtil.generatingFileNameByDate("authorization") + Constants.ZIP;
                    FileUtil.zipFiles(downloadUrl, configUtils.tempfolder + currentDate + "/" + zipFileName);
//				删除临时文件
//				downloadUrl.forEach(tempPath -> {
//					if (tempPath.indexOf(Constants.TEMP) > 0) {
//						FileUtil.deleteFile(tempPath);
//					}
//				});
                    String zipurl = "getResource.do?path=temp/" + currentDate + "/" + zipFileName;
                    url.add(zipurl);
                }
                return url;
                //返回url地址
            }
        }
        return null;
    }

//    @Override
//    public List<String> batchexportAppPhoto(String idNums) throws IOException {
//        String currentDate = DateUtil.getCurrentDate("yyyy-MM-dd");
//        if (StringUtil.isNotEmpty(idNums)) {
////            idNums = idNums.replaceAll(",", "");
////            idNums = idNums.replaceAll("\"", "");
////            idNums = idNums.replaceAll("\r\n", ",");
////            idNums = idNums.replaceAll("\n", ",");
//            idNums = idNums.replaceAll("([^a-zA-Z0-9])", ",");
//            String[] idNumArr = idNums.split(",");
//            List<HashMap<String, HashMap<String, String>>> excelList = new ArrayList<>();
//            List<String> pathList = new ArrayList<>();
//
//
//
//            if (idNumArr != null && idNumArr.length > 0) {
//                List<String> asList = Arrays.asList(idNumArr);
//                asList.forEach(str -> {
//                    if(StringUtil.isNotEmpty(str)){
//                        HashMap<String, HashMap<String, String>> pmap = new HashMap<>();
//                        HashMap<String, String> map = new HashMap<>();
//                        map.put("idNum", str);
//                        map.put("isCertification", "否");
//                        map.put("isIdPhoto", "否");
//                        map.put("isAppPhoto", "否");
//                        map.put("isPerson", "否");  //是否在人员表
//                        pmap.put(str.toUpperCase(), map);
//                        excelList.add(pmap);
//                    }
//                });
//                List<SecurityCertificate> list = securityCertificateDao.findByIdNums(idNumArr);
//                for (SecurityCertificate securityCertificate : list) {
//                    for (HashMap<String, HashMap<String, String>> map : excelList) {
//                        if (StringUtil.isNotEmpty(securityCertificate.getIdnum())) {
//                            HashMap<String, String> exportMap = map.get(securityCertificate.getIdnum().toUpperCase());
//                            if (null != exportMap) {
//                                exportMap.put("isCertification", "是");
//                                exportMap.put("name", securityCertificate.getXm());//姓名
//                                //查找人员表
//                                String idNum=securityCertificate.getIdnum();
//                                SecurityPerson securityperson = securityPersonDao.findByIdCardAndActive(idNum);
//                                if(null!=securityperson){
//                                    if(StringUtil.isNotEmpty(securityperson.getPhone())){
//                                        exportMap.put("phone",securityperson.getPhone());//手机号
//                                    }else {
//                                        exportMap.put("phone","暂无手机号");//手机号
//                                    }
//                                    exportMap.put("isPerson", "是");//是否存在人员表
//                                    if(null!=securityperson.getRelation()&&null!=securityperson.getRelation().getCompany()){
//                                        exportMap.put("company", securityperson.getRelation().getCompany().getName());//当前公司
//                                    }else {
//                                        exportMap.put("company","暂无公司");//当前公司
//                                    }
//                                }
//                                //查找人口库照片是否存在
//                                PersonBaseInfo byIdNum = personBaseInfoDao.findByIdNum(securityCertificate.getIdnum());
//                                if(null!=byIdNum&&StringUtil.isNotEmpty(byIdNum.getImgPath())){
////                                if (StringUtil.isNotEmpty(securityCertificate.getHeadImg())) {
//                                    exportMap.put("isIdPhoto", "是");
//                                } else {
//                                    if(null!=securityperson){
//                                        String idPhotoUrl=securityperson.getIdPhoto();
//                                        if (StringUtil.isNotEmpty(idPhotoUrl)) {
//                                            exportMap.put("isAppPhoto", "是");
//                                            //读取文件
//                                            String[] pathsArr = idPhotoUrl.split("/");
//                                            if (pathsArr.length == 3) {
//                                                String path = pathsArr[1] + "/" + pathsArr[2];
//                                                File file = new File(configUtils.uploadFolder + path);
//                                                byte[] bytes = FileUtil.File2byte(file);
//                                                //保存的地址
//                                                String appPhotoPath = configUtils.tempfolder + currentDate + "/";
//                                                String appPotoName = idNum + ".jpg";
//                                                FileUtil.byte2File(bytes, appPhotoPath, appPotoName);
//                                                pathList.add(appPhotoPath + appPotoName);
//                                            }
//                                        }
//                                    }
//                                }
////                                break;//找到了就跳出当前map循环
//                            }
//                        }
//                    }
//                }
//                //导出Excel到本地返回 url地址
//                String fileName = configUtils.tempfolder + "/" + currentDate + "/exportAppPhoto.xls";
//                pathList.add(fileName);
//                batchexportAppPhotoExcel(fileName, excelList);
//                List<String> downloadUrl = new ArrayList<>();
//                //打包并且返回url地址
//                String zipFileName = FileUtil.generatingFileNameByDate("appPhoto") + Constants.ZIP;
//                FileUtil.zipFiles(pathList, configUtils.tempfolder + currentDate + "/" + zipFileName);
////				删除临时文件
//                pathList.forEach(tempPath -> {
//                    if (tempPath.indexOf(Constants.TEMP) > 0) {
//                        FileUtil.deleteFile(tempPath);
//                    }
//                });
////				String excelUrl= "getResource.do?path=temp/"+currentDate+"/exportAppPhoto.xls";
////				downloadUrl.add(excelUrl);
//                String photoUrl = "getResource.do?path=temp/" + currentDate + "/" + zipFileName;
//                downloadUrl.add(photoUrl);
//                return downloadUrl;
//            }
//        }
//        return null;
//    }


    @Override
    public List<String> batchexportAppPhoto(List<Map<String, String>> idList) throws IOException {
        String currentDate = DateUtil.getCurrentDate("yyyy-MM-dd");
        if (idList.size() > 0) {
            List<String> idNumArr = new ArrayList<>();
            for (Map map : idList) {
                idNumArr.add((String) map.get("idNum"));
            }
            List<HashMap<String, HashMap<String, String>>> excelList = new ArrayList<>();
            List<String> pathList = new ArrayList<>();
            if (idList != null && idList.size() > 0) {
                idList.forEach(strMap -> {
                    HashMap<String, HashMap<String, String>> pmap = new HashMap<>();
                    HashMap<String, String> map = new HashMap<>();
                    String name = strMap.get("name");
                    String idNum = strMap.get("idNum");
                    if (StringUtil.isNotEmpty(idNum)) {
                        map.put("idNum", idNum);
                        map.put("isCertification", "否");
                        map.put("isIdPhoto", "否");
                        map.put("isAppPhoto", "否");
                        map.put("isPerson", "否");  //是否在人员表
                        map.put("expName", name);
                        map.put("remark", "");
                        pmap.put(idNum.toUpperCase(), map);
                        excelList.add(pmap);
                    }
                });

                String[] idNumArrs = idNumArr.toArray(new String[idNumArr.size()]);
                List<SecurityCertificate> list = securityCertificateDao.findByIdNums(idNumArrs);
                for (SecurityCertificate securityCertificate : list) {
                    for (HashMap<String, HashMap<String, String>> map : excelList) {
                        if (StringUtil.isNotEmpty(securityCertificate.getIdnum())) {
                            HashMap<String, String> exportMap = map.get(securityCertificate.getIdnum().toUpperCase());
                            if (null != exportMap) {
                                exportMap.put("isCertification", "是");
                                exportMap.put("name", securityCertificate.getXm());//姓名
                                if (null == securityCertificate.getXm() || !exportMap.get("expName").equals(securityCertificate.getXm())) {
                                    exportMap.put("remark", "导入姓名不一致，导入姓名为：" + exportMap.get("expName") + ",系统中姓名为:" + securityCertificate.getXm());
                                }

                                //查找人员表
                                String idNum = securityCertificate.getIdnum();
                                SecurityPerson securityperson = securityPersonDao.findByIdCardAndActive(idNum);
                                if (null != securityperson) {
                                    if (StringUtil.isNotEmpty(securityperson.getPhone())) {
                                        exportMap.put("phone", securityperson.getPhone());//手机号
                                    } else {
                                        exportMap.put("phone", "暂无手机号");//手机号
                                    }
                                    exportMap.put("isPerson", "是");//是否存在人员表
                                    if (null != securityperson.getRelation() && null != securityperson.getRelation().getCompany()) {
                                        exportMap.put("company", securityperson.getRelation().getCompany().getName());//当前公司
                                    } else {
                                        exportMap.put("company", "暂无公司");//当前公司
                                    }
                                }
                                //查找人口库照片是否存在
                                PersonBaseInfo byIdNum = personBaseInfoDao.findByIdNum(securityCertificate.getIdnum());
                                if (null != byIdNum && StringUtil.isNotEmpty(byIdNum.getImgPath())) {
//                                if (StringUtil.isNotEmpty(securityCertificate.getHeadImg())) {
                                    exportMap.put("isIdPhoto", "是");
                                } else {
                                    if (null != securityperson) {
                                        String idPhotoUrl = securityperson.getIdPhoto();
                                        if (StringUtil.isNotEmpty(idPhotoUrl)) {
                                            exportMap.put("isAppPhoto", "是");
                                            //读取文件
                                            String[] pathsArr = idPhotoUrl.split("/");
                                            if (pathsArr.length == 3) {
                                                String path = pathsArr[1] + "/" + pathsArr[2];
                                                File file = new File(configUtils.uploadFolder + path);
                                                byte[] bytes = FileUtil.File2byte(file);
                                                //保存的地址
                                                String appPhotoPath = configUtils.tempfolder + currentDate + "/";
                                                String appPotoName = idNum + ".jpg";
                                                FileUtil.byte2File(bytes, appPhotoPath, appPotoName);
                                                pathList.add(appPhotoPath + appPotoName);
                                            }
                                        }
                                    }
                                }
//                                break;//找到了就跳出当前map循环
                            }
                        }
                    }
                }
                //导出Excel到本地返回 url地址
                String fileName = configUtils.tempfolder + "/" + currentDate + "/exportAppPhoto.xls";
                pathList.add(fileName);
                batchexportAppPhotoExcel(fileName, excelList);
                List<String> downloadUrl = new ArrayList<>();
                //打包并且返回url地址
                String zipFileName = FileUtil.generatingFileNameByDate("appPhoto") + Constants.ZIP;
                FileUtil.zipFiles(pathList, configUtils.tempfolder + currentDate + "/" + zipFileName);
//				删除临时文件
                pathList.forEach(tempPath -> {
                    if (tempPath.indexOf(Constants.TEMP) > 0) {
                        FileUtil.deleteFile(tempPath);
                    }
                });

//				String excelUrl= "getResource.do?path=temp/"+currentDate+"/exportAppPhoto.xls";
//				downloadUrl.add(excelUrl);
                String photoUrl = "getResource.do?path=temp/" + currentDate + "/" + zipFileName;
                downloadUrl.add(photoUrl);
                return downloadUrl;
            }
        }
        return null;
    }

    /*
     * 将处理后的List集合重新生成Excel文件
     * */
    public static void batchexportAppPhotoExcel(String fileName, List<HashMap<String, HashMap<String, String>>> list) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        Sheet sh = wb.createSheet();
        sh.setColumnWidth(0, 15 * 256);
        sh.setColumnWidth(1, 20 * 256);
        sh.setColumnWidth(2, 20 * 256);
        sh.setColumnWidth(3, 35 * 256);
        sh.setColumnWidth(4, 15 * 256);
        sh.setColumnWidth(5, 20 * 256);
        sh.setColumnWidth(6, 15 * 256);
        sh.setColumnWidth(7, 70 * 256);
        sh.setColumnWidth(8, 60 * 256);
        String info[] = {"系统姓名", "身份证号码", "手机号码", "在职公司", "是否有资格证", "是否有人口库照片", "是否有app照片", "备注", "导入姓名对比结果"};
        int rowIndex = 0;
        int columnIndex = 0;
        Row header = sh.createRow(0);
        for (int i = 0; i < info.length; i++) {
            header.createCell(columnIndex++).setCellValue(info[i]);
        }
        for (int i = 0; i < list.size(); i++) {
            HashMap<String, HashMap<String, String>> map = list.get(i);
            if (map.size() > 0) {
                HashMap<String, String> hashMap = map.get(map.keySet().iterator().next());
                if (null != hashMap) {
                    Row row = sh.createRow(i + 1);
                    row.createCell(0).setCellValue(hashMap.get("name"));
                    row.createCell(1).setCellValue(hashMap.get("idNum"));
                    row.createCell(2).setCellValue(hashMap.get("phone"));
                    row.createCell(3).setCellValue(hashMap.get("company"));
                    row.createCell(4).setCellValue(hashMap.get("isCertification"));
                    row.createCell(5).setCellValue(hashMap.get("isIdPhoto"));
                    row.createCell(6).setCellValue(hashMap.get("isAppPhoto"));
                    //资格证存在的情况
                    if ("是".equals(hashMap.get("isCertification"))) {
                        //是否存在人口库照片
                        if ("是".equals(hashMap.get("isIdPhoto"))) {
                            //是否存在人员表
                            if ("是".equals(hashMap.get("isPerson"))) {
                                row.createCell(7).setCellValue("可制证，无需审核。");
                            } else {
                                row.createCell(7).setCellValue("可制证。该人员未录入系统。");
                            }
                        } else {
                            //不存在人口库照片 的情况
                            //是否存在app照片
                            if ("是".equals(hashMap.get("isAppPhoto"))) {
                                row.createCell(7).setCellValue("可制证需审核。需审核App照片是否符合要求。");
                            } else {
                                row.createCell(7).setCellValue("不可制证，该人员无人口照片、无App照片，需App补拍");
                            }
                        }
                    } else {
                        row.createCell(7).setCellValue("不可制证。该人员无资格证信息。");
                    }

                    row.createCell(8).setCellValue(hashMap.get("remark"));
                }
            }
        }
        FileOutputStream out = null;
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            out = new FileOutputStream(file);
            wb.write(out);
            out.close();
            wb.dispose();
        } catch (Exception e) {
            e.printStackTrace();

        }
        // dispose of temporary files backing this workbook on disk
    }

    /*
     * 批量修改 将处理后的List集合重新生成Excel文件
     * */
    public static void batchUpdateStateExcel(String fileName, List<String> noExistCertificateList, List<String> noExistHavePhotoList) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        Sheet sh = wb.createSheet();
        sh.setColumnWidth(0, 5 * 256);
        sh.setColumnWidth(1, 20 * 256);
        sh.setColumnWidth(2, 20 * 256);
        String info[] = {"", "身份证号码", "批量修改出现问题"};
        int rowIndex = 0;
        int columnIndex = 0;
        Row header = sh.createRow(0);
        for (int i = 0; i < info.length; i++) {
            header.createCell(columnIndex++).setCellValue(info[i]);
        }
        for (int rownum = 0; rownum < noExistCertificateList.size(); rownum++) {
            Row row = sh.createRow(rownum + 1);
            row.createCell(0).setCellValue("");
            row.createCell(1).setCellValue(noExistCertificateList.get(rownum));
            row.createCell(2).setCellValue("没有证书");
        }

        for (int rownum = 0; rownum < noExistHavePhotoList.size(); rownum++) {
            int index = noExistCertificateList.size();
            if (index > 0) {
                index = index + 2;
            } else {
                index = 1;
            }
            Row row = sh.createRow(rownum + index);
            row.createCell(0).setCellValue("");
            row.createCell(1).setCellValue(noExistHavePhotoList.get(rownum));
            row.createCell(2).setCellValue("没有照片");
        }

        FileOutputStream out = null;

        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            if (!file.getParentFile().mkdirs()) {

            }
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            out = new FileOutputStream(file);
            wb.write(out);
            out.close();
            wb.dispose();
        } catch (Exception e) {
            e.printStackTrace();

        }

        // dispose of temporary files backing this workbook on disk

    }


    /**
     * 批量导出json 格式 text
     *
     * @param
     * @return
     */
    public void batchImportTxt(String fileName, List<String> list) throws IOException {

        LinkedHashMap<String, Object> map = new LinkedHashMap<>();
        map.put("successful", true);
        map.put("code", "");
        map.put("msg", "");
        map.put("obj", "");
        map.put("token", "");
        map.put("state", "");
        List<Object> ImportList = new ArrayList<>();
        if (list.size() > 0) {
            String[] idNum = list.toArray(new String[list.size()]);
            List<SecurityCertificate> securityCertificateList = securityCertificateDao.findByIdNums(idNum);
            securityCertificateList.forEach(securityCertificate -> {
                BatchImportTxtDTO batchImportTxtDTO = new BatchImportTxtDTO();
                batchImportTxtDTO.setTitle("北京市保安员资格证");
                batchImportTxtDTO.setXm(securityCertificate.getXm());
                batchImportTxtDTO.setIdNumber(securityCertificate.getIdnum());
                batchImportTxtDTO.setZsbh(securityCertificate.getZsbh());


                if (null != securityCertificate.getFzrq()) {
                    batchImportTxtDTO.setFzrq(DateUtil.convertDateToString(securityCertificate.getFzrq(), "yyyy-MM-dd HH:mm:ss"));
                }
                if (StringUtil.isNotEmpty(securityCertificate.getHeadImg())) {
                    //读取文件


                    //getResource.do?path=upload/2020-07-07/1594101662580.jpg
                    //getResource.do?path=personImg/2020-02-20/1582137656122.jpg'
//						String jpg = Base64Img.GetImageStr(configUtils.uploadFolder + path, "jpg");
                    try {
                        String resourcePath = getResourcePath(securityCertificate.getHeadImg());
                        String jpg = Base64Img.GetImageStr(resourcePath);
                        batchImportTxtDTO.setImglogo(jpg);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }


                }
                //没关联快照则生成并关联
                if (securityCertificate.getSnapshotId() == null) {
                    //生成预览记录
                    this.savePerCerSnapshot(securityCertificate, securityCertificate.getHeadImg());
                }
                //二维码
                try {
                    Base64Utils.encodeToString(securityCertificate.getSnapshotId().toString().getBytes("UTF-8"));
                    String qrCodeForThirdParty = this.getQRCodeForThirdParty(DES3.encode(securityCertificate.getSnapshotId().toString()));
                    batchImportTxtDTO.setSnapshotPhoto(qrCodeForThirdParty);
//					batchImportTxtDTO.setSnapshotPhoto("data:image/jpg;base64,"+qrCodeForThirdParty);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                ImportList.add(batchImportTxtDTO);

            });

            map.put("data", ImportList);
            String json = JSON.toJSONString(map);
            FileOutputStream out = null;
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            try {
                out = new FileOutputStream(file);
                out.write(json.getBytes());
                out.close();
            } catch (Exception e) {
                e.printStackTrace();

            }

        }

    }


    @Override
    public AjaxResult checkyearAndday(String idNum) {
        AjaxResult result = new AjaxResult();
        SecurityCertificate securityCertificate = securityCertificateDao.findByIdnum(idNum);
        if (null != securityCertificate && null != securityCertificate.getFzrq()) {
            int day = DateUtil.dateDiff(securityCertificate.getFzrq(), new Date());
            if (day >= 365) {
                result.setSuccessful(true);
                result.setCode("200");
                result.setMsg("资格证满一年");
                return result;
            } else {
                result.setSuccessful(true);
                result.setCode("201");
                result.setMsg("资格证未满一年");
                return result;
            }
        } else {
            result.setSuccessful(true);
            result.setCode("202");
            result.setMsg("不存在");
            return result;
        }
    }


    @Override
    public AjaxResult searchForPublicQuery(String idnum) {
        List<SecurityCertificateDto> lists = new ArrayList<>();
        if(Constants.YES.equals(configUtils.getValueByKey(Constants.BJ_PUBLIC_QUERY_FORM_V5))){
            HttpResponse response = HttpUtil.createPost(configUtils.getValueByKey(Constants.V5_TENANT_URL)+"v3/public/qualification-credentials")
                    .contentType("application/json")
                    .body(String.format("{'idnum':'%s'}",idnum)).execute();
            V5ResultDto resultDto = JSON.parseObject(response.body(),V5ResultDto.class);
            if(resultDto.isSuccess() && resultDto.getData() != null){
                List<SecurityCertificateV5Dto> v5List = JSON.parseArray(JSON.toJSONString(resultDto.getData()),SecurityCertificateV5Dto.class);
                for (SecurityCertificateV5Dto securityCertificateV5Dto : v5List) {
                    SecurityCertificateDto securityCertificateDto = new SecurityCertificateDto();
                    securityCertificateDto.setFzjgmc(securityCertificateV5Dto.getOrgName());
                    securityCertificateDto.setFzrq(DateUtil.convertDateToString(securityCertificateV5Dto.getCerDate(),DateUtil.FORMAT2));
                    securityCertificateDto.setFromV5(true);
                    lists.add(securityCertificateDto);
                }
            }
        }else {
            lists = securityCertificateDao.searchaAcordingToIdNumber(idnum);
        }
        return AjaxResult.success(lists);
    }

    @Override
    public AjaxResult canSignUpSecurityCertificate(String idNumbers) {
        String subject = JwtUtil.parseJWT(idNumbers).getSubject();
        List<String> idNumbersList = JSON.parseArray(subject, String.class);
        HashSet<String> idNumbersSet = Sets.newHashSet(idNumbersList);
        AjaxResult ajaxResult = new AjaxResult();
        if (CollectionUtil.isEmpty(idNumbersSet)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("请输入正确参数");
            return ajaxResult;
        }
        // 结果类
        Map<String, Object> resultData = Maps.newHashMap();

        for (String idNumber : idNumbersSet) {
            // 不存在即可添加
            boolean canApply = checkCanApplySecurityCertificate(idNumber);
            resultData.put(idNumber, canApply);
        }

        ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(resultData, SerializerFeature.WriteMapNullValue)));
        ajaxResult.setMsg("查询成功");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    @Override
    public boolean checkCanApplySecurityCertificate(String idNumber) {
        if (StringUtil.isBlank(idNumber)) {
            return false;
        }
        boolean flag = false;
        SecurityPerson securityPerson = securityPersonDao.findByIdCard(idNumber);
        if (securityPerson == null) {
            logger.error("学员{}不存在入职记录！", idNumber);
        } else if (Constants.IDENTITYAUTHSTATE_Y.equals(securityPerson.getIdentityAuthState())) {
            flag = true;
        } else {
            logger.error("学员{}未实名认证通过！", idNumber);
        }
        if (flag) {
            if (Constants.ZGZBT_SWITCH_1.equals(configUtils.getValueByKey(Constants.ZGZBT_SWITCH))) {
                SecurityCertificate certificate = securityCertificateDao.findByIdnum(idNumber);
                if (certificate != null) {
                    flag = false;
                    logger.error("学员{}已持有保安员资格证！", idNumber);
                }

                if (flag) {
                    Personcertificate personcertificate = personcertificateDao.findApprovalingByIdNum(idNumber);
                    if (personcertificate != null) {
                        flag = false;
                        logger.error("学员{}已报名保安员资格证！", idNumber);
                    }
                }
            } else {
                //通过保安员id查询待审批、审批中或者审批通过的数据
                Personcertificate personcertificate = personcertificateDao.findApprovaling(securityPerson.getId());
                if (personcertificate != null) {
                    flag = false;
                }
            }
        }
        return flag;
    }

    @Override
    public SecurityCerDto findByIdNum(String idNum) {
        SecurityCerDto result = null;
        SecurityCertificate cer = securityCertificateDao.findByIdnum(idNum);
        if(cer != null) {
            result = new SecurityCerDto();
            cer.setPhoto(getPersonImgUtil.getPersonImg(cer.getIdnum()));
            BeanUtils.copyPropertiesIgnore(cer, result);
            result.setName(cer.getXm());
            result.setIdNum(cer.getIdnum());
            result.setOrgName(cer.getFzjgmc());
            result.setCerNo(cer.getZsbh());
            result.setCerDate(DateFormatUtils.format(cer.getFzrq(),"yyyy-MM-dd"));
        }
        return result;
    }

}
