package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.certificate.PerCerSnapshotDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.PerCerSnapshotPageSearchDto;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.certificate.PerCerSnapshotService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 保安员资格证打印快照Service实现类
 *
 * @author linqinglin
 * @Date 2020-04-16 16:39:19
 */
@Service
@Transactional
@DataSyncOutAnnotation(getClazz = PerCerSnapshot.class)
public class PerCerSnapshotServiceImpl implements PerCerSnapshotService {

    Logger logger = LoggerFactory.getLogger(PerCerSnapshotServiceImpl.class);

    @Autowired
    private PerCerSnapshotDao perCerSnapshotDao;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private PersonBaseInfoService personBaseInfoService;
    @Override
    public int delete(PerCerSnapshot perCerSnapshot) {
        User currentUser = arsUtil.getCurrentUser();
        perCerSnapshot.setUpdateTime(new Date());
        perCerSnapshot.setUpdateBy(currentUser.getUsername());
        return perCerSnapshotDao.delete(perCerSnapshot);
    }

    @Override
    public int save(PerCerSnapshot perCerSnapshot) {
        User currentUser = arsUtil.getCurrentUser();
        if(perCerSnapshot.getId() == null){
            perCerSnapshot.setId(idWorker.nextId());
            perCerSnapshot.setCreateTime(new Date());
        }else{
            PerCerSnapshot dbPerCerSnapshot = perCerSnapshotDao.findById(perCerSnapshot.getId());
            BeanUtils.copyPropertiesIgnore(perCerSnapshot,dbPerCerSnapshot,true);
            BeanUtils.copyPropertiesIgnore(dbPerCerSnapshot,perCerSnapshot,false);
        }

        perCerSnapshot.setActive(true);
        perCerSnapshot.setUpdateBy(currentUser.getUsername());
        perCerSnapshot.setUpdateTime(new Date());
        perCerSnapshot.setUpdateflag(true);
        perCerSnapshot.setAreaCode(currentUser.getPolice().getAreacode());
        if(StringUtil.isEmpty(perCerSnapshot.getPhoto())){
            String idNum = perCerSnapshot.getIdNum();
            PersonBaseInfo baseInfo = personBaseInfoService.findByIdNum(idNum);
            if(null!=baseInfo){
                perCerSnapshot.setPhoto(baseInfo.getPhoto());
            }
        }
        return perCerSnapshotDao.save(perCerSnapshot);
    }

    @Override
    public PerCerSnapshot findById(Long id) {
        return perCerSnapshotDao.findById(id);
    }

    @Override
    public void searchForPage(PerCerSnapshotPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       perCerSnapshotDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<PerCerSnapshot> list) {
        List<PerCerSnapshot> dbList = perCerSnapshotDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (PerCerSnapshot perCerSnapshot : list) {
                perCerSnapshot.setUpdateflag(false);
                //头像
                if(StringUtil.isEmpty(perCerSnapshot.getPhoto())){
                    String idNum = perCerSnapshot.getIdNum();
                    PersonBaseInfo baseInfo = personBaseInfoService.findByIdNum(idNum);
                    if(null!=baseInfo){
                        perCerSnapshot.setPhoto(baseInfo.getPhoto());
                    }
                }
                try {
                    if(!configUtils.isIntranet()){
                       perCerSnapshot.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, perCerSnapshot.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            perCerSnapshotDao.saveBatch(list);
    }
    }

    @Override
    public List<PerCerSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return perCerSnapshotDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<PerCerSnapshot> findDSOutList(String startDate) {
        return perCerSnapshotDao.findDSOutList(startDate);
    }

    @Override
    public List<PerCerSnapshot> findByBatchId(List<PerCerSnapshot> list) {
        return perCerSnapshotDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(PerCerSnapshot perCerSnapshot) {
        User currentUser = arsUtil.getCurrentUser();
        perCerSnapshot.setUpdateTime(new Date());
        perCerSnapshot.setUpdateBy(currentUser.getUsername());
        perCerSnapshotDao.updateSelective(perCerSnapshot);
    }
}
