package com.bcxin.ars.service.certificate.impl;


import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.certificate.CompanyCertificateDao;
import com.bcxin.ars.dao.certificate.TrainCertificateDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.dto.pdf.PdfChangeDTO;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.service.pdf.StampService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class CreatePDFServiceImpl implements CreatePDFService {

	@Autowired
	private CompanyCertificateDao companyCertificateDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;

	@Autowired
	private TrainCertificateDao trainCertificateDao;

	@Autowired
	private LegalchangeDao legalchangeDao;

	@Autowired
	private ProjectChangeDao projectChangeDao;

	@Autowired
	private StampService stampService;

	@Autowired
	private ConfigUtils configUtils;

	@Value("${base-folder}")
	private String baseFolder;

	CompanyCertificateSearchDto getompanyCertificateData(PdfFormDto pdfFormDto) {
		//正本数据
		CompanyCertificate companyCertificate = companyCertificateDao.findById(pdfFormDto.getBusinessid());
		CompanyCertificateSearchDto companyCertificateSearchDto = new CompanyCertificateSearchDto();
		//如果为空，直接返回
		if(null == companyCertificate){
			return companyCertificateSearchDto;
		}
		companyCertificateSearchDto.setChange("");
		BeanUtils.copyPropertiesIgnore(companyCertificate, companyCertificateSearchDto);
		if(null!=companyCertificate.getZczb()){
			companyCertificateSearchDto.setZczb(digitUppercase(Double.parseDouble(companyCertificate.getZczb())));
		}

		if (StringUtil.isNotEmpty(companyCertificate.getPzwh())) {
			companyCertificateSearchDto.setPzwh(companyCertificate.getPzwh().replace("【", "[").replace("】", "]"));
		}
		try {
			companyCertificateSearchDto.setXkzh(companyCertificate.getXkzh().substring(0, companyCertificate.getXkzh().indexOf("2")) + " " + companyCertificate.getXkzh().substring(companyCertificate.getXkzh().indexOf("2")) + " 号");
		}catch (Exception e){
			companyCertificateSearchDto.setXkzh(companyCertificate.getXkzh().substring(0, companyCertificate.getXkzh().indexOf("服")+1) + " " + companyCertificate.getXkzh().substring(companyCertificate.getXkzh().indexOf("服")+1) + " 号");
		}
		//发证日期
		if (null != companyCertificate.getFzrq()) {
			companyCertificateSearchDto.setFzrqn(DateUtil.convertDateToString(companyCertificate.getFzrq(),"yyyy-MM-dd").substring(0, 4));
			companyCertificateSearchDto.setFzrqy(DateUtil.convertDateToString(companyCertificate.getFzrq(),"yyyy-MM-dd").substring(5, 7));
			companyCertificateSearchDto.setFzrqr(DateUtil.convertDateToString(companyCertificate.getFzrq(),"yyyy-MM-dd").substring(8, 10));
		}
		//服务范围
		if (null != companyCertificate.getFwfw()) {
			String fwfw = formatManagement(companyCertificate.getFwfw(), companyCertificate.getOtherSecScopeType());
			//获取公司信息
			SecurityCompany company = securityCompanyDao.findById(companyCertificate.getCompanyid());


			//武装公司
			if(company!=null && Constants.SPONSORLICENSE_WZ.equals(company.getSponsorlicenseType())) {

				//公司类型
				companyCertificateSearchDto.setSponsorlicenseType(company.getSponsorlicenseType());

				//正本
				if (null != fwfw && fwfw.length() > 22) {
					companyCertificateSearchDto.setManagement(fwfw.substring(0, 22));
					companyCertificateSearchDto.setManagement2(fwfw.substring(22));
				} else {
					companyCertificateSearchDto.setManagement(fwfw);
				}
				//副本
				if(null!=fwfw && fwfw.length()>22){
					companyCertificateSearchDto.setManagement_1(fwfw.substring(0,22));
					companyCertificateSearchDto.setManagement_2(fwfw.substring(22));
				}else{
					companyCertificateSearchDto.setManagement_1(fwfw);
				}



			}else{//非武装公司
				//正本
				if (null != fwfw && fwfw.length() > 19) {
					companyCertificateSearchDto.setManagement(fwfw.substring(0, 19));
					companyCertificateSearchDto.setManagement2(fwfw.substring(19));
				} else {
					companyCertificateSearchDto.setManagement(fwfw);
				}

				//副本
				if(null!=fwfw && fwfw.length()>19){
					companyCertificateSearchDto.setManagement_1(fwfw.substring(0,19));
					companyCertificateSearchDto.setManagement_2(fwfw.substring(19));
				}else{
					companyCertificateSearchDto.setManagement_1(fwfw);
				}
			}

		}






		//公司地址(副本)
		if(null!=companyCertificate.getGsdz() && companyCertificate.getGsdz().length()>16){
			companyCertificateSearchDto.setGsdz_1(companyCertificate.getGsdz().substring(0,16));
			companyCertificateSearchDto.setGsdz_2(companyCertificate.getGsdz().substring(16));
			if(companyCertificate.getGsdz().length()> 34){
				companyCertificateSearchDto.setGsdz_2(companyCertificate.getGsdz().substring(16,32));
				companyCertificateSearchDto.setGsdz_3(companyCertificate.getGsdz().substring(32));
			}
		}else{
			companyCertificateSearchDto.setGsdz_1(companyCertificate.getGsdz());
		}
		//公司地址(正本)
		if(null!=companyCertificate.getGsdz()&&companyCertificate.getGsdz().length()>20){
			companyCertificateSearchDto.setGsdz(companyCertificate.getGsdz().substring(0,20));
			companyCertificateSearchDto.setGsdz2(companyCertificate.getGsdz().substring(20));
		}else{
			companyCertificateSearchDto.setGsdz(companyCertificate.getGsdz());
		}




		if(null!=companyCertificate) {
			//根据证书的ID获取已存在数据库的项目变更记载信息列表
            List<ProjectChange> projectChangeList = projectChangeDao.findByCertificateIdAndType(companyCertificate.getId().toString(),BusinessType.BAFWGS);
            //定义项目变更记载列表数组
            List<PdfChangeDTO> pdfChangeDTOList = new ArrayList<>();
			    //判断项目变更记载是否有记录列表
			    if(null!=projectChangeList && projectChangeList.size()>0){
			        //循环遍历项目变更信息列表
                    for (ProjectChange p: projectChangeList) {
                        //定义一个项目变更记载临时变量
                        PdfChangeDTO pdfChangeDTO= new PdfChangeDTO();
                        //项目名称
                        pdfChangeDTO.setProject(p.getProjectname());
                        //项目内容
                        pdfChangeDTO.setAfterChange(p.getProjectcontent());
                        //变更时间
                        pdfChangeDTO.setTime(p.getProjecttime());
                        //加入到打印项目变更记载列表中
                        pdfChangeDTOList.add(pdfChangeDTO);
                    }

			    }
			    //赋值项目变更记录信息打印列表
			  companyCertificateSearchDto.setPdfChangeDTOList(pdfChangeDTOList);

		}


		return companyCertificateSearchDto;
	}

	TrainCertificateSearchDto gettrainCertificateData(PdfFormDto pdfFormDto) {
		TrainCertificate trainCertificate = trainCertificateDao.findById(pdfFormDto.getBusinessid());
		TrainCertificateSearchDto trainCertificateSearchDto = new TrainCertificateSearchDto();
		if(null == trainCertificate){
			return  trainCertificateSearchDto;
		}
		BeanUtils.copyPropertiesIgnore(trainCertificate, trainCertificateSearchDto);
		trainCertificateSearchDto.setChange("");
		trainCertificateSearchDto.setXkzh(trainCertificate.getXkzh().substring(0,trainCertificate.getXkzh().indexOf("2"))+" "+trainCertificate.getXkzh().substring(trainCertificate.getXkzh().indexOf("2")) + " 号");
		if (null != trainCertificate.getFzrq()) {
			trainCertificateSearchDto.setFzrqn(DateUtil.convertDateToString(trainCertificate.getFzrq(),"yyyy-MM-dd").substring(0, 4));
			trainCertificateSearchDto.setFzrqy(DateUtil.convertDateToString(trainCertificate.getFzrq(),"yyyy-MM-dd").substring(5, 7));
			trainCertificateSearchDto.setFzrqr(DateUtil.convertDateToString(trainCertificate.getFzrq(),"yyyy-MM-dd").substring(8, 10));
		}

		//公司地址（正本）
		if(null!=trainCertificate.getGsdz()&&trainCertificate.getGsdz().length()>19){
			trainCertificateSearchDto.setGsdz(trainCertificate.getGsdz().substring(0,19));
			trainCertificateSearchDto.setGsdz2(trainCertificate.getGsdz().substring(19));
		} else{
			trainCertificateSearchDto.setGsdz(trainCertificate.getGsdz());
		}

        //培训内容
        //正本
		if(null!=trainCertificate.getPxnr()&&trainCertificate.getPxnr().length()>46){
			trainCertificateSearchDto.setPxnr(trainCertificate.getPxnr().substring(0,23));
			trainCertificateSearchDto.setPxnr2(trainCertificate.getPxnr().substring(23,46));
			trainCertificateSearchDto.setPxnr3(trainCertificate.getPxnr().substring(46));
		}else if(null!=trainCertificate.getPxnr()&&trainCertificate.getPxnr().length()>23){
            trainCertificateSearchDto.setPxnr(trainCertificate.getPxnr().substring(0,23));
            trainCertificateSearchDto.setPxnr2(trainCertificate.getPxnr().substring(23));
        }else{
            trainCertificateSearchDto.setPxnr(trainCertificate.getPxnr());
        }

		//公司地址（副本）
		if(null!=trainCertificate.getGsdz() && trainCertificate.getGsdz().length()>16){
			trainCertificateSearchDto.setGsdz_1(trainCertificate.getGsdz().substring(0,16));
			trainCertificateSearchDto.setGsdz_2(trainCertificate.getGsdz().substring(16));
		}else{
			trainCertificateSearchDto.setGsdz_1(trainCertificate.getGsdz());
		}

		//培训内容副本
		if(null!=trainCertificate.getPxnr() && trainCertificate.getPxnr().length()>44){
			trainCertificateSearchDto.setPxnr_1(trainCertificate.getPxnr().substring(0,22));
			trainCertificateSearchDto.setPxnr_2(trainCertificate.getPxnr().substring(22,44));
			trainCertificateSearchDto.setPxnr_3(trainCertificate.getPxnr().substring(44));
		}else if(null!=trainCertificate.getPxnr() && trainCertificate.getPxnr().length()>22){
			trainCertificateSearchDto.setPxnr_1(trainCertificate.getPxnr().substring(0,22));
			trainCertificateSearchDto.setPxnr_2(trainCertificate.getPxnr().substring(22));
		}else{
			trainCertificateSearchDto.setPxnr_1(trainCertificate.getPxnr());
		}





		List<ProjectChange> projectChangeList = projectChangeDao.findByCertificateIdAndType(trainCertificate.getId().toString(),BusinessType.PXDW);

		if(null!=projectChangeList && projectChangeList.size()>0){
			List<PdfChangeDTO> pdfChangeDTOList = new ArrayList<>();
			PdfChangeDTO pdfChangeDTO;
			for (ProjectChange p: projectChangeList) {
				pdfChangeDTO= new PdfChangeDTO();
				pdfChangeDTO.setProject(p.getProjectname());
				pdfChangeDTO.setAfterChange(p.getProjectcontent());
				pdfChangeDTO.setTime(p.getProjecttime());
				pdfChangeDTOList.add(pdfChangeDTO);

			}

			trainCertificateSearchDto.setPdfChangeDTOList(pdfChangeDTOList);

		}

		return trainCertificateSearchDto;
	}


	@Override
	public void createPDF(PdfFormDto pdfFormDto) throws Exception {

		String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
		Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
		//公司证书正本
		String companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6.pdf";
		//公司证书副本
		String companyCertificate2_Path  = templatePath + "pdfTemplate/CompanyCertificate-2-6.pdf";

		//培训公司正本
		String companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2.pdf";
		//培训公司副本
		String companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2.pdf";
		Date now = new Date();

		String confirmUrl = "";
		String registerUrl = "";

		String companyCertificate1FileName = now.getTime() + "_companyCertificate1.pdf";
		String companyCertificate2FileName = now.getTime() + "_companyCertificate2.pdf";

		String companyTrain1FileName = now.getTime() + "_companyTrain1.pdf";
		String companyTrain2FileName = now.getTime() + "_companyTrain2.pdf";
		String dirDate = DateUtil.systemDate.format(now);
		String filePath = "pdf/" + dirDate + "/";
		String pdfPath = baseFolder + filePath;
		File pdfFile = new File(pdfPath);
		if (!pdfFile.exists()) {
			pdfFile.mkdirs();
		}

		String companyCertificate1Path = pdfPath + companyCertificate1FileName;
		String companyCertificate2Path = pdfPath + companyCertificate2FileName;
		String companyCertificate2PathChaneg = pdfPath +"change_"+ companyCertificate2FileName;
		String companyTrain1Path = pdfPath + companyTrain1FileName;
		String companyTrain2Path = pdfPath + companyTrain2FileName;
		String companyTrain2FileNameChaneg = pdfPath +"change_"+ companyTrain2FileName;

		//保安服务公司许可申请
		if (BusinessType.BAFWGS.equals(pdfFormDto.getBusinesstype())) {
			//获取数据
			CompanyCertificateSearchDto companyCertificateSearchDto = getompanyCertificateData(pdfFormDto);

			if(null!=companyCertificateSearchDto){
				//判断是否为武装公司
				if( Constants.SPONSORLICENSE_WZ.equals(companyCertificateSearchDto.getSponsorlicenseType()) ) {
					if (StringUtil.isEmpty(companyCertificateSearchDto.getGsdz_2())) {
						//公司证书正本
						companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6_single.pdf";
						//公司证书副本
						companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_single_wz.pdf";

					}else if (StringUtil.isNotEmpty(companyCertificateSearchDto.getGsdz_3())) {
						//公司证书副本
						companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6-3_wz.pdf";
					}else{
						//公司证书副本
						companyCertificate2_Path  = templatePath + "pdfTemplate/CompanyCertificate-2-6_wz.pdf";
					}
				}else{
					if (StringUtil.isEmpty(companyCertificateSearchDto.getGsdz_2())) {
						//公司证书正本
						companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6_single.pdf";
						//公司证书副本
						companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_single.pdf";
					}
					if (StringUtil.isNotEmpty(companyCertificateSearchDto.getGsdz_3())) {
						//公司证书副本
						companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6-3.pdf";
					}
				}
				if(companyCertificateSearchDto.getGsmc().length()>15){
					//公司证书副本
					companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_c.pdf";
				}
				/**
				 * 生成
				* */
				PDFUtils.addPDFChange(companyCertificate2_Path, companyCertificate2PathChaneg, companyCertificateSearchDto.getPdfChangeDTOList());
				PDFUtils.createPDFForTemplate(companyCertificate1_Path, companyCertificate1Path, companyCertificateSearchDto);
				PDFUtils.createPDFForTemplate(companyCertificate2PathChaneg, companyCertificate2Path, companyCertificateSearchDto);
				//陕西需要盖章
				if(null!=provinceConfig && "610000".equals(provinceConfig.getValue())){
					stampService.addStamp(companyCertificate1Path,"1");
					stampService.addStamp(companyCertificate2Path,"2");				}
				CompanyCertificate companyCertificate = companyCertificateDao.findById(pdfFormDto.getBusinessid());
				companyCertificate.setPdfpath("getResource.do?path=" + filePath + companyCertificate1FileName);
				companyCertificate.setPdfpathRevese("getResource.do?path=" + filePath + companyCertificate2FileName);
				companyCertificateDao.update(companyCertificate);

			}

		} else if (BusinessType.PXDW.equals(pdfFormDto.getBusinesstype())) {
			TrainCertificateSearchDto trainCertificateSearchDto = gettrainCertificateData(pdfFormDto);

			if(StringUtil.isNotEmpty(trainCertificateSearchDto.getPxnr3())){
				companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2-3.pdf";
			}

            if(StringUtil.isEmpty(trainCertificateSearchDto.getGsdz2())){
                //培训公司正本
                companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2_single.pdf";
				if(StringUtil.isNotEmpty(trainCertificateSearchDto.getPxnr3())){
					companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2_single-3.pdf";
				}
            }

			if(StringUtil.isNotEmpty(trainCertificateSearchDto.getPxnr_3())){
				companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2-3.pdf";
			}

			if(StringUtil.isEmpty(trainCertificateSearchDto.getGsdz_2())){
				//培训公司副本
				companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single.pdf";
				if(StringUtil.isNotEmpty(trainCertificateSearchDto.getPxnr_3())){
					companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single-3.pdf";
				}
				if(trainCertificateSearchDto.getGsmc().length()>15){
					//培训公司副本
					companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single_c.pdf";
					if(StringUtil.isNotEmpty(trainCertificateSearchDto.getPxnr_3())){
						companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single_c-3.pdf";
					}
				}
			}else{
				if(trainCertificateSearchDto.getGsmc().length()>15){
					//培训公司副本
					companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_c.pdf";
					if(StringUtil.isNotEmpty(trainCertificateSearchDto.getPxnr_3())){
						companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_c-3.pdf";
					}
				}
			}
			if(null != trainCertificateSearchDto){
				/**
				 * 生成
				 * */
				PDFUtils.addPDFChange(companyTrain2_Path, companyTrain2FileNameChaneg, trainCertificateSearchDto.getPdfChangeDTOList());
				PDFUtils.createPDFForTemplate(companyTrain1_Path, companyTrain1Path, trainCertificateSearchDto);
				PDFUtils.createPDFForTemplate(companyTrain2FileNameChaneg, companyTrain2Path, trainCertificateSearchDto);
				//陕西需要盖章
				if(null!=provinceConfig && "610000".equals(provinceConfig.getValue())){
					stampService.addStamp(companyTrain1Path,"1");
					stampService.addStamp(companyTrain2Path,"2");
				}
				TrainCertificate trainCertificate = trainCertificateDao.findById(pdfFormDto.getBusinessid());
				trainCertificate.setPdfpath("getResource.do?path=" + filePath + companyTrain1FileName);
				trainCertificate.setPdfpathRevese("getResource.do?path=" + filePath + companyTrain2FileName);
				trainCertificateDao.update(trainCertificate);
			}
		}
	}

	/**
	 * 数字金额大写转换，思想先写个完整的然后将如零拾替换成零 要用到正则表达式
	 */
	public static String digitUppercase(double v) {
		//默认传的是万元为单位 转成元
		v = v*10000;

		String UNIT = "万仟佰拾亿仟佰拾万仟佰拾元角分";
		String DIGIT = "零壹贰叁肆伍陆柒捌玖";
		double MAX_VALUE = 9999999999999.99D;

		if (v < 0 || v > MAX_VALUE){
			return "参数非法!";
		}
		long l = Math.round(v * 100);
		if (l == 0){
			return "零元";
		}
		String strValue = l + "";
		// i用来控制数
		int i = 0;
		// j用来控制单位
		int j = UNIT.length() - strValue.length();
		String rs = "";
		boolean isZero = false;
		for (; i < strValue.length(); i++, j++) {
			char ch = strValue.charAt(i);
			if (ch == '0') {
				isZero = true;
				if (UNIT.charAt(j) == '亿' || UNIT.charAt(j) == '万' || UNIT.charAt(j) == '元') {
					rs = rs + UNIT.charAt(j);
					isZero = false;
				}
			} else {
				if (isZero) {
					rs = rs + "零";
					isZero = false;
				}
				rs = rs + DIGIT.charAt(ch - '0') + UNIT.charAt(j);
			}
		}
		rs = rs.replaceAll("亿万", "亿");
		return rs;
	}


	String formatManagement(String fwfw, String otherSecScopeType) {
		if (StringUtil.isEmpty(fwfw)) {
			return "";
		}
		StringBuffer management = new StringBuffer();

		//服务范围打印顺序  /*门卫  巡逻 守护 押运 随身护卫 安全检查 安全技术防范 安全风险评估 区域秩序维护 */
        String[] orders= new String[]{"1","2","3","6","4","7","9","8","10"};
        String[] ss = fwfw.split(",");
        for(int j=0;j<orders.length;j++){
            for (int i = 0; i < ss.length; i++) {
                if(orders[j].equals(ss[i])) {
                    if ("1".equals(ss[i])) {
                        management.append("门卫、");
                    } else if ("2".equals(ss[i])) {
                        management.append("巡逻、");
                    } else if ("3".equals(ss[i])) {
                        management.append("守护、");
                    } else if ("4".equals(ss[i])) {
                        management.append("随身护卫、");
                    } else if ("6".equals(ss[i])) {
                        management.append("押运、");
                    } else if ("10".equals(ss[i])) {
                        management.append("区域秩序维护、");
                    } else if ("7".equals(ss[i])) {
                        management.append("安全检查、");
                    } else if ("8".equals(ss[i])) {
                        management.append("安全风险评估、");
                    } else if ("9".equals(ss[i])) {
                        management.append("安全技术防范、");
                    } else if ("20".equals(ss[i])) {
                        management.append("其他" + (otherSecScopeType == null ? "" : "(" + otherSecScopeType + ")、"));
                    }
                }

            }
        }





		return management.toString().substring(0,management.toString().length()-1);

	}

	public static void main(String[] args) throws Exception {
		//CreatePDFServiceImpl createPDFServiceImpl = new CreatePDFServiceImpl();
        //
		//PdfFormDto pdfFormDto = new PdfFormDto();
		//pdfFormDto.setBusinesstype(BusinessType.BAFWGS);
		//pdfFormDto.setBusinessid(3L);
		//pdfFormDto.setHasReverse("1");
		//pdfFormDto.setHasStamp("1");
        //
		//createPDFServiceImpl.createPDF(pdfFormDto);

		//String gsdz ="陕西省榆林市绥德县学子大道翠园小区1楼门市";
		//System.out.println(gsdz.substring(0,18));
		//System.out.println(gsdz.substring(18,28));
		//System.out.println(gsdz.substring(28));
//		System.out.println(digitUppercase(Double.parseDouble("1080")));





	}



}
