package com.bcxin.ars.service.certificate.impl;

import com.bcxin.ars.dao.certificate.ComCertificateSnapshotDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import com.bcxin.ars.service.certificate.ComCertificateSnapshotService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import java.util.List;
/**
 * 保安服务公司快照保存Service实现类
 *
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
@Service
@Transactional
public class ComCertificateSnapshotServiceImpl implements ComCertificateSnapshotService {

    Logger logger = LoggerFactory.getLogger(ComCertificateSnapshotServiceImpl.class);

    @Autowired
    private ComCertificateSnapshotDao comCertificateSnapshotDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;
   


    @Override
    public int save(ComCertificateSnapshot comCertificateSnapshot) {
        User currentUser = arsUtil.getCurrentUser();
        if(comCertificateSnapshot.getId() == null){
            comCertificateSnapshot.setCreateTime(new Date());
        }else{
            ComCertificateSnapshot dbQrcodeInfo = comCertificateSnapshotDao.findByQrCodeId(comCertificateSnapshot.getQrCodeId());
            BeanUtils.copyPropertiesIgnore(comCertificateSnapshot,dbQrcodeInfo,true);
            BeanUtils.copyPropertiesIgnore(dbQrcodeInfo,comCertificateSnapshot,false);
        }

        comCertificateSnapshot.setActive(true);
        comCertificateSnapshot.setUpdateBy(currentUser.getUsername());
        comCertificateSnapshot.setUpdateTime(new Date());
        comCertificateSnapshot.setUpdateflag(true);
        comCertificateSnapshot.setAreaCode(currentUser.getPolice().getAreacode());
        return comCertificateSnapshotDao.save(comCertificateSnapshot);
    }

    @Override
    public ComCertificateSnapshot findByQrCodeId(Long qrCodeId) {
        return comCertificateSnapshotDao.findByQrCodeId(qrCodeId);
    }


    @Override
    public void importBatch(List<ComCertificateSnapshot> list) {
        List<ComCertificateSnapshot> dbList = comCertificateSnapshotDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComCertificateSnapshot comCertificateSnapshot : list) {
                comCertificateSnapshot.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        comCertificateSnapshot.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comCertificateSnapshot.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comCertificateSnapshotDao.saveBatch(list);
        }
    }

    @Override
    public List<ComCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comCertificateSnapshotDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComCertificateSnapshot> findDSOutList(String startDate) {
        return comCertificateSnapshotDao.findDSOutList(startDate);
    }

    @Override
    public List<ComCertificateSnapshot> findByBatchId(List<ComCertificateSnapshot> list) {
        return comCertificateSnapshotDao.findByBatchId(list);
    }


}
