package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zhangyutong
 */
public class RemoveDataFormatStrategy implements MinDataFormatStrategy {

    @Override
    public String format(Field columnField, Object data) {
        String value = (String) data;
        if(value == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        // 去除汉字
        String regex = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(regex);
        Matcher mat = pat.matcher(value);
        return mat.replaceAll("");
    }
}
