package com.bcxin.ars.model.task;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.io.Serializable;
import java.util.Date;

/**
 * 安保任务人员轨迹
 * @author Ethan
 */
public class TaskTrack extends BaseModel implements Serializable {

	private static final long serialVersionUID = 7024834670830499822L;
	
	private Long id;

	private String uuid;
	
	/**
	 * 区域编号
	 */
	private Long nativeCode;
	
	/**
	 * 所属任务反馈ID
	 */
    //Java后端开发过程中，尤其是id字段，因数值太大，通过json形式传输到前端后，在js解析时，会丢失精度。
    //将id字段序列化为json时，转换为字符串类型，前端传输到后端，反序列化时，再重新转换为Long。
    //2018年8月13日13:31:11  wjb
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long taskFeedbackId;
	
	private Long personId;
	/**
	 * 经度
	 */
	private String longitude;
	
	/**
	 * 纬度
	 */
	private String latitude;
	
	/**
	 * 更新时间
	 */
	private Date updateTime;

	public String getUuid() {
		return uuid;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Long getTaskFeedbackId() {
		return taskFeedbackId;
	}

	public void setTaskFeedbackId(Long taskFeedbackId) {
		this.taskFeedbackId = taskFeedbackId;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}
	
}
