package com.bcxin.ars.model.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.bcxin.ars.model.SecurityPerson;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;

/**
 * 安保任务和人员关系类
 * @author Ethan
 */
public class TaskPerson implements Serializable {

	private static final long serialVersionUID = 7024834670830499822L;
	
	private Long id;
	/**
	 * 区域编号
	 */
	private Long nativeCode;
	
	/**
	 * 所属任务ID
	 */
	private Long taskId;
	
	/**
	 * 负责人标记
	 */
	private boolean inCharge;
	/**
	 * 分配时间
	 */
	private Date createTime;

	/**
	 * 修改时间
	 */
	private Date updateTime;

	/**
	 * 接受状态 ：0-未接受（即新任务）、1-已接受、2-已拒绝、3已完成、4超时
	 */
	private Integer acceptStatus;

	/**
	 * 拒绝理由
	 */
	private String rejectReason;
	
	/**
	 * 保安员
	 */
	@JsonIgnoreProperties(value={"handler"})
	private SecurityPerson person;
	
	/**
	 * 保安员对应排班表
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<TaskPersonSchedule> scheduleList = new ArrayList<TaskPersonSchedule>();

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Long getTaskId() {
		return taskId;
	}

	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}
	
	public boolean isInCharge() {
		return inCharge;
	}

	public void setInCharge(boolean inCharge) {
		this.inCharge = inCharge;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Integer getAcceptStatus() {
		return acceptStatus;
	}

	public void setAcceptStatus(Integer acceptStatus) {
		this.acceptStatus = acceptStatus;
	}

	public String getRejectReason() {
		return rejectReason;
	}

	public void setRejectReason(String rejectReason) {
		this.rejectReason = rejectReason;
	}
	
	public SecurityPerson getPerson() {
		return person;
	}

	public void setPerson(SecurityPerson person) {
		this.person = person;
	}

	public List<TaskPersonSchedule> getScheduleList() {
		return scheduleList;
	}

	public void setScheduleList(List<TaskPersonSchedule> scheduleList) {
		this.scheduleList = scheduleList;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
	
}
