package com.bcxin.ars.model.task;

import lombok.Data;
import java.util.Date;
import com.bcxin.ars.model.BaseModel;


/**
 * 临保任务人员对象
 *
 * @table com_temp_task_per
 * @author lin
 * @date 2021-02-01
 */
@Data
public class ComTempTaskPer extends BaseModel{

    private static final long serialVersionUID=1L;

    
    /**
     * 临保任务人员ID
     */
    private Long comTempTaskPerId;
            
    /**
     * 创建人ID
     */
    private Long userId;
                    
    /**
     * 人员所在企业ID
     */
    private Long comId;
        
    /**
     * 开始日期
     */
    private Date startDate;
        
    /**
     * 结束日期
     */
    private Date endDate;
        
    /**
     * 临保任务ID
     */
    private Long comTempTaskId;
        
    /**
     * 人员ID
     */
    private Long perId;
    
    @Override
    public boolean equals(Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComTempTaskPer that = (ComTempTaskPer) o;
            if (that.getId() != null && this.getId() != null){
                if (that.getComTempTaskPerId().intValue() == this.getComTempTaskPerId().intValue() && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;

    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
