package com.bcxin.ars.model.task;

import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

@Data
@ModelTableAnnotation(tableName = "com_task_per",getName = "驻勤点与人员关联表")
public class ComTaskPer extends BaseModel {

    /** 任务ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comTaskId;

    /** 人员ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    /**
     * 勿删
     * @param o
     * @return
     */
    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComTaskPer that = (ComTaskPer) o;
            if (that.getComTaskId() != null && this.getComTaskId() != null && that.getPerId() != null && this.getPerId() != null){
                if (that.getComTaskId().intValue() == this.getComTaskId().intValue()
                        && that.getPerId().intValue() == this.getPerId().intValue()
                        && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        return getComTaskId().hashCode();
    }

}