package com.bcxin.ars.model.sx;

import lombok.Data;

import java.util.Date;
@Data
public class SxFile {
    /** 主键，有业务系统自动产生 */
    private String unid;

    /** 详见附录2.3 */
    private String projid;

    /** 审批事项所对应的提交材料 */
    private String attrname;

    /** GB 32100-2015中统一社会信用代码。 */
    private String deptid;

    /** 对应材料编码 */
    private String attrid;

    /** 根据材料顺序依次编号 */
    private String sortid;

    /** 纸质收取、附件上传、电子证照库 */
    private String taketype;

    /** 标识材料收取的情况，1-是，0-否 */
    private Byte istake;

    /** 记录所收取材料的数量 */
    private Byte amount;

    /** GB/T 19488.2-2008中日期时间 */
    private Date taketime;

    /** 如果有上传附件必填，上传附件的文件全称包含后缀名，如身份证.JPG */
    private String filename;

    /** 作为材料收取情况的补充说明 */
    private String memo;

    /** 由各业务系统产生，时间格式：YYYY-MM-DDHH24:MI:SS */
    private Date create_time;

    /** 主键，默认值=1，如果有信息变更，则版本号递增 */
    private Short dataver;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 审批过程序号 */
    private String sn;

    /** 业务环节发生行政区划，编码规则见附录2.4 */
    private String region_id;

    /** 编码规则见附录2.4 */
    private String itemregionid;

    /** 数据交换状态标志位，默认为0 */
    private Long signstate;

    /**  */
    private String entityurl_z;

    /**  */
    private String entityurl_h;

    /**  */
    private String sysmark;

    /**  */
    private Date localtime;

    /**  */
    private String cd_operation;

}